/*
 * Decompiled with CFR 0.152.
 */
package sanproject.session.server.unique;

import java.io.File;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import sanproject.session.server.common.SJsessionServerUty;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;

public class SJsessionFileLockUty {
    private static final String LOG_FUNCTION = "SessionServer";
    private static final String LOG_TITLE = SJsessionFileLockUty.class.getSimpleName();
    private RandomAccessFile raf = null;
    private FileLock lock = null;
    private static Object syncObject = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockFile() throws Exception {
        String LOG_SUBTITLE = "lockFile";
        SJcLoggerInterface logger = SJsessionServerUty.getLogger();
        logger.trace(LOG_FUNCTION, LOG_TITLE, LOG_SUBTITLE, "Start.");
        File file = new File(this.getFilePath());
        try {
            Object object = syncObject;
            synchronized (object) {
                this.raf = new RandomAccessFile(file, "rw");
                this.lock = this.raf.getChannel().lock();
            }
        }
        catch (Exception e) {
            logger.error(LOG_FUNCTION, LOG_TITLE, LOG_SUBTITLE, "Cannot lock.", e);
            this.releaseFile();
            throw e;
        }
        logger.trace(LOG_FUNCTION, LOG_TITLE, LOG_SUBTITLE, "End.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseFile() {
        String LOG_SUBTITLE = "releaseFile";
        SJcLoggerInterface logger = SJsessionServerUty.getLogger();
        logger.trace(LOG_FUNCTION, LOG_TITLE, LOG_SUBTITLE, "Start.");
        Object object = syncObject;
        synchronized (object) {
            if (this.lock != null) {
                try {
                    this.lock.release();
                    this.lock = null;
                }
                catch (Exception e) {
                    logger.error(LOG_FUNCTION, LOG_TITLE, LOG_SUBTITLE, "File was not able to be unpicked.", e);
                }
            }
            if (this.raf != null) {
                try {
                    this.raf.close();
                    this.raf = null;
                }
                catch (Exception e) {
                    logger.error(LOG_FUNCTION, LOG_TITLE, LOG_SUBTITLE, "File was not able to be unpicked.", e);
                }
            }
        }
        logger.trace(LOG_FUNCTION, LOG_TITLE, LOG_SUBTITLE, "End.");
    }

    private String getFilePath() {
        String dir = SJsessionServerUty.getSessionAbsoluetePath();
        String fName = "IDManager.lock";
        String path = dir + fName;
        return path;
    }
}

