/*
 * Decompiled with CFR 0.152.
 */
package sanproject.session.server.unique;

import sanproject.session.server.common.SJsessionServerUty;
import sanproject.session.server.unique.SJsessionFileLockUty;
import sanproject.session.server.unique.SJsessionUniqueIDInfo;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcFileUty;

public class SJsessionUniqueIDUtility {
    private static final String LOG_FUNCTION = "SessionServer";
    private static final String LOG_TITLE = SJsessionUniqueIDUtility.class.getSimpleName();

    private SJsessionUniqueIDUtility() {
    }

    public static void initializeTable() throws Exception {
        String LOG_SUBTITLE = "initializeTable";
        SJcLoggerInterface logger = SJsessionServerUty.getLogger();
        logger.info(LOG_FUNCTION, LOG_TITLE, "initializeTable", "Start.");
        SJsessionFileLockUty flockUty = new SJsessionFileLockUty();
        flockUty.lockFile();
        try {
            SJsessionUniqueIDInfo info = SJsessionUniqueIDUtility.readFile();
            info.initTable();
            SJsessionUniqueIDUtility.writeFile(info);
        }
        catch (SJcException ex) {
            throw ex;
        }
        finally {
            flockUty.releaseFile();
        }
        logger.info(LOG_FUNCTION, LOG_TITLE, "initializeTable", "End.");
    }

    public static SJsessionUniqueIDInfo readFile() {
        String LOG_SUBTITLE = "readFile";
        SJcLoggerInterface logger = SJsessionServerUty.getLogger();
        logger.trace(LOG_FUNCTION, LOG_TITLE, "readFile", "Start.");
        SJsessionUniqueIDInfo info = null;
        String dir = SJsessionServerUty.getSessionPath();
        try {
            info = (SJsessionUniqueIDInfo)SJcFileUty.loadSerialize(dir, "IDManager.dat");
        }
        catch (SJcException ex) {
            logger.error(LOG_FUNCTION, LOG_TITLE, "readFile", "SJsessionUniqueIDInfo cannot be read.");
        }
        if (info == null) {
            info = new SJsessionUniqueIDInfo();
            logger.info(LOG_FUNCTION, LOG_TITLE, "readFile", "create new SJsessionUniqueIDInfo.");
        }
        logger.trace(LOG_FUNCTION, LOG_TITLE, "readFile", "End.");
        return info;
    }

    public static void writeFile(SJsessionUniqueIDInfo info) throws SJcException {
        String LOG_SUBTITLE = "writeFile";
        SJcLoggerInterface logger = SJsessionServerUty.getLogger();
        logger.trace(LOG_FUNCTION, LOG_TITLE, "writeFile", "Start.");
        String dir = SJsessionServerUty.getSessionPath();
        SJcFileUty.saveSerialize(dir, "IDManager.dat", info);
        logger.trace(LOG_FUNCTION, LOG_TITLE, "writeFile", "End.");
    }
}

