/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.com.abs;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Vector;
import sanproject.client.com.abs.RJaDataModelEntry;

public class RJaDataModel {
    protected Vector rows = new Vector();
    protected RJaDataModelEntry columnNames = new RJaDataModelEntry();
    private Vector preSortKey = null;
    private boolean preMode;
    public static final int ASC = 0;
    public static final int DESC = 1;
    public static final int ALT = 0;
    public static final int FIX = 1;
    protected int settingMode = NORMAL;
    public static int NORMAL = 0;
    public static int UPDATE = 1;

    public RJaDataModel() {
    }

    public RJaDataModel(String[] stringArray) {
        this.createModel(stringArray);
    }

    public RJaDataModel(String[][] stringArray) {
        this.createModel(stringArray);
    }

    public RJaDataModelEntry getColumnNames() {
        return this.columnNames;
    }

    public void createModel(String[] stringArray) {
        this.columnNames.setKeys(stringArray);
    }

    public void createModel(String[][] stringArray) {
        this.columnNames.setKeysAndValues(stringArray);
    }

    public int getColumnCount() {
        return this.columnNames.size();
    }

    public int getRowCount() {
        return this.rows.size();
    }

    protected boolean isAvailColumn(int n) {
        return n >= 0 && n < this.getColumnCount();
    }

    protected boolean isAvailRow(int n) {
        return n >= 0 && n < this.getRowCount();
    }

    public RJaDataModelEntry getRow(int n) {
        RJaDataModelEntry rJaDataModelEntry = null;
        if (this.isAvailRow(n)) {
            rJaDataModelEntry = (RJaDataModelEntry)this.rows.get(n);
        }
        return rJaDataModelEntry;
    }

    public Vector getRowVector(int n) {
        Vector vector = null;
        if (this.isAvailRow(n)) {
            RJaDataModelEntry rJaDataModelEntry = (RJaDataModelEntry)this.rows.get(n);
            vector = rJaDataModelEntry.getValues();
        }
        return vector;
    }

    public RJaDataModelEntry getRowBySubKey(int n) {
        RJaDataModelEntry rJaDataModelEntry = null;
        if (this.isAvailRow(n)) {
            RJaDataModelEntry rJaDataModelEntry2 = new RJaDataModelEntry();
            RJaDataModelEntry rJaDataModelEntry3 = (RJaDataModelEntry)this.rows.get(n);
            Enumeration enumeration = rJaDataModelEntry3.elements();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                rJaDataModelEntry2.put(this.columnNames.get(e), rJaDataModelEntry3.get(e));
            }
            rJaDataModelEntry = rJaDataModelEntry2;
        }
        return rJaDataModelEntry;
    }

    public RJaDataModelEntry setRow(int n, RJaDataModelEntry rJaDataModelEntry) {
        RJaDataModelEntry rJaDataModelEntry2 = null;
        if (this.isAvailRow(n)) {
            rJaDataModelEntry2 = this.rows.set(n, rJaDataModelEntry);
        }
        return rJaDataModelEntry2;
    }

    public void addRow(RJaDataModelEntry rJaDataModelEntry) {
        this.rows.add(rJaDataModelEntry);
    }

    public void addRow(int n, RJaDataModelEntry rJaDataModelEntry) {
        this.rows.add(n, rJaDataModelEntry);
    }

    public void addRowVector(Vector vector) {
        RJaDataModelEntry rJaDataModelEntry = this.newEntry();
        rJaDataModelEntry.setValues(vector);
        this.rows.add(rJaDataModelEntry);
    }

    public Enumeration elements() {
        return this.rows.elements();
    }

    public Object getValueAt(int n, Object object) {
        Object object2 = null;
        if (this.isAvailRow(n)) {
            object2 = this.getRow(n).get(object);
        }
        return object2;
    }

    protected Object getValueAt(int n, int n2) {
        Object object = null;
        if (this.isAvailRow(n)) {
            object = ((RJaDataModelEntry)this.rows.get(n)).get(n2);
        }
        return object;
    }

    public void setValueAt(int n, Object object, Object object2) {
        if (this.isAvailRow(n)) {
            ((RJaDataModelEntry)this.rows.get(n)).put(object, object2);
        }
    }

    public void setValueAt(int n, int n2, Object object) {
        if (this.isAvailRow(n)) {
            RJaDataModelEntry rJaDataModelEntry = (RJaDataModelEntry)this.rows.get(n);
            Object object2 = rJaDataModelEntry.getKey(n2);
            rJaDataModelEntry.put(object2, object);
        }
    }

    public RJaDataModelEntry remove(int n) {
        RJaDataModelEntry rJaDataModelEntry = null;
        if (this.isAvailRow(n)) {
            rJaDataModelEntry = (RJaDataModelEntry)this.rows.remove(n);
        }
        return rJaDataModelEntry;
    }

    public void removeAll() {
        this.rows.removeAllElements();
    }

    public RJaDataModelEntry newEntry() {
        RJaDataModelEntry rJaDataModelEntry = new RJaDataModelEntry();
        rJaDataModelEntry.setKeys(this.columnNames);
        rJaDataModelEntry.setSearchKeys(this.columnNames);
        return rJaDataModelEntry;
    }

    public void setValues(Object[][] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            RJaDataModelEntry rJaDataModelEntry = new RJaDataModelEntry();
            Enumeration enumeration = this.columnNames.elements();
            int n = 0;
            while (enumeration.hasMoreElements()) {
                rJaDataModelEntry.put(enumeration.nextElement(), objectArray[i][n]);
                ++n;
            }
            this.rows.add(i, rJaDataModelEntry);
        }
    }

    public void setValues(RJaDataModel rJaDataModel) {
        Enumeration enumeration = rJaDataModel.elements();
        while (enumeration.hasMoreElements()) {
            RJaDataModelEntry rJaDataModelEntry = this.newEntry();
            RJaDataModelEntry rJaDataModelEntry2 = (RJaDataModelEntry)enumeration.nextElement();
            rJaDataModelEntry.setValues(rJaDataModelEntry2);
            this.addRow(rJaDataModelEntry);
        }
    }

    public void setValuesSubkey(RJaDataModel rJaDataModel) {
        Enumeration enumeration = rJaDataModel.elements();
        while (enumeration.hasMoreElements()) {
            RJaDataModelEntry rJaDataModelEntry = this.newEntry();
            RJaDataModelEntry rJaDataModelEntry2 = (RJaDataModelEntry)enumeration.nextElement();
            rJaDataModelEntry.setValues(rJaDataModelEntry2, this.columnNames);
            this.addRow(rJaDataModelEntry);
        }
    }

    public RJaDataModelEntry replace(RJaDataModelEntry rJaDataModelEntry) {
        RJaDataModelEntry rJaDataModelEntry2 = this.columnNames;
        this.columnNames = rJaDataModelEntry == null ? new RJaDataModelEntry() : rJaDataModelEntry;
        return rJaDataModelEntry2;
    }

    public Vector replace(Vector vector) {
        Vector vector2 = this.rows;
        this.rows = vector == null ? new Vector() : vector;
        return vector2;
    }

    public void removeUntouched() {
        for (int i = this.getRowCount() - 1; i >= 0; --i) {
            RJaDataModelEntry rJaDataModelEntry = (RJaDataModelEntry)this.rows.get(i);
            if (rJaDataModelEntry.isTouched()) continue;
            this.remove(i);
        }
    }

    public void clearTouched() {
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            RJaDataModelEntry rJaDataModelEntry = (RJaDataModelEntry)enumeration.nextElement();
            rJaDataModelEntry.untouched();
        }
    }

    public void beginSetting() {
        this.beginSetting(UPDATE);
    }

    public void beginSetting(int n) {
        this.settingMode = n;
        if (this.settingMode == UPDATE) {
            this.clearTouched();
        }
    }

    public void completeSetting() {
        if (this.settingMode == UPDATE) {
            this.removeUntouched();
        }
    }

    public RJaDataModelEntry availEntry(RJaDataModelEntry rJaDataModelEntry) {
        RJaDataModelEntry rJaDataModelEntry2 = rJaDataModelEntry;
        if (this.settingMode == UPDATE) {
            rJaDataModelEntry2 = this.searchEntry(rJaDataModelEntry);
            if (rJaDataModelEntry2 == null) {
                rJaDataModelEntry2 = rJaDataModelEntry;
                this.addRow(rJaDataModelEntry2);
            }
        } else {
            this.addRow(rJaDataModelEntry2);
        }
        return rJaDataModelEntry2;
    }

    public RJaDataModelEntry searchEntry(RJaDataModelEntry rJaDataModelEntry) {
        RJaDataModelEntry rJaDataModelEntry2 = null;
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            RJaDataModelEntry rJaDataModelEntry3 = (RJaDataModelEntry)enumeration.nextElement();
            if (!rJaDataModelEntry3.equals(rJaDataModelEntry)) continue;
            rJaDataModelEntry2 = rJaDataModelEntry3;
            break;
        }
        return rJaDataModelEntry2;
    }

    public int indexOf(RJaDataModelEntry rJaDataModelEntry) {
        return this.rows.indexOf(rJaDataModelEntry);
    }

    public int search(Object object, Object object2) {
        int n = -1;
        Enumeration enumeration = this.elements();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            RJaDataModelEntry rJaDataModelEntry = (RJaDataModelEntry)enumeration.nextElement();
            if (object2.equals(rJaDataModelEntry.get(object))) {
                n = n2;
                break;
            }
            ++n2;
        }
        return n;
    }

    public void print() {
        System.out.println("DataModel");
        System.out.print("[columnNames]:");
        this.columnNames.print();
        System.out.println("[rows]:");
        Enumeration enumeration = this.rows.elements();
        while (enumeration.hasMoreElements()) {
            RJaDataModelEntry rJaDataModelEntry = (RJaDataModelEntry)enumeration.nextElement();
            rJaDataModelEntry.print();
        }
    }

    public void sort(SortKey sortKey) {
        this.sort(sortKey, 0);
    }

    public void sort(Vector vector) {
        this.sort(vector, 0);
    }

    public void sort(SortKey sortKey, int n) {
        Vector<SortKey> vector = new Vector<SortKey>(1);
        vector.add(sortKey);
        this.sort(vector, n);
    }

    public void sort(Vector vector, int n) {
        boolean bl = false;
        if (n == 0) {
            bl = this.preMode = vector.equals(this.preSortKey) ? !this.preMode : false;
        }
        this.preSortKey = vector;
        int n2 = this.rows.size();
        RJaDataModelEntry[] rJaDataModelEntryArray = new RJaDataModelEntry[n2];
        Enumeration enumeration = this.rows.elements();
        int n3 = 0;
        while (enumeration.hasMoreElements()) {
            rJaDataModelEntryArray[n3] = (RJaDataModelEntry)enumeration.nextElement();
            ++n3;
        }
        DataComparator dataComparator = new DataComparator(vector, bl);
        Arrays.sort(rJaDataModelEntryArray, dataComparator);
        for (int i = 0; i < n2; ++i) {
            this.rows.set(i, rJaDataModelEntryArray[i]);
        }
    }

    public class SortKey {
        private Object key;
        private int direction;

        public SortKey(Object object) {
            this(object, 0);
        }

        public SortKey(Object object, int n) {
            this.key = object;
            this.direction = n;
        }

        public int getDirection() {
            return this.direction;
        }

        public boolean equals(Object object) {
            boolean bl = false;
            if (this.key != null && object instanceof SortKey && this.toString().equals(object.toString())) {
                bl = true;
            }
            return bl;
        }

        public int hashCode() {
            int n = 0;
            if (this.key != null) {
                n = this.key.toString().hashCode();
            }
            return n;
        }

        public String toString() {
            String string = null;
            if (this.key != null) {
                string = this.key.toString();
            }
            return string;
        }
    }

    class DataComparator
    implements Comparator {
        private Vector keys;
        private boolean reverse;

        DataComparator(Vector vector, boolean bl) {
            this.keys = vector;
            this.reverse = bl;
        }

        public int compare(Object object, Object object2) {
            int n = 0;
            int n2 = 0;
            Enumeration enumeration = this.keys.elements();
            while (enumeration.hasMoreElements()) {
                String string;
                SortKey sortKey = (SortKey)enumeration.nextElement();
                n2 = sortKey.getDirection();
                Object object3 = ((RJaDataModelEntry)object).get(sortKey.toString());
                Object object4 = ((RJaDataModelEntry)object2).get(sortKey.toString());
                if (object3 == null && object4 == null) continue;
                if (object3 == null) {
                    n = -1;
                    break;
                }
                if (object4 == null) {
                    n = 1;
                    break;
                }
                if (object3 instanceof Comparable) {
                    n = ((Comparable)object3).compareTo(object4);
                    if (n == 0) continue;
                    break;
                }
                if (object3 instanceof Boolean) {
                    if (((Boolean)object3).equals(object4)) continue;
                    n = (Boolean)object3 != false ? 1 : -1;
                    break;
                }
                String string2 = object3.toString();
                n = string2.compareTo(string = object4.toString());
                if (n == 0) continue;
                break;
            }
            if (n2 == 1) {
                n = -n;
            }
            if (this.reverse) {
                n = -n;
            }
            return n;
        }
    }
}

