/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.horc;

import java.util.ArrayList;
import sanproject.client.com.RJCom;
import sanproject.client.com.RJComCHA;
import sanproject.client.data.RJDataControl;
import sanproject.client.horc.RJRmcpDataControl;
import sanproject.client.horc.RJRmcpGuide;
import sanproject.client.horc.RJRmcpMacro;
import sanproject.client.horc.RJRmcpPresetData;
import sanproject.common.Robj_interface_RJiCHAInfoDetail;
import sanproject.common.Robj_interface_RJiPortAttributeInfoDetail;
import sanproject.common.Robj_interface_RJiPortInfoDetail;

public class RJPortDataControl
implements RJRmcpMacro {
    private ArrayList alPort;
    private boolean m_chgFlag = false;
    public static final int RJPORT_MODE_UNKNOWN = 0;
    public static final int RJPORT_MODE_LCP = 1;
    public static final int RJPORT_MODE_RCP = 2;
    public static final int RJPORT_MODE_TARGET = 3;
    public static final int RJPORT_MODE_RCUTARGET = 4;
    public static final int RJPORT_MODE_INITIATOR = 5;
    public static final int RJPORT_MODE_EXTERNAL = 6;
    public static final int RJPORT_MODE_INIEXT = 7;
    static String[] RJPORT_MODE_STRING;
    public static final int RJPORT_CMD_INITIATOR = 0;
    public static final int RJPORT_CMD_RCUTARGET = 240;
    public static final int RJPORT_CMD_TARGET = 255;
    static final int[] RJPORT_MODE_CMD;
    static final int RJPORT_SPEED_UNKNOWN = 0;
    static final int RJPORT_SPEED_STANDARD = 1;
    static final int RJPORT_SPEED_HIGH = 2;
    static final int RJPORT_SPEED_2MPHIGH = 4;
    static final int RJPORT_SPEED_NA = 3;
    static final int RJPORT_SPEED_HIGH_H = 5;
    static final int RJPORT_SPEED_HIGH_L = 6;
    static final int RJPORT_SPEED_MIX = 99;
    static String[] RJPORT_SPEED_STRING;
    static final int RJPORT_UPDATE_NOTSPECIFIED = 0;
    static final int RJPORT_UPDATE_MODIFIED = 1;
    static String[] RJPORT_UPDATE_STRING;
    static final int RJPORT_SLPR0 = 0;
    private static short[] PortPCBMaskToCHANumber;
    RJDataControl data;
    RJRmcpGuide RJHorcGuide;
    private final int[] MP_2P1MP = new int[]{0, 1, 0, 1, 2, 3, 2, 3, 4, 5, 4, 5, 6, 7, 6, 7};
    private final int[] MP_2P2MP = new int[]{0, 0, 0, 0, 2, 2, 2, 2, 4, 4, 4, 4, 6, 6, 6, 6};
    private final int[] MP_2P2MP_ESCON = new int[]{0, 0, 2, 2, 4, 4, 6, 6};

    private void defineMacroString() {
        String[] stringArray = new String[9];
        stringArray[0] = RJRmcpGuide.Get3Asterisk.getGuidance();
        stringArray[1] = RJRmcpGuide.Port_LCP.getGuidance();
        stringArray[2] = RJRmcpGuide.Port_RCP.getGuidance();
        stringArray[3] = RJRmcpGuide.Port_Target.getGuidance();
        stringArray[4] = RJRmcpGuide.Port_RCUTarget.getGuidance();
        stringArray[5] = RJRmcpGuide.Port_Initiator.getGuidance();
        stringArray[6] = RJRmcpGuide.Port_External.getGuidance();
        stringArray[7] = RJRmcpGuide.Port_IniExt.getGuidance();
        stringArray[8] = "";
        String[] stringArray2 = stringArray;
        String[] stringArray3 = new String[5];
        stringArray3[0] = RJRmcpGuide.Get3Asterisk.getGuidance();
        stringArray3[1] = RJRmcpGuide.PortDataControlStandard.getGuidance();
        stringArray3[2] = RJRmcpGuide.PortDataControlHigh.getGuidance();
        stringArray3[3] = "";
        stringArray3[4] = RJRmcpGuide.PortDataControl2MPHigh.getGuidance();
        String[] stringArray4 = stringArray3;
        String[] stringArray5 = new String[2];
        stringArray5[0] = "";
        stringArray5[1] = RJRmcpGuide.PortDataControlModified.getGuidance();
        String[] stringArray6 = stringArray5;
        RJPORT_MODE_STRING = stringArray2;
        RJPORT_SPEED_STRING = stringArray4;
        RJPORT_UPDATE_STRING = stringArray6;
    }

    public void unittest_dmy(RJRmcpDataControl rJRmcpDataControl) {
    }

    public RJPortDataControl(RJRmcpDataControl rJRmcpDataControl) {
        this.data = rJRmcpDataControl.getDataControl();
        this.RJHorcGuide = rJRmcpDataControl.getRmcpGuide();
        this.defineMacroString();
        this.create(rJRmcpDataControl);
    }

    private void create(RJRmcpDataControl rJRmcpDataControl) {
        this.alPort = new ArrayList();
        Robj_interface_RJiPortInfoDetail[] robj_interface_RJiPortInfoDetailArray = rJRmcpDataControl.getPortInfoDetailData();
        if (robj_interface_RJiPortInfoDetailArray == null) {
            RJCom.putLog(this.data, this.RJHorcGuide.getTRCKey(), "create()", "rjDataPort = null", 0);
            return;
        }
        Robj_interface_RJiCHAInfoDetail[] robj_interface_RJiCHAInfoDetailArray = rJRmcpDataControl.getCHAInfoDetailData();
        if (robj_interface_RJiCHAInfoDetailArray == null) {
            RJCom.putLog(this.data, this.RJHorcGuide.getTRCKey(), "create()", "rjCha = null", 0);
            return;
        }
        byte[] byArray = null;
        this.alPort.clear();
        for (int i = 0; i < robj_interface_RJiPortInfoDetailArray.length; ++i) {
            Robj_interface_RJiPortInfoDetail robj_interface_RJiPortInfoDetail = robj_interface_RJiPortInfoDetailArray[i];
            RJPort rJPort = new RJPort();
            rJPort.m_Update = 0;
            rJPort.m_PortNo = robj_interface_RJiPortInfoDetail.getSPort();
            RJDataControl rJDataControl = RJDataControl.getDataControl();
            if (rJPort.m_PortNo < 0 || 256 <= rJPort.m_PortNo) {
                RJCom.putLog(this.data, this.RJHorcGuide.getTRCKey(), "create()", "PortNo = " + rJPort.m_PortNo, 0);
                rJPort = null;
                continue;
            }
            rJPort.m_SLPR = robj_interface_RJiPortInfoDetail.getSSLPR();
            rJPort.m_PortName = robj_interface_RJiPortInfoDetail.getStrPortDisplayName();
            boolean bl = false;
            for (int j = 0; j < robj_interface_RJiCHAInfoDetailArray.length; ++j) {
                Robj_interface_RJiCHAInfoDetail robj_interface_RJiCHAInfoDetail = robj_interface_RJiCHAInfoDetailArray[j];
                short s = RJComCHA.getPortToCHANumber((short)rJPort.m_PortNo);
                int n = 0;
                n = rJDataControl.isHM() ? 32 : 128;
                if (robj_interface_RJiCHAInfoDetail.getSCHAClusterNumber() != rJPort.m_PortNo / n + 1 || robj_interface_RJiCHAInfoDetail.getSCHANumber() != s) continue;
                bl = true;
                rJPort.m_Cluster = robj_interface_RJiCHAInfoDetail.getSCHAClusterNumber();
                rJPort.m_ChaNo = robj_interface_RJiCHAInfoDetail.getSCHANumber();
                rJPort.m_ChaType = robj_interface_RJiCHAInfoDetail.getByCHAPackageType();
                byArray = robj_interface_RJiCHAInfoDetail.getByCHAModeBit();
                if (0 == this.getAppType()) {
                    if (RJPortDataControl.isFibrePackage(rJPort.m_ChaType)) break;
                    bl = false;
                    break;
                }
                if (1 == this.getAppType()) {
                    if (RJPortDataControl.isSerialPackage(rJPort.m_ChaType)) break;
                    bl = false;
                    break;
                }
                if (RJPortDataControl.isSerialPackage(rJPort.m_ChaType) || RJPortDataControl.isFibrePackage(rJPort.m_ChaType)) break;
                bl = false;
                break;
            }
            if (!bl) continue;
            Robj_interface_RJiPortAttributeInfoDetail robj_interface_RJiPortAttributeInfoDetail = rJRmcpDataControl.getPortAttributeInfoDetailData(rJPort.m_PortNo);
            int n = -1;
            if (robj_interface_RJiPortAttributeInfoDetail != null) {
                n = robj_interface_RJiPortAttributeInfoDetail.getByPortKind();
            }
            switch (n) {
                case 1: 
                case 2: {
                    rJPort.m_Mode = n;
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    rJPort.m_Mode = n;
                    break;
                }
                default: {
                    rJPort.m_Mode = 0;
                    System.out.println("RJDataPortInf p=" + rJPort.m_PortNo + ":" + rJPort.m_PortName + ",cha=" + rJPort.m_Cluster + "-" + rJPort.m_ChaNo + ",pk=" + rJPort.m_ChaType + ",pkmod=" + byArray + ",spd=" + ",mod=" + n);
                }
            }
            rJPort.m_strMode = RJPORT_MODE_STRING[rJPort.m_Mode];
            rJPort.m_OrgMode = rJPort.m_Mode;
            if (RJPortDataControl.isFibrePackage(rJPort.m_ChaType)) {
                if (byArray == null) {
                    rJPort.m_Speed = 0;
                    rJPort.m_ModeId = this.calcModeId(rJPort.m_Cluster, rJPort.m_ChaNo, 0, rJPort.m_PortNo);
                    System.out.println("RJDataPortInf p=" + rJPort.m_PortNo + ":" + rJPort.m_PortName + ",cha=" + rJPort.m_Cluster + "-" + rJPort.m_ChaNo + ",pk=" + rJPort.m_ChaType + ",spd=" + ",mod=" + rJPort.m_Mode);
                } else {
                    rJPort.m_Speed = this.calcSpeed(byArray, rJPort.m_PortNo);
                    rJPort.m_ModeId = this.calcModeId(rJPort.m_Cluster, rJPort.m_ChaNo, 0, rJPort.m_PortNo);
                }
            } else if (RJPortDataControl.isSerialPackage(rJPort.m_ChaType)) {
                rJPort.m_Speed = 3;
                int n2 = rJPort.m_PortNo & 7;
                rJPort.m_ModeId = this.calcModeId(rJPort.m_Cluster, rJPort.m_ChaNo, 0, this.MP_2P2MP_ESCON[n2]);
            } else {
                rJPort.m_Speed = 0;
                rJPort.m_ModeId = this.calcModeId(rJPort.m_Cluster, rJPort.m_ChaNo, 0, rJPort.m_PortNo);
                System.out.println("RJDataPortInf p=" + rJPort.m_PortNo + ":" + rJPort.m_PortName + ",cha=" + rJPort.m_Cluster + "-" + rJPort.m_ChaNo + ",pk=" + rJPort.m_ChaType + ",pkmod=" + byArray + ",spd=" + ",mod=" + rJPort.m_Mode);
            }
            this.alPort.add(rJPort);
        }
    }

    private int calcModeId(int n, int n2, int n3, int n4) {
        return ((n * 100 + n2) * 100 + n3) * 1000 + n4;
    }

    private int calcSpeed(byte[] byArray, int n) {
        int n2 = 1;
        return n2;
    }

    private int getChp(int n, int n2, int n3) {
        int n4 = 99;
        int n5 = n2 & 7;
        switch (n3) {
            case 1: {
                n4 = this.MP_2P1MP[n5];
                break;
            }
            case 2: {
                n4 = this.MP_2P2MP[n5];
            }
        }
        return n4;
    }

    public int[] getPortList() {
        int n = this.alPort.size();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = ((RJPort)this.alPort.get((int)i)).m_PortNo;
        }
        return nArray;
    }

    private int searchPort(int n) {
        int n2 = -1;
        for (int i = 0; i < this.alPort.size(); ++i) {
            RJPort rJPort = (RJPort)this.alPort.get(i);
            if (n != rJPort.m_PortNo) continue;
            n2 = i;
            break;
        }
        return n2;
    }

    public int getCluster(int n) {
        int n2 = this.searchPort(n);
        if (n2 < 0) {
            return -1;
        }
        return ((RJPort)this.alPort.get((int)n2)).m_Cluster;
    }

    public int getMode(int n) {
        int n2 = this.searchPort(n);
        if (n2 < 0) {
            return -1;
        }
        return ((RJPort)this.alPort.get((int)n2)).m_Mode;
    }

    public int getOrgMode(int n) {
        int n2 = this.searchPort(n);
        if (n2 < 0) {
            return -1;
        }
        int n3 = ((RJPort)this.alPort.get((int)n2)).m_OrgMode;
        if ((n3 == 5 || n3 == 6) && this.isMIXmode(n)) {
            n3 = 7;
        }
        return n3;
    }

    public int getSpeed(int n) {
        int n2 = this.searchPort(n);
        if (n2 < 0) {
            return -1;
        }
        int n3 = ((RJPort)this.alPort.get((int)n2)).m_Speed;
        if (n3 == 2 && this.isMIXmode(n)) {
            n3 = 99;
        }
        return n3;
    }

    public boolean isMIXmode(int n) {
        boolean bl = false;
        int[] nArray = this.getPortListBeSameMode(n);
        if (nArray != null) {
            int n2 = 0;
            int n3 = 1;
            int n4 = 2;
            for (int i = 0; i < nArray.length; ++i) {
                int n5 = -1;
                int n6 = this.searchPort(nArray[i]);
                if (n6 >= 0) {
                    n5 = ((RJPort)this.alPort.get((int)n6)).m_OrgMode;
                }
                if (n5 == 5) {
                    n2 |= n3;
                    continue;
                }
                if (n5 != 6) break;
                n2 |= n4;
            }
            if (n2 == (n4 | n3)) {
                bl = true;
            }
        }
        return bl;
    }

    private int getModeId(int n) {
        int n2 = this.searchPort(n);
        if (n2 < 0) {
            return -1;
        }
        return ((RJPort)this.alPort.get((int)n2)).m_ModeId;
    }

    public String convertPortNoToName(int n) {
        int n2 = this.searchPort(n);
        if (n2 < 0) {
            return null;
        }
        return ((RJPort)this.alPort.get((int)n2)).m_PortName;
    }

    public String convertModeToString(int n) {
        return RJPORT_MODE_STRING[n];
    }

    public String convertSpeedToString(int n) {
        if (n == 99) {
            return RJRmcpGuide.PortDataControlMix.getGuidance();
        }
        return RJPORT_SPEED_STRING[n];
    }

    public int[] getPortListBeSameMode(int n) {
        int[] nArray = new int[256];
        int n2 = this.getModeId(n);
        int n3 = 0;
        for (int i = 0; i < this.alPort.size(); ++i) {
            if (n2 != ((RJPort)this.alPort.get((int)i)).m_ModeId) continue;
            nArray[n3++] = ((RJPort)this.alPort.get((int)i)).m_PortNo;
        }
        if (n3 == 0) {
            return null;
        }
        int[] nArray2 = new int[n3];
        for (int i = 0; i < n3; ++i) {
            nArray2[i] = nArray[i];
        }
        return nArray2;
    }

    public int[] getPortListMaybeDifferentMode() {
        int n;
        int[] nArray = new int[256];
        int[] nArray2 = new int[256];
        int n2 = 0;
        for (int i = 0; i < this.alPort.size(); ++i) {
            n = 1;
            int n3 = ((RJPort)this.alPort.get((int)i)).m_ModeId;
            for (int j = 0; j < n2 && n != 0; ++j) {
                if (n3 != nArray2[j]) continue;
                n = 0;
            }
            if (n == 0) continue;
            nArray[n2] = ((RJPort)this.alPort.get((int)i)).m_PortNo;
            nArray2[n2] = n3;
            ++n2;
        }
        if (n2 == 0) {
            return null;
        }
        int[] nArray3 = new int[n2];
        for (n = 0; n < n2; ++n) {
            nArray3[n] = nArray[n];
        }
        return nArray3;
    }

    public int[] getPortListMaybeDifferentMode(int n) {
        int n2;
        int[] nArray = new int[256];
        int[] nArray2 = new int[256];
        int n3 = 0;
        for (int i = 0; i < this.alPort.size(); ++i) {
            if (n != this.getOrgMode(((RJPort)this.alPort.get((int)i)).m_PortNo)) continue;
            n2 = 1;
            int n4 = ((RJPort)this.alPort.get((int)i)).m_ModeId;
            for (int j = 0; j < n3 && n2 != 0; ++j) {
                if (n4 != nArray2[j]) continue;
                n2 = 0;
            }
            if (n2 == 0) continue;
            nArray[n3] = ((RJPort)this.alPort.get((int)i)).m_PortNo;
            nArray2[n3] = n4;
            ++n3;
        }
        if (n3 == 0) {
            return null;
        }
        int[] nArray3 = new int[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            nArray3[n2] = nArray[n2];
        }
        return nArray3;
    }

    public int[] getPortListMaybeDifferentMode(int n, int n2) {
        int n3;
        int[] nArray = new int[256];
        int[] nArray2 = new int[256];
        int n4 = 0;
        for (int i = 0; i < this.alPort.size(); ++i) {
            n3 = 1;
            int n5 = ((RJPort)this.alPort.get((int)i)).m_ModeId;
            for (int j = 0; j < n4 && n3 != 0; ++j) {
                if (n5 != nArray2[j]) continue;
                n3 = 0;
            }
            if (n3 == 0 || ((RJPort)this.alPort.get((int)i)).m_Cluster != n || ((RJPort)this.alPort.get((int)i)).m_ChaNo != n2) continue;
            nArray[n4] = ((RJPort)this.alPort.get((int)i)).m_PortNo;
            nArray2[n4] = n5;
            ++n4;
        }
        if (n4 == 0) {
            return null;
        }
        int[] nArray3 = new int[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            nArray3[n3] = nArray[n3];
        }
        return nArray3;
    }

    public int getUpdate(int n) {
        int n2 = this.searchPort(n);
        if (n2 < 0) {
            return -1;
        }
        return ((RJPort)this.alPort.get((int)n2)).m_Update;
    }

    public int setUpdateMode(int n, int n2) {
        int n3 = this.searchPort(n);
        if (n3 < 0) {
            return -1;
        }
        int n4 = ((RJPort)this.alPort.get((int)n3)).m_Update;
        ((RJPort)this.alPort.get((int)n3)).m_Mode = n2;
        ((RJPort)this.alPort.get((int)n3)).m_Update = 1;
        this.m_chgFlag = true;
        return n4;
    }

    public String convertUpdateToString(int n) {
        return RJPORT_UPDATE_STRING[n];
    }

    public boolean getChgStatus() {
        return this.m_chgFlag;
    }

    public int convertModeToCmd(int n) {
        return RJPORT_MODE_CMD[n];
    }

    public static boolean isModeCmdEscon(int n) {
        boolean bl = false;
        switch (n) {
            case 1: 
            case 241: {
                bl = true;
                break;
            }
        }
        return bl;
    }

    public void setCancelUpdateMode() {
        for (int i = 0; i < this.alPort.size(); ++i) {
            int n;
            ((RJPort)this.alPort.get((int)i)).m_Mode = n = ((RJPort)this.alPort.get((int)i)).m_OrgMode;
            ((RJPort)this.alPort.get((int)i)).m_Update = 0;
            ((RJPort)this.alPort.get((int)i)).m_Preset.removeErrorList(-1, -1);
        }
        this.m_chgFlag = false;
    }

    public int setCancelUpdateMode(int n) {
        int n2;
        int n3 = this.searchPort(n);
        if (n3 < 0) {
            return -1;
        }
        ((RJPort)this.alPort.get((int)n3)).m_Mode = n2 = ((RJPort)this.alPort.get((int)n3)).m_OrgMode;
        ((RJPort)this.alPort.get((int)n3)).m_Update = 0;
        ((RJPort)this.alPort.get((int)n3)).m_Preset.removeErrorList(-1, -1);
        boolean bl = false;
        for (int i = 0; i < this.alPort.size(); ++i) {
            if (((RJPort)this.alPort.get((int)i)).m_Update != 1) continue;
            bl = true;
            break;
        }
        this.m_chgFlag = bl;
        return n2;
    }

    public boolean hasInitiatorMode() {
        boolean bl = false;
        for (int i = 0; i < this.alPort.size(); ++i) {
            if (((RJPort)this.alPort.get((int)i)).m_Mode != 5) continue;
            bl = true;
        }
        return bl;
    }

    public ArrayList getRCPList(int n) {
        ArrayList arrayList = new ArrayList();
        return arrayList;
    }

    int getAppType() {
        return this.RJHorcGuide.getAppChnlType();
    }

    public static boolean isFibrePackage(int n) {
        boolean bl = false;
        RJComCHA rJComCHA = new RJComCHA();
        bl = RJComCHA.isPKFibre((byte)n);
        return bl;
    }

    public static boolean isSerialPackage(int n) {
        boolean bl = false;
        switch (n) {
            case 40: {
                bl = true;
                break;
            }
        }
        return bl;
    }

    public void ResetErrorCode() {
        for (int i = 0; i < this.alPort.size(); ++i) {
            if (((RJPort)this.alPort.get((int)i)).m_Update != 1) continue;
            ((RJPort)this.alPort.get((int)i)).m_Preset.removeErrorList(-1, -1);
        }
    }

    public int setModifyUpdate(int n) {
        int n2;
        int n3 = this.searchPort(n);
        if (n3 < 0) {
            return -1;
        }
        ((RJPort)this.alPort.get((int)n3)).m_OrgMode = n2 = ((RJPort)this.alPort.get((int)n3)).m_Mode;
        ((RJPort)this.alPort.get((int)n3)).m_Update = 0;
        ((RJPort)this.alPort.get((int)n3)).m_Preset.removeErrorList(-1, -1);
        boolean bl = false;
        for (int i = 0; i < this.alPort.size(); ++i) {
            if (((RJPort)this.alPort.get((int)i)).m_Update != 1) continue;
            bl = true;
            break;
        }
        this.m_chgFlag = bl;
        return 0;
    }

    public int setErrorCode(int n, int n2, int n3) {
        int n4 = this.searchPort(n);
        if (n4 < 0) {
            return -1;
        }
        ((RJPort)this.alPort.get((int)n4)).m_Preset.addErrorList(n2, n3);
        return 0;
    }

    public String getErrorString(int n) {
        int n2 = this.searchPort(n);
        if (n2 < 0) {
            return "";
        }
        String string = ((RJPort)this.alPort.get((int)n2)).m_Preset.convertErrorListToString(this.RJHorcGuide);
        return string;
    }

    public ArrayList getErrorList(int n) {
        int n2 = this.searchPort(n);
        ArrayList arrayList = new ArrayList();
        if (n2 < 0) {
            return arrayList;
        }
        arrayList = ((RJPort)this.alPort.get((int)n2)).m_Preset.getErrorList();
        return arrayList;
    }

    public int getSLPR(int n) {
        int n2 = this.searchPort(n);
        if (n2 < 0) {
            return -1;
        }
        return ((RJPort)this.alPort.get((int)n2)).m_SLPR;
    }

    public ArrayList getAlPort() {
        return this.alPort;
    }

    public void setAlPortInfo(ArrayList arrayList) {
        if (arrayList == null) {
            return;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            if (!(arrayList.get(i) instanceof RJPort)) continue;
            RJPort rJPort = (RJPort)arrayList.get(i);
            if (rJPort.m_Update != 1) continue;
            this.setUpdateMode(rJPort.m_PortNo, rJPort.m_Mode);
            ArrayList arrayList2 = rJPort.m_Preset.getErrorList();
            for (int j = 0; j < arrayList2.size(); ++j) {
                int[] nArray = (int[])arrayList2.get(j);
                this.setErrorCode(rJPort.m_PortNo, nArray[0], nArray[1]);
            }
        }
    }

    static {
        RJPORT_MODE_CMD = new int[]{-1, 241, 1, 255, 240, 0, 15, -1};
        PortPCBMaskToCHANumber = new short[]{0, 2, 1, 3, 6, 8, 7, 9, 4, -1, 5, -1, 10, -1, 11, -1};
    }

    private class RJPort {
        int m_Cluster;
        int m_PortNo;
        String m_PortName;
        int m_Mode;
        String m_strMode;
        int m_Speed;
        int m_ModeId;
        int m_ChaType;
        int m_ChaNo;
        int m_Update;
        int m_OrgMode;
        RJRmcpPresetData m_Preset = new RJRmcpPresetData();
        int m_SLPR;

        private RJPort() {
        }
    }
}

