/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.ldevguard.dctl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import sanproject.client.com.RJComFuncPanel;
import sanproject.client.data.RJDataControl;
import sanproject.client.ldevguard.dctl.ManageGuardStatus;
import sanproject.client.ldevguard.dctl.ManageLdevInfo;
import sanproject.client.ldevguard.dctl.ManageLdkcCu;
import sanproject.client.ldevguard.dctl.ManageVtocArea;
import sanproject.client.ldevguard.dctl.OperationNothing;
import sanproject.client.ldevguard.dctl.RJDGDApplyThread;
import sanproject.client.ldevguard.dctl.RJDGDErrInfo;
import sanproject.client.ldevguard.dctl.RJDGDException;
import sanproject.client.ldevguard.dctl.RJDGDLdev;
import sanproject.client.ldevguard.dctl.VrmOperation;
import sanproject.client.ldevguard.gui.RJDGDApplyEndListener;
import sanproject.client.ldevguard.gui.logging.Logger;
import sanproject.client.openldevguard.dctl.com.ManageReadDataInterface;
import sanproject.client.openldevguard.dctl.com.ManageReadWriteDataInterface;
import sanproject.client.openldevguard.dctl.com.Mediator;
import sanproject.client.openldevguard.dctl.com.Operation;
import sanproject.serverux.dataimpl.SanRmiOutputInterface;

public class RJDGDDataControl
implements Mediator {
    private static final int ERP_CLIENT = 9210;
    private static final int ERC_UNKNOWN_ERR = 7060;
    private static final int ERC_NO_VOL = 8112;
    private final RJDataControl commonDataControl;
    private final String logName;
    private ArrayList applyEndListener;
    private ArrayList errorInfoList;
    private boolean noVolMsgFlg;
    private VrmOperation operation;
    private int hasLdkcNumber;
    private int hasCuGroup;
    private int selectLdkcNumber;
    private int selectCuGroup;
    private ArrayList managerList;
    private ManageLdkcCu ldkcCuManager;
    private ManageGuardStatus guardStatusManager;
    private ManageVtocArea vtocAreaManager;
    private ManageLdevInfo ldevInfoManager;

    public RJDGDDataControl(RJDataControl rJDataControl) {
        this.commonDataControl = rJDataControl;
        this.logName = "DataControl";
        this.operation = OperationNothing.getInstance();
        RJDGDErrInfo.clearMassageCache();
        this.noVolMsgFlg = true;
        this.hasLdkcNumber = -1;
        this.hasCuGroup = -1;
        this.selectLdkcNumber = -1;
        this.selectCuGroup = -1;
        this.applyEndListener = new ArrayList();
        this.errorInfoList = new ArrayList();
        this.managerList = new ArrayList();
        this.ldkcCuManager = new ManageLdkcCu(this);
        this.ldevInfoManager = new ManageLdevInfo(this);
        this.guardStatusManager = new ManageGuardStatus(this);
        this.vtocAreaManager = new ManageVtocArea(this);
    }

    public void initStructure() throws RJDGDException {
        Iterator iterator;
        long l = System.currentTimeMillis();
        Logger.put(Level.FINE, this.logName, "The initialization of the base data begins.");
        this.operation = OperationNothing.getInstance();
        this.hasLdkcNumber = -1;
        this.hasCuGroup = -1;
        List list = this.getDataManager(2);
        Iterator iterator2 = list.iterator();
        while (iterator2.hasNext()) {
            iterator = (ManageReadDataInterface)iterator2.next();
            this.initManagerData((ManageReadDataInterface)((Object)iterator));
        }
        long l2 = System.currentTimeMillis();
        iterator = new StringBuffer("The initialization of the base data ends. ");
        ((StringBuffer)((Object)iterator)).append("<Time = ").append(l2 - l).append(" ms>");
        Logger.put(Level.FINE, this.logName, ((StringBuffer)((Object)iterator)).toString());
        iterator = this.ldkcCuManager.getLdkcList().iterator();
        while (iterator.hasNext()) {
            Integer n = (Integer)iterator.next();
            ArrayList arrayList = this.ldkcCuManager.getCuGroupList(n);
            if (arrayList.size() <= 0) continue;
            this.noVolMsgFlg = false;
            break;
        }
        if (this.noVolMsgFlg) {
            this.noVolMsgFlg = false;
            throw new RJDGDException(9210, 8112);
        }
    }

    private void initData() throws RJDGDException {
        if (this.isChangeDisplayedArea()) {
            long l = System.currentTimeMillis();
            Object object = new StringBuffer("The initialization of the detail data begins. ");
            ((StringBuffer)object).append("<LDKC = ").append(this.selectLdkcNumber).append("> ");
            ((StringBuffer)object).append("<CU Group = ").append(this.selectCuGroup).append(">");
            Logger.put(Level.FINE, this.logName, ((StringBuffer)object).toString());
            object = this.getDataManagerSub(4);
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                ManageReadDataInterface manageReadDataInterface = (ManageReadDataInterface)iterator.next();
                this.initManagerData(manageReadDataInterface);
            }
            this.hasLdkcNumber = this.selectLdkcNumber;
            this.hasCuGroup = this.selectCuGroup;
            long l2 = System.currentTimeMillis();
            StringBuffer stringBuffer = new StringBuffer("The initialization of the detail data ends. ");
            stringBuffer.append("<Time = ").append(l2 - l).append(" ms>");
            Logger.put(Level.FINE, this.logName, stringBuffer.toString());
        }
    }

    private void initManagerData(ManageReadDataInterface manageReadDataInterface) throws RJDGDException {
        try {
            StringBuffer stringBuffer = new StringBuffer("    ");
            stringBuffer.append(manageReadDataInterface.getClass().getName());
            stringBuffer.append(".initData()");
            Logger.put(Level.FINE, this.logName, stringBuffer.toString());
            long l = System.currentTimeMillis();
            manageReadDataInterface.initData();
            long l2 = System.currentTimeMillis();
            StringBuffer stringBuffer2 = new StringBuffer("    initData() return. <Time = ");
            stringBuffer2.append(l2 - l).append(" ms>");
            Logger.put(Level.FINE, this.logName, stringBuffer2.toString());
        }
        catch (RJDGDException rJDGDException) {
            Logger.put(Level.WARNING, this.logName, rJDGDException.getMessage());
            throw rJDGDException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Logger.put(Level.WARNING, this.logName, exception.getMessage());
            throw new RJDGDException(9210, 7060);
        }
    }

    private boolean isChangeDisplayedArea() {
        return this.hasLdkcNumber != this.selectLdkcNumber || this.hasCuGroup != this.selectCuGroup;
    }

    protected void createErrInfo(Object[] objectArray) throws ClassCastException {
        this.errorInfoList.clear();
        List list = this.getDataManagerRW(4);
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] instanceof SanRmiOutputInterface) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    ManageReadWriteDataInterface manageReadWriteDataInterface = (ManageReadWriteDataInterface)iterator.next();
                    List list2 = manageReadWriteDataInterface.makeErrInfo((SanRmiOutputInterface)objectArray[i]);
                    this.errorInfoList.addAll(list2);
                }
                continue;
            }
            throw new ClassCastException(objectArray[i].getClass().getName());
        }
        String string = this.errorInfoList.size() + " errors created.";
        Logger.put(Level.FINE, this.logName, string);
    }

    protected List getApplyData() {
        Object object;
        ArrayList arrayList = new ArrayList();
        List list = this.getDataManagerRW(4);
        Object object2 = list.iterator();
        while (object2.hasNext()) {
            object = (ManageReadWriteDataInterface)object2.next();
            if (!object.isModify()) continue;
            List list2 = object.makeApplyData();
            arrayList.addAll(list2);
        }
        object2 = arrayList.size() + " Apply data created.";
        Logger.put(Level.FINE, this.logName, (String)object2);
        object = arrayList.iterator();
        while (object.hasNext()) {
            Logger.put(Level.FINE, this.logName, "    --> " + object.next().getClass().getName());
        }
        return arrayList;
    }

    protected List getApplyEndListener() {
        return this.applyEndListener;
    }

    protected VrmOperation getOperationState() {
        return this.operation;
    }

    protected ManageGuardStatus getGuardStatusManager() {
        return this.guardStatusManager;
    }

    protected ManageVtocArea getVtocAreaManager() {
        return this.vtocAreaManager;
    }

    protected ManageLdevInfo getLdevInfoManager() {
        return this.ldevInfoManager;
    }

    public List getDataManager(int n) {
        ArrayList<ManageReadDataInterface> arrayList = new ArrayList<ManageReadDataInterface>();
        Iterator iterator = this.managerList.iterator();
        while (iterator.hasNext()) {
            ManageReadDataInterface manageReadDataInterface = (ManageReadDataInterface)iterator.next();
            if (manageReadDataInterface.getDataPriority() != n) continue;
            arrayList.add(manageReadDataInterface);
        }
        return arrayList;
    }

    public List getDataManagerRW(int n) {
        ArrayList<ManageReadDataInterface> arrayList = new ArrayList<ManageReadDataInterface>();
        Iterator iterator = this.managerList.iterator();
        while (iterator.hasNext()) {
            ManageReadDataInterface manageReadDataInterface = (ManageReadDataInterface)iterator.next();
            if (!(manageReadDataInterface instanceof ManageReadWriteDataInterface) || manageReadDataInterface.getDataPriority() < n) continue;
            arrayList.add(manageReadDataInterface);
        }
        return arrayList;
    }

    public List getDataManagerSub(int n) {
        ArrayList<ManageReadDataInterface> arrayList = new ArrayList<ManageReadDataInterface>();
        Iterator iterator = this.managerList.iterator();
        while (iterator.hasNext()) {
            ManageReadDataInterface manageReadDataInterface = (ManageReadDataInterface)iterator.next();
            if (manageReadDataInterface.getDataPriority() < n) continue;
            arrayList.add(manageReadDataInterface);
        }
        return arrayList;
    }

    public void notifyOperation(Operation operation) {
        if (this.operation.equals(OperationNothing.getInstance())) {
            this.operation = (VrmOperation)operation;
        } else if (operation.equals(OperationNothing.getInstance())) {
            boolean bl;
            ManageReadWriteDataInterface manageReadWriteDataInterface;
            List list = this.getDataManagerRW(4);
            Iterator iterator = list.iterator();
            for (bl = false; !bl && iterator.hasNext(); bl |= manageReadWriteDataInterface.isModify()) {
                manageReadWriteDataInterface = (ManageReadWriteDataInterface)iterator.next();
            }
            if (!bl) {
                this.operation = OperationNothing.getInstance();
            }
        }
    }

    public void setDataManager(ManageReadDataInterface manageReadDataInterface) {
        Comparator comparator = new Comparator(){

            public int compare(Object object, Object object2) {
                if (object instanceof ManageReadDataInterface && object2 instanceof ManageReadDataInterface) {
                    int n;
                    int n2 = 0;
                    int n3 = ((ManageReadDataInterface)object).getDataPriority();
                    if (n3 < (n = ((ManageReadDataInterface)object2).getDataPriority())) {
                        n2 = -1;
                    } else if (n3 > n) {
                        n2 = 1;
                    }
                    return n2;
                }
                throw new ClassCastException();
            }
        };
        this.managerList.add(manageReadDataInterface);
        Collections.sort(this.managerList, comparator);
    }

    public int getLdkc() {
        return this.selectLdkcNumber;
    }

    public int getCuGroup() {
        return this.selectCuGroup;
    }

    public int getOperation() {
        return this.operation.getOperation();
    }

    public boolean addApplyEndListener(RJDGDApplyEndListener rJDGDApplyEndListener) {
        return this.applyEndListener.add(rJDGDApplyEndListener);
    }

    public void pushParentPanel(RJComFuncPanel rJComFuncPanel) {
        List list = this.getDataManagerSub(0);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ManageReadDataInterface manageReadDataInterface = (ManageReadDataInterface)iterator.next();
            manageReadDataInterface.pushParentPanel(rJComFuncPanel);
        }
    }

    public void applyStart() throws RJDGDException {
        RJDGDApplyThread rJDGDApplyThread = new RJDGDApplyThread(this);
        rJDGDApplyThread.setDataControl(this.commonDataControl);
        rJDGDApplyThread.start();
    }

    public RJDGDErrInfo[] getErrInfo() {
        return this.errorInfoList.toArray(new RJDGDErrInfo[0]);
    }

    public ArrayList getEquipLdkcList() {
        return this.ldkcCuManager.getLdkcList();
    }

    public ArrayList getEquipCuGroupList(int n) {
        return this.ldkcCuManager.getCuGroupList(n);
    }

    public ArrayList getEquipCuList(int n, int n2) {
        this.selectLdkcNumber = n;
        this.selectCuGroup = n2;
        return this.ldkcCuManager.getCuList(n, n2);
    }

    public int[] getEquipCuBitmap() {
        return this.ldkcCuManager.getCuBitmap(this.selectLdkcNumber, this.selectCuGroup);
    }

    public ArrayList getEquipLDEVIndex() {
        return this.guardStatusManager.getEquipLDEVIndex();
    }

    public RJDGDLdev[] getLdevs(int n) throws RJDGDException {
        ArrayList<RJDGDLdev> arrayList = new ArrayList<RJDGDLdev>();
        this.initData();
        for (int i = 0; i < 256; ++i) {
            if (!this.ldevInfoManager.isVrmVolume(this.hasLdkcNumber, n, i)) continue;
            arrayList.add(new RJDGDLdev(this, this.hasLdkcNumber, n, i));
        }
        return arrayList.toArray(new RJDGDLdev[0]);
    }

    public void initChangeData() {
        long l = System.currentTimeMillis();
        this.operation = OperationNothing.getInstance();
        List list = this.getDataManagerRW(4);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ManageReadWriteDataInterface manageReadWriteDataInterface = (ManageReadWriteDataInterface)iterator.next();
            manageReadWriteDataInterface.initChangeData();
        }
        long l2 = System.currentTimeMillis();
        StringBuffer stringBuffer = new StringBuffer("The change data is cleared. ");
        stringBuffer.append("<Time = ").append(l2 - l).append(" ms>");
        Logger.put(Level.FINE, this.logName, stringBuffer.toString());
    }

    public void updateData() {
        long l = System.currentTimeMillis();
        Logger.put(Level.FINE, this.logName, "The update of detailed data begins.");
        this.operation = OperationNothing.getInstance();
        List list = this.getDataManagerRW(4);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ManageReadWriteDataInterface manageReadWriteDataInterface = (ManageReadWriteDataInterface)iterator.next();
            manageReadWriteDataInterface.updateData();
        }
        long l2 = System.currentTimeMillis();
        StringBuffer stringBuffer = new StringBuffer("The update of detailed data ends. ");
        stringBuffer.append("<Time = ").append(l2 - l).append(" ms>");
        Logger.put(Level.FINE, this.logName, stringBuffer.toString());
    }
}

