/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.ldevguard.gui.main;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.event.TableModelEvent;
import sanproject.client.ldevguard.gui.main.ErrorInformationTableItem;
import sanproject.client.ldevguard.gui.main.LDEVGuardDataControlWrapper;
import sanproject.client.ldevguard.gui.main.LDEVGuardProperties;
import sanproject.client.ldevguard.gui.main.ViewDefine;
import sanproject.client.openldevguard.com.TableSortedEvent;
import sanproject.client.openldevguard.gui.OpenLDEVGuardException;
import sanproject.client.openldevguard.gui.main.AbstractPagingTableModel;
import sanproject.client.openldevguard.gui.main.ErrorInformationWrapper;
import sanproject.client.openldevguard.gui.main.TableDataItem;
import sanproject.client.openldevguard.utility.ObjectUtilities;

class ErrorInformationTableModel
extends AbstractPagingTableModel {
    public static final int ERROR_LOCATION = 0;
    public static final int ERROR_MESSAGE = 1;
    public static final int MAX_LENGTH = 2;
    private LDEVGuardDataControlWrapper mdcwWrapper;
    private List mlstApplyErrors;
    private int[] marrSorterType;
    private String[] marrColumnNames;
    private String[] marrColumnIDs;

    ErrorInformationTableModel(LDEVGuardDataControlWrapper lDEVGuardDataControlWrapper) {
        this.loadProperties();
        this.mdcwWrapper = lDEVGuardDataControlWrapper;
        this.mlstApplyErrors = new ArrayList();
        this.marrSorterType = new int[2];
        this.marrColumnIDs = new String[2];
        this.marrColumnNames = new String[2];
        this.marrSorterType[0] = 2;
        this.marrColumnIDs[0] = "location";
        this.marrColumnNames[0] = lDEVGuardDataControlWrapper.getGuidanceString("LDEV Guard/STRING_TAH_ERRORLOCATION");
        this.marrSorterType[1] = 1;
        this.marrColumnIDs[1] = "message";
        this.marrColumnNames[1] = lDEVGuardDataControlWrapper.getGuidanceString("COMMON/ErrorMsg");
    }

    public final int getMaxRowCountInPage() {
        int n = 0;
        return n;
    }

    protected final List getAllRowDataList() {
        return this.mlstApplyErrors;
    }

    protected final TableDataItem createCellObject(Object object, int n) {
        TableDataItem tableDataItem;
        ErrorInformationWrapper errorInformationWrapper = (ErrorInformationWrapper)object;
        switch (n) {
            case 0: {
                tableDataItem = ErrorInformationTableItem.createErrorLocationCellItem(this.mdcwWrapper, errorInformationWrapper);
                break;
            }
            case 1: {
                tableDataItem = ErrorInformationTableItem.createErrorMessageCellItem(this.mdcwWrapper, errorInformationWrapper);
                break;
            }
            default: {
                tableDataItem = null;
            }
        }
        return tableDataItem;
    }

    protected final TableDataItem[] getRowCellItems(Object object) {
        TableDataItem[] tableDataItemArray = new TableDataItem[2];
        for (int i = 0; i < 2; ++i) {
            tableDataItemArray[i] = this.createCellObject(object, i);
        }
        return tableDataItemArray;
    }

    protected final int getSorterType(int n) {
        int n2 = this.marrSorterType[n];
        return n2;
    }

    public final int getSortingIndex() {
        String string = ObjectUtilities.getClassName(this);
        String string2 = string + ".sortingindex";
        String string3 = LDEVGuardProperties.getProperty(string2);
        int n = -1;
        try {
            n = Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            String string4 = String.valueOf(n);
            LDEVGuardProperties.setProperty(string2, string4);
        }
        return n;
    }

    public final int getSortKind(int n) {
        int n2 = this.getSortingIndex();
        int n3 = -1;
        if (n2 == n) {
            String string = ObjectUtilities.getClassName(this);
            String string2 = string + ".sortkind";
            String string3 = LDEVGuardProperties.getProperty(string2);
            try {
                n3 = Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                String string4 = String.valueOf(n3);
                LDEVGuardProperties.setProperty(string2, string4);
            }
        }
        return n3;
    }

    protected final String[] getColumnNames() {
        String[] stringArray = this.marrColumnNames;
        return stringArray;
    }

    protected final String[] getColumnIDs() {
        String[] stringArray = this.marrColumnIDs;
        return stringArray;
    }

    private void loadProperties() {
        String string;
        String string2 = ObjectUtilities.getClassName(this);
        String string3 = string2 + ".sortingindex";
        int n = -1;
        if (ViewDefine.isSupportLoadViewProperties() && (string = LDEVGuardProperties.getProperty(string3)) != null && !string.equals("")) {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                n = -1;
            }
        }
        string = String.valueOf(n);
        LDEVGuardProperties.setProperty(string3, string);
        string3 = string2 + ".sortkind";
        n = 0;
        if (ViewDefine.isSupportLoadViewProperties() && (string = LDEVGuardProperties.getProperty(string3)) != null && !string.equals("")) {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
        }
        string = String.valueOf(n);
        LDEVGuardProperties.setProperty(string3, string);
    }

    public final void initializeData() throws OpenLDEVGuardException {
        ErrorInformationWrapper[] errorInformationWrapperArray = this.mdcwWrapper.getApplyErrors();
        this.mlstApplyErrors = Arrays.asList(errorInformationWrapperArray);
        this.updateCellData();
        TableModelEvent tableModelEvent = new TableModelEvent(this, -1);
        this.fireTableChanged(tableModelEvent);
        int n = this.getSortingIndex();
        int n2 = this.getSortKind(n);
        TableSortedEvent tableSortedEvent = new TableSortedEvent(this, n, n2);
        this.fireTableSorted(tableSortedEvent);
    }

    public final void requestSort(int n) {
        int n2 = this.getSortKind(n);
        n2 = this.getNextSortKind(n, n2);
        this.updateSortingFlags(n, n2);
        this.updateSortCellData(n, n2);
        n2 = this.getRowCount();
        TableModelEvent tableModelEvent = new TableModelEvent(this, 0, n2);
        this.fireTableChanged(tableModelEvent);
        n2 = this.getSortingIndex();
        int n3 = this.getSortKind(n2);
        TableSortedEvent tableSortedEvent = new TableSortedEvent(this, n2, n3);
        this.fireTableSorted(tableSortedEvent);
    }

    private void updateSortingFlags(int n, int n2) {
        String string = ObjectUtilities.getClassName(this);
        String string2 = String.valueOf(n);
        String string3 = String.valueOf(n2);
        LDEVGuardProperties.setProperty(string + ".sortingindex", string2);
        LDEVGuardProperties.setProperty(string + ".sortkind", string3);
    }

    public final void changePreviousPage() {
        int n = this.getShowPage();
        this.updateChangePageAt(n - 1);
        int n2 = this.getRowCount();
        int n3 = this.getColumnCount();
        TableModelEvent tableModelEvent = new TableModelEvent(this, 0, n2, n3, -1);
        this.fireTableChanged(tableModelEvent);
    }

    public final void changeNextPage() {
        int n = this.getShowPage();
        this.updateChangePageAt(n + 1);
        int n2 = this.getRowCount();
        int n3 = this.getColumnCount();
        TableModelEvent tableModelEvent = new TableModelEvent(this, 0, n2, n3, -1);
        this.fireTableChanged(tableModelEvent);
    }
}

