/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.monitor.com;

import java.text.DecimalFormat;
import sanproject.client.com.RJComUty;
import sanproject.client.com.RJcGuide;
import sanproject.client.com.RJcTreePanel;
import sanproject.client.monitor.com.RJHihDataSupplier;
import sanproject.client.monitor.com.RJHihLdevElement;
import sanproject.client.monitor.com.RJHihLdevItemOwnerID;
import sanproject.client.monitor.com.RJHihPGrpElement;
import sanproject.common.Robj_interface_RJiLDEVIndex;
import sanproject.common.Robj_interface_RJiPGIndex;
import sanproject.serversx.data.RJiPGIndex;
import sanproject.serverux.dataimpl.RJiLDEVInfoDetail3;

public class RJHihHiLdevElement
extends RJHihLdevElement {
    private static final DecimalFormat cylFormat = new DecimalFormat("#,##0");
    private static final DecimalFormat gbFormat = new DecimalFormat("#0.00");
    private byte volumeFlag;
    private Long capacity = null;
    private Long lbacount = null;
    private String raidLevel = null;
    private int fb4 = -1;
    private int pg = -1;
    private boolean reserve = false;
    private String hdd = null;
    private Integer luPath = null;
    private int luseCount = -1;
    protected int ownerID = -1;
    protected RJHihLdevItemOwnerID itemOwnerID = null;
    private int slprNo = 0;
    private int vmaInfo = 0;
    private boolean jnlVolInfo = false;
    private boolean cvsInfo = false;
    private String poolCapacity = null;
    private String poolRemaining = null;
    private Integer poolId = null;
    private boolean aouVol = false;
    private boolean internalVol = true;
    private boolean sysDisk = false;
    private byte protection = 0;
    private boolean lockVol = false;
    private boolean odmVol = false;

    public RJHihHiLdevElement(int n, int n2, int n3) {
        this(n, n2, n3, null, null);
    }

    public RJHihHiLdevElement(int n, int n2, int n3, RJHihDataSupplier rJHihDataSupplier, RJcTreePanel rJcTreePanel) {
        super(n, n2, n3, rJHihDataSupplier, rJcTreePanel);
    }

    public RJHihHiLdevElement(Robj_interface_RJiLDEVIndex robj_interface_RJiLDEVIndex, RJHihDataSupplier rJHihDataSupplier, RJcTreePanel rJcTreePanel) {
        super(robj_interface_RJiLDEVIndex, rJHihDataSupplier, rJcTreePanel);
    }

    public void initDetail(RJiLDEVInfoDetail3 rJiLDEVInfoDetail3) {
        int n;
        super.initDetail(rJiLDEVInfoDetail3);
        this.volumeFlag = rJiLDEVInfoDetail3.getByVolumeFlag();
        this.slprNo = rJiLDEVInfoDetail3.getSSLPR();
        this.raidLevel = this.supplier.changeRAIDLevel(rJiLDEVInfoDetail3.getIRaidLevel());
        if (this.raidLevel.equals("")) {
            this.raidLevel = "-";
        }
        this.reserve = rJiLDEVInfoDetail3.isBHIHSMReserve();
        this.jnlVolInfo = rJiLDEVInfoDetail3.isBJNLVolume();
        int n2 = rJiLDEVInfoDetail3.getIFB4();
        Robj_interface_RJiPGIndex robj_interface_RJiPGIndex = this.supplier.getRepresentivePG(n2, n = rJiLDEVInfoDetail3.getIPG());
        if (robj_interface_RJiPGIndex == null) {
            n2 = robj_interface_RJiPGIndex.getIFB4();
            n = robj_interface_RJiPGIndex.getIPG();
        }
        this.fb4 = n2;
        this.pg = n;
        this.capacity = new Long(rJiLDEVInfoDetail3.getLLDEVSize());
        this.lbacount = new Long(rJiLDEVInfoDetail3.getLLDEVLBASize());
        this.luPath = new Integer(rJiLDEVInfoDetail3.getILUPathNumber());
        this.luseCount = rJiLDEVInfoDetail3.getSLUSEElmCount();
        this.vmaInfo = rJiLDEVInfoDetail3.getByVolumeInfo();
        if (this.isExternal()) {
            this.hdd = RJcGuide.text("Performance/ExternalHDD");
        }
        this.cvsInfo = rJiLDEVInfoDetail3.isBCvsVolume();
        this.internalVol = rJiLDEVInfoDetail3.isInternalVolume();
        this.aouVol = rJiLDEVInfoDetail3.isAOUVvol();
        this.sysDisk = rJiLDEVInfoDetail3.isBSystemDisk();
        this.protection = rJiLDEVInfoDetail3.getByProtectionLevel();
        this.lockVol = rJiLDEVInfoDetail3.isBLockVolume();
        this.odmVol = rJiLDEVInfoDetail3.isBOdmVolume();
    }

    public Long getCapacity() {
        return this.capacity;
    }

    public Long getLBACount() {
        return this.lbacount;
    }

    public int getVolumeFlg() {
        return this.volumeFlag;
    }

    public String toCapacityString() {
        String string = null;
        switch (this.volumeFlag) {
            case 1: 
            case 2: {
                string = cylFormat.format(this.capacity) + " " + RJcGuide.text("HIHSM/LdevCapacityCyl");
                break;
            }
            case 3: {
                string = RJComUty.ktoGSlong(this.capacity) + " " + RJcGuide.text("HIHSM/LdevCapacityGB");
                break;
            }
        }
        return string;
    }

    public String getRaidLevel() {
        return this.raidLevel;
    }

    public int getFB4() {
        return this.fb4;
    }

    public void setFB4(int n) {
        this.fb4 = n;
    }

    public int getPG() {
        return this.pg;
    }

    public void setPG(int n) {
        this.pg = n;
    }

    public Robj_interface_RJiPGIndex getPGIndex() {
        RJiPGIndex rJiPGIndex = new RJiPGIndex();
        rJiPGIndex.setPGIndex((int)((short)this.fb4), (int)((short)this.pg));
        return rJiPGIndex;
    }

    public RJHihPGrpElement getPGElement() {
        RJHihPGrpElement rJHihPGrpElement = new RJHihPGrpElement(this.fb4, this.pg, this.supplier);
        return rJHihPGrpElement;
    }

    public boolean isReserve() {
        return this.reserve;
    }

    public String getHDD() {
        return this.hdd;
    }

    public void setHDD(String string) {
        if (this.isInternal()) {
            this.hdd = string;
        }
    }

    public byte getProtection() {
        return this.protection;
    }

    public void setProtection(byte by) {
        this.protection = by;
    }

    public Integer getLUPath() {
        return this.luPath;
    }

    public boolean isLuse() {
        return this.luseCount != 1;
    }

    public boolean isExternal() {
        return this.external;
    }

    public int getOwnerID() {
        return this.ownerID;
    }

    public void setOwnerID(int n) {
        this.ownerID = n;
    }

    public RJHihLdevItemOwnerID getItemOwnerID() {
        RJHihLdevItemOwnerID rJHihLdevItemOwnerID = this.itemOwnerID;
        if (rJHihLdevItemOwnerID == null) {
            rJHihLdevItemOwnerID = new RJHihLdevItemOwnerID(this);
        }
        return rJHihLdevItemOwnerID;
    }

    public int getSlprNo() {
        return this.slprNo;
    }

    public int getVmaInfo() {
        return this.vmaInfo;
    }

    public boolean isJnlVol() {
        return this.jnlVolInfo;
    }

    public boolean isCvsVol() {
        if (this.getEmulationType().equals("OPEN-V")) {
            return true;
        }
        return this.cvsInfo;
    }

    public boolean is3390V() {
        return this.getEmulationType().equalsIgnoreCase("3390-V");
    }

    public void setPoolId(Integer n) {
        this.poolId = n;
    }

    public Integer getPoolId() {
        return this.poolId;
    }

    public boolean isPoolRelation() {
        boolean bl = false;
        if (this.isAouVol() && this.poolId != null && this.poolId > -1) {
            bl = true;
        }
        if (this.isInternal() || this.isExternal()) {
            bl = true;
        }
        return bl;
    }

    public void setPoolCapacity(String string) {
        this.poolCapacity = string;
    }

    public String getPoolCapacity() {
        return this.poolCapacity;
    }

    public void setPoolRemainderCapacity(String string) {
        this.poolRemaining = string;
    }

    public String getPoolRemainderCapacity() {
        return this.poolRemaining;
    }

    public boolean isAouVol() {
        return this.aouVol;
    }

    public boolean isInternal() {
        return this.internalVol;
    }

    public boolean isSysDisk() {
        return this.sysDisk;
    }

    public boolean isLockVol() {
        return this.lockVol;
    }

    public boolean isOdmVol() {
        return this.odmVol;
    }
}

