/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.monitor.performance.physical;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import sanproject.client.com.RJcConst;
import sanproject.client.com.RJcGuide;
import sanproject.client.com.abs.RJaComboBox;
import sanproject.client.com.abs.RJaComboItemListener;
import sanproject.client.monitor.com.RJHihChartData;
import sanproject.client.monitor.com.RJHihChartDataCollection;
import sanproject.client.monitor.com.RJHihDataSupplier;
import sanproject.client.monitor.com.RJHihExComboBox;
import sanproject.client.monitor.com.RJHihMonitoringInfo;
import sanproject.client.monitor.com.RJHihTimePair;
import sanproject.client.monitor.performance.RJHihPerfChartAxisComboBox;
import sanproject.client.monitor.performance.RJHihPerfChartPanel;

public class RJHihPhChartPanel
extends RJHihPerfChartPanel {
    public static final int CHART_Normal = 0;
    public static final int CHART_External = 1;
    public static final int CHART_CacheS = 2;
    public static final int CHART_CacheL = 4;
    private RJaComboBox detailComboBox;
    private Integer[] axisYResponse = new Integer[]{new Integer(10), new Integer(20), new Integer(50), new Integer(100), new Integer(200), new Integer(500), new Integer(1000), new Integer(2000), new Integer(5000), new Integer(10000), new Integer(20000), new Integer(50000)};
    private Integer[] axisYTrans = new Integer[]{new Integer(1), new Integer(2), new Integer(5), new Integer(10), new Integer(20), new Integer(50), new Integer(100), new Integer(200), new Integer(500), new Integer(1000), new Integer(2000), new Integer(5000), new Integer(10000)};
    private Object[][] axisYComboItems = new Object[][]{this.axisYResponse, this.axisYTrans};
    private Object[] detailComboItemsN = new Object[]{""};
    private Object[] detailComboItemsEx = new Object[]{"PerformanceManagement/DetailComboItemResponse", "PerformanceManagement/DetailComboItemTrans"};
    private Object[] detailComboItemsCS = new Object[]{"PerformanceManagement/DetailComboItemCacheUse", "PerformanceManagement/DetailComboItemWritePend"};
    private Object[] detailComboItemsCL = new Object[]{"PerformanceManagement/DetailComboItemWritePend"};
    private int detailComboKind = 0;
    private String[] axisTitles = new String[]{"PerformanceManagement/AxisXResponseLbl", "PerformanceManagement/AxisXTransLbl"};
    private boolean stayEvent = false;
    protected RJHihChartDataCollection chartCollection = null;

    public RJHihPhChartPanel() {
        this.createExtraPanel();
    }

    public void init(RJHihDataSupplier rJHihDataSupplier) {
        super.init(rJHihDataSupplier);
    }

    private void createExtraPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        Border border = BorderFactory.createEmptyBorder(0, 4, 4, 4);
        jPanel.setBorder(border);
        jPanel.setOpaque(false);
        JLabel jLabel = new JLabel(RJcGuide.text("PerformanceManagement/AxisYComboLbl"));
        jLabel.setFont(RJcConst.boldFont);
        RJHihPerfChartAxisComboBox rJHihPerfChartAxisComboBox = new RJHihPerfChartAxisComboBox();
        rJHihPerfChartAxisComboBox.setName("PerformanceManagement/AxisYComboBox");
        rJHihPerfChartAxisComboBox.setItems(this.axisYComboItems[0], this);
        rJHihPerfChartAxisComboBox.setEnabled(false);
        super.setAxisYComboBox(rJHihPerfChartAxisComboBox);
        JLabel jLabel2 = new JLabel();
        this.detailComboBox = new RJHihExComboBox();
        this.detailComboBox.setName("PerformanceManagement/DetailComboBox");
        this.detailComboBox.setItems(this.detailComboItemsN, new RJaComboItemListener(){

            public void comboItemStateChanged(int n) {
                RJHihPhChartPanel.this.detailComboItemChanged(n);
            }
        });
        this.detailComboBox.setPreferredSize(new Dimension(140, 24));
        this.detailComboBox.setFont(RJcConst.normalFont);
        this.detailComboBox.setHorizontalAlignment(2);
        this.detailComboBox.setEnabled(false);
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 4), 0, 0));
        jPanel.add((Component)rJHihPerfChartAxisComboBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)jLabel2, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.detailComboBox, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)jPanel, "North");
    }

    public void drawScale(RJHihChartDataCollection rJHihChartDataCollection) {
        if (this.detailComboBox.isEnabled()) {
            this.chartCollection = rJHihChartDataCollection;
            RJHihChartData rJHihChartData = (RJHihChartData)rJHihChartDataCollection.get(this.getChartKey());
            this.drawScale(rJHihChartData);
        } else {
            super.drawScale(rJHihChartDataCollection);
        }
    }

    public void drawChart(RJHihChartDataCollection rJHihChartDataCollection) {
        if (this.detailComboBox.isEnabled()) {
            RJHihChartData rJHihChartData = (RJHihChartData)rJHihChartDataCollection.get(this.getChartKey());
            this.drawChart(rJHihChartData);
        } else {
            super.drawChart(rJHihChartDataCollection);
        }
    }

    private Object getChartKey() {
        Object object = null;
        int n = this.detailComboBox.getSelectedIndex();
        switch (this.detailComboKind) {
            case 1: {
                object = this.detailComboItemsEx[n];
                break;
            }
            case 2: {
                object = this.detailComboItemsCS[n];
                break;
            }
            case 4: {
                object = this.detailComboItemsCL[n];
            }
        }
        return object;
    }

    public void clearChart() {
        this.chartCollection = null;
        super.clearChart();
    }

    protected String getYAxisTitle(RJHihChartData rJHihChartData) {
        String string = RJcGuide.text("PerformanceManagement/AxisYPerLbl");
        if (this.getAxisYComboBox().isEnabled()) {
            string = RJcGuide.text("PerformanceManagement/AxisYLbl");
            int n = this.detailComboBox.getSelectedIndex();
            if (n > 0) {
                string = RJcGuide.text("PerformanceManagement/AxisYSecLbl");
            }
        }
        return string;
    }

    protected double getYAxisMax() {
        double d = 100.0;
        if (this.getAxisYComboBox().isEnabled()) {
            int n = this.detailComboBox.getSelectedIndex();
            d = ((Integer)this.axisYComboItems[n][this.nChartMax]).intValue();
        }
        return d;
    }

    protected String getXAxisTitle(RJHihChartData rJHihChartData) {
        RJHihMonitoringInfo rJHihMonitoringInfo = this.supplier.getMonitoringInfo();
        RJHihTimePair rJHihTimePair = rJHihMonitoringInfo.getMonitoringTime();
        int n = rJHihMonitoringInfo.getIntervalTime();
        String string = "PerformanceManagement/AxisXDefaultLbl";
        if (this.detailComboKind == 1 && this.detailComboBox.isEnabled()) {
            int n2 = this.detailComboBox.getSelectedIndex();
            string = this.axisTitles[n2];
        }
        MessageFormat messageFormat = new MessageFormat(RJcGuide.text(string));
        String string2 = messageFormat.format(new Object[]{new Integer(n)});
        return string2;
    }

    public RJaComboBox getDetailComboBox() {
        return this.detailComboBox;
    }

    public void detailComboItemChanged(int n) {
        if (!this.stayEvent) {
            switch (this.detailComboKind) {
                case 1: {
                    this.detailComboItemChangedE(n);
                    break;
                }
            }
            if (this.chartCollection != null) {
                this.drawScale(this.chartCollection);
                this.drawChart(this.chartCollection);
            }
        }
    }

    private void detailComboItemChangedE(int n) {
        RJHihPerfChartAxisComboBox rJHihPerfChartAxisComboBox = this.getAxisYComboBox();
        rJHihPerfChartAxisComboBox.setEnabled(false);
        rJHihPerfChartAxisComboBox.setItems(this.axisYComboItems[n], this);
        rJHihPerfChartAxisComboBox.setEnabled(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void adjustComponent(int n) {
        RJHihPerfChartAxisComboBox rJHihPerfChartAxisComboBox = this.getAxisYComboBox();
        rJHihPerfChartAxisComboBox.setEnabled(false);
        this.detailComboBox.setEnabled(false);
        try {
            this.stayEvent = true;
            switch (n) {
                case 0: {
                    rJHihPerfChartAxisComboBox.setItems(this.axisYComboItems[0], this);
                    this.detailComboBox.setItems(this.detailComboItemsN, null);
                    return;
                }
                case 1: {
                    if (n == this.detailComboKind) return;
                    this.detailComboBox.setItems(this.detailComboItemsEx, null);
                    return;
                }
                case 2: {
                    if (n == this.detailComboKind) return;
                    this.detailComboBox.setItems(this.detailComboItemsCS, null);
                    return;
                }
                case 4: {
                    if (n == this.detailComboKind) return;
                    this.detailComboBox.setItems(this.detailComboItemsCL, null);
                    return;
                }
            }
            return;
        }
        finally {
            this.detailComboKind = n;
            this.stayEvent = false;
        }
    }
}

