/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.monitor.performance.physical;

import java.awt.EventQueue;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.event.AncestorEvent;
import sanproject.client.com.RJcTablePanel;
import sanproject.client.com.RJcTreePanel;
import sanproject.client.monitor.com.RJHihDataSupplier;
import sanproject.client.monitor.com.RJHihDef;
import sanproject.client.monitor.com.RJHihElement;
import sanproject.client.monitor.com.RJHihMonitoringInfo;
import sanproject.client.monitor.com.RJHihMonitoringInfoLN;
import sanproject.client.monitor.com.RJHihMonitoringInfoSN;
import sanproject.client.monitor.com.RJHihPageListInfo;
import sanproject.client.monitor.performance.RJHihPerfTreePanel;
import sanproject.client.monitor.performance.physical.RJHihPhRootElement;

public class RJHihPhysicalTreePanel
extends RJHihPerfTreePanel
implements RJHihDef {
    private String identifier = null;
    private String[] identifiers = new String[]{"ShortN", "LongN"};
    private String[] combItems;
    private int combIndex = 0;
    private String[] rangeCombItems;
    private int rangeCombIndex = 1;
    private boolean first = false;
    private JComponent buttonCompo = null;
    private RJHihElement selectedElement = null;

    public RJHihPhysicalTreePanel() {
        this(null, null);
    }

    public RJHihPhysicalTreePanel(RJHihDataSupplier rJHihDataSupplier, RJcTablePanel rJcTablePanel) {
        super(rJHihDataSupplier, rJcTablePanel);
        this.setTitle("PerformanceManagement/PhysicalTabLabel");
        this.combItems = new String[]{"PerformanceManagement/PhysicalComboItem0"};
        this.rangeCombItems = new String[]{"PerformanceManagement/RangeComboItemShort", "PerformanceManagement/RangeComboItemLong"};
        this.identifier = this.identifiers[0];
    }

    public void initMonitoringInfo(HashMap hashMap) {
        RJHihMonitoringInfo rJHihMonitoringInfo = null;
        rJHihMonitoringInfo = (RJHihMonitoringInfo)hashMap.get(this.identifiers[0]);
        if (rJHihMonitoringInfo == null) {
            rJHihMonitoringInfo = new RJHihMonitoringInfoSN(this.identifiers[0], this.supplier);
            hashMap.put(this.identifiers[0], rJHihMonitoringInfo);
        }
        if ((rJHihMonitoringInfo = (RJHihMonitoringInfo)hashMap.get(this.identifiers[1])) == null) {
            rJHihMonitoringInfo = new RJHihMonitoringInfoLN(this.identifiers[1], this.supplier);
            hashMap.put(this.identifiers[1], rJHihMonitoringInfo);
        }
    }

    public void ancestorAdded(AncestorEvent ancestorEvent) {
        super.ancestorAdded(ancestorEvent);
    }

    protected String getIdentifier() {
        return this.identifier;
    }

    protected Object[] getComboItems() {
        return this.combItems;
    }

    protected int getComboIndex() {
        return this.combIndex;
    }

    protected Object[] getRangeComboItems() {
        return this.rangeCombItems;
    }

    public int getRangeComboIndex() {
        return this.rangeCombIndex;
    }

    public void rangeComboItemChanged(int n) {
        if (n >= 0) {
            this.identifier = this.identifiers[n];
            if (this.termPanel != null) {
                this.supplier.changeAvailInfo(this.getIdentifier());
                this.termPanel.init();
            }
            if (this.buttonCompo != null) {
                this.buttonCompo.setEnabled(n == 1);
            }
            if (this.rangeCombIndex != n) {
                System.out.println("<><><><> rangeComboItemChanged " + n + " " + this.rangeCombobox.getSelectedItem());
                super.selectNode();
                this.rangeCombIndex = n;
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        RJHihPhysicalTreePanel.this.checkMonitoringTime();
                    }
                });
            }
        }
    }

    protected void setRootObject() {
        RJHihPhRootElement rJHihPhRootElement = new RJHihPhRootElement(this.supplier, (RJcTreePanel)this);
        this.setRootObject(rJHihPhRootElement);
    }

    public void setButtonCompo(JComponent jComponent) {
        this.buttonCompo = jComponent;
    }

    public RJHihElement getSelectedElement() {
        return this.selectedElement;
    }

    public void setSelectedElement(RJHihElement rJHihElement) {
        this.selectedElement = rJHihElement;
    }

    public void refreshTree() {
        RJHihPageListInfo rJHihPageListInfo;
        if (this.getSelectedElement() != null && (rJHihPageListInfo = this.getSelectedElement().getPageListInfo()) != null) {
            rJHihPageListInfo.mapClear();
        }
        this.setSelectedElement(null);
        super.refreshTree();
    }
}

