/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.openldevguard.gui.restoreview;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JTable;
import sanproject.client.com.restoreview.ComponentParser;
import sanproject.client.com.restoreview.DefaultTableComponentParser;
import sanproject.client.com.restoreview.TableComponentParser;
import sanproject.client.com.restoreview.UnsupportedComponentException;
import sanproject.client.com.restoreview.UnsupportedRestoreModeException;
import sanproject.client.com.restoreview.ViewRestorer;

public class SimpleTableViewRestorer
implements ViewRestorer {
    private int miRestoreMode;
    private TableComponentParser mclsComponentParser;
    private List mlstSelectionRowCells;

    public SimpleTableViewRestorer() {
        int n = 0;
        n |= 1;
        try {
            this.setRestoreMode(n);
        }
        catch (UnsupportedRestoreModeException unsupportedRestoreModeException) {
            throw new RuntimeException();
        }
        this.mclsComponentParser = new DefaultTableComponentParser();
        this.mlstSelectionRowCells = new ArrayList();
    }

    public final void saveViewComponent(Component component) throws UnsupportedComponentException {
        if (!(component instanceof JTable)) {
            String string = "Any components other than 'javax.swing.JTable' are not supported.";
            throw new UnsupportedComponentException(string);
        }
        JTable jTable = (JTable)component;
        this.mlstSelectionRowCells.clear();
        int n = jTable.getColumnCount();
        int[] nArray = jTable.getSelectedRows();
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray[i];
            Object[] objectArray = new Object[n];
            for (int j = 0; j < n; ++j) {
                objectArray[j] = jTable.getValueAt(n2, j);
            }
            this.mlstSelectionRowCells.add(objectArray);
        }
    }

    public final void restoreViewComponent(Component component) throws UnsupportedComponentException {
        if (!(component instanceof JTable)) {
            String string = "Any components other than 'javax.swing.JTable' are not supported.";
            throw new UnsupportedComponentException(string);
        }
        if (this.hasSavedViewComponent()) {
            JTable jTable = (JTable)component;
            int n = 0;
            n = this.getRestoreMode();
            TableComponentParser tableComponentParser = (TableComponentParser)this.getComponentParser();
            tableComponentParser.setAnalysisComponent(jTable);
            if ((n & 1) > 0) {
                Iterator iterator = this.mlstSelectionRowCells.iterator();
                while (iterator.hasNext()) {
                    Object[] objectArray = (Object[])iterator.next();
                    int n2 = tableComponentParser.searchTableRow(objectArray);
                    if (n2 == -1) continue;
                    jTable.addRowSelectionInterval(n2, n2);
                }
            }
        }
    }

    public final void setRestoreMode(int n) throws UnsupportedRestoreModeException {
        if (!this.isSupportedRestoreMode(n)) {
            String string = "The parameter which is not supported was specified [" + n + "].";
            throw new UnsupportedRestoreModeException(string);
        }
        this.miRestoreMode = n;
    }

    public final int getRestoreMode() {
        return this.miRestoreMode;
    }

    public final void setComponentParser(ComponentParser componentParser) {
        if (componentParser == null || !(componentParser instanceof TableComponentParser)) {
            String string = "Any components other than 'restoreview.TableComponentParser' are not supported.";
            throw new IllegalArgumentException(string);
        }
        this.mclsComponentParser = (TableComponentParser)componentParser;
    }

    public final ComponentParser getComponentParser() {
        return this.mclsComponentParser;
    }

    public final boolean isSupportedRestoreMode(int n) {
        int n2 = n;
        return (n2 &= 0xFFFFFFFE) == 0;
    }

    public final boolean hasSavedViewComponent() {
        boolean bl = !this.mlstSelectionRowCells.isEmpty();
        return bl;
    }

    public final void releaseSavedViewComponent() {
        this.mlstSelectionRowCells.clear();
    }
}

