/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.ppkey;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import sanproject.client.com.RJComUty;
import sanproject.client.ppkey.RJPPKeyMacro;
import sanproject.serverux.dataimpl.PPKPremablePPClass;
import sanproject.serverux.dataimpl.PPKget1PPInfo;
import sanproject.serverux.dataimpl.PPKget1PortableLicense;

public class RJPPKeyErrorTableData
implements RJPPKeyMacro {
    public int m_nDetailCode = 0;
    public String m_strPPName;
    public String m_strDevNum;
    public String m_strKeyKind;
    public String m_strTerm;
    public String m_strPresSize;
    public String m_strExteSize;
    public String m_strPreamblePP;
    public String m_strSuiteName;
    public String m_strErrCode = new String("405 ");
    public String keyCode = "";
    RJComUty uty = new RJComUty();
    public static final int INTEGER_OVERFLOW = 21474836;

    public RJPPKeyErrorTableData(PPKget1PPInfo pPKget1PPInfo) {
        this.m_nDetailCode = pPKget1PPInfo.nErrCode;
        this.m_strPPName = pPKget1PPInfo.strPPName;
        this.m_strKeyKind = pPKget1PPInfo.strLicenseType;
        this.m_strTerm = this.makeTerm(pPKget1PPInfo.nExpireDays, pPKget1PPInfo.nDeterDays);
        this.m_strSuiteName = new String("");
        String string = new String("" + Integer.toString(pPKget1PPInfo.nErrCode));
        this.m_strErrCode = this.m_strErrCode.concat(string);
        this.m_strDevNum = pPKget1PPInfo.nSN != 0L ? Long.toString(pPKget1PPInfo.nSN) : new String("");
        this.m_strPresSize = this.makePresentSize(pPKget1PPInfo.nPermitVol, pPKget1PPInfo.strLicenseType);
        this.m_strExteSize = this.makeExtendSize(pPKget1PPInfo.nIncCapa, pPKget1PPInfo.strLicenseType);
        this.m_strPreamblePP = new String("");
        for (int i = 0; i < pPKget1PPInfo.nRelPpCnt; ++i) {
            Object e = pPKget1PPInfo.strRelPpName.get(i);
            if (e == null) continue;
            String string2 = (String)e;
            this.m_strPreamblePP = this.m_strPreamblePP + string2;
            if (i >= pPKget1PPInfo.nRelPpCnt - 1) continue;
            this.m_strPreamblePP = this.m_strPreamblePP.concat(" , ");
        }
    }

    public RJPPKeyErrorTableData(String string, PPKget1PPInfo pPKget1PPInfo) {
        this.m_strSuiteName = string == null ? new String("") : new String(string);
        this.m_nDetailCode = pPKget1PPInfo.nErrCode;
        this.m_strPPName = pPKget1PPInfo.strPPName;
        this.m_strKeyKind = pPKget1PPInfo.strLicenseType;
        this.m_strTerm = this.makeTerm(pPKget1PPInfo.nExpireDays, pPKget1PPInfo.nDeterDays);
        String string2 = new String("" + Integer.toString(pPKget1PPInfo.nErrCode));
        this.m_strErrCode = this.m_strErrCode.concat(string2);
        this.m_strDevNum = Long.toString(pPKget1PPInfo.nSN);
        this.m_strPresSize = this.makePresentSize(pPKget1PPInfo.nPermitVol, pPKget1PPInfo.strLicenseType);
        this.m_strExteSize = this.makeExtendSize(pPKget1PPInfo.nIncCapa, pPKget1PPInfo.strLicenseType);
        this.m_strPreamblePP = new String("");
        for (int i = 0; i < pPKget1PPInfo.nRelPpCnt; ++i) {
            Object e = pPKget1PPInfo.strRelPpName.get(i);
            if (e == null) continue;
            String string3 = (String)e;
            this.m_strPreamblePP.concat(string3);
            if (i >= pPKget1PPInfo.nRelPpCnt - 1) continue;
            this.m_strPreamblePP = this.m_strPreamblePP.concat(" , ");
        }
    }

    public String makeTerm(int n, int n2) {
        String string = new String("");
        if (n != 0) {
            string = string.concat(Integer.toString(n));
        } else if (n2 != 0) {
            string = string.concat(Integer.toString(n2));
        }
        return string;
    }

    public String connectPremablePP(PPKPremablePPClass[] pPKPremablePPClassArray) {
        String string = new String();
        for (int i = 0; i < pPKPremablePPClassArray.length; ++i) {
            if (string.length() != 0) {
                string = string.concat(" , ");
            }
            string = string.concat(pPKPremablePPClassArray[i].strPremablePP);
        }
        return string;
    }

    public String makeExtendSize(int n, String string) {
        String string2 = new String("");
        if (!string.equalsIgnoreCase("Enterprise")) {
            if (n == -1) {
                string2 = string2.concat("Unlimited");
            } else if (0 < n) {
                int n2 = 0;
                n2 = n < 21474836 ? n * 100 : 2147483600;
                string2 = RJComUty.gtoTS1000(n2, 1);
            }
        }
        return string2;
    }

    public String makePresentSize(int n, String string) {
        String string2 = new String("");
        if (!string.equalsIgnoreCase("Enterprise")) {
            if (n == -1) {
                string2 = string2.concat("Unlimited");
            } else if (0 < n) {
                boolean bl = false;
                string2 = n + ".0";
            }
        }
        return string2;
    }

    public static List createAllErrors(PPKget1PPInfo pPKget1PPInfo) {
        ArrayList<RJPPKeyErrorTableData> arrayList = new ArrayList<RJPPKeyErrorTableData>();
        if (pPKget1PPInfo != null) {
            if (pPKget1PPInfo.nErrCode != -2) {
                RJPPKeyErrorTableData rJPPKeyErrorTableData = new RJPPKeyErrorTableData(pPKget1PPInfo);
                arrayList.add(rJPPKeyErrorTableData);
            } else {
                Object object;
                ArrayList arrayList2 = new ArrayList(pPKget1PPInfo.portableLicenseList);
                Iterator iterator = arrayList2.iterator();
                while (iterator.hasNext()) {
                    object = (PPKget1PortableLicense)iterator.next();
                    int n = object.nErrCode;
                    if (n == 0) continue;
                    RJPPKeyErrorTableData rJPPKeyErrorTableData = new RJPPKeyErrorTableData(pPKget1PPInfo);
                    rJPPKeyErrorTableData.m_strErrCode = String.valueOf(405) + " " + String.valueOf(n);
                    rJPPKeyErrorTableData.keyCode = object.strKeyCode;
                    pPKget1PPInfo.portableLicenseList.remove(object);
                    arrayList.add(rJPPKeyErrorTableData);
                }
                if (arrayList.isEmpty()) {
                    object = new IllegalStateException();
                    throw object;
                }
            }
        }
        return arrayList;
    }
}

