/*
 * Decompiled with CFR 0.152.
 */
package sanproject.serverux.surveil;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.rmi.AccessException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.Properties;
import java.util.Vector;
import sanproject.serverux.data.Logout;
import sanproject.serverux.data.RmiControlObj;
import sanproject.serverux.data.SANRmiException;
import sanproject.serverux.data.SanRmiMultiDKCUtility;
import sanproject.serverux.data.SanRmiTRlog;
import sanproject.serverux.surveil.RmiConObjEnvInfoSurve;

public class RmiSurveillance
extends Thread {
    protected int nTimeOut;
    protected int nPollingTime;
    protected int nInitWait;
    protected String strRmiObjURL;
    protected RmiControlObj rmicontrol;
    static Logout log;
    static final int nTIMEOUT_DEF = 1800;
    static final int nPOLLING_DEF = 10;
    static final int nINITWATE = 10;
    static final int nOK = 0;
    static final int nRETRY = 1;
    static final int nAPPEND = 2;
    static final String EXE_PROPERTY = "..\\..\\..\\..\\supervisor\\dkcman\\cnf\\env.properties";
    protected Calling calling = null;
    protected Vector excpactlist;

    static synchronized void logwrite(String string) {
        System.out.println("[RmiSurveillance]** " + string);
    }

    void initException() throws ClassNotFoundException {
        this.excpactlist = new Vector();
        this.excpactlist.add(new ExceptAct("java.rmi.AccessException", 1));
        this.excpactlist.add(new ExceptAct("java.rmi.activation.ActivateFailedException", 1));
        this.excpactlist.add(new ExceptAct("java.rmi.ConnectException", 2));
        this.excpactlist.add(new ExceptAct("java.rmi.ConnectIOException", 1));
        this.excpactlist.add(new ExceptAct("java.rmi.server.ExportException", 2));
        this.excpactlist.add(new ExceptAct("javax.transaction.InvalidTransactionException", 2));
        this.excpactlist.add(new ExceptAct("java.rmi.MarshalException", 2));
        this.excpactlist.add(new ExceptAct("java.rmi.NoSuchObjectException", 2));
        this.excpactlist.add(new ExceptAct("java.rmi.ServerError", 2));
        this.excpactlist.add(new ExceptAct("java.rmi.ServerException", 2));
        this.excpactlist.add(new ExceptAct("java.rmi.StubNotFoundException", 1));
        this.excpactlist.add(new ExceptAct("javax.transaction.TransactionRequiredException", 2));
        this.excpactlist.add(new ExceptAct("javax.transaction.TransactionRolledbackException", 2));
        this.excpactlist.add(new ExceptAct("java.rmi.UnexpectedException", 1));
        this.excpactlist.add(new ExceptAct("java.rmi.UnknownHostException", 1));
        this.excpactlist.add(new ExceptAct("java.rmi.UnmarshalException", 1));
        this.excpactlist.add(new ExceptAct("java.lang.Exception", 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RmiSurveillance(int n, int n2) throws ClassNotFoundException {
        RmiSurveillance.logwrite("RmiSurveillance() start");
        this.initException();
        this.nTimeOut = n2;
        this.nPollingTime = n;
        RmiSurveillance.logwrite("TimeOut = " + this.nTimeOut);
        RmiSurveillance.logwrite("Polinng = " + this.nPollingTime);
        if (this.nTimeOut == 0 || this.nPollingTime == 0) {
            RmiSurveillance.logwrite("Error timer is 0.");
            System.exit(6);
        }
        this.nInitWait = 10;
        this.rmicontrol = null;
        this.calling = new Calling();
        Properties properties = new Properties();
        InputStream inputStream = null;
        try {
            inputStream = new FileInputStream(new File(EXE_PROPERTY));
            properties.load(inputStream);
        }
        catch (Exception exception) {
            System.out.println("RmiSurveillance() :property file Error");
            exception.printStackTrace(System.out);
            SanRmiTRlog.outputTRlog((int)1);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        String string = properties.getProperty("com.hitachi.sanproject.registry.privateport");
        if (string == null) {
            string = "11099";
            RmiSurveillance.logwrite("Default port used:" + string);
            SanRmiTRlog.outputTRlog((int)2, (String)string);
        }
        this.strRmiObjURL = SanRmiMultiDKCUtility.makeLookupPath((String)("rmi://localhost:" + string + "/"));
        RmiSurveillance.logwrite("RmiSurveillance() end");
    }

    private int lookup() throws InterruptedException {
        int n = 0;
        try {
            this.calling.set(1);
            RmiSurveillance.logwrite("RmiSurveillance.lookup() start");
            RmiSurveillance.logwrite("lookup() strRmiObjURL:" + this.strRmiObjURL);
            this.rmicontrol = (RmiControlObj)Naming.lookup(this.strRmiObjURL);
            RmiSurveillance.logwrite("RmiSurveillance.lookup() end");
            this.calling.set(0);
        }
        catch (NotBoundException notBoundException) {
            n = this.checkNextAction(notBoundException);
        }
        catch (AccessException accessException) {
            n = this.checkNextAction(accessException);
        }
        catch (RemoteException remoteException) {
            n = this.checkNextAction(remoteException);
        }
        catch (MalformedURLException malformedURLException) {
            n = this.checkNextAction(malformedURLException);
        }
        return n;
    }

    private int remoteCall() throws InterruptedException {
        int n = 0;
        try {
            this.calling.set(1);
            this.rmicontrol.getTime();
            this.calling.set(0);
        }
        catch (RemoteException remoteException) {
            n = this.checkNextAction(remoteException);
        }
        catch (SANRmiException sANRmiException) {
            n = this.checkNextAction((Exception)((Object)sANRmiException));
        }
        return n;
    }

    public void run() {
        int n = 0;
        RmiSurveillance.logwrite("RmiSurveillance.run() start");
        try {
            RmiSurveillance.sleep(this.nInitWait * 1000);
            do {
                n = this.lookup();
                this.NextAction(n);
                RmiSurveillance.sleep(this.nPollingTime * 1000);
            } while (1 == n);
            RmiSurveillance.logwrite("Success lookup");
            while (n != 2) {
                RmiSurveillance.sleep(this.nPollingTime * 1000);
                n = this.remoteCall();
                this.NextAction(n);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            System.exit(1);
        }
        this.rmicontrol = null;
        RmiSurveillance.logwrite("RmiSurveillance.run() end");
    }

    private void NextAction(int n) {
        if (n != 0) {
            if (n == 1) {
                RmiSurveillance.logwrite("Error retry RemoteCall");
            } else if (n == 2) {
                RmiSurveillance.logwrite("RemoteCall Error. RmiSurveillance die.");
                System.exit(2);
            } else {
                RmiSurveillance.logwrite("Internal Error. RmiSurveillance die.");
                System.exit(3);
            }
        }
    }

    private int checkNextAction(Exception exception) {
        int n = 0;
        RmiSurveillance.logwrite(exception.toString());
        exception.printStackTrace(System.out);
        for (int i = 0; i < this.excpactlist.size(); ++i) {
            ExceptAct exceptAct = (ExceptAct)this.excpactlist.get(i);
            if (!exceptAct.cls.isInstance(exception)) continue;
            n = exceptAct.nAct;
            break;
        }
        RmiSurveillance.logwrite("Actions is " + n);
        return n;
    }

    public static void main(String[] stringArray) {
        Thread thread = null;
        RmiSurveillance.logwrite("RmiSurveillance.main() start");
        try {
            RmiConObjEnvInfoSurve rmiConObjEnvInfoSurve = new RmiConObjEnvInfoSurve();
            thread = new RmiSurveillance(rmiConObjEnvInfoSurve.getSurveillanceTimer(), rmiConObjEnvInfoSurve.getSurveillanceTimeOut());
            rmiConObjEnvInfoSurve = null;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            System.exit(4);
        }
        thread.setDaemon(true);
        thread.start();
        try {
            while (true) {
                int n = 0;
                int n2 = 10;
                while (1 == ((RmiSurveillance)thread).calling.get()) {
                    RmiSurveillance.sleep(1000L);
                    if (n2 < ++n) {
                        RmiSurveillance.logwrite("Calling waiting. " + n2 + "sec");
                        n2 *= 10;
                    }
                    if (((RmiSurveillance)thread).nTimeOut >= n) continue;
                    RmiSurveillance.logwrite("Calling TimeOut.");
                    break;
                }
                if (((RmiSurveillance)thread).nTimeOut >= n) {
                    RmiSurveillance.sleep(1000L);
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            System.exit(5);
        }
        RmiSurveillance.logwrite("RmiSurveillance.main() end");
    }

    class ExceptAct {
        String strClass;
        int nAct;
        Class cls;

        public ExceptAct(String string, int n) throws ClassNotFoundException {
            this.strClass = string;
            this.nAct = n;
            this.cls = Class.forName(string);
        }
    }

    class Calling {
        public static final int nNORMAL = 0;
        public static final int nCALLING = 1;
        private int stat = 0;

        public synchronized int get() {
            return this.stat;
        }

        public synchronized void set(int n) {
            this.stat = n;
        }
    }
}

