/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.rptdt.csv.wrapper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import sanproject.sn2.rptdt.csv.wrapper.SJdtCSVWrapperBase;
import sanproject.sn2.rptdt.util.SJdtRPTDTDevice;

public class SJdtLdevInfoCSVWrapper
extends SJdtCSVWrapperBase {
    private static final String csvName = "LdevInfo";
    private static final String[] keyColumnArray = new String[]{"LDEV#"};

    @Override
    public String getCsvName() {
        return csvName;
    }

    @Override
    public String[] getKeyColumnArray() {
        return keyColumnArray;
    }

    public List<String> getEccGroupValueSet(List<String> ldevSet) {
        ArrayList<String> result = new ArrayList<String>();
        List<String> eccGroupValueSet = this.getMatchedAllKeyRecordColumnValueSet(ldevSet, "ECC Group");
        for (String eccGroup : eccGroupValueSet) {
            if (!eccGroup.startsWith("E") && !StringUtils.isNumeric((String)eccGroup.substring(0, 1))) continue;
            result.add(eccGroup);
        }
        return result;
    }

    public List<String[]> getMachedAllRecordSet(List<String> eccGroupList) {
        ArrayList<String[]> result = new ArrayList<String[]>();
        for (String eccGroup : eccGroupList) {
            List<String[]> machedAllRecord = this.getMatchedAllRecord(eccGroup, "ECC Group");
            result.addAll(machedAllRecord);
        }
        return result;
    }

    public List<String[]> getUnallocatedRecordList(List<String[]> recordList) {
        ArrayList<String[]> unallocatedRecordList = new ArrayList<String[]>();
        for (String[] record : recordList) {
            if (!this.isUnallocatedRecord(record)) continue;
            unallocatedRecordList.add(record);
        }
        return unallocatedRecordList;
    }

    public String getSumSize(List<String> ldevSet) {
        BigDecimal result = BigDecimal.ZERO;
        for (String ldev : ldevSet) {
            String value = this.getKeyRecordColumnValue(ldev, "Volume Size(MB)");
            if (!value.matches("^[0-9]+$|^[0-9]+[.]?[0-9]+$")) continue;
            result = result.add(new BigDecimal(value));
        }
        result = result.setScale(2, 1);
        return result.toString();
    }

    public String getSumSize(List<String[]> recordList, String targetColumn) {
        BigDecimal result = new BigDecimal(0);
        for (String[] record : recordList) {
            String value = this.getValue(record, targetColumn);
            if (!value.matches("^[0-9]+$|^[0-9]+[.]?[0-9]+$")) continue;
            result = result.add(new BigDecimal(value));
        }
        result = result.setScale(2, 1);
        return result.toString();
    }

    private boolean isUnallocatedRecord(String[] record) {
        boolean result = false;
        String allocated = this.getValue(record, "Allocated");
        if ("N".equals(allocated)) {
            String ldevAttribute = this.getValue(record, "LDEV Attribute");
            if (SJdtRPTDTDevice.isHmdev()) {
                if (!("System Disk".equals(ldevAttribute) || "Journal".equals(ldevAttribute) || "Pool".equals(ldevAttribute) || "Reserve".equals(ldevAttribute) || "Quorum Disk".equals(ldevAttribute))) {
                    result = true;
                }
            } else if (!("Journal".equals(ldevAttribute) || "Pool".equals(ldevAttribute) || "Reserve".equals(ldevAttribute))) {
                result = true;
            }
        }
        return result;
    }
}

