/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.rptdt.report.generator;

import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.VelocityContext;
import sanproject.sn2.rptdt.csv.SJdtCSVWrapperManager;
import sanproject.sn2.rptdt.csv.wrapper.SJdtCacheInfoCSVWrapper;
import sanproject.sn2.rptdt.exception.SJdtRPTDTException;
import sanproject.sn2.rptdt.report.SJdtReportGeneratorManager;
import sanproject.sn2.rptdt.report.generator.Pcb;
import sanproject.sn2.rptdt.report.generator.SJdtCachedetailReportGenerator;
import sanproject.sn2.rptdt.util.SJdtRPTDTDevice;

public class SJdtHMCachedetailReportGenerator
extends SJdtCachedetailReportGenerator {
    private static Logger logger = Logger.getLogger(SJdtCachedetailReportGenerator.class.getName());
    private static final String REPORT_NAME = "Cachedetail";
    private static final String VM_LIBLARY_PATH = "/sanproject/sn2/rptdt/template/cachedetail/vm/VM_HMcachedetail_library.vm";
    private static final String CONTENTS_BODY_VM_FILE_PATH = "/sanproject/sn2/rptdt/template/cachedetail/vm/contentsBody_HMCachedetail.vm";

    @Override
    public void generateContentsBody() throws SJdtRPTDTException {
        VelocityContext context = SJdtReportGeneratorManager.getVelocityContext();
        context.put("libraryPath", (Object)VM_LIBLARY_PATH);
        this.setFixedStr(context);
        this.setVariableStr(context);
        String generateFilePath = this.OUTPUT_HTML_DIR + this.getContentsBodyHtmlFileName();
        SJdtReportGeneratorManager.generateFile(context, CONTENTS_BODY_VM_FILE_PATH, generateFilePath);
        String cssFileName = "contentsBody_Cachedetail.css";
        String originalFilePath = "/sanproject/sn2/rptdt/template/cachedetail/css/" + cssFileName;
        String destFilePath = this.OUTPUT_CSS_DIR + cssFileName;
        SJdtReportGeneratorManager.copyFile(originalFilePath, destFilePath);
        SJdtReportGeneratorManager.copyAllFile(this, "/cachedetail/img/", this.OUTPUT_IMG_DIR);
    }

    private void setFixedStr(VelocityContext context) {
        context.put("cacheSize", (Object)SJdtReportGeneratorManager.getGuidanceValue("Cachedetail.cacheSize"));
        context.put("sharedMemorySize", (Object)SJdtReportGeneratorManager.getGuidanceValue("Cachedetail.sharedMemorySize"));
        context.put("gb", (Object)SJdtReportGeneratorManager.getGuidanceValue("Cachedetail.gb"));
        context.put("mb", (Object)SJdtReportGeneratorManager.getGuidanceValue("Cachedetail.mb"));
        context.put("ctl1", (Object)SJdtReportGeneratorManager.getGuidanceValue("Cachedetail.ctl1"));
        context.put("ctl2", (Object)SJdtReportGeneratorManager.getGuidanceValue("Cachedetail.ctl2"));
        context.put("notInstalled", (Object)SJdtReportGeneratorManager.getGuidanceValue("Cachedetail.notInstalled"));
    }

    private void setVariableStr(VelocityContext context) {
        String model = SJdtRPTDTDevice.getModel(SJdtRPTDTDevice.getModelInfo());
        context.put("modelInfo", (Object)model);
        this.setCacheInfo(context);
    }

    private void setCacheInfo(VelocityContext context) {
        SJdtCacheInfoCSVWrapper cacheInfo = (SJdtCacheInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("CacheInfo.csv");
        HashMap<String, Pcb> cacheMap = new HashMap<String, Pcb>();
        int dkc0CacheSize = 0;
        List<String[]> csvDataList = cacheInfo.getCsvDataList();
        String dkc0SharedMemorySize = cacheInfo.getSumSizeDecimalPoint(csvDataList, "SM Size(MB)");
        for (String[] cacheInfoRecord : csvDataList) {
            String label = cacheInfo.getValue(cacheInfoRecord, "Location");
            Pcb pcb = new Pcb();
            String cmg0SizeStr = StringUtils.defaultIfEmpty((String)cacheInfo.getValue(cacheInfoRecord, "CMG#0 Size(GB)"), (String)"0");
            String cmg1SizeStr = StringUtils.defaultIfEmpty((String)cacheInfo.getValue(cacheInfoRecord, "CMG#1 Size(GB)"), (String)"0");
            String cacheSizeStr = StringUtils.defaultIfEmpty((String)cacheInfo.getValue(cacheInfoRecord, "Cache Size(GB)"), (String)"0");
            int cmg0Size = this.getSize(cmg0SizeStr);
            int cmg1Size = this.getSize(cmg1SizeStr);
            int cmgSize = cmg0Size + cmg1Size;
            int cacheSize = this.getSize(cacheSizeStr);
            pcb.setCmgSize(cmgSize);
            pcb.setCmg0Size(cmg0Size);
            pcb.setCmg1Size(cmg1Size);
            pcb.setCacheSize(cacheSize);
            cacheMap.put(label, pcb);
            dkc0CacheSize += cacheSize;
        }
        context.put("cacheMap", cacheMap);
        context.put("valueOfDkc0CacheSize", (Object)String.valueOf(dkc0CacheSize));
        context.put("valueOfDkc0SharedMemorySize", (Object)dkc0SharedMemorySize);
    }

    private int getSize(String target) {
        if ("-".equals(target)) {
            return 0;
        }
        return Integer.parseInt(target);
    }
}

