/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.rptdt.report.generator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import sanproject.sn2.rptdt.csv.SJdtCSVWrapperManager;
import sanproject.sn2.rptdt.csv.wrapper.SJdtIscsiHostInfoCSVWrapper;
import sanproject.sn2.rptdt.csv.wrapper.SJdtIscsiTargetInfoCSVWrapper;
import sanproject.sn2.rptdt.csv.wrapper.SJdtLdevInfoCSVWrapper;
import sanproject.sn2.rptdt.csv.wrapper.SJdtLunInfoCSVWrapper;
import sanproject.sn2.rptdt.csv.wrapper.SJdtLunPortInfoCSVWrapper;
import sanproject.sn2.rptdt.csv.wrapper.SJdtWwnInfoCSVWrapper;
import sanproject.sn2.rptdt.report.generator.SJdtTableReportGenerator;
import sanproject.sn2.rptdt.util.SJdtRPTDTDevice;

public class SJdtLunReportGenerator
extends SJdtTableReportGenerator {
    private static final String REPORT_NAME = "Lun";
    private static final boolean IS_GRAPHIC_REPORT = false;
    private static final boolean USE_TABLE_SORT = true;
    private static final boolean USE_CONTENTS_FOOTER = false;
    private static final String[] HEADER_KEY_ARRAY = new String[]{"portLocation", "portInternalWwn", "portSecurity", "hostGroup", "hostMode", "hostModeOption", "lun", "ldevId", "emulationType", "capacity"};
    private static final String[] HM_HEADER_KEY_ARRAY = new String[]{"portLocation", "hbaWwnIscsiName", "portSecurity", "hostGroupIscsiTargetAlias", "iscsiTargetName", "hostMode", "hostModeOption", "lun", "ldevId", "emulationType", "capacity", "asymmetricAccessState"};
    private static final int COLUMN_LENGTH = SJdtLunReportGenerator.getColumnLengthForKeySort(HEADER_KEY_ARRAY.length);
    private static final int HM_COLUMN_LENGTH = SJdtLunReportGenerator.getColumnLengthForKeySort(HM_HEADER_KEY_ARRAY.length);
    private static final String MENU_LINK_VIEW_KEY = "Common.menu.Lun";
    private static final String EXPLANATION_KEY = "Common.explanation.Lun";
    private static final String TABLE_HEADER_BASE_KEY = "Lun.table.header";
    private static final String REPORT_FRAMESET_HTML_FILE_NAME = "Lun.html";
    private static final String MENU_FRAMESET_HTML_FILE_NAME = "menuFrameset_Lun.html";
    private static final String MENU_BODY_HTML_FILE_NAME = "menuBody_Lun.html";
    private static final String CONTENTS_FRAMESET_HTML_FILE_NAME = "contentsFrameset_Lun.html";
    private static final String CONTENTS_TITLE_HTML_FILE_NAME = "contentsTitle_Lun.html";
    private static final String CONTENTS_BODY_HTML_FILE_NAME = "contentsBody_Lun.html";
    private static final String ADD_HEX_STR = "0x";

    @Override
    public String getReportName() {
        return REPORT_NAME;
    }

    @Override
    public boolean isGraphicReport() {
        return false;
    }

    @Override
    public boolean useTableSort() {
        return true;
    }

    @Override
    public boolean useContentsFooter() {
        return false;
    }

    @Override
    public String[] getTableHeaderKeyArray() {
        if (SJdtRPTDTDevice.isHmdev()) {
            return HM_HEADER_KEY_ARRAY;
        }
        return HEADER_KEY_ARRAY;
    }

    @Override
    public String getMenuLinkViewKey() {
        return MENU_LINK_VIEW_KEY;
    }

    @Override
    public String getExplanationKey() {
        return EXPLANATION_KEY;
    }

    @Override
    public String getTableHeaderBaseKey() {
        return TABLE_HEADER_BASE_KEY;
    }

    @Override
    public String getReportFramesetHtmlFileName() {
        return REPORT_FRAMESET_HTML_FILE_NAME;
    }

    @Override
    public String getMenuFramesetHtmlFileName() {
        return MENU_FRAMESET_HTML_FILE_NAME;
    }

    @Override
    public String getMenuBodyHtmlFileName() {
        return MENU_BODY_HTML_FILE_NAME;
    }

    @Override
    public String getContentsFramesetHtmlFileName() {
        return CONTENTS_FRAMESET_HTML_FILE_NAME;
    }

    @Override
    public String getContentsTitleHtmlFileName() {
        return CONTENTS_TITLE_HTML_FILE_NAME;
    }

    @Override
    public String getContentsBodyHtmlFileName() {
        return CONTENTS_BODY_HTML_FILE_NAME;
    }

    @Override
    public boolean isEnableSortKey() {
        return true;
    }

    @Override
    public List<String[]> getTableDataList() {
        ArrayList<String[]> tableDataList = new ArrayList<String[]>();
        SJdtLunInfoCSVWrapper lunInfo = (SJdtLunInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("LunInfo.csv");
        SJdtLdevInfoCSVWrapper ldevInfo = (SJdtLdevInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("LdevInfo.csv");
        SJdtLunPortInfoCSVWrapper lunPortInfo = (SJdtLunPortInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("LunPortInfo.csv");
        SJdtWwnInfoCSVWrapper wwnInfo = (SJdtWwnInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("WwnInfo.csv");
        SJdtIscsiHostInfoCSVWrapper iscsiHostInfo = (SJdtIscsiHostInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("IscsiHostInfo.csv");
        SJdtIscsiTargetInfoCSVWrapper iscsiTagetInfo = (SJdtIscsiTargetInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("IscsiTargetInfo.csv");
        List<String[]> csvDataList = lunInfo.getCsvDataList();
        for (String[] lunInfoRecord : csvDataList) {
            String asymmetricAccessState;
            String port;
            String lun = lunInfo.getValue(lunInfoRecord, "LUN#");
            if (!StringUtils.isNotEmpty((String)lun)) continue;
            String[] oneRecord = null;
            oneRecord = SJdtRPTDTDevice.isHmdev() ? new String[HM_COLUMN_LENGTH] : new String[COLUMN_LENGTH];
            oneRecord[((Integer)SJdtLunReportGenerator.headerMap.get((Object)"portLocation")).intValue()] = port = lunInfo.getValue(lunInfoRecord, "Port");
            oneRecord[((Integer)SJdtLunReportGenerator.headerMap.get((Object)"hostGroupIscsiTargetAlias")).intValue()] = lunInfo.getValue(lunInfoRecord, "Host Group");
            String currentLun = lunInfo.getValue(lunInfoRecord, "LUN#");
            String DspLun = String.valueOf(Integer.parseInt(currentLun.toUpperCase(), 16));
            oneRecord[((Integer)SJdtLunReportGenerator.headerMap.get((Object)"lun")).intValue()] = DspLun = DspLun + " (" + ADD_HEX_STR + currentLun.toUpperCase() + ")";
            String ldev = lunInfo.getValue(lunInfoRecord, "LDEV#");
            oneRecord[((Integer)SJdtLunReportGenerator.headerMap.get((Object)"ldevId")).intValue()] = ldev.toUpperCase();
            String ldevEmulation = null;
            oneRecord[((Integer)SJdtLunReportGenerator.headerMap.get((Object)"emulationType")).intValue()] = ldevEmulation = ldevInfo.getKeyRecordColumnValue(ldev, "LDEV Emulation");
            String volumeSize = "";
            oneRecord[((Integer)SJdtLunReportGenerator.headerMap.get((Object)"capacity")).intValue()] = volumeSize = ldevInfo.getKeyRecordColumnValue(ldev, "Volume Size(MB)");
            String packageType = lunInfo.getValue(lunInfoRecord, "Package Type");
            oneRecord[((Integer)SJdtLunReportGenerator.headerMap.get((Object)"asymmetricAccessState")).intValue()] = asymmetricAccessState = lunInfo.getValue(lunInfoRecord, "Asymmetric Access State");
            if (!this.isIscsi(packageType)) {
                String hostMode = lunInfo.getValue(lunInfoRecord, "Host Mode");
                oneRecord[((Integer)SJdtLunReportGenerator.headerMap.get((Object)"hostMode")).intValue()] = hostMode.toUpperCase();
                oneRecord[((Integer)SJdtLunReportGenerator.headerMap.get((Object)"hostModeOption")).intValue()] = lunInfo.getValue(lunInfoRecord, "Host Mode Option");
                String[] lunPortInfoRecord = lunPortInfo.getMatchedOneRecord(port, "Port");
                String portInternalWwn = lunPortInfo.getValue(lunPortInfoRecord, "WWN");
                oneRecord[((Integer)SJdtLunReportGenerator.headerMap.get((Object)"hbaWwnIscsiName")).intValue()] = portInternalWwn.toUpperCase();
                String securitySwitch = lunPortInfo.getValue(lunPortInfoRecord, "Security Switch");
                oneRecord[((Integer)SJdtLunReportGenerator.headerMap.get((Object)"portSecurity")).intValue()] = this.getOnOffToDisplayStr(securitySwitch);
                oneRecord[((Integer)SJdtLunReportGenerator.headerMap.get((Object)"iscsiTargetName")).intValue()] = "-";
                tableDataList.add(oneRecord);
                continue;
            }
            String iscsiAlias = lunInfo.getValue(lunInfoRecord, "Host Group");
            String iscsiTargetId = wwnInfo.getHostGroupNumber(port, iscsiAlias);
            List<String[]> iscsiHostListSpecifidPort = iscsiHostInfo.getMatchedAllRecord(port, "Port");
            List<String[]> iscsiHostListSpecifidIscsiId = iscsiHostInfo.getMatchedAllRecord(iscsiTargetId, "iSCSI Target ID", iscsiHostListSpecifidPort);
            String[] iSCSIHostInfoRecord = iscsiHostInfo.getDefaultRecordValue();
            if (iscsiHostListSpecifidIscsiId.size() != 0) {
                iSCSIHostInfoRecord = iscsiHostListSpecifidIscsiId.get(0);
            }
            oneRecord[((Integer)SJdtLunReportGenerator.headerMap.get((Object)"hbaWwnIscsiName")).intValue()] = iscsiHostInfo.getValue(iSCSIHostInfoRecord, "iSCSI Name");
            List<String[]> iscsiTrgetListSpecifidPort = iscsiTagetInfo.getMatchedAllRecord(port, "Port");
            List<String[]> iscsiTrgetListSpecifidIscsiId = iscsiTagetInfo.getMatchedAllRecord(iscsiTargetId, "iSCSI Target ID", iscsiTrgetListSpecifidPort);
            String[] iscsiTagetInfoRecord = iscsiTagetInfo.getDefaultRecordValue();
            if (iscsiTrgetListSpecifidIscsiId.size() != 0) {
                iscsiTagetInfoRecord = iscsiTrgetListSpecifidIscsiId.get(0);
            }
            String hostMode = iscsiTagetInfo.getValue(iscsiTagetInfoRecord, "Host Mode");
            oneRecord[((Integer)SJdtLunReportGenerator.headerMap.get((Object)"hostMode")).intValue()] = hostMode.toUpperCase();
            oneRecord[((Integer)SJdtLunReportGenerator.headerMap.get((Object)"hostModeOption")).intValue()] = iscsiTagetInfo.getValue(iscsiTagetInfoRecord, "Host Mode Option");
            oneRecord[((Integer)SJdtLunReportGenerator.headerMap.get((Object)"iscsiTargetName")).intValue()] = iscsiTagetInfo.getValue(iscsiTagetInfoRecord, "iSCSI Target Name");
            String securitySwitch = iscsiTagetInfo.getValue(iscsiTagetInfoRecord, "Security Switch");
            oneRecord[((Integer)SJdtLunReportGenerator.headerMap.get((Object)"portSecurity")).intValue()] = this.getOnOffToDisplayStr(securitySwitch);
            tableDataList.add(oneRecord);
        }
        Comparator<Object> portLocationOrderByAsc = new Comparator<Object>(){
            private final int portLocationHeaderIndex = SJdtTableReportGenerator.headerMap.get("portLocation");

            @Override
            public int compare(Object record0, Object record1) {
                int result = 0;
                String port0 = ((String[])record0)[this.portLocationHeaderIndex];
                String port1 = ((String[])record1)[this.portLocationHeaderIndex];
                result = port0.compareTo(port1);
                return result;
            }
        };
        Collections.sort(tableDataList, portLocationOrderByAsc);
        return tableDataList;
    }
}

