/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.List;
import sanproject.client.data.RJDataCULDEV;
import sanproject.server.data.DGDgetLdevGuard;
import sanproject.server.data.DGDgetVtocArea;
import sanproject.server.data.DGDsetVtocArea;

public class RJDGDGuardPatternOfDkc
extends RJDGDGuardPatternCom {
    private RJDataCULDEV _ldevs = null;
    private RJDGDVtocArea[][] _vtoc = new RJDGDVtocArea[32][256];
    private boolean _flgMfVolExist = false;

    public RJDGDGuardPatternOfDkc(RJDGDDataControl rJDGDDataControl) throws NullPointerException, RJDGDException {
        super(rJDGDDataControl, RJDGDGuidanceManager.getString("STRING_TNN_KEYDKC"));
    }

    public RJDGDGuardPatternOfDkc(RJDGDDataControl rJDGDDataControl, DGDgetLdevGuard dGDgetLdevGuard, RJDataCULDEV rJDataCULDEV, DGDgetVtocArea[] dGDgetVtocAreaArray) throws NullPointerException, RJDGDException {
        super(rJDGDDataControl, RJDGDGuidanceManager.getString("STRING_TNN_KEYDKC"));
        if (rJDataCULDEV == null) {
            throw new NullPointerException("culdev is null");
        }
        this._ldevs = rJDataCULDEV;
        try {
            if (dGDgetVtocAreaArray.length != 8192) {
                String string = new String("Illegal VTOC area data length (8192!=" + dGDgetVtocAreaArray.length + ")");
                throw new IllegalArgumentException(string);
            }
            int n = 0;
            while (n < dGDgetVtocAreaArray.length) {
                int n2 = dGDgetVtocAreaArray[n].cu;
                int n3 = dGDgetVtocAreaArray[n].ldev;
                if (this._vtoc[n2][n3] != null) {
                    String string = new String("Illegal address invtoc[" + n + "]=[" + n2 + ":" + n3 + "]");
                    throw new IllegalArgumentException(string);
                }
                this._vtoc[n2][n3] = dGDgetVtocAreaArray[n].start == 0 ? RJDGDVtocArea.newNull() : new RJDGDVtocArea(this, dGDgetVtocAreaArray[n]);
                ++n;
            }
        }
        catch (Exception exception) {
            RJDGDLogManager.putLog(this._logName, exception.getMessage());
            throw new RJDGDException(9210, 7443, exception.getMessage());
        }
        this.setupGuardStatus(dGDgetLdevGuard.guard);
    }

    public void setupGuardStatus(byte[][] byArray) throws RJDGDException {
        try {
            if (byArray == null) {
                throw new NullPointerException("guard is null");
            }
            this.newGuardPattern();
            if (byArray.length != 32) {
                throw new IllegalArgumentException("guard.length = " + byArray.length);
            }
            int n = 0;
            while (n < 32) {
                if (byArray[n].length != 256) {
                    throw new IllegalArgumentException("guard[" + n + "].length = " + byArray[n].length);
                }
                int n2 = 0;
                while (n2 < 256) {
                    boolean bl;
                    if (this._ldevs != null) {
                        if (!RJDGDLdev.isMfVol(this._ldevs.getDataLDEV(n, n2))) {
                            byArray[n][n2] = 0;
                        } else {
                            this._flgMfVolExist = true;
                        }
                    }
                    if (!(bl = this.initGuardStatus(n, n2, byArray[n][n2]))) {
                        this.initGuardStatus(n, n2, (byte)-128);
                    }
                    ++n2;
                }
                ++n;
            }
        }
        catch (Exception exception) {
            RJDGDLogManager.putLog(this._logName, exception.getMessage());
            throw new RJDGDException(9210, 7442, exception.getMessage());
        }
    }

    public boolean rename(String string) {
        return false;
    }

    public RJDGDLdev[] getLdevs(int n) throws ArrayIndexOutOfBoundsException, RJDGDException {
        RJDGDLdev[] rJDGDLdevArray = new RJDGDLdev[this._guard[n].length];
        if (this.isUnload()) {
            int n2 = 0;
            while (n2 < this._guard[n].length) {
                rJDGDLdevArray[n2] = new RJDGDLdev(n, n2, this);
                ++n2;
            }
        } else {
            int n3 = 0;
            while (n3 < this._guard[n].length) {
                rJDGDLdevArray[n3] = new RJDGDLdev(n, n3, this, this._ldevs.getDataLDEV(n, n3), this._vtoc[n][n3]);
                ++n3;
            }
        }
        return rJDGDLdevArray;
    }

    public RJDGDGuardPattern getCopy() {
        RJDGDGuardPatternOfFile rJDGDGuardPatternOfFile = null;
        if (this.canCopy()) {
            try {
                rJDGDGuardPatternOfFile = new RJDGDGuardPatternOfFile(this._dctl, this.getName());
                rJDGDGuardPatternOfFile.copyGuardStatus(this._guard);
            }
            catch (RJDGDException rJDGDException) {
                RJDGDLogManager.putLog(this._logName, rJDGDException.getMessage());
            }
        }
        return rJDGDGuardPatternOfFile;
    }

    public boolean setGuardStatus(int n, int n2, byte by) throws ArrayIndexOutOfBoundsException {
        boolean bl = super.setGuardStatus(n, n2, by);
        if (bl) {
            this._dctl.enterSetupToDkc(this);
        }
        return bl;
    }

    public void setVtocArea(RJDGDVtocArea rJDGDVtocArea) {
        if (rJDGDVtocArea.isModify()) {
            super.setVtocArea(rJDGDVtocArea);
            this._dctl.enterSetupToDkc(this);
        }
    }

    public DGDsetVtocArea[] getDGDsetVtocArea() {
        ArrayList<DGDsetVtocArea> arrayList = new ArrayList<DGDsetVtocArea>();
        int n = 0;
        while (n < this._vtoc.length) {
            int n2 = 0;
            while (n2 < this._vtoc[n].length) {
                if (this._vtoc[n][n2] != null && this._vtoc[n][n2].isModify()) {
                    arrayList.add(this._vtoc[n][n2].getDGDsetVtocArea());
                }
                ++n2;
            }
            ++n;
        }
        DGDsetVtocArea[] dGDsetVtocAreaArray = new DGDsetVtocArea[arrayList.size()];
        int n3 = 0;
        while (n3 < dGDsetVtocAreaArray.length) {
            dGDsetVtocAreaArray[n3] = (DGDsetVtocArea)arrayList.get(n3);
            ++n3;
        }
        return dGDsetVtocAreaArray;
    }

    public List getSetupData() {
        DGDsetVtocArea[] dGDsetVtocAreaArray;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (this.isSetupToDkc() & this.isChgAttribute()) {
            arrayList.add(this.getDGDsetLdevGuard());
        }
        if (this.isChgVtoc() && (dGDsetVtocAreaArray = this.getDGDsetVtocArea()).length > 0) {
            arrayList.add(dGDsetVtocAreaArray);
        }
        return arrayList;
    }

    public boolean canRename() {
        return false;
    }

    public boolean canDelete() {
        return false;
    }

    public boolean canChgAttribute() {
        return super.canChgAttribute() & this.isSetupToDkc();
    }

    public boolean canChgVtoc() {
        return super.canChgVtoc() & this.isSetupToDkc();
    }

    public boolean isModify() {
        return this.isCopy() | this.isRename() | this.isDelete() | this.isChgAttribute() | this.isChgVtoc();
    }

    public boolean isDkc() {
        return true;
    }

    public boolean hasMfVol() {
        return this._flgMfVolExist;
    }
}

