/*
 * Decompiled with CFR 0.152.
 */
package sanproject.getmondat;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import sanproject.getmondat.RJMdCmdManager;
import sanproject.getmondat.com.RJMdConfig;
import sanproject.getmondat.com.RJMdExecParameter;
import sanproject.getmondat.com.RJMdMessage;
import sanproject.getmondat.com.RJMdMsgID;
import sanproject.getmondat.data.RJMdDataControl;

public class RJMdMain
implements RJMdMsgID {
    public static final String PROPERTY_COMMAND = "md.command";
    public static final String PROPERTY_SIM = "md.sim";
    public static final String PROPERTY_LOGPATH = "md.logpath";
    public static final String PROPERTY_LOGFILE = "md.logfile";
    public static final String PROPERTY_VENDER = "md.vender";
    public static final String PROPERTY_RMITIMEOUT = "md.rmitimeout";
    public static final String PROPERTY_DIVIDELONG = "md.dividelong";
    public static final String PROPERTY_DEVIDESHORT = "md.divide";
    public static final String PROPERTY_TRACE = "md.trace";
    public static final String CONFIG_VERSION = "version";
    private RJMdDataControl controller;
    private RJMdExecParameter parameter;
    private InputStream commandIn = null;

    public RJMdMain() {
        String string = System.getProperty(PROPERTY_SIM);
        try {
            this.controller = this.createDataControl();
            this.parameter = new RJMdExecParameter();
            this.controller.setExecParameter(this.parameter);
            this.parameter.setVender(System.getProperty(PROPERTY_VENDER));
            RJMdConfig rJMdConfig = new RJMdConfig();
            String string2 = rJMdConfig.get(CONFIG_VERSION);
            this.parameter.setVersion(string2);
            int n = this.getTimeoutValue();
            if (n > 0) {
                this.parameter.setTimeoutValue(n);
            }
            if ((n = this.getDivideShort()) > 0) {
                this.parameter.setDivideShort(n);
            }
            if ((n = this.getTrace()) > 0) {
                this.parameter.setDebug(n);
            }
            this.commandUserInterface();
        }
        catch (IOException iOException) {
            RJMdDataControl.trace("IOException : " + iOException.getMessage());
        }
        catch (OutOfMemoryError outOfMemoryError) {
            outOfMemoryError.printStackTrace();
            StackTraceElement[] stackTraceElementArray = outOfMemoryError.getStackTrace();
            for (int i = 0; i < stackTraceElementArray.length; ++i) {
                RJMdDataControl.trace(stackTraceElementArray[i].toString());
            }
        }
    }

    private int getTimeoutValue() {
        int n = 0;
        String string = System.getProperty(PROPERTY_RMITIMEOUT);
        if (string != null) {
            n = -1;
            try {
                int n2 = Integer.parseInt(string);
                if (n2 >= 1 && n2 <= 60) {
                    n = n2;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }

    private int getDivideShort() {
        int n = 0;
        String string = System.getProperty(PROPERTY_DEVIDESHORT);
        if (string != null) {
            n = -1;
            try {
                int n2 = Integer.parseInt(string);
                if (n2 >= 60 && n2 <= 1440) {
                    n = n2;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }

    private int getTrace() {
        int n = 0;
        String string = System.getProperty(PROPERTY_TRACE);
        if (string != null) {
            if ((string = string.toLowerCase()).equals("on")) {
                n = 1;
            } else if (!string.equals("off")) {
                n = -1;
            }
        }
        return n;
    }

    private void commandUserInterface() {
        String string = System.getProperty(PROPERTY_COMMAND);
        this.traceHeader(string);
        File file = null;
        if (string != null && !string.equals("")) {
            file = new File(string);
            RJMdDataControl.putInfomation("command file = " + file.getAbsolutePath());
            if (file.isFile() && file.canRead()) {
                try {
                    this.commandIn = new FileInputStream(file);
                    RJMdCmdManager rJMdCmdManager = new RJMdCmdManager(this.controller);
                    rJMdCmdManager.analyze(this.commandIn);
                }
                catch (IOException iOException) {}
            } else {
                this.controller.putMessage(RJMdMessage.message("MSG020", string));
                this.controller.putMessage(RJMdMessage.message("INF004"));
            }
        } else {
            this.controller.putMessage(RJMdMessage.message("MSG021"));
            this.controller.putMessage(RJMdMessage.message("INF004"));
        }
        RJMdDataControl.putInfomation("Export tool end ");
        System.exit(this.parameter.getExitCode());
    }

    private void traceHeader(String string) {
        RJMdDataControl.putInfomation("Export tool start [Version " + this.parameter.getVersion() + "]");
        RJMdDataControl.trace("md.command = " + string);
        RJMdDataControl.trace("md.logpath = " + System.getProperty(PROPERTY_LOGPATH));
        RJMdDataControl.trace("md.logfile = " + System.getProperty(PROPERTY_LOGFILE));
        String string2 = "md.rmitimeout = " + System.getProperty(PROPERTY_RMITIMEOUT);
        RJMdDataControl.trace(string2);
        int n = this.getTimeoutValue();
        if (n < 0) {
            this.controller.putMessage(RJMdMessage.message("MSG019", string2));
        }
        string2 = "md.divide = " + System.getProperty(PROPERTY_DEVIDESHORT);
        RJMdDataControl.trace(string2);
        n = this.getDivideShort();
        if (n < 0) {
            this.controller.putMessage(RJMdMessage.message("MSG019", string2));
        }
    }

    private void graphicalUserInterface() {
    }

    private RJMdDataControl createDataControl() throws IOException {
        RJMdDataControl rJMdDataControl = null;
        String string = null;
        String string2 = System.getProperty(PROPERTY_SIM);
        if (string2 != null && string2.equals("y")) {
            try {
                Class<?> clazz = Class.forName("sanproject.getmondat.test.TestDataControl");
                Constructor<?> constructor = clazz.getConstructor(null);
                rJMdDataControl = (RJMdDataControl)constructor.newInstance(null);
            }
            catch (ClassNotFoundException classNotFoundException) {
                string = classNotFoundException.toString();
            }
            catch (NoSuchMethodException noSuchMethodException) {
                string = noSuchMethodException.toString();
            }
            catch (InvocationTargetException invocationTargetException) {
                string = invocationTargetException.toString();
            }
            catch (IllegalAccessException illegalAccessException) {
                string = illegalAccessException.toString();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                string = illegalArgumentException.toString();
            }
            catch (InstantiationException instantiationException) {
                string = instantiationException.toString();
            }
        }
        if (rJMdDataControl == null) {
            rJMdDataControl = new RJMdDataControl();
        }
        rJMdDataControl.setLogPath(System.getProperty(PROPERTY_LOGPATH), System.getProperty(PROPERTY_LOGFILE));
        if (string != null) {
            RJMdDataControl.trace(string);
        }
        return rJMdDataControl;
    }

    public static void main(String[] stringArray) {
        new RJMdMain();
    }
}

