/*
 * Decompiled with CFR 0.152.
 */
package sanproject.getmondat.group;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import sanproject.getmondat.com.RJMdCmdParser;
import sanproject.getmondat.com.RJMdRange;
import sanproject.getmondat.com.RJMdRmiException;
import sanproject.getmondat.com.RJMdTimeRange;
import sanproject.getmondat.data.RJMdDataControl;
import sanproject.getmondat.data.RJMdDataPort;
import sanproject.getmondat.group.RJMdColumn;
import sanproject.getmondat.group.RJMdGroupData;
import sanproject.getmondat.group.RJMdUnitEntry;
import sanproject.getmondat.group.RJMdUnitParallelStream;
import sanproject.serverux.arg.monitor.ArgMFPortAbility;
import sanproject.serverux.arg.monitor.MonArg;
import sanproject.serverux.data.MFPortAbility;
import sanproject.serverux.data.MonitorInfoCollection;

public class RJMdGroupMFPort
extends RJMdGroupData {
    private static final String groupID = "MFPort";
    private static final String[] groupAlias = new String[0];
    private static final String groupName = "MFPort_dat";
    private static final String groupInfo = "MFport data";
    public static final int LIMIT_PARAMS_PORT = 256;
    private RJMdUnitParallelStream stream = null;
    private static final String EN_MFPort_IOPS = "MF_Port_IOPS";
    private static final String EN_MFPort_Response = "MF_Port_Response";
    private static final String EN_MFPort_Read_Write_KBPS = "MF_Port_Read_Write_KBPS";
    private static final String EN_MFPort_Read_KBPS = "MF_Port_Read_KBPS";
    private static final String EN_MFPort_Write_KBPS = "MF_Port_Write_KBPS";
    private static final String EN_MFPort_Avr_CMR = "MF_Port_Avr_CMR";
    private static final String EN_MFPort_Avr_DisconnectTime = "MF_Port_Avr_DisconnectTime";
    private static final String EN_MFPort_Avr_ConnectTime = "MF_Port_Avr_ConnectTime";
    private static final String EN_MFPort_Avr_OpenExchange = "MF_Port_Avr_OpenExchange";
    private static final String[] entryNames = new String[]{"MF_Port_IOPS", "MF_Port_Response", "MF_Port_Read_Write_KBPS", "MF_Port_Read_KBPS", "MF_Port_Write_KBPS", "MF_Port_Avr_CMR", "MF_Port_Avr_DisconnectTime", "MF_Port_Avr_ConnectTime", "MF_Port_Avr_OpenExchange"};
    private static final int KIND_HTP = 8;
    private static final int KIND_FNP = 16;
    private static final String Console_htp = "Htp ";
    private static final String Console_fnp = "Fnp ";

    public RJMdGroupMFPort(RJMdDataControl rJMdDataControl) {
        super(rJMdDataControl);
    }

    public void init() throws IOException {
        String string = this.parameter.getDirectory();
        File file = new File(string);
        this.stream = new RJMdUnitParallelStream(groupName, file);
        this.stream.setCompress(this.parameter.isCompless());
    }

    protected boolean isGroupExists() {
        boolean bl = this.stream.exists();
        return bl;
    }

    public void deleteGroup() {
        this.stream.deleteAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createGroup() throws RJMdRmiException, IOException {
        try {
            this.createGroupMFPort(8, entryNames);
        }
        finally {
            this.stream.close();
        }
    }

    private void createGroupMFPort(int n, String[] stringArray) throws RJMdRmiException, IOException {
        Object object;
        switch (n) {
            case 8: {
                this.putInfomation("INF006", Console_htp + this.getGroupInfo());
            }
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (int i = 0; i < stringArray.length; ++i) {
            object = this.stream.createEntry(stringArray[i], this.getTimeRange());
            hashMap.put(stringArray[i], object);
        }
        RJMdTimeRange rJMdTimeRange = this.parameter.getShortRange();
        object = new CollectParam(rJMdTimeRange.getFromTime(), rJMdTimeRange.getToTime());
        ArrayList arrayList = this.controller.getPort(n);
        this.initProgress(arrayList);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            RJMdDataPort rJMdDataPort = (RJMdDataPort)iterator.next();
            if (!this.parameter.containsRange(this.getGroupID(), rJMdDataPort)) continue;
            if (((CollectParam)object).size() >= 256) {
                this.collect(hashMap, (CollectParam)object, n);
                this.addProgress(((CollectParam)object).size());
                object = new CollectParam(rJMdTimeRange.getFromTime(), rJMdTimeRange.getToTime());
            }
            ((CollectParam)object).add(rJMdDataPort);
        }
        this.collect(hashMap, (CollectParam)object, n);
        this.addProgress(((CollectParam)object).size());
        this.closeProgress();
        switch (n) {
            case 8: {
                this.putInfomation("INF007", Console_htp + this.getGroupInfo());
            }
        }
    }

    private void initProgress(ArrayList arrayList) {
        int n = 0;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            RJMdDataPort rJMdDataPort = (RJMdDataPort)iterator.next();
            if (!this.parameter.containsRange(this.getGroupID(), rJMdDataPort)) continue;
            ++n;
        }
        super.initProgress(n, arrayList.size());
    }

    public void collect(HashMap hashMap, CollectParam collectParam, int n) throws RJMdRmiException, IOException {
        if (collectParam.size() > 0) {
            MonitorInfoCollection monitorInfoCollection = (MonitorInfoCollection)this.controller.getMonitorInfo((MonArg)collectParam.getArgument());
            block4: for (int i = 0; i < monitorInfoCollection.size(); ++i) {
                MFPortAbility mFPortAbility = (MFPortAbility)monitorInfoCollection.get(i);
                String string = collectParam.getPortName(mFPortAbility.getPortID());
                switch (n) {
                    case 8: {
                        this.stream.write((RJMdUnitEntry)hashMap.get(EN_MFPort_IOPS), new RJMdColumn(string, mFPortAbility.getAvrIOPerSec()));
                        this.stream.write((RJMdUnitEntry)hashMap.get(EN_MFPort_Response), new RJMdColumn(string, mFPortAbility.getResponseTime()));
                        this.stream.write((RJMdUnitEntry)hashMap.get(EN_MFPort_Read_Write_KBPS), new RJMdColumn(string, mFPortAbility.getAvrTransRate()));
                        this.stream.write((RJMdUnitEntry)hashMap.get(EN_MFPort_Read_KBPS), new RJMdColumn(string, mFPortAbility.getAvrTransRateRead()));
                        this.stream.write((RJMdUnitEntry)hashMap.get(EN_MFPort_Write_KBPS), new RJMdColumn(string, mFPortAbility.getAvrTransRateWrite()));
                        this.stream.write((RJMdUnitEntry)hashMap.get(EN_MFPort_Avr_CMR), new RJMdColumn(string, mFPortAbility.getAvrCUQueuing()));
                        this.stream.write((RJMdUnitEntry)hashMap.get(EN_MFPort_Avr_DisconnectTime), new RJMdColumn(string, mFPortAbility.getAvrDisconnectTime()));
                        this.stream.write((RJMdUnitEntry)hashMap.get(EN_MFPort_Avr_ConnectTime), new RJMdColumn(string, mFPortAbility.getAvrConnectTime()));
                        this.stream.write((RJMdUnitEntry)hashMap.get(EN_MFPort_Avr_OpenExchange), new RJMdColumn(string, mFPortAbility.getAvrOpenExchange()));
                        continue block4;
                    }
                    case 16: {
                        continue block4;
                    }
                }
            }
        }
    }

    public String[] getGroupAlias() {
        return groupAlias;
    }

    public String getGroupID() {
        return groupID;
    }

    public String getGroupName() {
        return groupName;
    }

    public String getGroupInfo() {
        return groupInfo;
    }

    public RJMdTimeRange getTimeRange() {
        return this.parameter.getShortRange();
    }

    public void analyzeOperand(RJMdCmdParser rJMdCmdParser) throws ParseException {
        RJMdRange rJMdRange = null;
        char c = rJMdCmdParser.getKind();
        while ((rJMdRange = this.analyzePortRange(rJMdCmdParser)) != null) {
            RJMdDataControl.trace("\tMFPort =  " + rJMdRange);
            this.parameter.addGroupRange(this.getGroupID(), rJMdRange);
            if (rJMdCmdParser.getKind() != ' ') break;
            rJMdCmdParser.nextToken();
        }
    }

    class CollectParam {
        private ArgMFPortAbility portArgument = null;
        private ArrayList portlist = new ArrayList();

        CollectParam(Date date, Date date2) {
            this.portArgument = new ArgMFPortAbility(1, date, date2);
        }

        public void add(RJMdDataPort rJMdDataPort) {
            this.portlist.add(rJMdDataPort);
            this.portArgument.addPortID(rJMdDataPort.getPortID());
        }

        public int size() {
            return this.portArgument.size();
        }

        public String getPortName(int n) {
            String string = "unknown";
            Iterator iterator = this.portlist.iterator();
            while (iterator.hasNext()) {
                RJMdDataPort rJMdDataPort = (RJMdDataPort)iterator.next();
                if (n != rJMdDataPort.getPortID()) continue;
                string = rJMdDataPort.getPortName();
                break;
            }
            return string;
        }

        public ArgMFPortAbility getArgument() {
            return this.portArgument;
        }
    }
}

