/*
 * Decompiled with CFR 0.152.
 */
package sanproject.getmondat.group;

import java.io.File;
import java.io.IOException;
import java.text.Format;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import sanproject.getmondat.com.RJMdCmdParser;
import sanproject.getmondat.com.RJMdRange;
import sanproject.getmondat.com.RJMdRmiException;
import sanproject.getmondat.com.RJMdTimeRange;
import sanproject.getmondat.data.RJMdDataControl;
import sanproject.getmondat.data.RJMdDataPPCGroup;
import sanproject.getmondat.data.RJMdDataWWN;
import sanproject.getmondat.group.RJMdColumn;
import sanproject.getmondat.group.RJMdGroupData;
import sanproject.getmondat.group.RJMdUnitEntry;
import sanproject.getmondat.group.RJMdUnitParallelStream;
import sanproject.serverux.arg.monitor.ArgWWNAbility;
import sanproject.serverux.arg.monitor.MonArg;
import sanproject.serverux.data.MonitorInfoCollection;
import sanproject.serverux.data.PPCWWNAbility;

public class RJMdGroupPPCGWWN
extends RJMdGroupData {
    private static final String groupID = "PPCGWWN";
    private static final String[] groupAlias = new String[0];
    private static final String groupName = "PPCGWWN_dat";
    private static final String groupInfo = "PPCGWWN data";
    private RJMdUnitParallelStream stream = null;
    public static final int LIMIT_PARAMS_PPCGWWN = 512;
    private static final String EN_PPCGWWN_IOPS = "PPCGWWN_{0}_IOPS{1}";
    private static final String EN_PPCGWWN_KBPS = "PPCGWWN_{0}_KBPS{1}";
    private static final String EN_PPCGWWN_Response = "PPCGWWN_{0}_Response{1}";
    private static final String[] entryNames = new String[]{"PPCGWWN_{0}_IOPS{1}", "PPCGWWN_{0}_KBPS{1}", "PPCGWWN_{0}_Response{1}"};

    public RJMdGroupPPCGWWN(RJMdDataControl rJMdDataControl) {
        super(rJMdDataControl);
    }

    public void init() throws IOException {
        String string = this.parameter.getDirectory();
        File file = new File(string);
        this.stream = new RJMdUnitParallelStream(groupName, file);
        this.stream.setCompress(this.parameter.isCompless());
        this.stream.setIndirect(true);
    }

    protected boolean isGroupExists() {
        boolean bl = this.stream.exists();
        return bl;
    }

    public void deleteGroup() {
        this.stream.deleteAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createGroup() throws RJMdRmiException, IOException {
        try {
            this.createGroupPPCGWWN();
        }
        finally {
            this.stream.close();
        }
    }

    private void createGroupPPCGWWN() throws RJMdRmiException, IOException {
        Object object;
        String string;
        Object object2;
        this.putInfomation("INF006", this.getGroupInfo());
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        RJMdTimeRange rJMdTimeRange = this.parameter.getShortRange();
        CollectParam collectParam = new CollectParam(rJMdTimeRange.getFromTime(), rJMdTimeRange.getToTime());
        super.createGroup();
        ArrayList arrayList = this.controller.getPPCGroup();
        ArrayList arrayList2 = this.controller.getNotGroupedWWN();
        this.initProgress(arrayList, arrayList2);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Object object3;
            Object object4;
            RJMdDataPPCGroup rJMdDataPPCGroup = (RJMdDataPPCGroup)iterator.next();
            if (!this.parameter.containsRange(this.getGroupID(), rJMdDataPPCGroup)) continue;
            object2 = rJMdDataPPCGroup.getNickname();
            string = this.getFileNo((String)object2);
            for (int i = 0; i < entryNames.length; ++i) {
                object4 = new MessageFormat(entryNames[i]);
                object3 = ((Format)object4).format(new String[]{object2, string});
                RJMdUnitEntry rJMdUnitEntry = this.stream.createEntry((String)object3, this.getTimeRange());
                hashMap.put(entryNames[i] + (String)object2, rJMdUnitEntry);
            }
            object = this.controller.getPPCGroupToWWN((String)object2);
            object4 = ((ArrayList)object).iterator();
            while (object4.hasNext()) {
                object3 = (RJMdDataWWN)object4.next();
                if (collectParam.size() >= 512) {
                    this.collect(hashMap, collectParam);
                    this.addProgress(collectParam.size());
                    collectParam = new CollectParam(rJMdTimeRange.getFromTime(), rJMdTimeRange.getToTime());
                }
                collectParam.add(rJMdDataPPCGroup, (RJMdDataWWN)object3);
            }
        }
        if (arrayList2.size() > 0) {
            for (int i = 0; i < entryNames.length; ++i) {
                object2 = new MessageFormat(entryNames[i]);
                string = ((Format)object2).format(new String[]{"NotGrouped", ""});
                object = this.stream.createEntry(string, this.getTimeRange());
                hashMap.put(entryNames[i], object);
            }
            Iterator iterator2 = arrayList2.iterator();
            while (iterator2.hasNext()) {
                object2 = (RJMdDataWWN)iterator2.next();
                if (collectParam.size() >= 512) {
                    this.collect(hashMap, collectParam);
                    this.addProgress(collectParam.size());
                    collectParam = new CollectParam(rJMdTimeRange.getFromTime(), rJMdTimeRange.getToTime());
                }
                collectParam.add((RJMdDataWWN)object2);
            }
        }
        this.collect(hashMap, collectParam);
        this.stream.flushAll();
        this.addProgress(collectParam.size());
        this.closeProgress();
        this.putInfomation("INF007", this.getGroupInfo());
    }

    private void initProgress(ArrayList arrayList, ArrayList arrayList2) throws RJMdRmiException {
        int n = 0;
        int n2 = 0;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            RJMdDataPPCGroup rJMdDataPPCGroup = (RJMdDataPPCGroup)iterator.next();
            String string = rJMdDataPPCGroup.getNickname();
            ArrayList arrayList3 = this.controller.getPPCGroupToWWN(string);
            n2 += arrayList3.size();
            if (!this.parameter.containsRange(this.getGroupID(), rJMdDataPPCGroup)) continue;
            n += arrayList3.size();
        }
        if (arrayList2.size() > 0) {
            n2 += arrayList2.size();
            n += arrayList2.size();
        }
        super.initProgress(n, n2);
    }

    public void collect(HashMap hashMap, CollectParam collectParam) throws RJMdRmiException, IOException {
        if (collectParam.size() > 0) {
            MonitorInfoCollection monitorInfoCollection = (MonitorInfoCollection)this.controller.getMonitorInfo((MonArg)collectParam.getArgument());
            for (int i = 0; i < monitorInfoCollection.size(); ++i) {
                PPCWWNAbility pPCWWNAbility = (PPCWWNAbility)monitorInfoCollection.get(i);
                String string = collectParam.getNickname(pPCWWNAbility.getWWNBytes());
                String string2 = this.toWWNString(pPCWWNAbility.getWWNBytes()) + "(" + string + ")";
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_PPCGWWN_IOPS + collectParam.getName()), new RJMdColumn(string2, pPCWWNAbility.getAvrIOPerSec()));
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_PPCGWWN_KBPS + collectParam.getName()), new RJMdColumn(string2, pPCWWNAbility.getAvrTransRate()));
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_PPCGWWN_Response + collectParam.getName()), new RJMdColumn(string2, pPCWWNAbility.getResponseTime()));
            }
        }
    }

    public String[] getGroupAlias() {
        return groupAlias;
    }

    public String getGroupID() {
        return groupID;
    }

    public String getGroupName() {
        return groupName;
    }

    public String getGroupInfo() {
        return groupInfo;
    }

    public RJMdTimeRange getTimeRange() {
        return this.parameter.getShortRange();
    }

    public void analyzeOperand(RJMdCmdParser rJMdCmdParser) throws ParseException {
        RJMdRange rJMdRange = null;
        char c = rJMdCmdParser.getKind();
        while ((rJMdRange = this.analyzePPCGRange(rJMdCmdParser)) != null) {
            RJMdDataControl.trace("\tPPCG =  " + rJMdRange);
            this.parameter.addGroupRange(this.getGroupID(), rJMdRange);
            if (rJMdCmdParser.getKind() != ' ') break;
            rJMdCmdParser.nextToken();
        }
    }

    class CollectParam {
        private String ppcgName;
        private ArrayList ppcgList = new ArrayList();
        private ArrayList wwnList = new ArrayList();
        private ArgWWNAbility wwnAbility = null;

        CollectParam(Date date, Date date2) {
            this.wwnAbility = new ArgWWNAbility(1, date, date2);
        }

        public int size() {
            return this.wwnAbility.size();
        }

        public void add(RJMdDataPPCGroup rJMdDataPPCGroup, RJMdDataWWN rJMdDataWWN) {
            this.ppcgList.add(rJMdDataPPCGroup);
            this.wwnList.add(rJMdDataWWN);
            this.wwnAbility.addWWN(rJMdDataWWN.getWWN());
        }

        public void add(RJMdDataWWN rJMdDataWWN) {
            this.ppcgList.add("");
            this.wwnList.add(rJMdDataWWN);
            this.wwnAbility.addWWN(rJMdDataWWN.getWWN());
        }

        private void setName(int n) {
            this.ppcgName = this.ppcgList.get(n).toString();
        }

        public String getName() {
            return this.ppcgName;
        }

        private String getNickname(byte[] byArray) {
            String string = "";
            Iterator iterator = this.wwnList.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                RJMdDataWWN rJMdDataWWN = (RJMdDataWWN)iterator.next();
                boolean bl = true;
                for (int i = 0; i < 8; ++i) {
                    if (byArray[i] == rJMdDataWWN.getWWN()[i]) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    string = rJMdDataWWN.getNickname();
                    this.setName(n);
                }
                ++n;
            }
            return string;
        }

        public ArgWWNAbility getArgument() {
            return this.wwnAbility;
        }
    }
}

