/*
 * Decompiled with CFR 0.152.
 */
package sanproject.getmondat.group;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import sanproject.getmondat.com.RJMdCmdParser;
import sanproject.getmondat.com.RJMdRange;
import sanproject.getmondat.com.RJMdRmiException;
import sanproject.getmondat.com.RJMdTimeRange;
import sanproject.getmondat.data.RJMdDataControl;
import sanproject.getmondat.data.RJMdDataPG;
import sanproject.getmondat.group.RJMdColumn;
import sanproject.getmondat.group.RJMdGroupData;
import sanproject.getmondat.group.RJMdUnitEntry;
import sanproject.getmondat.group.RJMdUnitParallelStream;
import sanproject.serverux.arg.monitor.HIHsmPhysicalExdPGUseRateArgInfo;
import sanproject.serverux.arg.monitor.MonArg;
import sanproject.serverux.data.HIHsmPhysicalExdPGUseRate;
import sanproject.serverux.data.MonitorInfoCollection;

public class RJMdGroupPhyExG
extends RJMdGroupData {
    private static final String groupID = "PhyExG";
    private static final String[] groupAlias = new String[0];
    private static final String groupName = "PhyExG_dat";
    private static final String groupInfo = " data of physical";
    private RJMdUnitParallelStream stream = null;
    private String DLM = ".";
    public static final int LIMIT_PARAMS_PhyExG = 128;
    private static final String EN_PHY_ExG_Response = "PHY_ExG_Response";
    private static final String EN_PHY_ExG_Read_Response = "PHY_ExG_Read_Response";
    private static final String EN_PHY_ExG_Write_Response = "PHY_ExG_Write_Response";
    private static final String EN_PHY_ExG_Trans = "PHY_ExG_Trans";
    private static final String EN_PHY_ExG_Read_Trans = "PHY_ExG_Read_Trans";
    private static final String EN_PHY_ExG_Write_Trans = "PHY_ExG_Write_Trans";
    private static final String[] entryNames = new String[]{"PHY_ExG_Response", "PHY_ExG_Read_Response", "PHY_ExG_Write_Response", "PHY_ExG_Trans", "PHY_ExG_Read_Trans", "PHY_ExG_Write_Trans"};

    public RJMdGroupPhyExG(RJMdDataControl rJMdDataControl) {
        super(rJMdDataControl);
    }

    public void init() throws IOException {
        String string = this.parameter.getDirectory();
        File file = new File(string);
        this.stream = new RJMdUnitParallelStream(groupName, file);
        this.stream.setCompress(this.parameter.isCompless());
    }

    protected boolean isGroupExists() {
        boolean bl = this.stream.exists();
        return bl;
    }

    public void deleteGroup() {
        this.stream.deleteAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createGroup() throws RJMdRmiException, IOException {
        try {
            this.createGroupPhyExG();
        }
        finally {
            this.stream.close();
        }
    }

    private void createGroupPhyExG() throws RJMdRmiException, IOException {
        this.putInfomation("INF006", "external group" + this.getGroupInfo());
        HashMap<String, RJMdUnitEntry> hashMap = new HashMap<String, RJMdUnitEntry>();
        for (int i = 0; i < entryNames.length; ++i) {
            RJMdUnitEntry rJMdUnitEntry = this.stream.createEntry(entryNames[i], this.getTimeRange());
            hashMap.put(entryNames[i], rJMdUnitEntry);
        }
        ArrayList arrayList = this.controller.getPG(3);
        int n = this.initProgressPG(arrayList);
        int n2 = 0;
        HIHsmPhysicalExdPGUseRateArgInfo hIHsmPhysicalExdPGUseRateArgInfo = this.createArgument(n);
        n -= hIHsmPhysicalExdPGUseRateArgInfo.getCount();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            RJMdDataPG rJMdDataPG = (RJMdDataPG)iterator.next();
            if (!this.parameter.containsRange(this.getGroupID(), rJMdDataPG)) continue;
            if (n2 >= 128) {
                this.collect(hIHsmPhysicalExdPGUseRateArgInfo, hashMap);
                this.addProgress(n2);
                n2 = 0;
                hIHsmPhysicalExdPGUseRateArgInfo = this.createArgument(n);
                n -= hIHsmPhysicalExdPGUseRateArgInfo.getCount();
            }
            hIHsmPhysicalExdPGUseRateArgInfo.setAllParam(n2, rJMdDataPG.getFB4(), rJMdDataPG.getPG());
            ++n2;
        }
        this.collect(hIHsmPhysicalExdPGUseRateArgInfo, hashMap);
        this.addProgress(n2);
        this.closeProgress();
        this.putInfomation("INF007", this.getGroupInfo());
    }

    public HIHsmPhysicalExdPGUseRateArgInfo createArgument(int n) {
        HIHsmPhysicalExdPGUseRateArgInfo hIHsmPhysicalExdPGUseRateArgInfo = null;
        int n2 = n;
        if (n >= 128) {
            n2 = 128;
        }
        hIHsmPhysicalExdPGUseRateArgInfo = new HIHsmPhysicalExdPGUseRateArgInfo(1, this.parameter.getShortRange().getFromTime(), this.parameter.getShortRange().getToTime(), n2);
        return hIHsmPhysicalExdPGUseRateArgInfo;
    }

    public void collect(HIHsmPhysicalExdPGUseRateArgInfo hIHsmPhysicalExdPGUseRateArgInfo, HashMap hashMap) throws RJMdRmiException, IOException {
        if (hIHsmPhysicalExdPGUseRateArgInfo.getCount() > 0) {
            MonitorInfoCollection monitorInfoCollection = (MonitorInfoCollection)this.controller.getMonitorInfo((MonArg)hIHsmPhysicalExdPGUseRateArgInfo);
            for (int i = 0; i < monitorInfoCollection.size(); ++i) {
                HIHsmPhysicalExdPGUseRate hIHsmPhysicalExdPGUseRate = (HIHsmPhysicalExdPGUseRate)monitorInfoCollection.get(i);
                String string = new RJMdDataPG(hIHsmPhysicalExdPGUseRate.getExdLu(), hIHsmPhysicalExdPGUseRate.getExdPg()).toString();
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_PHY_ExG_Response), new RJMdColumn(string, hIHsmPhysicalExdPGUseRate.getResponseTime()));
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_PHY_ExG_Read_Response), new RJMdColumn(string, hIHsmPhysicalExdPGUseRate.getReadResponseTime()));
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_PHY_ExG_Write_Response), new RJMdColumn(string, hIHsmPhysicalExdPGUseRate.getWriteResponseTime()));
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_PHY_ExG_Trans), new RJMdColumn(string, hIHsmPhysicalExdPGUseRate.getTransmit()));
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_PHY_ExG_Read_Trans), new RJMdColumn(string, hIHsmPhysicalExdPGUseRate.getReadTransRate()));
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_PHY_ExG_Write_Trans), new RJMdColumn(string, hIHsmPhysicalExdPGUseRate.getWriteTransRate()));
            }
        }
    }

    private int initProgressPG(ArrayList arrayList) {
        int n = arrayList.size();
        int n2 = 0;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            RJMdDataPG rJMdDataPG = (RJMdDataPG)iterator.next();
            if (!this.parameter.containsRange(this.getGroupID(), rJMdDataPG)) continue;
            ++n2;
        }
        super.initProgress(n2, n);
        return n2;
    }

    public String[] getGroupAlias() {
        return groupAlias;
    }

    public String getGroupID() {
        return groupID;
    }

    public String getGroupName() {
        return groupName;
    }

    public String getGroupInfo() {
        return groupInfo;
    }

    public RJMdTimeRange getTimeRange() {
        return this.parameter.getShortRange();
    }

    public void analyzeOperand(RJMdCmdParser rJMdCmdParser) throws ParseException {
        RJMdRange rJMdRange = null;
        char c = rJMdCmdParser.getKind();
        while ((rJMdRange = this.analyzePGrpRange(rJMdCmdParser, false, true)) != null) {
            RJMdDataControl.trace("\tPG =  " + rJMdRange);
            this.parameter.addGroupRange(this.getGroupID(), rJMdRange);
            if (rJMdCmdParser.getKind() != ' ') break;
            rJMdCmdParser.nextToken();
        }
    }
}

