/*
 * Decompiled with CFR 0.152.
 */
package sanproject.getmondat.group;

import java.io.File;
import java.io.IOException;
import sanproject.getmondat.com.RJMdRmiException;
import sanproject.getmondat.com.RJMdTimeRange;
import sanproject.getmondat.data.RJMdDataControl;
import sanproject.getmondat.group.RJMdColumn;
import sanproject.getmondat.group.RJMdGroupData;
import sanproject.getmondat.group.RJMdUnitSerialStream;
import sanproject.serverux.arg.monitor.ArgHRCSystemEx;
import sanproject.serverux.arg.monitor.MonArg;
import sanproject.serverux.data.MonitorInfoCollection;
import sanproject.serverux.dataimpl.RMCPgetUsageInfEx;

public class RJMdGroupRemoteCopy
extends RJMdGroupData {
    private static final String groupID = "RemoteCopy";
    private static final String[] groupAlias = new String[0];
    private static final String groupName = "RemoteCopy_dat";
    private static final String groupInfo = "RemoteCopy data";
    private RJMdUnitSerialStream stream = null;
    private static final String CM_SideFile = "SideFile(%)";
    private static final String CM_AllRIO = "All RIO";
    private static final String CM_AllWrite = "All Write";
    private static final String CM_RIOUCK = "RIO Error";
    private static final String CM_IniRIO = "Initial Copy RIO";
    private static final String CM_IniLength = "Initial Copy Transfer(KB/s)";
    private static final String CM_IniTime = "Initial Copy Response(ms)";
    private static final String CM_RenewRIO = "Update Copy RIO";
    private static final String CM_RenewLength = "Update Copy Transfer(KB/s)";
    private static final String CM_RenewTime = "Update Copy Response(ms)";
    private static final String CM_ACopyRIO = "Asynchronous RIO";
    private static final String CM_ACopyRecordSet = "Recordset";
    private static final String CM_ACopyLength = "Asynchronous Copy Transfer(KB/s)";
    private static final String CM_ACopyTime = "Asynchronous Copy Response(ms)";
    private static final String CM_ACopySvolScheRecset = "Scheduling Recordset";
    private static final String CM_ACopySvolScheMiss = "Scheduling Miss Recordset";
    private static final String CM_ACopySvolRemRecset = "Remained Recordset";
    private static final String CM_ACopySvolScheAtmpt = "Scheduling Attempt";
    private static final String CM_PairSync = "Pair Synchronized(%)";
    private static final String CM_OutOfSync = "Out of Sync Tracks";
    private static final String RemoteCopy = "RemoteCopy";

    public RJMdGroupRemoteCopy(RJMdDataControl rJMdDataControl) {
        super(rJMdDataControl);
        this.allowPSA = false;
    }

    public void init() throws IOException {
        String string = this.parameter.getDirectory();
        File file = new File(string);
        this.stream = new RJMdUnitSerialStream(groupName, file);
        this.stream.setCompress(this.parameter.isCompless());
    }

    protected boolean isGroupExists() {
        boolean bl = this.stream.exists();
        return bl;
    }

    public void deleteGroup() {
        this.stream.deleteAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createGroup() throws RJMdRmiException, IOException {
        try {
            this.remoteCopy();
        }
        finally {
            this.stream.close();
        }
    }

    private void remoteCopy() throws RJMdRmiException, IOException {
        this.putInfomation("INF006", this.getGroupInfo());
        this.stream.createEntry("RemoteCopy", this.getTimeRange());
        RJMdTimeRange rJMdTimeRange = this.parameter.getShortRange();
        ArgHRCSystemEx argHRCSystemEx = new ArgHRCSystemEx(rJMdTimeRange.getFromTime(), rJMdTimeRange.getToTime());
        this.initProgress(1, 1);
        MonitorInfoCollection monitorInfoCollection = (MonitorInfoCollection)this.controller.getMonitorInfo((MonArg)argHRCSystemEx);
        if (monitorInfoCollection.size() > 0) {
            RMCPgetUsageInfEx rMCPgetUsageInfEx = (RMCPgetUsageInfEx)monitorInfoCollection.get(0);
            this.stream.write(new RJMdColumn(CM_AllRIO, rMCPgetUsageInfEx.getAllRIO()));
            this.stream.write(new RJMdColumn(CM_AllWrite, rMCPgetUsageInfEx.getAllWrite()));
            this.stream.write(new RJMdColumn(CM_RIOUCK, rMCPgetUsageInfEx.getRIOUCK()));
            this.stream.write(new RJMdColumn(CM_IniRIO, rMCPgetUsageInfEx.getIniRIO()));
            this.stream.write(new RJMdColumn(CM_IniLength, rMCPgetUsageInfEx.getIniLength()));
            this.stream.write(new RJMdColumn(CM_IniTime, rMCPgetUsageInfEx.getIniTime()));
            this.stream.write(new RJMdColumn(CM_RenewRIO, rMCPgetUsageInfEx.getRenewRIO()));
            this.stream.write(new RJMdColumn(CM_RenewLength, rMCPgetUsageInfEx.getRenewLength()));
            this.stream.write(new RJMdColumn(CM_RenewTime, rMCPgetUsageInfEx.getRenewTime()));
            this.stream.write(new RJMdColumn(CM_PairSync, rMCPgetUsageInfEx.getPairSync()));
            this.stream.write(new RJMdColumn(CM_OutOfSync, rMCPgetUsageInfEx.getOutOfSync()));
        }
        this.addProgress(1);
        this.closeProgress();
        this.stream.closeEntry();
        this.putInfomation("INF007", this.getGroupInfo());
    }

    public String[] getGroupAlias() {
        return groupAlias;
    }

    public String getGroupID() {
        return "RemoteCopy";
    }

    public String getGroupName() {
        return groupName;
    }

    public String getGroupInfo() {
        return groupInfo;
    }

    public RJMdTimeRange getTimeRange() {
        return this.parameter.getShortRange();
    }
}

