/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem.server.adapters.ih.cimxml;

import com.ws.cim.xmlcim.CIMXMLElementsWriter;
import com.ws.wbem.client.adapter.common.HTTPClient;
import com.ws.wbem.client.adapter.common.TLSInfo;
import com.ws.wbem.server.adapters.ih.common.IndicationHandler;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Principal;
import java.util.UUID;
import java.util.logging.Level;
import javax.cim.CIMInstance;
import javax.security.auth.Subject;
import javax.wbem.WBEMException;
import javax.wbem.client.PasswordCredential;
import javax.wbem.client.UserPrincipal;
import javax.wbem.provider.ProviderHandle;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class CIMXMLIndicationHandler
extends IndicationHandler {
    private static final String GUEST = "guest";
    private static final String defaultScheme = "http";
    private final Subject mSubject = new Subject();

    public CIMXMLIndicationHandler() {
        this.mSubject.getPrincipals().add((Principal)new UserPrincipal(GUEST));
        this.mSubject.getPrivateCredentials().add(new PasswordCredential(GUEST.toCharArray()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IndicationHandler.DeliveryStatus deliverIndication(Object object, CIMInstance cIMInstance) {
        IndicationHandler.DeliveryStatus deliveryStatus = IndicationHandler.DeliveryStatus.UNSUCCESSFUL;
        IndicationHTTPClient indicationHTTPClient = null;
        URL uRL = (URL)object;
        try {
            indicationHTTPClient = new IndicationHTTPClient(uRL, this.mSubject, this.mTLSInfo);
            indicationHTTPClient.connect("application/xml", null);
            indicationHTTPClient.addHeader("CIMExport", "MethodRequest");
            indicationHTTPClient.addHeader("CIMExportMethod", "ExportIndication");
            this.writeIndicationToStream((OutputStream)indicationHTTPClient.getOutputStream(), cIMInstance);
            indicationHTTPClient.getInputStream();
            deliveryStatus = IndicationHandler.DeliveryStatus.SUCCESSFUL;
        }
        catch (ConnectException connectException) {
            Object[] objectArray = new Object[]{uRL, connectException, cIMInstance};
            this.mLogger.log(Level.WARNING, "Caught ConnectException trying to deliver indication to {0}: {1}.\nAttempted Indication was: {2}", objectArray);
        }
        catch (IOException iOException) {
            Object[] objectArray = new Object[]{uRL, iOException, cIMInstance};
            this.mLogger.log(Level.WARNING, "Caught IOException trying to deliver indication to {0}: {1}.\nAttempted Indication was: {2}", objectArray);
        }
        catch (Throwable throwable) {
            Object[] objectArray = new Object[]{uRL, throwable, cIMInstance};
            this.mLogger.log(Level.WARNING, "Caught Exception trying to deliver indication to {0}: {1}.\nAttempted Indication was: {2}", objectArray);
        }
        finally {
            if (null != indicationHTTPClient) {
                indicationHTTPClient.connectionDone();
            }
        }
        return deliveryStatus;
    }

    public String getClassName() {
        return "CIM_ListenerDestinationCIMXML";
    }

    protected Object getDestinationObject(String string) {
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            String string2 = string;
            string2 = string2.startsWith("//") ? "http:" + string : "http://" + string;
            try {
                uRL = new URL(string2);
            }
            catch (MalformedURLException malformedURLException2) {
                String string3 = "Cannot deliver event because \"Destination\" value of the listener instance is invalid: " + string2;
                this.mLogger.log(Level.SEVERE, string3);
            }
        }
        return uRL;
    }

    public void initialize(ProviderHandle providerHandle) {
        super.initialize(providerHandle);
        this.mTLSInfo = null;
    }

    public void start(CIMInstance cIMInstance) {
        super.start(cIMInstance);
        this.mStarted = true;
        this.refreshTLSInfo();
    }

    private void writeIndicationToStream(OutputStream outputStream, CIMInstance cIMInstance) throws XMLStreamException {
        XMLOutputFactory xMLOutputFactory = XMLOutputFactory.newInstance();
        XMLStreamWriter xMLStreamWriter = xMLOutputFactory.createXMLStreamWriter(outputStream);
        xMLStreamWriter.writeStartDocument();
        xMLStreamWriter.writeStartElement("CIM");
        xMLStreamWriter.writeAttribute("CIMVERSION", "2.0");
        xMLStreamWriter.writeAttribute("DTDVERSION", "2.0");
        xMLStreamWriter.writeStartElement("MESSAGE");
        xMLStreamWriter.writeAttribute("ID", UUID.randomUUID().toString());
        xMLStreamWriter.writeAttribute("PROTOCOLVERSION", "1.0");
        xMLStreamWriter.writeStartElement("SIMPLEEXPREQ");
        xMLStreamWriter.writeStartElement("EXPMETHODCALL");
        xMLStreamWriter.writeAttribute("NAME", "ExportIndication");
        xMLStreamWriter.writeStartElement("EXPPARAMVALUE");
        xMLStreamWriter.writeAttribute("NAME", "NewIndication");
        CIMXMLElementsWriter.writeInstance((XMLStreamWriter)xMLStreamWriter, (CIMInstance)cIMInstance);
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeEndDocument();
        xMLStreamWriter.flush();
        xMLStreamWriter.close();
    }

    class IndicationHTTPClient
    extends HTTPClient {
        public IndicationHTTPClient(URL uRL, Subject subject, TLSInfo tLSInfo) throws WBEMException {
            if (null != tLSInfo && tLSInfo.isAuthRequired()) {
                this.initializeClient(uRL, subject, tLSInfo.getKeystoreFile(), tLSInfo.getKeystorePassword(), tLSInfo.getTruststoreFile(), tLSInfo.getCiphers());
            } else {
                this.initializeClient(uRL, subject, null, null, null, null);
            }
        }

        public IndicationHTTPClient(URL uRL, TLSInfo tLSInfo) throws WBEMException {
            this(uRL, null, null);
        }

        protected String getDefaultHTTPPort() {
            return Integer.toString(0);
        }

        protected String getDefaultHTTPSPort() {
            return Integer.toString(0);
        }

        protected String getProtocolPath() {
            return "";
        }
    }
}

