/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.base.authentication.plugin;

import java.util.HashMap;
import java.util.UUID;
import sanproject.sn2.base.authentication.inf.SJbaseAuthenticationModulePluginInterface;
import sanproject.sn2.com.utility.SJcAccountChkUty;
import sanproject.sn2.com.utility.SJcLogUty;
import sanproject.sn2.com.utility.SJcSecureUty;
import sanproject.sn2.com.utility.SJcUserInfoUty;
import sanproject.sn2.com.utility.account.SJcAccountConst;
import sanproject.sn2.com.utility.account.SJcUserInfoContainer;
import sanproject.sn2.com.utility.account.exception.SJcNotFoundUserException;
import sanproject.sn2.com.utility.account.exception.SJcParamErrorException;

public class SJbaseAuthenticetionLocal
implements SJbaseAuthenticationModulePluginInterface {
    private final String LOG_FUNCTION = "SJbaseAuthenticetionLocal";
    private final String LOG_TITLE = this.getClass().getSimpleName();
    private static String szMsg;
    private String m_szUserName = null;
    private String m_SessionID = null;
    private String[] m_szGroupName = null;
    private String m_szPassword = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int authentication(String szUserName, String szPassword) {
        int iRet;
        block19: {
            String LOG_SUBTITLE = "authentication";
            iRet = 6;
            try {
                szMsg = "<" + szUserName + ">Start.";
                SJcLogUty.getLogger().info("SJbaseAuthenticetionLocal", this.LOG_TITLE, "authentication", szMsg);
                String[] szAlyUser = new String[]{szUserName};
                SJcUserInfoContainer[] clsUserInfo = SJcUserInfoUty.getUserInfo(szAlyUser);
                if (clsUserInfo[0] == null) {
                    throw new SJcNotFoundUserException();
                }
                if (clsUserInfo[0].getEnable()) {
                    if (clsUserInfo[0].getAuthPtn() == SJcAccountConst.INT_AUTHPTN_LOCAL) {
                        boolean bCheck = false;
                        try {
                            if (!bCheck) {
                                SJcAccountChkUty.chkUserName(szUserName);
                            }
                        }
                        catch (SJcParamErrorException ex) {
                            iRet = 6;
                            bCheck = true;
                        }
                        try {
                            if (!bCheck) {
                                SJcAccountChkUty.chkPassword(szPassword);
                            }
                        }
                        catch (SJcParamErrorException ex) {
                            iRet = 1;
                            bCheck = true;
                        }
                        if (!bCheck) {
                            if (SJcUserInfoUty.checkPassword(szUserName, szPassword)) {
                                iRet = 0;
                                this.m_szUserName = szUserName;
                                this.m_szPassword = szPassword;
                                String szUuid = UUID.randomUUID().toString().replaceAll("-", "");
                                String szSession = szUserName + szPassword + szUuid;
                                this.m_SessionID = SJcSecureUty.getHashValueStringHex(szSession).substring(0, 32);
                                this.m_szGroupName = clsUserInfo[0].getGrpName();
                            } else {
                                iRet = 1;
                            }
                        }
                        break block19;
                    }
                    iRet = 7;
                    break block19;
                }
                iRet = 2;
            }
            catch (SJcNotFoundUserException e) {
                iRet = 6;
                szMsg = "<" + szUserName + ">NotFound UserData.";
                SJcLogUty.getLogger().error("SJbaseAuthenticetionLocal", this.LOG_TITLE, "authentication", szMsg);
            }
            catch (Exception e) {
                iRet = 11;
                szMsg = "<" + szUserName + ">";
                SJcLogUty.getLogger().error("SJbaseAuthenticetionLocal", this.LOG_TITLE, "authentication", szMsg, e);
            }
            finally {
                szMsg = "<" + szUserName + ">End. - status:" + iRet;
                SJcLogUty.getLogger().info("SJbaseAuthenticetionLocal", this.LOG_TITLE, "authentication", szMsg);
            }
        }
        return iRet;
    }

    @Override
    public String getUserName() {
        return this.m_szUserName;
    }

    @Override
    public String[] getGroupID() {
        return this.m_szGroupName;
    }

    @Override
    public String getSessionID() {
        return this.m_SessionID;
    }

    @Override
    public String getAuthSystemName(String szSystem) {
        return szSystem;
    }

    @Override
    public HashMap getAuthObject() {
        return null;
    }

    @Override
    public String[] getRoleID() {
        return null;
    }

    @Override
    public boolean[] getResourceGrpMap() {
        return null;
    }

    @Override
    public boolean isAllRSG() {
        return false;
    }

    @Override
    public boolean[] getRoleMap() {
        return null;
    }

    @Override
    public String getPassword() {
        return this.m_szPassword;
    }
}

