/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.com.utility.account;

import com.hitachi.sanproject.data.SanList;
import com.hitachi.sanproject.data.SanObject;
import com.hitachi.sanproject.rmi.SanRequest;
import com.hitachi.sanproject.rmi.SanResponse;
import java.util.ArrayList;
import java.util.BitSet;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.SJcEnvUty;
import sanproject.sn2.com.utility.account.SJcAccountFileManage;
import sanproject.sn2.com.utility.account.SJcRmiAccess;
import sanproject.sn2.com.utility.account.SJcUserGroupInfoContainer;
import sanproject.sn2.com.utility.account.exception.SJcCommunicationErrorException;
import sanproject.sn2.com.utility.account.exception.SJcExistDataException;
import sanproject.sn2.com.utility.account.exception.SJcFailDataException;
import sanproject.sn2.com.utility.account.exception.SJcMaxCreateException;
import sanproject.sn2.com.utility.account.exception.SJcNoMatchDataException;
import sanproject.sn2.com.utility.account.exception.SJcNotFoundGroupException;
import sanproject.sn2.com.utility.account.exception.SJcNotFoundRoleException;
import sanproject.sn2.com.utility.account.exception.SJcParamErrorException;
import sanproject.sn2.com.utility.account.exception.SJcTypeErrorException;

public class SJcAccountFileGroupInfo
extends SJcAccountFileManage {
    private int m_iMaxCount = SJcEnvUty.getProperty2int("SN_ACCOUNT_MAX_GROUP", 256);

    public SJcAccountFileGroupInfo() {
        super("GroupInfo");
    }

    public static void createUserGroup(String szGrpName, String[] szRoleName, int[] iRsrcGpID, boolean bAllRsrc, long lRscLockID) throws Exception {
        SJcRmiAccess rmiAccess = new SJcRmiAccess();
        SanRequest request = rmiAccess.getSanRequest(false, "ACCcreateUserGroup", lRscLockID);
        SanObject reqUserGroup = request.newObj("UserGroup");
        reqUserGroup.putString("Name", szGrpName);
        SanList roles = reqUserGroup.newList("Roles");
        for (int i = 0; i < szRoleName.length; ++i) {
            SanObject role = roles.addObj();
            role.putString("Name", szRoleName[i]);
        }
        BitSet bitset = new BitSet(1024);
        if (iRsrcGpID != null) {
            for (int i = 0; i < iRsrcGpID.length; ++i) {
                bitset.set(iRsrcGpID[i]);
            }
        }
        reqUserGroup.putBitSet("ResourceGroupBitmap", bitset);
        reqUserGroup.putBoolean("AllResourceGroup", bAllRsrc);
        SanResponse response = rmiAccess.invoke();
        SanObject errorInfo = response.getObj("ErrorInfo");
        int errorCode = errorInfo.getInt("ErrorCode");
        if (errorCode != 0) {
            int[] messageId = errorInfo.getIntArray("MessageId");
            switch (messageId[1]) {
                case 106061: {
                    throw new SJcParamErrorException();
                }
                case 205001: {
                    throw new SJcParamErrorException();
                }
                case 206001: {
                    throw new SJcMaxCreateException();
                }
                case 206002: {
                    throw new SJcExistDataException();
                }
                case 207001: {
                    throw new SJcNotFoundRoleException();
                }
                case 207007: {
                    throw new SJcException();
                }
                case 207008: {
                    throw new SJcException();
                }
                case 208001: {
                    throw new SJcCommunicationErrorException();
                }
            }
            throw new SJcException();
        }
    }

    public static void setUserGroupName(String szNowGrpName, String szNewGrpName, long lRscLockID) throws Exception {
        SJcRmiAccess rmiAccess = new SJcRmiAccess();
        SanRequest request = rmiAccess.getSanRequest(false, "ACCupdateUserGroupName", lRscLockID);
        SanObject reqUserGroup = request.newObj("UserGroup");
        reqUserGroup.putString("Name", szNowGrpName);
        reqUserGroup.putString("NewName", szNewGrpName);
        SanResponse response = rmiAccess.invoke();
        SanObject errorInfo = response.getObj("ErrorInfo");
        int errorCode = errorInfo.getInt("ErrorCode");
        if (errorCode != 0) {
            int[] messageId = errorInfo.getIntArray("MessageId");
            switch (messageId[1]) {
                case 106061: {
                    throw new SJcParamErrorException();
                }
                case 205002: {
                    throw new SJcNotFoundGroupException();
                }
                case 206002: {
                    throw new SJcExistDataException();
                }
                case 207003: {
                    throw new SJcTypeErrorException();
                }
                case 207007: {
                    throw new SJcException();
                }
                case 207008: {
                    throw new SJcException();
                }
                case 208001: {
                    throw new SJcCommunicationErrorException();
                }
            }
            throw new SJcException();
        }
    }

    public static void setUserGroupRole(String szGrpName, String[] szRoleName, long lRscLockID) throws Exception {
        SJcRmiAccess rmiAccess = new SJcRmiAccess();
        SanRequest request = rmiAccess.getSanRequest(false, "ACCupdateUserGroupRole", lRscLockID);
        SanObject reqUserGroup = request.newObj("UserGroup");
        reqUserGroup.putString("Name", szGrpName);
        SanList roles = reqUserGroup.newList("Roles");
        for (int i = 0; i < szRoleName.length; ++i) {
            SanObject role = roles.addObj();
            role.putString("Name", szRoleName[i]);
        }
        SanResponse response = rmiAccess.invoke();
        SanObject errorInfo = response.getObj("ErrorInfo");
        int errorCode = errorInfo.getInt("ErrorCode");
        if (errorCode != 0) {
            int[] messageId = errorInfo.getIntArray("MessageId");
            switch (messageId[1]) {
                case 106061: {
                    throw new SJcParamErrorException();
                }
                case 205001: {
                    throw new SJcParamErrorException();
                }
                case 205002: {
                    throw new SJcNotFoundGroupException();
                }
                case 207003: {
                    throw new SJcTypeErrorException();
                }
                case 207001: {
                    throw new SJcNotFoundRoleException();
                }
                case 207007: {
                    throw new SJcException();
                }
                case 207008: {
                    throw new SJcException();
                }
                case 208001: {
                    throw new SJcCommunicationErrorException();
                }
            }
            throw new SJcException();
        }
    }

    public static void setUserGroupResourceGrpMap(String szGrpName, int[] iRsrcGpID, long lRscLockID) throws Exception {
        SJcRmiAccess rmiAccess = new SJcRmiAccess();
        SanRequest request = rmiAccess.getSanRequest(false, "ACCupdateUserGroupResourceGrpBmp", lRscLockID);
        SanObject reqUserGroup = request.newObj("UserGroup");
        reqUserGroup.putString("Name", szGrpName);
        BitSet bitset = new BitSet(1024);
        if (iRsrcGpID != null) {
            for (int i = 0; i < iRsrcGpID.length; ++i) {
                bitset.set(iRsrcGpID[i]);
            }
        }
        reqUserGroup.putBitSet("ResourceGroupBitmap", bitset);
        SanResponse response = rmiAccess.invoke();
        SanObject errorInfo = response.getObj("ErrorInfo");
        int errorCode = errorInfo.getInt("ErrorCode");
        if (errorCode != 0) {
            int[] messageId = errorInfo.getIntArray("MessageId");
            switch (messageId[1]) {
                case 106061: {
                    throw new SJcParamErrorException();
                }
                case 205002: {
                    throw new SJcNotFoundGroupException();
                }
                case 207003: {
                    throw new SJcTypeErrorException();
                }
                case 205004: {
                    throw new SJcNoMatchDataException();
                }
                case 207007: {
                    throw new SJcException();
                }
                case 207008: {
                    throw new SJcException();
                }
                case 208001: {
                    throw new SJcCommunicationErrorException();
                }
            }
            throw new SJcException();
        }
    }

    public static void setUserGroupAllResourceGrp(String szGrpName, boolean bAllRsrc, long lRscLockID) throws Exception {
        SJcRmiAccess rmiAccess = new SJcRmiAccess();
        SanRequest request = rmiAccess.getSanRequest(false, "ACCupdateUserGroupAllResourceGrp", lRscLockID);
        SanObject reqUserGroup = request.newObj("UserGroup");
        reqUserGroup.putString("Name", szGrpName);
        reqUserGroup.putBoolean("AllResourceGroup", bAllRsrc);
        SanResponse response = rmiAccess.invoke();
        SanObject errorInfo = response.getObj("ErrorInfo");
        int errorCode = errorInfo.getInt("ErrorCode");
        if (errorCode != 0) {
            int[] messageId = errorInfo.getIntArray("MessageId");
            switch (messageId[1]) {
                case 106061: {
                    throw new SJcParamErrorException();
                }
                case 205002: {
                    throw new SJcNotFoundGroupException();
                }
                case 207003: {
                    throw new SJcTypeErrorException();
                }
                case 207007: {
                    throw new SJcException();
                }
                case 207008: {
                    throw new SJcException();
                }
                case 208001: {
                    throw new SJcCommunicationErrorException();
                }
            }
            throw new SJcException();
        }
    }

    public static void deleteUserGroup(String[] szGrpName, long lRscLockID) throws Exception {
        SJcRmiAccess rmiAccess = new SJcRmiAccess();
        SanRequest request = rmiAccess.getSanRequest(false, "ACCdeleteUserGroups", lRscLockID);
        SanList reqUserGroups = request.newList("UserGroups");
        for (int i = 0; i < szGrpName.length; ++i) {
            SanObject reqUserGroup = reqUserGroups.addObj();
            reqUserGroup.putString("Name", szGrpName[i]);
        }
        SanResponse response = rmiAccess.invoke();
        SanObject errorInfo = response.getObj("ErrorInfo");
        int errorCode = errorInfo.getInt("ErrorCode");
        if (errorCode == 7000) {
            ArrayList<String> alList = new ArrayList<String>();
            SanList resUserGroups = response.getList("UserGroups");
            for (int i = 0; i < resUserGroups.size(); ++i) {
                SanObject resUserGroup = resUserGroups.getObj(i);
                SanObject userGroupErrorInfo = resUserGroup.getObj("ErrorInfo");
                int userGroupErrorCode = userGroupErrorInfo.getInt("ErrorCode");
                if (userGroupErrorCode == 0) continue;
                alList.add(szGrpName[i]);
            }
            String[] szFail = alList.toArray(new String[0]);
            throw new SJcFailDataException(szFail);
        }
        if (errorCode != 0) {
            int[] messageId = errorInfo.getIntArray("MessageId");
            switch (messageId[1]) {
                case 207007: {
                    throw new SJcException();
                }
                case 207008: {
                    throw new SJcException();
                }
                case 208001: {
                    throw new SJcCommunicationErrorException();
                }
            }
            throw new SJcException();
        }
    }

    public static String[] getUserGroupList() throws Exception {
        SJcRmiAccess rmiAccess = new SJcRmiAccess();
        SanRequest request = rmiAccess.getSanRequest(true, "ACCreadAllUserGroupNames", 0L);
        SanResponse response = rmiAccess.invoke();
        SanObject errorInfo = response.getObj("ErrorInfo");
        int errorCode = errorInfo.getInt("ErrorCode");
        if (errorCode != 0) {
            int[] messageId = errorInfo.getIntArray("MessageId");
            switch (messageId[1]) {
                case 207007: {
                    throw new SJcException();
                }
                case 207008: {
                    throw new SJcException();
                }
                case 208001: {
                    throw new SJcCommunicationErrorException();
                }
            }
            throw new SJcException();
        }
        ArrayList<String> alList = new ArrayList<String>();
        SanList resUserGroups = response.getList("UserGroups");
        for (int i = 0; i < resUserGroups.size(); ++i) {
            SanObject resUserGroup = resUserGroups.getObj(i);
            String name = resUserGroup.getString("Name");
            alList.add(name);
        }
        return alList.toArray(new String[0]);
    }

    public static SJcUserGroupInfoContainer getUserGroupInfo(String szGrpName) throws Exception {
        String[] szGrpNames = new String[]{szGrpName};
        SJcUserGroupInfoContainer[] clsData = SJcAccountFileGroupInfo.getUserGroupInfo(szGrpNames);
        return clsData[0];
    }

    public static SJcUserGroupInfoContainer[] getUserGroupInfo(String[] szGrpName) throws Exception {
        SJcRmiAccess rmiAccess = new SJcRmiAccess();
        SanRequest request = rmiAccess.getSanRequest(true, "ACCreadUserGroupInfoEx", 0L);
        SanList reqUserGroups = request.newList("UserGroups");
        for (int i = 0; i < szGrpName.length; ++i) {
            SanObject reqUserGroup = reqUserGroups.addObj();
            reqUserGroup.putString("Name", szGrpName[i]);
        }
        SanResponse response = rmiAccess.invoke();
        SanObject errorInfo = response.getObj("ErrorInfo");
        int errorCode = errorInfo.getInt("ErrorCode");
        if (errorCode != 0 && errorCode != 7000) {
            int[] messageId = errorInfo.getIntArray("MessageId");
            switch (messageId[1]) {
                case 207007: {
                    throw new SJcException();
                }
                case 207008: {
                    throw new SJcException();
                }
                case 208001: {
                    throw new SJcCommunicationErrorException();
                }
            }
            throw new SJcException();
        }
        SanList resUserGroups = response.getList("UserGroups");
        SJcUserGroupInfoContainer[] clsData = new SJcUserGroupInfoContainer[resUserGroups.size()];
        for (int group_cnt = 0; group_cnt < resUserGroups.size(); ++group_cnt) {
            SanObject resUserGroup = resUserGroups.getObj(group_cnt);
            SanObject userGroupErrorInfo = resUserGroup.getObj("ErrorInfo");
            int userGroupErrorCode = userGroupErrorInfo.getInt("ErrorCode");
            if (userGroupErrorCode != 0) {
                clsData[group_cnt] = null;
                continue;
            }
            clsData[group_cnt] = new SJcUserGroupInfoContainer();
            String name = resUserGroup.getString("Name");
            clsData[group_cnt].setGroupName(new String(name));
            SanList roles = resUserGroup.getList("Roles");
            String[] roleNames = new String[roles.size()];
            for (int role_cnt = 0; role_cnt < roles.size(); ++role_cnt) {
                SanObject role = roles.getObj(role_cnt);
                String roleName = role.getString("Name");
                roleNames[role_cnt] = new String(roleName);
            }
            clsData[group_cnt].setRoleName(roleNames);
            BitSet resourceGroupBitmap = resUserGroup.getBitSet("ResourceGroupBitmap");
            boolean[] resoruceGroupId = new boolean[1024];
            for (int rsg_cnt = 0; rsg_cnt < 1024; ++rsg_cnt) {
                resoruceGroupId[rsg_cnt] = resourceGroupBitmap.get(rsg_cnt);
            }
            clsData[group_cnt].setRsrcGroupMap(resoruceGroupId);
            boolean builtin = resUserGroup.getBoolean("Builtin");
            clsData[group_cnt].setType(builtin ? "1" : "2");
            boolean allResourceGroup = resUserGroup.getBoolean("AllResourceGroup");
            clsData[group_cnt].setAllRsrcGroup(allResourceGroup);
        }
        return clsData;
    }

    public static ArrayList<String[]> getUserInUserGroup(String[] szGrpName) throws Exception {
        SJcRmiAccess rmiAccess = new SJcRmiAccess();
        SanRequest request = rmiAccess.getSanRequest(true, "ACCreadAllUserNamesInUserGroupEx", 0L);
        SanList reqUserGroups = request.newList("UserGroups");
        for (int i = 0; i < szGrpName.length; ++i) {
            SanObject reqUserGroup = reqUserGroups.addObj();
            reqUserGroup.putString("Name", szGrpName[i]);
        }
        SanResponse response = rmiAccess.invoke();
        SanObject errorInfo = response.getObj("ErrorInfo");
        int errorCode = errorInfo.getInt("ErrorCode");
        if (errorCode != 0 && errorCode != 7000) {
            int[] messageId = errorInfo.getIntArray("MessageId");
            switch (messageId[1]) {
                case 207007: {
                    throw new SJcException();
                }
                case 207008: {
                    throw new SJcException();
                }
                case 208001: {
                    throw new SJcCommunicationErrorException();
                }
            }
            throw new SJcException();
        }
        SanList resUserGroups = response.getList("UserGroups");
        ArrayList<String[]> alList = new ArrayList<String[]>();
        for (int group_cnt = 0; group_cnt < resUserGroups.size(); ++group_cnt) {
            SanObject resUserGroup = resUserGroups.getObj(group_cnt);
            SanObject userGroupErrorInfo = resUserGroup.getObj("ErrorInfo");
            int userGroupErrorCode = userGroupErrorInfo.getInt("ErrorCode");
            if (userGroupErrorCode != 0) {
                alList.add(null);
                continue;
            }
            SanList resUsers = resUserGroup.getList("Users");
            String[] userNames = new String[resUsers.size()];
            for (int user_cnt = 0; user_cnt < resUsers.size(); ++user_cnt) {
                SanObject resUser = resUsers.getObj(user_cnt);
                userNames[user_cnt] = resUser.getString("Name");
            }
            alList.add(userNames);
        }
        return alList;
    }
}

