/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.servlet.login;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.BitSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.UUID;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import sanproject.serverux.dataimpl.DKCSystemOptionEx;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcEnvUty;
import sanproject.sn2.com.utility.SJcLogUty;
import sanproject.sn2.com.utility.SJcProductUty;
import sanproject.sn2.com.utility.SJcStringUty;
import sanproject.sn2.datasupplier.SJdsSupplierMgr;
import sanproject.sn2.sn2com.utility.SJsncProductModelUty;
import sanproject.sn2.sn2com.utility.SJsncVersionCheckUty;

public class SJsvlLoginScreenServlet
extends HttpServlet {
    public static final String PARAM_SN_LANGUAGE = "SN_Language";
    public static final String PARAM_SN_VENDER = "SN_Vender";
    public static final String PARAM_SN_MICROVERSION = "SN_MicroVersion";
    public static final String PARAM_SN_VIEW_LOGINTYPE = "SN_View_LoginType";
    public static final String PARAM_SN_VIEW_USERNAME = "SN_View_UserName";
    public static final String PARAM_SN_VIEW_PASSWORD = "SN_View_Password";
    public static final String PARAM_SN_VIEW_CLIENTID = "SN_View_ClientID";
    public static final String PARAM_SN_LOG_LEVEL = "SN_Log_Level";
    public static final String PARAM_SN_VIEW_LOGINTERVAL = "SN_View_LogInterval";
    public static final String PARAM_SN_VIEW_WARNINGINFOURL = "SN_View_WarningInfoURL";
    public static final String PARAM_SN_COPYRIGHT = "SN_Copyright";
    public static final String PARAM_SN_VIEW_LOADPRM = "SN_View_LoadPrm";
    public static final String PARAM_SN_VIEW_PTYPE = "SN_View_PType";
    public static final String PARAM_SN_VIEW_DIRECTLAUNCH = "SN_View_DirectLaunch";
    public static final String PARAM_SN_VIEW_CALLBACL_URL_BACK = "SN_View_CallbackUrlBack";
    public static final String PARAM_SN_VIEW_CALLBACL_URL_APPLY = "SN_View_CallbackUrlApply";
    public static final String PARAM_SN_VIEW_CALLBACL_PARAM = "SN_View_CallbackParam";
    public static final String PARAM_SN_VIEW_SUBMENU_DISABLE = "SN_SubMenu_Disable";
    public static final String PARAM_SN_VIEW_HELPURL = "SN_View_HelpURL";
    public static final String DEFAULT_PARAM_SN_VIEW_DIRECTLAUNCH = "0";
    public static final String DEFAULT_PARAM_SN_VIEW_SUBMENU_DISABLE = "0";
    public static final String DEFAULT_PARAM_SN_VIEW_HELPURL = "";
    public static final String PARAM_SN_VIEW_MTYPE = "SN_View_MType";
    public static final String PARAM_SN_VIEW_PATHINFO_FLAG = "SN_View_PathInfo_Flag";
    public static final String LOGINTYPE_NOR = "NOR";
    public static final String LOGINTYPE_SVP = "SVP";
    public static final String LOGINTYPE_HIC = "HIC";
    public static final String LOGINTYPE_SSO = "HSSO";
    public static final String LANG_EN = "EN";
    public static final String LANG_JA = "JA";
    public static final String LANG_AUTO = "AUTO";
    private final String LOG_FUNCTION = "Login";
    private final String LOG_TITLE = ((Object)((Object)this)).getClass().getSimpleName();
    private final String ENCODE_UTF8 = "UTF-8";
    private final String VAR_CONNECTOR = "&";
    private final String VAR_REPLACE = "___and___";
    private final String KEYVAL_CONNECTOR = "=";
    private final String KEY_FLASHVARS = "flashvars";
    private final String KEY_BROWSERTITLE = "browserTitle";
    private final String KEY_LOADSWF = "loadSwf";
    private final String KEY_LOADPRM = "loadParam";
    private final String KEY_SWFBASE = "swfBase";
    private static final String FORWARD_URL = "/jsp/SJsvlLoginScreen.jsp";
    private final String LOAD_SWF_DEFAULT = "RMcAppWindowHI";
    private SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String helpURL;
        String subMenuDisable;
        String callbackOnBackParam;
        String callbackOnApply;
        String callbackOnBack;
        String LOG_SUBTITLE = "doPost";
        this.STD_LOGGER.info("Login", this.LOG_TITLE, "doPost", "Start.");
        request.setCharacterEncoding("UTF-8");
        String language = (String)request.getAttribute(PARAM_SN_LANGUAGE);
        String logintype = (String)request.getAttribute(PARAM_SN_VIEW_LOGINTYPE);
        String userName = (String)request.getAttribute(PARAM_SN_VIEW_USERNAME);
        String password = (String)request.getAttribute(PARAM_SN_VIEW_PASSWORD);
        Boolean flg = (Boolean)request.getAttribute(PARAM_SN_VIEW_PATHINFO_FLAG);
        String launchMode = (String)request.getAttribute(PARAM_SN_VIEW_DIRECTLAUNCH);
        if (launchMode == null) {
            launchMode = "0";
        }
        if ((callbackOnBack = (String)request.getAttribute(PARAM_SN_VIEW_CALLBACL_URL_BACK)) == null) {
            callbackOnBack = DEFAULT_PARAM_SN_VIEW_HELPURL;
        }
        if ((callbackOnApply = (String)request.getAttribute(PARAM_SN_VIEW_CALLBACL_URL_APPLY)) == null) {
            callbackOnApply = DEFAULT_PARAM_SN_VIEW_HELPURL;
        }
        if ((callbackOnBackParam = (String)request.getAttribute(PARAM_SN_VIEW_CALLBACL_PARAM)) == null) {
            callbackOnBackParam = DEFAULT_PARAM_SN_VIEW_HELPURL;
        }
        if ((subMenuDisable = (String)request.getAttribute(PARAM_SN_VIEW_SUBMENU_DISABLE)) == null) {
            subMenuDisable = "0";
        }
        if ((helpURL = (String)request.getAttribute(PARAM_SN_VIEW_HELPURL)) == null) {
            helpURL = DEFAULT_PARAM_SN_VIEW_HELPURL;
        }
        if (language == null) {
            language = SJcProductUty.getLanguageList();
        }
        if (logintype == null) {
            String venderID = SJcProductUty.getVenderID();
            if ("HIE".equals(venderID)) {
                logintype = "NOR_BASIC";
                BitSet snSystemOption = this.getSnSystemOption();
                if (snSystemOption == null) {
                    logintype = "NOR_BASIC";
                    this.STD_LOGGER.info("Login", this.LOG_TITLE, "doPost", "snSystemOption is null.");
                } else if (snSystemOption.get(4)) {
                    logintype = LOGINTYPE_NOR;
                    this.STD_LOGGER.info("Login", this.LOG_TITLE, "doPost", "Enable Storage Navigator 2 All Function:" + snSystemOption.get(4));
                }
            } else {
                logintype = LOGINTYPE_NOR;
            }
        }
        String vender = SJcProductUty.getVenderID();
        String microVersion = SJcProductUty.getMicroVersionList().get(LOGINTYPE_SVP);
        String ClientID = this.getClientID();
        String level = String.valueOf(SJcEnvUty.getProperty2int(PARAM_SN_LOG_LEVEL, 20000));
        String interval = SJcEnvUty.getProperty(PARAM_SN_VIEW_LOGINTERVAL);
        String url = SJcEnvUty.getProperty(PARAM_SN_VIEW_WARNINGINFOURL);
        String copyright = SJcProductUty.getCopylight();
        String loadParam = Integer.toHexString(SJcProductUty.getMicroVersionList().hashCode());
        String viewPType = SJsncVersionCheckUty.getVersion();
        String flashVariable = this.createFlashVariable(language, vender, microVersion, logintype, userName, password, ClientID, level, interval, url, copyright, loadParam, viewPType, launchMode, subMenuDisable, helpURL, callbackOnBack, callbackOnApply, callbackOnBackParam);
        String productName = SJcProductUty.getManagerAppName();
        String serialNumber = SJcProductUty.getSerialNumber();
        String userSystemName = SJcProductUty.getUserSystemName();
        String browserTitle = this.createTitle(productName, request.getServerName(), serialNumber, userSystemName);
        String loadFile = null;
        if (vender != null) {
            String loadFileKey = "SN_LOAD_SWF." + vender;
            loadFile = SJcEnvUty.getProperty(loadFileKey, "RMcAppWindowHI");
        } else {
            loadFile = "RMcAppWindowHI";
        }
        loadFile = SJcStringUty.filterEscape(loadFile);
        String swfBase = "./";
        if (LOGINTYPE_HIC.equals(logintype) && flg != null && flg.booleanValue()) {
            swfBase = "../";
        }
        request.setAttribute("flashvars", (Object)flashVariable);
        request.setAttribute("browserTitle", (Object)browserTitle);
        request.setAttribute("loadSwf", (Object)loadFile);
        request.setAttribute("loadParam", (Object)loadParam);
        request.setAttribute("swfBase", (Object)swfBase);
        this.STD_LOGGER.info("Login", this.LOG_TITLE, "doPost", "End.");
        RequestDispatcher dispatch = request.getRequestDispatcher(FORWARD_URL);
        dispatch.forward((ServletRequest)request, (ServletResponse)response);
    }

    private BitSet getSnSystemOption() {
        String LOG_SUBTITLE = "getSnSystemOption";
        BitSet result = null;
        SJdsSupplierMgr supplierMgr = SJdsSupplierMgr.getSupplierMgr();
        if (supplierMgr == null) {
            this.STD_LOGGER.error("Login", this.LOG_TITLE, "getSnSystemOption", "supplierMgr is null.");
            return result;
        }
        DKCSystemOptionEx systemOptionEx = supplierMgr.getSystemOptionInfo(false);
        if (systemOptionEx == null) {
            this.STD_LOGGER.error("Login", this.LOG_TITLE, "getSnSystemOption", "systemOptionEx is null.");
            return result;
        }
        result = systemOptionEx.getBitSnSysOpt();
        return result;
    }

    private String createFlashVariable(String language, String vender, String microVersion, String logintype, String userName, String password, String clientID, String level, String interval, String url, String copyright, String loadParam, String viewPType, String launchMode, String subMenuDisable, String helpURL, String callbackOnBack, String callbackOnApply, String callbackOnBackParam) {
        String LOG_SUBTITLE = "createFlashVariable";
        this.STD_LOGGER.info("Login", this.LOG_TITLE, "createFlashVariable", "Start.");
        LinkedHashMap<String, String> linkedHash = new LinkedHashMap<String, String>();
        String viewMType = String.valueOf(SJsncProductModelUty.getProductModel());
        linkedHash.put(PARAM_SN_LANGUAGE, language);
        linkedHash.put(PARAM_SN_VENDER, vender);
        linkedHash.put(PARAM_SN_MICROVERSION, microVersion);
        linkedHash.put(PARAM_SN_VIEW_LOGINTYPE, logintype);
        linkedHash.put(PARAM_SN_VIEW_USERNAME, userName);
        linkedHash.put(PARAM_SN_VIEW_PASSWORD, password);
        linkedHash.put(PARAM_SN_VIEW_CLIENTID, clientID);
        linkedHash.put(PARAM_SN_LOG_LEVEL, level);
        linkedHash.put(PARAM_SN_VIEW_LOGINTERVAL, interval);
        linkedHash.put(PARAM_SN_VIEW_WARNINGINFOURL, url);
        linkedHash.put(PARAM_SN_COPYRIGHT, copyright);
        linkedHash.put(PARAM_SN_VIEW_LOADPRM, loadParam);
        linkedHash.put(PARAM_SN_VIEW_PTYPE, viewPType);
        linkedHash.put(PARAM_SN_VIEW_DIRECTLAUNCH, launchMode);
        linkedHash.put(PARAM_SN_VIEW_SUBMENU_DISABLE, subMenuDisable);
        linkedHash.put(PARAM_SN_VIEW_HELPURL, helpURL);
        linkedHash.put(PARAM_SN_VIEW_MTYPE, viewMType);
        linkedHash.put(PARAM_SN_VIEW_CALLBACL_URL_BACK, callbackOnBack);
        linkedHash.put(PARAM_SN_VIEW_CALLBACL_URL_APPLY, callbackOnApply);
        linkedHash.put(PARAM_SN_VIEW_CALLBACL_PARAM, callbackOnBackParam.replace("&", "___and___"));
        StringBuffer couplingArgs = new StringBuffer();
        Iterator ite = linkedHash.keySet().iterator();
        while (ite.hasNext()) {
            String key = (String)ite.next();
            String value = (String)linkedHash.get(key);
            value = this.nullToEmpty(value);
            value = this.encodeString(key, value);
            couplingArgs.append(key);
            couplingArgs.append("=");
            couplingArgs.append(value);
            if (!ite.hasNext()) continue;
            couplingArgs.append("&");
        }
        this.STD_LOGGER.info("Login", this.LOG_TITLE, "createFlashVariable", "End. ");
        return couplingArgs.toString();
    }

    private String createTitle(String productName, String ipAddress, String serialNumber, String userSystemName) {
        String LOG_SUBTITLE = "createTitle";
        this.STD_LOGGER.info("Login", this.LOG_TITLE, "createTitle", "Start.");
        String TITLE_SEPARETOR = " - ";
        productName = this.nullToEmpty(productName);
        ipAddress = this.nullToEmpty(ipAddress);
        serialNumber = this.nullToEmpty(serialNumber);
        userSystemName = this.nullToEmpty(userSystemName);
        productName = SJcStringUty.filterEscape(productName);
        ipAddress = SJcStringUty.filterEscape(ipAddress);
        serialNumber = SJcStringUty.filterEscape(serialNumber);
        userSystemName = SJcStringUty.filterEscape(userSystemName);
        StringBuffer titleBuffer = new StringBuffer();
        titleBuffer.append(productName).append(" - ");
        titleBuffer.append("IP:").append(ipAddress).append(" - ");
        titleBuffer.append("S/N:").append(serialNumber).append(" - ");
        titleBuffer.append("D/N:").append(userSystemName);
        this.STD_LOGGER.info("Login", this.LOG_TITLE, "createTitle", "End. -return : " + titleBuffer.toString());
        return titleBuffer.toString();
    }

    private String getClientID() {
        UUID ClientID = UUID.randomUUID();
        String strClientID = ClientID.toString();
        return strClientID;
    }

    private String nullToEmpty(String str) {
        if (str == null) {
            str = DEFAULT_PARAM_SN_VIEW_HELPURL;
        }
        return str;
    }

    private String encodeString(String key, String value) {
        String LOG_SUBTITLE = "encodeString";
        String encodeValue = value;
        if (value == null || value.length() == 0) {
            return encodeValue;
        }
        if (key.equals(PARAM_SN_VIEW_USERNAME) || key.equals(PARAM_SN_VIEW_PASSWORD)) {
            try {
                encodeValue = URLEncoder.encode(value, "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                // empty catch block
            }
        }
        if (key.equals(PARAM_SN_VIEW_USERNAME)) {
            this.STD_LOGGER.info("Login", this.LOG_TITLE, "encodeString", value + " -> " + encodeValue);
        }
        return encodeValue;
    }
}

