/*
 * Decompiled with CFR 0.152.
 */
package javax.cim;

import com.ws.cim.mof.MOFStyle;
import java.io.Serializable;
import java.text.MessageFormat;
import javax.cim.CIMClass;
import javax.cim.CIMDateTime;
import javax.cim.CIMInstance;
import javax.cim.Messages;
import javax.cim.UnsignedInteger16;
import javax.cim.UnsignedInteger32;
import javax.cim.UnsignedInteger64;
import javax.cim.UnsignedInteger8;

public class CIMDataType
implements Serializable {
    private static final long serialVersionUID = -4117670221008320188L;
    private final int mType;
    private final boolean mIsArray;
    private final int mSize;
    private final String mClassName;
    public static final int INVALID = -1;
    public static final int UINT8 = 0;
    public static final int SINT8 = 1;
    public static final int UINT16 = 2;
    public static final int SINT16 = 3;
    public static final int UINT32 = 4;
    public static final int SINT32 = 5;
    public static final int UINT64 = 6;
    public static final int SINT64 = 7;
    public static final int STRING = 8;
    public static final int BOOLEAN = 9;
    public static final int REAL32 = 10;
    public static final int REAL64 = 11;
    public static final int DATETIME = 12;
    public static final int CHAR16 = 13;
    public static final int REFERENCE = 14;
    public static final int OBJECT = 15;
    public static final int NULL = 16;
    public static final int CLASS = 17;
    public static final CIMDataType UINT8_T = new CIMDataType(0);
    public static final CIMDataType UINT16_T = new CIMDataType(2);
    public static final CIMDataType UINT32_T = new CIMDataType(4);
    public static final CIMDataType UINT64_T = new CIMDataType(6);
    public static final CIMDataType SINT8_T = new CIMDataType(1);
    public static final CIMDataType SINT16_T = new CIMDataType(3);
    public static final CIMDataType SINT32_T = new CIMDataType(5);
    public static final CIMDataType SINT64_T = new CIMDataType(7);
    public static final CIMDataType STRING_T = new CIMDataType(8);
    public static final CIMDataType BOOLEAN_T = new CIMDataType(9);
    public static final CIMDataType REAL32_T = new CIMDataType(10);
    public static final CIMDataType REAL64_T = new CIMDataType(11);
    public static final CIMDataType DATETIME_T = new CIMDataType(12);
    public static final CIMDataType CHAR16_T = new CIMDataType(13);
    public static final CIMDataType CLASS_T = new CIMDataType(17);
    public static final CIMDataType OBJECT_T = new CIMDataType(15);
    public static final CIMDataType INVALID_T = new CIMDataType(-1);
    public static final CIMDataType UINT8_ARRAY_T = new CIMDataType(0, true, 0);
    public static final CIMDataType UINT16_ARRAY_T = new CIMDataType(2, true, 0);
    public static final CIMDataType UINT32_ARRAY_T = new CIMDataType(4, true, 0);
    public static final CIMDataType UINT64_ARRAY_T = new CIMDataType(6, true, 0);
    public static final CIMDataType SINT8_ARRAY_T = new CIMDataType(1, true, 0);
    public static final CIMDataType SINT16_ARRAY_T = new CIMDataType(3, true, 0);
    public static final CIMDataType SINT32_ARRAY_T = new CIMDataType(5, true, 0);
    public static final CIMDataType SINT64_ARRAY_T = new CIMDataType(7, true, 0);
    public static final CIMDataType STRING_ARRAY_T = new CIMDataType(8, true, 0);
    public static final CIMDataType BOOLEAN_ARRAY_T = new CIMDataType(9, true, 0);
    public static final CIMDataType REAL32_ARRAY_T = new CIMDataType(10, true, 0);
    public static final CIMDataType REAL64_ARRAY_T = new CIMDataType(11, true, 0);
    public static final CIMDataType DATETIME_ARRAY_T = new CIMDataType(12, true, 0);
    public static final CIMDataType CHAR16_ARRAY_T = new CIMDataType(13, true, 0);
    public static final CIMDataType OBJECT_ARRAY_T = new CIMDataType(15, true, 0);
    public static final CIMDataType CLASS_ARRAY_T = new CIMDataType(17, true, 0);

    public static final CIMDataType getDataType(Object o) {
        if (o instanceof String) {
            return STRING_T;
        }
        if (o instanceof UnsignedInteger8) {
            return UINT8_T;
        }
        if (o instanceof Byte) {
            return SINT8_T;
        }
        if (o instanceof UnsignedInteger16) {
            return UINT16_T;
        }
        if (o instanceof Short) {
            return SINT16_T;
        }
        if (o instanceof UnsignedInteger32) {
            return UINT32_T;
        }
        if (o instanceof Integer) {
            return SINT32_T;
        }
        if (o instanceof UnsignedInteger64) {
            return UINT64_T;
        }
        if (o instanceof Long) {
            return SINT64_T;
        }
        if (o instanceof Boolean) {
            return BOOLEAN_T;
        }
        if (o instanceof Float) {
            return REAL32_T;
        }
        if (o instanceof Double) {
            return REAL64_T;
        }
        if (o instanceof Character) {
            return CHAR16_T;
        }
        if (o instanceof CIMDateTime) {
            return DATETIME_T;
        }
        if (o instanceof String[]) {
            return STRING_ARRAY_T;
        }
        if (o instanceof Boolean[]) {
            return BOOLEAN_ARRAY_T;
        }
        if (o instanceof Character[]) {
            return CHAR16_ARRAY_T;
        }
        if (o instanceof UnsignedInteger8[]) {
            return UINT8_ARRAY_T;
        }
        if (o instanceof Byte[]) {
            return SINT8_ARRAY_T;
        }
        if (o instanceof UnsignedInteger16[]) {
            return UINT16_ARRAY_T;
        }
        if (o instanceof Short[]) {
            return SINT16_ARRAY_T;
        }
        if (o instanceof UnsignedInteger32[]) {
            return UINT32_ARRAY_T;
        }
        if (o instanceof Integer[]) {
            return SINT32_ARRAY_T;
        }
        if (o instanceof UnsignedInteger64[]) {
            return UINT64_ARRAY_T;
        }
        if (o instanceof Long[]) {
            return SINT64_ARRAY_T;
        }
        if (o instanceof Float[]) {
            return REAL32_ARRAY_T;
        }
        if (o instanceof Double[]) {
            return REAL64_ARRAY_T;
        }
        if (o instanceof CIMDateTime[]) {
            return DATETIME_ARRAY_T;
        }
        if (o instanceof CIMInstance) {
            return OBJECT_T;
        }
        if (o instanceof CIMClass) {
            return CLASS_T;
        }
        if (o instanceof CIMInstance[]) {
            return OBJECT_ARRAY_T;
        }
        if (o instanceof CIMClass[]) {
            return CLASS_ARRAY_T;
        }
        Object[] oArray = new Object[]{o};
        throw new IllegalArgumentException(MessageFormat.format(Messages.getString("CIMDataType.INVALID_DATATYPE"), oArray));
    }

    private CIMDataType(int type) {
        this(type, false, 0);
    }

    private CIMDataType(int type, boolean isArray, int size) {
        if (type == 14 || type > 17 || type < -1) {
            throw new IllegalArgumentException();
        }
        this.mType = type;
        this.mClassName = null;
        this.mSize = size;
        this.mIsArray = isArray;
    }

    public CIMDataType(int type, int size) {
        this(type, true, size);
        if (size <= 0) {
            throw new IllegalArgumentException(Messages.getString("CIMDataType.INVALIDSIZE"));
        }
    }

    public CIMDataType(String classname) {
        this(classname, false, 0);
    }

    protected CIMDataType(String classname, boolean isArray, int size) {
        if (classname == null || classname.length() == 0) {
            throw new IllegalArgumentException("The class name can not be null for a reference.");
        }
        this.mClassName = classname;
        this.mIsArray = isArray;
        this.mSize = size;
        this.mType = 14;
    }

    public CIMDataType(String classname, int size) {
        this(classname, true, size);
    }

    public boolean equals(Object obj) {
        if (null == obj || !(obj instanceof CIMDataType)) {
            return false;
        }
        CIMDataType ct = (CIMDataType)obj;
        if (this.mClassName == null && ct.mClassName != null) {
            return false;
        }
        if (this.mClassName != null && !this.mClassName.equals(ct.mClassName)) {
            return false;
        }
        return this.mType == ct.mType;
    }

    public String getRefClassName() {
        return this.mClassName;
    }

    public int hashCode() {
        int hash = this.mType;
        hash ^= this.mIsArray ? 0 : 1;
        hash ^= this.mSize;
        if (null != this.mClassName) {
            hash ^= this.mClassName.hashCode();
        }
        return hash;
    }

    public int getSize() {
        return this.mSize;
    }

    public int getType() {
        return this.mType;
    }

    public boolean isArray() {
        return this.mIsArray;
    }

    public String toString() {
        MOFStyle mf = new MOFStyle();
        return mf.generateMOF(this);
    }
}

