/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.client;

import java.util.Random;

public class PasswordCredential {
    private static final int MAX_SIZE = 256;
    private static final byte[] NULL_PASSWORD = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private byte[] mNullData;
    private final byte[] mPassword;
    private String mHostname;

    private PasswordCredential() {
        this.setup();
        this.mPassword = new byte[256];
        this.mHostname = null;
    }

    public PasswordCredential(char[] credential) {
        this(null == credential ? null : new String(credential));
    }

    public PasswordCredential(String credential) {
        this();
        if (null == credential) {
            throw new IllegalArgumentException();
        }
        if (null != credential && credential.trim().length() > 0) {
            this.encode(this.mPassword, credential);
        } else {
            this.resetPassword(this.mPassword);
        }
    }

    public PasswordCredential(String credential, String hostname) {
        this(credential);
        this.mHostname = hostname;
    }

    private String decode() {
        String str = "";
        byte[] kb = new byte[256];
        System.arraycopy(this.mNullData, 0, kb, 0, 256);
        int len = 256;
        boolean sw = true;
        int j = len;
        for (int i = 0; i < len; ++i) {
            int n = i;
            kb[n] = (byte)(kb[n] ^ this.mPassword[i]);
            if (!sw || kb[i] != 0) continue;
            sw = false;
            j = i;
        }
        if (j > 0) {
            str = new String(kb, 0, j);
        }
        return str;
    }

    private void encode(byte[] pswd, String password) {
        if (password != null) {
            int i;
            byte[] kb = new byte[256];
            System.arraycopy(this.mNullData, 0, kb, 0, 256);
            byte[] data = password.getBytes();
            int len = data.length;
            if (len > 256) {
                len = 256;
            }
            for (i = 0; i < len; ++i) {
                int n = i;
                kb[n] = (byte)(kb[n] ^ data[i]);
            }
            if (i < 256) {
                int n = i;
                kb[n] = (byte)(kb[n] ^ 0);
            }
            System.arraycopy(kb, 0, pswd, 0, 256);
        } else {
            this.resetPassword(pswd);
        }
    }

    public String getHostName() {
        return this.mHostname;
    }

    public char[] getUserPassword() {
        String str = this.decode();
        return str.toCharArray();
    }

    private void resetPassword(byte[] pswd) {
        System.arraycopy(NULL_PASSWORD, 0, pswd, 0, 256);
        pswd[0] = this.mNullData[0];
    }

    private void setup() {
        byte[] kb1 = new byte[256];
        byte[] kb2 = new byte[256];
        this.mNullData = new byte[256];
        long time = System.currentTimeMillis();
        Random seeder = new Random(time);
        seeder.nextBytes(kb1);
        seeder.nextBytes(kb2);
        time = System.currentTimeMillis();
        long mask = 1L;
        long test = 0L;
        for (int i = 0; i < 256; ++i) {
            test = time & mask;
            this.mNullData[i] = test > 0L ? kb1[i] : kb2[i];
            mask <<= 1;
        }
    }
}

