/*
 * Decompiled with CFR 0.152.
 */
package sanproject.serverux.data;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import sanproject.serverux.data.GetRmiException;
import sanproject.serverux.data.RmiConObjErr;

public class RmiConObjOutFile {
    private static final int NUM_BYTE_IN_LOG_LINE = 150;
    private static final byte SPACE_BYTE = 32;
    private static final byte CR_BYTE = 13;
    private static final byte LF_BYTE = 10;
    private static byte[] byteSpaceLine = new byte[150];
    final int LINE_NUM_POS = 11;
    final int LINE_NUM_BUF_SIZE = 20;
    private int nLineWrapRound;
    private RandomAccessFile rf;
    private String fileName;
    private boolean errLogFlag = true;
    private static ObjectCache excls;

    private void open() throws GetRmiException {
        try {
            this.rf = new RandomAccessFile(this.fileName, "rw");
        }
        catch (FileNotFoundException fileNotFoundException) {
            RmiConObjErr.putFileErrLog(4001, "RmiConObjOutFile: Could not open " + this.fileName, this.errLogFlag);
            throw RmiConObjErr.makeException(4001);
        }
    }

    private byte[] fillSpace(String string) throws UnsupportedEncodingException {
        byte[] byArray = string.toString().getBytes();
        byte[] byArray2 = new byte[150];
        for (int i = 0; i < byArray2.length; ++i) {
            byArray2[i] = i < byArray.length ? byArray[i] : 32;
        }
        return byArray2;
    }

    private void initFile() throws IOException {
        byte[] byArray = this.fillSpace("Last Line: 1");
        this.rf.seek(0L);
        this.rf.write(byArray, 0, byteSpaceLine.length);
        this.rf.write(13);
        this.rf.write(10);
        for (int i = 0; i < this.nLineWrapRound; ++i) {
            this.rf.write(byteSpaceLine, 0, byteSpaceLine.length);
            this.rf.write(13);
            this.rf.write(10);
        }
    }

    private void addLine(long l, int n) throws IOException {
        this.rf.seek(l);
        for (int i = 0; i < n; ++i) {
            this.rf.write(byteSpaceLine, 0, byteSpaceLine.length);
            this.rf.write(13);
            this.rf.write(10);
        }
    }

    private int readLineNum() throws IOException, GetRmiException {
        int n;
        byte[] byArray = new byte[20];
        this.rf.seek(11L);
        this.rf.read(byArray);
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (byArray[n2] != 32) {
            stringBuffer.append(String.valueOf((char)byArray[n2]));
            ++n2;
        }
        try {
            n = Integer.parseInt(stringBuffer.toString());
        }
        catch (NumberFormatException numberFormatException) {
            RmiConObjErr.putFileErrLog(1006, "RmiConObjOutFile: Format Error of Line Numver: " + this.fileName, this.errLogFlag);
            throw RmiConObjErr.makeException(1006);
        }
        return n;
    }

    private void writeLineNum(int n) throws IOException {
        byte[] byArray = Integer.toString(n).getBytes();
        byte[] byArray2 = new byte[20];
        for (int i = 0; i < byArray2.length; ++i) {
            byArray2[i] = i < byArray.length ? byArray[i] : 32;
        }
        this.rf.seek(11L);
        this.rf.write(byArray2, 0, byArray2.length);
    }

    private void init() throws GetRmiException {
        boolean bl = false;
        this.open();
        try {
            long l = this.rf.length();
            if (l == 0L) {
                this.initFile();
            } else if (l < (long)((this.nLineWrapRound + 1) * 152)) {
                int n = (int)((long)((this.nLineWrapRound + 1) * 152) - l);
                if (n % 152 != 0) {
                    RmiConObjErr.putFileErrLog(1005, "RmiConObjOutFile: File Size Error ->File size isn't a multiple of Byte of a Line : " + this.fileName, this.errLogFlag);
                    throw RmiConObjErr.makeException(1005);
                }
                this.addLine(l, n / 152);
            } else if (l > (long)((this.nLineWrapRound + 1) * 152)) {
                RmiConObjErr.putFileErrLog(1005, "RmiConObjOutFile: File Size Error ->File size is bigger than RegulationSize : " + this.fileName, this.errLogFlag);
                throw RmiConObjErr.makeException(1005);
            }
            bl = true;
        }
        catch (IOException iOException) {
            RmiConObjErr.putFileErrLog(4001, "RmiConObjOutFile: File Access Failed : " + this.fileName, this.errLogFlag);
            throw RmiConObjErr.makeException(4001);
        }
        finally {
            if (!bl) {
                this.clearAfterErr();
            }
        }
    }

    private void clearAfterErr() {
        try {
            this.clear();
        }
        catch (Exception exception) {
            RmiConObjErr.putErrLog("-", "RmiConObjOutFile: " + exception.getMessage());
        }
    }

    protected RmiConObjOutFile(String string) throws GetRmiException {
        this.fileName = string;
    }

    protected RmiConObjOutFile(String string, int n) throws GetRmiException {
        this.fileName = string;
        this.nLineWrapRound = n;
        this.init();
    }

    protected RmiConObjOutFile(String string, int n, boolean bl) throws GetRmiException {
        this.fileName = string;
        this.nLineWrapRound = n;
        this.errLogFlag = bl;
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putLog(String string) throws GetRmiException {
        boolean bl = false;
        Object object = excls.getObj(this.fileName);
        synchronized (object) {
            try {
                byte[] byArray = this.fillSpace(string);
                int n = (this.readLineNum() - 1) % this.nLineWrapRound + 2;
                this.rf.seek((n - 1) * 152);
                this.rf.write(byArray, 0, byArray.length);
                this.writeLineNum(n);
                bl = true;
            }
            catch (IOException iOException) {
                RmiConObjErr.putFileErrLog(4001, "RmiConObjOutFile: File Access Failed : " + this.fileName, this.errLogFlag);
                throw RmiConObjErr.makeException(4001);
            }
            finally {
                if (bl) {
                    this.clear();
                } else {
                    this.clearAfterErr();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putLog(String string, ArrayList arrayList) throws GetRmiException {
        boolean bl = false;
        Object object = excls.getObj(this.fileName);
        synchronized (object) {
            try {
                for (int i = 0; i < arrayList.size(); ++i) {
                    byte[] byArray = this.fillSpace(string + (String)arrayList.get(i));
                    int n = (this.readLineNum() - 1) % this.nLineWrapRound + 2;
                    this.rf.seek((n - 1) * 152);
                    this.rf.write(byArray, 0, byArray.length);
                    this.writeLineNum(n);
                }
                bl = true;
            }
            catch (IOException iOException) {
                RmiConObjErr.putFileErrLog(4001, "RmiConObjOutFile: File Access Failed : " + this.fileName, this.errLogFlag);
                throw RmiConObjErr.makeException(4001);
            }
            finally {
                if (bl) {
                    this.clear();
                } else {
                    this.clearAfterErr();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putOneLine(String string) throws GetRmiException {
        Object object = excls.getObj(this.fileName);
        synchronized (object) {
            this.open();
            try {
                this.rf.writeBytes(string);
                this.rf.write(13);
                this.rf.write(10);
            }
            catch (Exception exception) {
                RmiConObjErr.putFileErrLog(4001, "RmiConObjOutFile: File Access Failed : " + this.fileName, this.errLogFlag);
                throw RmiConObjErr.makeException(4001);
            }
            finally {
                this.clear();
            }
        }
    }

    protected void clear() throws GetRmiException {
        try {
            this.rf.close();
        }
        catch (IOException iOException) {
            RmiConObjErr.putFileErrLog(4001, "RmiConObjOutFile: close unsuccessuful: " + this.fileName, this.errLogFlag);
            throw RmiConObjErr.makeException(4001);
        }
    }

    static {
        for (int i = 0; i < 150; ++i) {
            RmiConObjOutFile.byteSpaceLine[i] = 32;
        }
        excls = new ObjectCache(128);
    }

    static class ObjectCache {
        Map cache;

        public ObjectCache(int n) {
            this.cache = new HashMap(n);
        }

        public synchronized Object getObj(String string) {
            String string2 = (String)this.cache.get(string);
            if (string2 == null) {
                string2 = string;
                this.cache.put(string, string2);
            }
            return string2;
        }
    }
}

