/*
 * Decompiled with CFR 0.152.
 */
package sanproject.serverux.dataimpl;

import java.io.ByteArrayInputStream;
import java.nio.ByteOrder;
import sanproject.serverux.dataimpl.SanRmiByteArrayInterface;

public class SanRmiByteArrayInputStream
extends ByteArrayInputStream
implements SanRmiByteArrayInterface {
    protected ByteOrder _ByteOrder;

    public SanRmiByteArrayInputStream(byte[] byArray) {
        super(byArray);
        this.setLittleEndian();
    }

    public void setLittleEndian() {
        this._ByteOrder = ByteOrder.LITTLE_ENDIAN;
    }

    public void setBigEndian() {
        this._ByteOrder = ByteOrder.BIG_ENDIAN;
    }

    public ByteOrder nativeOrder() {
        return this._ByteOrder;
    }

    public byte getUCHARtoByte() {
        int n = this.read();
        byte by = n != -1 ? (byte)(n & 0xFF) : (byte)0;
        return by;
    }

    public short getUCHARtoShort() {
        int n = this.read();
        short s = n != -1 ? (short)n : (short)0;
        return s;
    }

    public int getUCHARtoInt() {
        int n = this.read();
        if (n == -1) {
            n = 0;
        }
        return n;
    }

    public int getUSHORTtoInt() {
        int n;
        int n2 = 0;
        int[] nArray = new int[2];
        for (n = 0; n < 2; ++n) {
            nArray[n] = this.read();
            if (nArray[n] != -1) continue;
            n2 = 0;
            return 0;
        }
        if (this._ByteOrder == ByteOrder.LITTLE_ENDIAN) {
            for (n = 0; n < 2; ++n) {
                n2 |= nArray[n] << 8 * n;
            }
        } else {
            for (n = 0; n < 2; ++n) {
                n2 |= nArray[2 - (n + 1)] << 8 * n;
            }
        }
        return n2;
    }

    public int getINTtoInt() {
        int n;
        int n2 = 0;
        int[] nArray = new int[4];
        for (n = 0; n < 4; ++n) {
            nArray[n] = this.read();
            if (nArray[n] != -1) continue;
            return 0;
        }
        if (this._ByteOrder == ByteOrder.LITTLE_ENDIAN) {
            for (n = 0; n < 4; ++n) {
                n2 |= nArray[n] << 8 * n;
            }
        } else {
            for (n = 0; n < 4; ++n) {
                n2 |= nArray[4 - (n + 1)] << 8 * n;
            }
        }
        return n2;
    }

    public long getULONGtoLong() {
        int n;
        long l = 0L;
        int[] nArray = new int[4];
        for (n = 0; n < 4; ++n) {
            nArray[n] = this.read();
            if (nArray[n] != -1) continue;
            return 0L;
        }
        if (this._ByteOrder == ByteOrder.LITTLE_ENDIAN) {
            for (n = 0; n < 4; ++n) {
                l |= (long)nArray[n] << 8 * n;
            }
        } else {
            for (n = 0; n < 4; ++n) {
                l |= (long)nArray[4 - (n + 1)] << 8 * n;
            }
        }
        return l;
    }

    public long getINT64toLong() {
        int n;
        long l = 0L;
        int[] nArray = new int[8];
        for (n = 0; n < 8; ++n) {
            nArray[n] = this.read();
            if (nArray[n] != -1) continue;
            return 0L;
        }
        if (this._ByteOrder == ByteOrder.LITTLE_ENDIAN) {
            for (n = 0; n < 8; ++n) {
                l |= (long)nArray[n] << 8 * n;
            }
        } else {
            for (n = 0; n < 8; ++n) {
                l |= (long)nArray[8 - (n + 1)] << 8 * n;
            }
        }
        return l;
    }

    public String getByteArraytoString(int n) {
        int n2;
        byte[] byArray = new byte[n];
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.read();
            if (nArray[i] != -1) continue;
            return new String();
        }
        for (n2 = 0; n2 < n - 1 && nArray[n2] != 0; ++n2) {
            byArray[n2] = (byte)(nArray[n2] & 0xFF);
        }
        return new String(byArray, 0, n2);
    }
}

