/*
 * Decompiled with CFR 0.152.
 */
package sanproject.trlog.utility.com;

import java.io.File;
import sanproject.trlog.utility.com.TRLogComUty;
import sanproject.trlog.utility.com.TRLogConst;

public class TRPathUty {
    private String basePath = this.getBasePath();
    private String sNum = "";

    private String getBasePath() throws Exception {
        String wk = null;
        wk = this.getCanonicalPath(System.getProperty("SN_BasePath"));
        if (wk != null) {
            if (!this.isSNBase(wk)) {
                wk = this.getCanonicalPath(System.getProperty("Cmn_BasePath"));
                if (!this.isCmnBase(wk)) {
                    this.throwBasePathError();
                }
            } else {
                this.sNum = TRPathUty.getSerialNumber(wk);
            }
        } else {
            wk = this.getCanonicalPath(System.getProperty("Cmn_BasePath"));
            if (!this.isCmnBase(wk)) {
                this.throwBasePathError();
            }
        }
        if (wk == null) {
            this.throwBasePathError();
        }
        wk = TRPathUty.appendSeparator(wk);
        return wk;
    }

    private String getCanonicalPath(String path) throws Exception {
        try {
            path = new File(path).getCanonicalPath();
        }
        catch (Exception e) {
            TRLogComUty.outException(e);
        }
        return path;
    }

    private void throwBasePathError() throws Exception {
        Exception e = new Exception("Java enviromental parameter error.");
        TRLogComUty.outException(e);
        throw e;
    }

    private boolean isSNBase(String path) {
        return path.toUpperCase().indexOf("DKC200") != -1;
    }

    private boolean isSNBase() {
        return this.isSNBase(this.basePath);
    }

    private boolean isCmnBase(String path) {
        return path.toUpperCase().indexOf("SUPERVISOR") != -1;
    }

    private static String getSerialNumber(String dkcpath) {
        String num = "";
        dkcpath = TRPathUty.getMoveUpPath(dkcpath, 1);
        File dkcDirectory = new File(dkcpath);
        if ((dkcpath = dkcDirectory.getName()).length() > 6) {
            num = dkcpath.substring(6);
        }
        return num;
    }

    public String getLockFilePath() {
        String lockFilePath = null;
        if (this.isSNBase()) {
            lockFilePath = TRPathUty.getMoveUpPath(this.basePath, 2);
            lockFilePath = lockFilePath + TRLogConst.DKC_LOCK_FILE_DIR + TRLogConst.PATH_SEPARATOR + "system" + "_" + this.sNum + ".lck";
        } else {
            lockFilePath = this.basePath + TRLogConst.SUPER_LOCK_FILE_DIR + TRLogConst.PATH_SEPARATOR + "system" + ".lck";
        }
        return lockFilePath;
    }

    public String getJavaexePath() {
        String path = null;
        path = this.isSNBase() ? TRPathUty.getMoveUpPath(this.basePath, 3) : TRPathUty.getMoveUpPath(this.basePath, 2);
        return path + TRLogConst.JAVA_HOME;
    }

    public String getClassPath() {
        if (this.isSNBase()) {
            return this.basePath + TRLogConst.DKC_JAR;
        }
        return this.basePath + TRLogConst.SUPER_JAR;
    }

    public String getPropertyFilePath() {
        String propertyFilePath = null;
        propertyFilePath = this.isSNBase() ? this.basePath + TRLogConst.PATH_SEPARATOR + TRLogConst.DKC_CNF_FILE_DIR + TRLogConst.PATH_SEPARATOR + "TRLog.properties" : this.basePath + TRLogConst.PATH_SEPARATOR + TRLogConst.SUPER_CNF_FILE_DIR + TRLogConst.PATH_SEPARATOR + "TRLog.properties";
        return propertyFilePath;
    }

    public String getLogFilePath() {
        String logFilePath = null;
        if (this.isSNBase()) {
            logFilePath = TRPathUty.getMoveUpPath(this.basePath, 2);
            logFilePath = logFilePath + TRLogConst.DKC_LOG_FILE_DIR + TRLogConst.PATH_SEPARATOR + "system" + "_" + this.sNum + "_" + "%g" + ".log";
        } else {
            logFilePath = this.basePath + TRLogConst.SUPER_LOG_FILE_DIR + TRLogConst.PATH_SEPARATOR + "system" + "_" + "%g" + ".log";
        }
        return logFilePath;
    }

    private static String getMoveUpPath(String path, int mlevel) {
        String curdir = path;
        try {
            for (int i = 0; i < mlevel; ++i) {
                File currentDirectory = new File(curdir);
                if ((curdir = currentDirectory.getParent()) != null) continue;
                curdir = "";
                break;
            }
        }
        catch (Exception ex) {
            curdir = "";
        }
        if (!"".equals(curdir)) {
            curdir = TRPathUty.appendSeparator(curdir);
        }
        return curdir;
    }

    private static String appendSeparator(String path) {
        if (path == null || "".equals(path)) {
            path = TRLogConst.PATH_SEPARATOR;
        } else if (!path.endsWith(TRLogConst.PATH_SEPARATOR)) {
            path = path + TRLogConst.PATH_SEPARATOR;
        }
        return path;
    }

    public static void checkDirExist(File dir) {
        if (!dir.exists()) {
            dir.mkdirs();
        }
    }
}

