/*
 * Decompiled with CFR 0.152.
 */
package com.ws.cim.codegen;

import com.ws.cim.CIMMappingBase;
import com.ws.cim.codegen.CreateJar;
import com.ws.cim.codegen.JCompiler;
import com.ws.cim.codegen.jsr48.CodeGeneratorUtils;
import com.ws.cim.codegen.jsr48.client.ClientCodeGenerator;
import com.ws.cim.codegen.jsr48.constants.ConstantsCodeGenerator;
import com.ws.cim.codegen.jsr48.provider.BaseProviderGenerator;
import com.ws.cim.codegen.jsr48.provider.ProviderCodeGenerator;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import javax.cim.CIMClass;
import javax.cim.CIMElement;
import javax.cim.CIMInstance;

public class JavaMapping
extends CIMMappingBase {
    private static final String FORMAT_CLIENT = "client";
    private static final String FORMAT_PROVIDER = "provider";
    private static final String COMPANY = "company";
    private static final String JAR_NAME = "jar";
    private static final String TEMPLATES = "templates";
    private static final String SCHEMA = "schema";
    private static final String CLASS = "class";
    private static final String PACKAGE = "package";
    private static final String COPYWRITE = "copywrite";
    private String mFormat;
    private String mOutdir;
    private HashMap<String, String> mCustomPropMap;
    private boolean mQuiet;
    private Properties mProperties;

    private void addPackage2Path(String packageName, StringBuilder dirPath) throws NullPointerException {
        if (null == packageName || null == dirPath) {
            throw new NullPointerException("Parameters can not be null");
        }
        String[] packageArray = packageName.split("\\.");
        if (null != packageArray) {
            if (File.separatorChar != dirPath.charAt(dirPath.length() - 1)) {
                dirPath.append(File.separatorChar);
            }
            for (String str : packageArray) {
                dirPath.append(str).append(File.separator);
            }
        }
    }

    @Override
    public void close() throws Exception {
        String[] remove = new String[]{"Version_Number", "store", "Logfile.", "Snapshot."};
        String jar = this.mCustomPropMap.get(JAR_NAME);
        if (null != jar) {
            this.makeJarFile(this.mOutdir, jar);
        }
        if (this.mFormat.equalsIgnoreCase(FORMAT_PROVIDER)) {
            String srcDir = this.mOutdir + File.separatorChar + "src";
            String binDir = this.mOutdir + File.separatorChar + "bin";
            this.compileGeneratedSources(srcDir, binDir);
            String libDir = this.mOutdir + File.separator + "lib";
            File lib = new File(libDir);
            if (!lib.exists()) {
                lib.mkdir();
            }
            if (lib.exists() && lib.isDirectory()) {
                System.out.println(this.mProperties.getProperty("CREATING_JARS"));
                String jarFile = libDir + File.separator + ProviderCodeGenerator.getGeneratedJarFileName();
                CreateJar cj = new CreateJar(jarFile, binDir, "\\.class", null);
                cj.jarFiles();
                cj = new CreateJar(jarFile.replaceAll("\\.jar", "Src.jar"), srcDir, "\\.java", null);
                cj.jarFiles();
                System.out.println(this.mProperties.getProperty("REMOVING_GENERATED_FILES"));
                this.deleteDirectoryAndFiles(binDir);
                StringBuilder tDir = new StringBuilder(srcDir);
                this.addPackage2Path(this.mCustomPropMap.get(PACKAGE), tDir);
                String pkgDir = tDir.toString();
                this.deleteDirectoryAndFiles(ProviderCodeGenerator.getAbstractImplDirName(pkgDir));
                this.deleteDirectoryAndFiles(ProviderCodeGenerator.getDataDirName(pkgDir));
                this.deleteDirectoryAndFiles(ProviderCodeGenerator.getProviderDirName(pkgDir));
                this.deleteDirectoryAndFiles(ProviderCodeGenerator.getSchemaDirName(pkgDir));
                this.deleteDirectoryAndFiles(ProviderCodeGenerator.getCommonDirName(pkgDir));
            } else {
                System.err.println("could not generate jar file because a required directory is missing: " + libDir);
            }
        }
        this.removeTempFiles(this.mQuiet, this.mOutdir, remove);
    }

    private void compileGeneratedSources(String srcDir, String binDir) {
        String sdkDir = System.getProperty("user.dir");
        StringBuilder classPath = new StringBuilder(sdkDir);
        classPath.append(File.separatorChar);
        classPath.append("jserver.jar");
        classPath.append(File.pathSeparatorChar);
        classPath.append(sdkDir);
        classPath.append(File.separatorChar);
        classPath.append("..");
        classPath.append(File.separatorChar);
        classPath.append("lib");
        classPath.append(File.separatorChar);
        classPath.append("jwbemserver.jar");
        classPath.append(File.pathSeparatorChar);
        classPath.append(sdkDir);
        classPath.append(File.separatorChar);
        classPath.append("..");
        classPath.append(File.separatorChar);
        classPath.append("lib");
        classPath.append(File.separatorChar);
        classPath.append("wbem.jar");
        classPath.append(File.pathSeparatorChar);
        classPath.append(sdkDir);
        classPath.append(File.separatorChar);
        classPath.append("..");
        classPath.append(File.separatorChar);
        classPath.append("lib");
        classPath.append(File.separatorChar);
        classPath.append("ws_lib.jar");
        ArrayList<String> cmdLine = new ArrayList<String>();
        cmdLine.add("-classpath");
        cmdLine.add(classPath.toString());
        cmdLine.add("-sourcepath");
        cmdLine.add(srcDir);
        cmdLine.add("-d");
        cmdLine.add(binDir);
        JCompiler jc = new JCompiler(cmdLine.toArray(new String[cmdLine.size()]), "implementation");
        try {
            jc.compile();
        }
        catch (IOException e) {
            System.err.println("Unable to compile generated sources!");
            e.printStackTrace();
        }
    }

    private void deleteDirectoryAndFiles(String dir2Delete) {
        Path directory = Paths.get(dir2Delete, new String[0]);
        try {
            Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            System.err.println("Unable to delete directory " + dir2Delete);
            e.printStackTrace();
        }
    }

    @Override
    public String getCustomPropertyDescription(String cpName) {
        return this.mProperties.getProperty(cpName);
    }

    @Override
    public String[] getCustomPropertyNames(String format) {
        if (FORMAT_CLIENT.equalsIgnoreCase(format)) {
            return new String[]{CLASS, COMPANY, JAR_NAME, "q", SCHEMA, PACKAGE, COPYWRITE};
        }
        if (FORMAT_PROVIDER.equalsIgnoreCase(format)) {
            return new String[]{CLASS, COMPANY, JAR_NAME, "q", SCHEMA, TEMPLATES, PACKAGE, COPYWRITE};
        }
        return null;
    }

    @Override
    public void initialize(String outdir) throws Exception {
        this.mProperties = new Properties();
        this.mProperties.load(this.getClass().getResourceAsStream("JavaMapping.properties"));
        this.mQuiet = false;
        this.mFormat = FORMAT_CLIENT;
        this.mOutdir = null == outdir || 0 == outdir.length() || outdir.equals(".") ? System.getProperty("user.dir") : outdir;
        this.mCustomPropMap = new HashMap();
    }

    private void makeJarFile(String pOutDir, String pJarName) {
        File dir = new File(pOutDir);
        try {
            Runtime runtime = Runtime.getRuntime();
            String[] mkdir = new String[]{"cmd", "/c mkdir bin"};
            Process binDirProcess = runtime.exec(mkdir, null, dir);
            binDirProcess.waitFor();
            String[] sourceFiles = new String[]{"cmd", "/c for /f \"tokens=*\" %I in (\"*.java\") do dir /s/b > sourceList.txt %~spI*.java"};
            Process makeSourceList = runtime.exec(sourceFiles, null, dir);
            makeSourceList.waitFor();
            System.out.println("Compiling Generated Java Files...");
            String[] compileJava = new String[]{"javac", "-J-mx512m", "-d", "./bin", "@sourceList.txt"};
            String[] envp = new String[]{"CLASSPATH=.;c:\\progra~1\\ws\\lib\\wbem.jar;c:\\progra~1\\ws\\lib\\wbem_cimxml.jar;c:\\progra~1\\ws\\lib\\wbem_wsman.jar;c:\\progra~1\\ws\\lib\\ws_lib.jar"};
            Process compile = runtime.exec(compileJava, envp, dir);
            compile.waitFor();
            String[] delExamples = new String[]{"cmd", "/c del /s *Example*.class"};
            Process deleteExamples = runtime.exec(delExamples, null, dir);
            deleteExamples.waitFor();
            System.out.println("Generating Jar File...");
            String[] makeJar = new String[]{JAR_NAME, "cf", pJarName, "*"};
            dir = new File(pOutDir + "\\bin");
            Process createJar = runtime.exec(makeJar, null, dir);
            createJar.waitFor();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void produceMappedElement(CIMElement element) throws Exception {
        if (element instanceof CIMClass) {
            String companyName = this.mCustomPropMap.get(COMPANY);
            String packageName = this.mCustomPropMap.get(PACKAGE);
            if (null == packageName || packageName.equals("")) {
                throw new Exception(this.mProperties.getProperty("ERROR_PACKAGE_NAME_REQUIRED"));
            }
            if (null == companyName || companyName.equals("")) {
                throw new Exception(this.mProperties.getProperty("ERROR_COMPANY_NAME_REQUIRED"));
            }
            StringBuilder dirPath = new StringBuilder(BaseProviderGenerator.getCommonSRCName(this.mOutdir));
            dirPath.append(File.separator);
            this.addPackage2Path(packageName, dirPath);
            ArrayList<String> selectedSchema = CodeGeneratorUtils.parseSelectedItems(this.mCustomPropMap.get(SCHEMA), ":");
            ArrayList<String> selectedClasses = CodeGeneratorUtils.parseSelectedItems(this.mCustomPropMap.get(CLASS), ":");
            ConstantsCodeGenerator constants = new ConstantsCodeGenerator((CIMClass)element, dirPath.toString(), companyName, null, packageName.toLowerCase());
            constants.generateCode();
            if (this.mFormat.equalsIgnoreCase(FORMAT_CLIENT)) {
                ClientCodeGenerator client = new ClientCodeGenerator((CIMClass)element, dirPath.toString(), packageName.toLowerCase());
                client.generateCode();
            } else if (this.mFormat.equalsIgnoreCase(FORMAT_PROVIDER)) {
                ProviderCodeGenerator provider = new ProviderCodeGenerator((CIMClass)element, dirPath.toString(), this.mCustomPropMap, selectedSchema, selectedClasses);
                provider.generateCode();
            }
        }
    }

    @Override
    public void produceMappedInstance(CIMInstance instance) throws Exception {
    }

    @Override
    public void setFormat(String format) {
        if (format.equalsIgnoreCase(FORMAT_CLIENT)) {
            this.mFormat = FORMAT_CLIENT;
        } else if (format.equalsIgnoreCase(FORMAT_PROVIDER)) {
            this.mFormat = FORMAT_PROVIDER;
        } else {
            throw new IllegalArgumentException(this.mProperties.getProperty("ERROR_INVALID_FORMAT"));
        }
    }

    @Override
    public void setProperty(String name, String value) {
        this.mCustomPropMap.put(name, value);
    }
}

