/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.sanproject.data;

import com.hitachi.sanproject.data.SanAttrs;
import com.hitachi.sanproject.data.SanClass;
import com.hitachi.sanproject.data.SanClassImpl;
import com.hitachi.sanproject.data.SanDataErrorCode;
import com.hitachi.sanproject.data.SanDataException;
import com.hitachi.sanproject.data.SanDataNode;
import com.hitachi.sanproject.data.SanList;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SanObject
implements SanClass,
SanDataNode,
Serializable {
    private static final long serialVersionUID = -1229287801166257091L;
    protected SanClassImpl clazz;
    protected SanDataNode parentDataNode;
    protected ArrayList<Object> valueList;

    protected SanObject() {
    }

    protected SanObject(SanDataNode sanDataNode, SanClassImpl sanClassImpl) {
        this.clazz = sanClassImpl;
        this.parentDataNode = sanDataNode;
        this.valueList = new ArrayList(sanClassImpl.numberOfMembers());
        for (int i = 0; i < sanClassImpl.numberOfMembers(); ++i) {
            this.valueList.add(null);
        }
        this.valueList.trimToSize();
    }

    protected void copyTo(SanObject sanObject) {
        sanObject.clazz = this.clazz;
        if (this.valueList == null) {
            sanObject.valueList = null;
        } else {
            sanObject.valueList = new ArrayList<Object>(this.valueList);
            for (int i = 0; i < this.valueList.size(); ++i) {
                Object object = this.valueList.get(i);
                if (object == null) continue;
                if (object instanceof SanObject) {
                    sanObject.valueList.set(i, ((SanObject)object).clone(sanObject));
                    continue;
                }
                if (object instanceof SanList) {
                    sanObject.valueList.set(i, ((SanList)object).clone(sanObject));
                    continue;
                }
                if (object instanceof Integer || object instanceof Long || object instanceof Float || object instanceof Double || object instanceof Boolean || object instanceof String) continue;
                if (object instanceof BitSet) {
                    sanObject.valueList.set(i, ((BitSet)object).clone());
                    continue;
                }
                if (object instanceof int[]) {
                    sanObject.valueList.set(i, ((int[])object).clone());
                    continue;
                }
                if (!(object instanceof byte[])) continue;
                sanObject.valueList.set(i, ((byte[])object).clone());
            }
        }
    }

    protected SanObject clone(SanDataNode sanDataNode) {
        SanObject sanObject = new SanObject();
        sanObject.parentDataNode = sanDataNode;
        this.copyTo(sanObject);
        return sanObject;
    }

    @Override
    public int index() {
        return this.clazz.index();
    }

    @Override
    public String key() {
        return this.clazz.key();
    }

    @Override
    public String type() {
        return this.clazz.type();
    }

    @Override
    public SanAttrs attrs() {
        return this.clazz.attrs();
    }

    @Override
    public Object attr(String string) throws SanDataException {
        return this.clazz.attr(string);
    }

    @Override
    public SanClass parentClass() {
        return this.clazz.parentClass();
    }

    @Override
    public String path() {
        return this.clazz.path();
    }

    @Override
    public int memberIndex(String string) throws SanDataException {
        return this.clazz.memberIndex(string);
    }

    @Override
    public SanClass memberClass(int n) {
        return this.clazz.memberClass(n);
    }

    @Override
    public SanClass memberClass(String string) throws SanDataException {
        return this.clazz.memberClass(string);
    }

    @Override
    public int numberOfMembers() {
        return this.clazz.numberOfMembers();
    }

    @Override
    public List<String> memberKeyList() {
        return this.clazz.memberKeyList();
    }

    @Override
    public List<SanClass> memberClassList() {
        return this.clazz.memberClassList();
    }

    protected void optimizeMemoryUsage() {
        for (Object object : this.valueList) {
            if (object instanceof SanObject) {
                ((SanObject)object).optimizeMemoryUsage();
                continue;
            }
            if (!(object instanceof SanList)) continue;
            ((SanList)object).optimizeMemoryUsage();
        }
    }

    public int hashCode() {
        int n = 1;
        for (Object object : this.valueList) {
            if (object == null) {
                n = 31 * n + 0;
                continue;
            }
            if (object instanceof int[]) {
                n = 31 * n + Arrays.hashCode((int[])object);
                continue;
            }
            if (object instanceof byte[]) {
                n = 31 * n + Arrays.hashCode((byte[])object);
                continue;
            }
            n = 31 * n + object.hashCode();
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SanObject)) {
            return false;
        }
        SanObject sanObject = (SanObject)object;
        if (!this.clazz.equals(sanObject.clazz)) {
            return false;
        }
        return this.equalsValuesOf(sanObject);
    }

    protected boolean equalsValuesOf(SanObject sanObject) {
        if (sanObject == this) {
            return true;
        }
        if (!(sanObject instanceof SanObject)) {
            return false;
        }
        ListIterator<Object> listIterator = this.valueList.listIterator();
        ListIterator<Object> listIterator2 = sanObject.valueList.listIterator();
        while (listIterator.hasNext() && listIterator2.hasNext()) {
            Object object = listIterator.next();
            Object object2 = listIterator2.next();
            if (object == null) {
                if (object2 == null) continue;
                return false;
            }
            if (object2 == null) {
                return false;
            }
            if (!object.getClass().equals(object2.getClass())) {
                return false;
            }
            if (object instanceof int[]) {
                if (Arrays.equals((int[])object, (int[])object2)) continue;
                return false;
            }
            if (object instanceof byte[]) {
                if (Arrays.equals((byte[])object, (byte[])object2)) continue;
                return false;
            }
            if (object instanceof SanObject) {
                return ((SanObject)object).equalsValuesOf((SanObject)object2);
            }
            if (object.equals(object2)) continue;
            return false;
        }
        return !listIterator.hasNext() && !listIterator2.hasNext();
    }

    @Override
    public SanDataNode parentDataNode() {
        return this.parentDataNode;
    }

    protected void connectParentObjNode(ArrayList<String> arrayList) {
        SanDataNode sanDataNode = this.parentDataNode();
        if (sanDataNode == null) {
            arrayList.add(this.key());
        } else if (sanDataNode instanceof SanObject) {
            arrayList.add(this.key());
            ((SanObject)sanDataNode).connectParentObjNode(arrayList);
        } else if (sanDataNode instanceof SanList) {
            SanList sanList = (SanList)sanDataNode;
            arrayList.add(String.format("%s[%d]", this.key(), sanList.indexOf(this)));
            sanList.connectParentObjNode(arrayList);
        }
    }

    @Override
    public String objPath() {
        ArrayList<String> arrayList = new ArrayList<String>();
        this.connectParentObjNode(arrayList);
        StringBuilder stringBuilder = null;
        ListIterator<String> listIterator = arrayList.listIterator(arrayList.size());
        while (listIterator.hasPrevious()) {
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder(256);
            } else {
                stringBuilder.append(".");
            }
            String string = listIterator.previous();
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public SanObject getObj(String string) throws SanDataException {
        int n = this.memberIndex(string);
        if (!this.memberClass(n).type().equals("Object")) {
            throw SanDataErrorCode.newException(SanDataErrorCode.INVALID_TYPE, String.format("key=%s.%s, type=%s", this.objPath(), string, "Object"));
        }
        return (SanObject)this.valueList.get(n);
    }

    public SanObject newObj(String string) throws SanDataException {
        int n = this.memberIndex(string);
        if (!this.memberClass(n).type().equals("Object")) {
            throw SanDataErrorCode.newException(SanDataErrorCode.INVALID_TYPE, String.format("key=%s.%s, type=%s", this.objPath(), string, "Object"));
        }
        SanObject sanObject = new SanObject(this, (SanClassImpl)this.memberClass(n));
        this.valueList.set(n, sanObject);
        return sanObject;
    }

    public SanObject deleteObj(String string) throws SanDataException {
        int n = this.memberIndex(string);
        if (!this.memberClass(n).type().equals("Object")) {
            throw SanDataErrorCode.newException(SanDataErrorCode.INVALID_TYPE, String.format("key=%s.%s, type=%s", this.objPath(), string, "Object"));
        }
        return this.valueList.set(n, null);
    }

    public SanList getList(String string) throws SanDataException {
        int n = this.memberIndex(string);
        if (!this.memberClass(n).type().equals("List")) {
            throw SanDataErrorCode.newException(SanDataErrorCode.INVALID_TYPE, String.format("key=%s.%s, type=%s", this.objPath(), string, "List"));
        }
        return (SanList)this.valueList.get(n);
    }

    public SanList newList(String string) throws SanDataException {
        int n = this.memberIndex(string);
        if (!this.memberClass(n).type().equals("List")) {
            throw SanDataErrorCode.newException(SanDataErrorCode.INVALID_TYPE, String.format("key=%s.%s, type=%s", this.objPath(), string, "List"));
        }
        SanList sanList = new SanList(this, (SanClassImpl)this.memberClass(n));
        this.valueList.set(n, sanList);
        return sanList;
    }

    public SanList deleteList(String string) throws SanDataException {
        int n = this.memberIndex(string);
        if (!this.memberClass(n).type().equals("List")) {
            throw SanDataErrorCode.newException(SanDataErrorCode.INVALID_TYPE, String.format("key=%s.%s, type=%s", this.objPath(), string, "List"));
        }
        return this.valueList.set(n, null);
    }

    public Object getMember(String string) throws SanDataException {
        return this.valueList.get(this.memberIndex(string));
    }

    public Object putMember(String string, Object object) throws SanDataException {
        int n = this.memberIndex(string);
        String string2 = this.memberClass(n).type();
        if (string2.equals("Object") || string2.equals("List")) {
            throw SanDataErrorCode.newException(SanDataErrorCode.UNSUPPORTED_TYPE, String.format("putMember{key=%s.%s, type=%s}", this.objPath(), string, string2));
        }
        String string3 = SanObject.parseValueType(object);
        if (string3 != null && !string2.equals(string3)) {
            throw SanDataErrorCode.newException(SanDataErrorCode.INVALID_TYPE, String.format("key=%s.%s, type=%s", this.objPath(), string, string3));
        }
        return this.putValue(string, object);
    }

    public String getMemberToString(String string) throws SanDataException {
        int n = this.memberIndex(string);
        String string2 = this.memberClass(n).type();
        if (string2.equals("Object") || string2.equals("List")) {
            throw SanDataErrorCode.newException(SanDataErrorCode.UNSUPPORTED_TYPE, String.format("getMemberToString{key=%s.%s, type=%s}", this.objPath(), string, string2));
        }
        Object object = this.valueList.get(n);
        return SanObject.valueToString(object);
    }

    public String parseAndPutMember(String string, String string2) throws SanDataException {
        int n = this.memberIndex(string);
        String string3 = this.memberClass(n).type();
        if (string3.equals("Object") || string3.equals("List")) {
            throw SanDataErrorCode.newException(SanDataErrorCode.UNSUPPORTED_TYPE, String.format("parseAndPutMember{key=%s.%s, type=%s}", this.objPath(), string, string3));
        }
        Object object = SanObject.parseValue(string3, string2);
        if (object == null) {
            throw SanDataErrorCode.newException(SanDataErrorCode.INVALID_VALUE_FORMAT, String.format("parseAndPutMember{key=%s.%s, value=%s}", this.objPath(), string, string2));
        }
        return SanObject.valueToString(this.putValue(string, object));
    }

    public int getInt(String string) throws SanDataException {
        int n = this.memberIndex(string);
        if (!this.memberClass(n).type().equals("int")) {
            throw SanDataErrorCode.newException(SanDataErrorCode.INVALID_TYPE, String.format("key=%s.%s, type=%s", this.objPath(), string, "int"));
        }
        Object object = this.valueList.get(n);
        if (object == null) {
            return 0;
        }
        return (Integer)object;
    }

    public int putInt(String string, int n) throws SanDataException {
        Object object;
        int n2;
        int n3 = this.memberIndex(string);
        SanClass sanClass = this.memberClass(n3);
        if (!sanClass.type().equals("int")) {
            throw SanDataErrorCode.newException(SanDataErrorCode.INVALID_TYPE, String.format("key=%s.%s, type=%s", this.objPath(), string, "int"));
        }
        int[] nArray = (int[])sanClass.attrs().get(2);
        if (nArray != null) {
            n2 = 0;
            for (int n4 : nArray) {
                if (n != n4) continue;
                n2 = 1;
                break;
            }
            if (n2 == 0) {
                throw SanDataErrorCode.newException(SanDataErrorCode.INVALID_VALUE, String.format("key=%s.%s, value=%s", this.objPath(), string, n));
            }
        } else {
            n2 = Integer.MAX_VALUE;
            int n5 = Integer.MIN_VALUE;
            Integer n6 = (Integer)sanClass.attrs().get(0);
            Integer n7 = (Integer)sanClass.attrs().get(1);
            if (n6 != null) {
                n2 = n6;
            }
            if (n7 != null) {
                n5 = n7;
            }
            if (n > n2 || n < n5) {
                throw SanDataErrorCode.newException(SanDataErrorCode.INVALID_VALUE, String.format("key=%s.%s, value=%s", this.objPath(), string, n));
            }
        }
        if ((object = this.valueList.set(n3, n)) == null) {
            return 0;
        }
        return (Integer)object;
    }

    public long getLong(String string) throws SanDataException {
        int n = this.memberIndex(string);
        if (!this.memberClass(n).type().equals("long")) {
            throw SanDataErrorCode.newException(SanDataErrorCode.INVALID_TYPE, String.format("key=%s.%s, type=%s", this.objPath(), string, "long"));
        }
        Object object = this.valueList.get(n);
        if (object == null) {
            return 0L;
        }
        return (Long)object;
    }

    public long putLong(String string, long l) throws SanDataException {
        int n = this.memberIndex(string);
        SanClass sanClass = this.memberClass(n);
        if (!sanClass.type().equals("long")) {
            throw SanDataErrorCode.newException(SanDataErrorCode.INVALID_TYPE, String.format("key=%s.%s, type=%s", this.objPath(), string, "long"));
        }
        long l2 = Long.MAX_VALUE;
        long l3 = Long.MIN_VALUE;
        Long l4 = (Long)sanClass.attrs().get(0);
        Long l5 = (Long)sanClass.attrs().get(1);
        if (l4 != null) {
            l2 = l4;
        }
        if (l5 != null) {
            l3 = l5;
        }
        if (l > l2 || l < l3) {
            throw SanDataErrorCode.newException(SanDataErrorCode.INVALID_VALUE, String.format("key=%s.%s, value=%s", this.objPath(), string, l));
        }
        Object object = this.valueList.set(n, l);
        if (object == null) {
            return 0L;
        }
        return (Long)object;
    }

    public float getFloat(String string) throws SanDataException {
        int n = this.memberIndex(string);
        if (!this.memberClass(n).type().equals("float")) {
            throw SanDataErrorCode.newException(SanDataErrorCode.INVALID_TYPE, String.format("key=%s.%s, type=%s", this.objPath(), string, "float"));
        }
        Object object = this.valueList.get(n);
        if (object == null) {
            return 0.0f;
        }
        return ((Float)object).floatValue();
    }

    public float putFloat(String string, float f) throws SanDataException {
        int n = this.memberIndex(string);
        SanClass sanClass = this.memberClass(n);
        if (!sanClass.type().equals("float")) {
            throw SanDataErrorCode.newException(SanDataErrorCode.INVALID_TYPE, String.format("key=%s.%s, type=%s", this.objPath(), string, "float"));
        }
        float f2 = Float.MAX_VALUE;
        float f3 = Float.MIN_VALUE;
        Float f4 = (Float)sanClass.attrs().get(0);
        Float f5 = (Float)sanClass.attrs().get(1);
        if (f4 != null) {
            f2 = f4.floatValue();
        }
        if (f5 != null) {
            f3 = f5.floatValue();
        }
        if (f > f2 || f < f3) {
            throw SanDataErrorCode.newException(SanDataErrorCode.INVALID_VALUE, String.format("key=%s.%s, value=%s", this.objPath(), string, Float.valueOf(f)));
        }
        Object object = this.valueList.set(n, Float.valueOf(f));
        if (object == null) {
            return 0.0f;
        }
        return ((Float)object).floatValue();
    }

    public double getDouble(String string) throws SanDataException {
        int n = this.memberIndex(string);
        if (!this.memberClass(n).type().equals("double")) {
            throw SanDataErrorCode.newException(SanDataErrorCode.INVALID_TYPE, String.format("key=%s.%s, type=%s", this.objPath(), string, "double"));
        }
        Object object = this.valueList.get(n);
        if (object == null) {
            return 0.0;
        }
        return (Double)object;
    }

    public double putDouble(String string, double d) throws SanDataException {
        int n = this.memberIndex(string);
        SanClass sanClass = this.memberClass(n);
        if (!sanClass.type().equals("double")) {
            throw SanDataErrorCode.newException(SanDataErrorCode.INVALID_TYPE, String.format("key=%s.%s, type=%s", this.objPath(), string, "double"));
        }
        double d2 = Double.MAX_VALUE;
        double d3 = Double.MIN_VALUE;
        Double d4 = (Double)sanClass.attrs().get(0);
        Double d5 = (Double)sanClass.attrs().get(1);
        if (d4 != null) {
            d2 = d4;
        }
        if (d5 != null) {
            d3 = d5;
        }
        if (d > d2 || d < d3) {
            throw SanDataErrorCode.newException(SanDataErrorCode.INVALID_VALUE, String.format("key=%s.%s, value=%s", this.objPath(), string, d));
        }
        Object object = this.valueList.set(n, d);
        if (object == null) {
            return 0.0;
        }
        return (Double)object;
    }

    public boolean getBoolean(String string) throws SanDataException {
        int n = this.memberIndex(string);
        if (!this.memberClass(n).type().equals("boolean")) {
            throw SanDataErrorCode.newException(SanDataErrorCode.INVALID_TYPE, String.format("key=%s.%s, type=%s", this.objPath(), string, "boolean"));
        }
        Object object = this.valueList.get(n);
        if (object == null) {
            return false;
        }
        return (Boolean)object;
    }

    public boolean putBoolean(String string, boolean bl) throws SanDataException {
        int n = this.memberIndex(string);
        if (!this.memberClass(n).type().equals("boolean")) {
            throw SanDataErrorCode.newException(SanDataErrorCode.INVALID_TYPE, String.format("key=%s.%s, type=%s", this.objPath(), string, "boolean"));
        }
        Object object = this.valueList.set(n, bl);
        if (object == null) {
            return false;
        }
        return (Boolean)object;
    }

    public String getString(String string) throws SanDataException {
        int n = this.memberIndex(string);
        if (!this.memberClass(n).type().equals("String")) {
            throw SanDataErrorCode.newException(SanDataErrorCode.INVALID_TYPE, String.format("key=%s.%s, type=%s", this.objPath(), string, "String"));
        }
        Object object = this.valueList.get(n);
        if (object == null) {
            return "";
        }
        return (String)object;
    }

    public String putString(String string, String string2) throws SanDataException {
        int n;
        int n2 = this.memberIndex(string);
        SanClass sanClass = this.memberClass(n2);
        if (!sanClass.type().equals("String")) {
            throw SanDataErrorCode.newException(SanDataErrorCode.INVALID_TYPE, String.format("key=%s.%s, type=%s", this.objPath(), string, "String"));
        }
        int n3 = Integer.MAX_VALUE;
        int n4 = Integer.MIN_VALUE;
        Integer n5 = (Integer)sanClass.attrs().get(0);
        Integer n6 = (Integer)sanClass.attrs().get(1);
        if (n5 != null) {
            n3 = n5;
        }
        if (n6 != null) {
            n4 = n6;
        }
        if ((n = string2.length()) > n3 || n < n4) {
            throw SanDataErrorCode.newException(SanDataErrorCode.INVALID_VALUE, String.format("key=%s.%s, value=%s", this.objPath(), string, string2));
        }
        Object object = this.valueList.set(n2, string2);
        if (object == null) {
            return "";
        }
        return (String)object;
    }

    public BitSet getBitSet(String string) throws SanDataException {
        int n = this.memberIndex(string);
        if (!this.memberClass(n).type().equals("BitSet")) {
            throw SanDataErrorCode.newException(SanDataErrorCode.INVALID_TYPE, String.format("key=%s.%s, type=%s", this.objPath(), string, "BitSet"));
        }
        Object object = this.valueList.get(n);
        if (object == null) {
            return new BitSet();
        }
        return (BitSet)object;
    }

    protected int[] getBitSetToIntArray(String string) throws SanDataException {
        int n;
        BitSet bitSet = this.getBitSet(string);
        if (bitSet == null) {
            return new int[]{0};
        }
        int[] nArray = new int[(n >>> 5) + (((n = bitSet.length()) & 0x1F) != 0 ? 1 : 0)];
        for (int i = 0; i < n; ++i) {
            if (!bitSet.get(i)) continue;
            int n2 = i >>> 5;
            nArray[n2] = nArray[n2] | Integer.MIN_VALUE >>> (i & 0x1F);
        }
        return nArray;
    }

    public BitSet putBitSet(String string, BitSet bitSet) throws SanDataException {
        int n;
        int n2 = this.memberIndex(string);
        SanClass sanClass = this.memberClass(n2);
        if (!sanClass.type().equals("BitSet")) {
            throw SanDataErrorCode.newException(SanDataErrorCode.INVALID_TYPE, String.format("key=%s.%s, type=%s", this.objPath(), string, "BitSet"));
        }
        int n3 = Integer.MAX_VALUE;
        Integer n4 = (Integer)sanClass.attrs().get(0);
        if (n4 != null) {
            n3 = n4;
        }
        if ((n = bitSet.length()) > n3) {
            throw SanDataErrorCode.newException(SanDataErrorCode.INVALID_VALUE, String.format("key=%s.%s, value=%s", this.objPath(), string, bitSet));
        }
        Object object = this.valueList.set(n2, bitSet);
        if (object == null) {
            return new BitSet();
        }
        return (BitSet)object;
    }

    protected void putBitSetFromIntArray(String string, int[] nArray) throws SanDataException {
        if (nArray == null) {
            return;
        }
        BitSet bitSet = new BitSet();
        for (int i = 0; i < nArray.length * 32; ++i) {
            if ((nArray[i >>> 5] & Integer.MIN_VALUE >>> (i & 0x1F)) == 0) continue;
            bitSet.set(i);
        }
        this.putBitSet(string, bitSet);
    }

    public int[] getIntArray(String string) throws SanDataException {
        int n = this.memberIndex(string);
        if (!this.memberClass(n).type().equals("int[]")) {
            throw SanDataErrorCode.newException(SanDataErrorCode.INVALID_TYPE, String.format("key=%s.%s, type=%s", this.objPath(), string, "int[]"));
        }
        Object object = this.valueList.get(n);
        if (object == null) {
            SanClass sanClass = this.memberClass(n);
            Integer n2 = (Integer)sanClass.attrs().get(0);
            int[] nArray = n2 != null ? new int[n2.intValue()] : new int[]{};
            Arrays.fill(nArray, 0);
            return nArray;
        }
        return (int[])object;
    }

    public int[] putIntArray(String string, int[] nArray) throws SanDataException {
        int[] nArray2;
        Object object;
        int n = this.memberIndex(string);
        SanClass sanClass = this.memberClass(n);
        if (!sanClass.type().equals("int[]")) {
            throw SanDataErrorCode.newException(SanDataErrorCode.INVALID_TYPE, String.format("key=%s.%s, type=%s", this.objPath(), string, "int[]"));
        }
        Integer n2 = (Integer)sanClass.attrs().get(0);
        if (n2 != null) {
            if (nArray.length != n2) {
                throw SanDataErrorCode.newException(SanDataErrorCode.INVALID_VALUE, String.format("key=%s.%s, value=%s", this.objPath(), string, nArray));
            }
            object = (int[])sanClass.attrs().get(1);
            if (object != null) {
                for (int i = 0; i < nArray.length; ++i) {
                    if (nArray[i] <= object[i]) continue;
                    throw SanDataErrorCode.newException(SanDataErrorCode.INVALID_VALUE, String.format("key=%s.%s, value=%s", this.objPath(), string, nArray));
                }
            }
            if ((nArray2 = (int[])sanClass.attrs().get(2)) != null) {
                for (int i = 0; i < nArray.length; ++i) {
                    if (nArray[i] >= nArray2[i]) continue;
                    throw SanDataErrorCode.newException(SanDataErrorCode.INVALID_VALUE, String.format("key=%s.%s, value=%s", this.objPath(), string, nArray));
                }
            }
        } else {
            n2 = 0;
        }
        if ((object = this.valueList.set(n, nArray)) == null) {
            nArray2 = new int[n2.intValue()];
            Arrays.fill(nArray2, 0);
            return nArray2;
        }
        return (int[])object;
    }

    public byte[] getByteArray(String string) throws SanDataException {
        int n = this.memberIndex(string);
        if (!this.memberClass(n).type().equals("byte[]")) {
            throw SanDataErrorCode.newException(SanDataErrorCode.INVALID_TYPE, String.format("key=%s.%s, type=%s", this.objPath(), string, "byte[]"));
        }
        Object object = this.valueList.get(n);
        if (object == null) {
            SanClass sanClass = this.memberClass(n);
            Integer n2 = (Integer)sanClass.attrs().get(0);
            byte[] byArray = n2 != null ? new byte[n2.intValue()] : new byte[]{};
            Arrays.fill(byArray, (byte)0);
            return byArray;
        }
        return (byte[])object;
    }

    public byte[] putByteArray(String string, byte[] byArray) throws SanDataException {
        Object object;
        int n = this.memberIndex(string);
        SanClass sanClass = this.memberClass(n);
        if (!sanClass.type().equals("byte[]")) {
            throw SanDataErrorCode.newException(SanDataErrorCode.INVALID_TYPE, String.format("key=%s.%s, type=%s", this.objPath(), string, "byte[]"));
        }
        Integer n2 = (Integer)sanClass.attrs().get(0);
        if (n2 != null) {
            if (byArray.length != n2) {
                throw SanDataErrorCode.newException(SanDataErrorCode.INVALID_VALUE, String.format("key=%s.%s, value=%s", this.objPath(), string, byArray));
            }
        } else {
            n2 = 0;
        }
        if ((object = this.valueList.set(n, byArray)) == null) {
            byte[] byArray2 = new byte[n2.intValue()];
            Arrays.fill(byArray2, (byte)0);
            return byArray2;
        }
        return (byte[])object;
    }

    protected static String valueToString(Object object) {
        String string = null;
        string = object == null ? null : (object instanceof Integer ? ((Integer)object).toString() : (object instanceof Long ? ((Long)object).toString() : (object instanceof Float ? ((Float)object).toString() : (object instanceof Double ? ((Double)object).toString() : (object instanceof Boolean ? ((Boolean)object).toString() : (object instanceof String ? ((String)object).toString() : (object instanceof BitSet ? ((BitSet)object).toString() : (object instanceof int[] ? Arrays.toString((int[])object) : (object instanceof byte[] ? SanObject.byteArrayValueToString((byte[])object) : null)))))))));
        return string;
    }

    protected static String byteArrayValueToString(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        if (byArray.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(byArray.length * 3);
        for (byte by : byArray) {
            stringBuilder.append(String.format("%02X-", by));
        }
        stringBuilder.replace(stringBuilder.length() - 1, stringBuilder.length(), "");
        return stringBuilder.toString();
    }

    protected static String parseValueType(Object object) {
        String string = null;
        string = object == null ? null : (object instanceof SanObject ? "Object" : (object instanceof SanList ? "List" : (object instanceof Integer ? "int" : (object instanceof Long ? "long" : (object instanceof Float ? "float" : (object instanceof Double ? "double" : (object instanceof Boolean ? "boolean" : (object instanceof String ? "String" : (object instanceof BitSet ? "BitSet" : (object instanceof int[] ? "int[]" : (object instanceof byte[] ? "byte[]" : "Unknown")))))))))));
        return string;
    }

    protected static Object parseValue(String string, String string2) {
        Object object;
        block11: {
            object = null;
            try {
                if (string.equals("int")) {
                    object = Integer.parseInt(string2);
                    break block11;
                }
                if (string.equals("long")) {
                    object = Long.parseLong(string2);
                    break block11;
                }
                if (string.equals("float")) {
                    object = Float.valueOf(Float.parseFloat(string2));
                    break block11;
                }
                if (string.equals("double")) {
                    object = Double.parseDouble(string2);
                    break block11;
                }
                if (string.equals("boolean")) {
                    object = Boolean.parseBoolean(string2);
                    break block11;
                }
                if (string.equals("String")) {
                    object = string2;
                    break block11;
                }
                if (string.equals("BitSet")) {
                    object = SanObject.parseBitSet(string2);
                    break block11;
                }
                if (string.equals("int[]")) {
                    object = SanObject.parseIntArray(string2);
                    break block11;
                }
                if (string.equals("byte[]")) {
                    object = SanObject.parseByteArray(string2);
                    break block11;
                }
                return null;
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        return object;
    }

    protected static BitSet parseBitSet(String string) {
        BitSet bitSet = null;
        if (string == null) {
            return null;
        }
        Pattern pattern = Pattern.compile("\\s*\\{(\\s*)\\}\\s*");
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            bitSet = new BitSet();
        } else {
            Pattern pattern2 = Pattern.compile("\\s*\\{(.*)\\}\\s*");
            Pattern pattern3 = Pattern.compile("\\s*(\\d+)");
            Matcher matcher2 = pattern2.matcher(string);
            if (matcher2.find()) {
                String string2 = matcher2.group(1);
                String[] stringArray = string2.split(",");
                if (stringArray.length == 0) {
                    return null;
                }
                BitSet bitSet2 = new BitSet();
                for (String string3 : stringArray) {
                    Matcher matcher3 = pattern3.matcher(string3);
                    if (!matcher3.find()) {
                        return null;
                    }
                    bitSet2.set(Integer.parseInt(matcher3.group(1)));
                }
                bitSet = bitSet2;
            } else {
                return null;
            }
        }
        return bitSet;
    }

    protected static int[] parseIntArray(String string) {
        int[] nArray = null;
        if (string == null) {
            return null;
        }
        Pattern pattern = Pattern.compile("\\s*\\[(\\s*)\\]\\s*");
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            nArray = new int[]{};
        } else {
            Pattern pattern2 = Pattern.compile("\\s*\\[(.*)\\]\\s*");
            Pattern pattern3 = Pattern.compile("\\s*(-?\\d+)");
            Matcher matcher2 = pattern2.matcher(string);
            if (matcher2.find()) {
                String string2 = matcher2.group(1);
                String[] stringArray = string2.split(",");
                if (stringArray.length == 0) {
                    return null;
                }
                int[] nArray2 = new int[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    Matcher matcher3 = pattern3.matcher(stringArray[i]);
                    if (!matcher3.find()) {
                        return null;
                    }
                    nArray2[i] = Integer.parseInt(matcher3.group(1));
                }
                nArray = nArray2;
            } else {
                return null;
            }
        }
        return nArray;
    }

    protected static byte[] parseByteArray(String string) {
        byte[] byArray = null;
        if (string == null) {
            return null;
        }
        byArray = SanObject.parseByteArray1(string);
        if (byArray == null) {
            byArray = SanObject.parseByteArray2(string);
        }
        return byArray;
    }

    protected static byte[] parseByteArray1(String string) {
        byte[] byArray = null;
        if (string == null) {
            return null;
        }
        Pattern pattern = Pattern.compile("^(\\s*)$");
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            byArray = new byte[]{};
        } else {
            Pattern pattern2 = Pattern.compile("^([^\\[\\]]+)$");
            Pattern pattern3 = Pattern.compile("^\\s*([0-9a-fA-F]{1,2})\\s*$");
            Matcher matcher2 = pattern2.matcher(string);
            if (matcher2.find()) {
                String string2 = matcher2.group(1);
                String[] stringArray = string2.split("-");
                if (stringArray.length == 0) {
                    return null;
                }
                byte[] byArray2 = new byte[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    Matcher matcher3 = pattern3.matcher(stringArray[i]);
                    if (!matcher3.find()) {
                        return null;
                    }
                    byArray2[i] = (byte)Integer.parseInt(matcher3.group(1), 16);
                }
                byArray = byArray2;
            } else {
                return null;
            }
        }
        return byArray;
    }

    protected static byte[] parseByteArray2(String string) {
        byte[] byArray = null;
        if (string == null) {
            return null;
        }
        Pattern pattern = Pattern.compile("\\s*\\[(\\s*)\\]\\s*");
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            byArray = new byte[]{};
        } else {
            Pattern pattern2 = Pattern.compile("\\s*\\[(.*)\\]\\s*");
            Pattern pattern3 = Pattern.compile("\\s*(-?\\d+)");
            Matcher matcher2 = pattern2.matcher(string);
            if (matcher2.find()) {
                String string2 = matcher2.group(1);
                String[] stringArray = string2.split(",");
                if (stringArray.length == 0) {
                    return null;
                }
                byte[] byArray2 = new byte[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    Matcher matcher3 = pattern3.matcher(stringArray[i]);
                    if (!matcher3.find()) {
                        return null;
                    }
                    byArray2[i] = Byte.parseByte(matcher3.group(1));
                }
                byArray = byArray2;
            } else {
                return null;
            }
        }
        return byArray;
    }

    protected Object putValue(String string, Object object) throws SanDataException {
        Object object2 = null;
        if (object instanceof Integer) {
            object2 = this.putInt(string, (Integer)object);
        } else if (object instanceof Long) {
            object2 = this.putLong(string, (Long)object);
        } else if (object instanceof Float) {
            object2 = Float.valueOf(this.putFloat(string, ((Float)object).floatValue()));
        } else if (object instanceof Double) {
            object2 = this.putDouble(string, (Double)object);
        } else if (object instanceof Boolean) {
            object2 = this.putBoolean(string, (Boolean)object);
        } else if (object instanceof String) {
            object2 = this.putString(string, (String)object);
        } else if (object instanceof BitSet) {
            object2 = this.putBitSet(string, (BitSet)object);
        } else if (object instanceof int[]) {
            object2 = this.putIntArray(string, (int[])object);
        } else if (object instanceof byte[]) {
            object2 = this.putByteArray(string, (byte[])object);
        }
        return object2;
    }
}

