/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.com;

import java.awt.Color;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.Icon;
import sanproject.client.com.RJcConst;
import sanproject.client.com.RJcElementForm;
import sanproject.client.com.RJcElementIconItem;
import sanproject.client.com.RJcTableModel;
import sanproject.client.com.RJcTablePanel;
import sanproject.client.com.RJcTreePanel;
import sanproject.client.com.abs.RJaContainColor;
import sanproject.client.com.abs.RJaContainFont;
import sanproject.client.com.abs.RJaContainIcon;
import sanproject.client.com.abs.RJaContainToolTip;
import sanproject.client.com.abs.RJaTreeManager;
import sanproject.client.com.abs.RJaTreeNode;
import sanproject.client.com.abs.RJaTreeNodeObject;

public class RJcElement
implements RJcConst,
Comparable,
Serializable,
RJaContainIcon,
RJaTreeNodeObject,
RJaContainColor,
RJaContainFont,
RJaContainToolTip {
    protected String name;
    protected RJcTreePanel treePanel;
    protected RJaTreeNode treeNode;
    protected RJcTableModel model = null;
    protected RJcTableModel saveModel = null;
    protected boolean created = false;
    protected ArrayList children = null;
    protected HashMap childrenMap = null;
    protected RJcElementIconItem iconItem = null;
    protected RJcElementForm formItem = null;

    public RJcElement() {
        this("???", null);
    }

    public RJcElement(String string) {
        this(string, null);
    }

    public RJcElement(String string, RJcTreePanel rJcTreePanel) {
        this.name = string;
        this.setTreePanel(rJcTreePanel);
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof RJcElement) {
            bl = this.name.equals(((RJcElement)object).getName());
        }
        return bl;
    }

    public int hashCode() {
        int n = this.name.hashCode();
        return n;
    }

    public String getName() {
        return this.name;
    }

    public String getEditingName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setTreePanel(RJcTreePanel rJcTreePanel) {
        this.treePanel = rJcTreePanel;
    }

    public String toString() {
        return this.name;
    }

    public int compareTo(Object object) {
        int n = 1;
        if (object instanceof RJcElement) {
            n = this.name.compareTo(((RJcElement)object).getName());
        }
        return n;
    }

    public Icon getIcon() {
        return this.getIcon(false);
    }

    public Icon getIcon(boolean bl) {
        Icon icon = null;
        return icon;
    }

    public RJcElementIconItem getIconItem() {
        if (this.iconItem == null) {
            this.iconItem = new RJcElementIconItem(this);
        }
        return this.iconItem;
    }

    public Comparable getIconValue() {
        return null;
    }

    public void setTreeNode(RJaTreeNode rJaTreeNode) {
        this.treeNode = rJaTreeNode;
    }

    public void createChildren(RJaTreeManager rJaTreeManager, RJaTreeNode rJaTreeNode, boolean bl, int n) {
        if (n == 0) {
            this.createChildren(rJaTreeManager, rJaTreeNode);
        }
    }

    public void createChildren(RJaTreeManager rJaTreeManager, RJaTreeNode rJaTreeNode) {
    }

    public boolean getAllowsChildren() {
        return false;
    }

    public boolean isExpandMode() {
        return false;
    }

    public void selectNode(RJaTreeNode rJaTreeNode) {
        RJcTablePanel rJcTablePanel = this.treePanel.getTablePanel();
        if (rJcTablePanel != null) {
            rJcTablePanel.reset();
        }
    }

    public static Integer newInteger(int n) {
        Integer n2 = null;
        if (n >= 0) {
            n2 = new Integer(n);
        }
        return n2;
    }

    public static Long newLong(long l) {
        Long l2 = null;
        if (l >= 0L) {
            l2 = new Long(l);
        }
        return l2;
    }

    public static String toMiBValue(long l) {
        return RJcElement.toDecimal((double)l / 1024.0);
    }

    public static String toSecValue(long l) {
        return RJcElement.toDecimal((double)l / 1000.0);
    }

    public static String toDecimal(double d) {
        double d2 = (double)Math.round(d * 1000.0) / 1000.0;
        DecimalFormat decimalFormat = new DecimalFormat("0.00");
        String string = decimalFormat.format(d2);
        return string;
    }

    public static String toClprString(Integer n, String string) {
        String string2 = "-:-";
        if (n != null) {
            if (string == null) {
                string = "-";
            }
            MessageFormat messageFormat = new MessageFormat("{0,number,00}:{1}");
            Object[] objectArray = new Object[]{n, string};
            string2 = messageFormat.format(objectArray);
        }
        return string2;
    }

    public static String toHexString(int n) {
        String string = Integer.toHexString(n).toUpperCase();
        return string;
    }

    public static String toHexString(int n, int n2) {
        String string = "0000000" + Integer.toHexString(n).toUpperCase();
        return string.substring(string.length() - n2);
    }

    public RJcElementForm getElementForm() {
        if (this.formItem == null) {
            this.formItem = new RJcElementForm(this);
        }
        return this.formItem;
    }

    public Color getForeground() {
        Color color = null;
        if (!this.isEnabled()) {
            color = RJcConst.disableColor;
        } else if (this.isModify()) {
            color = RJcConst.modifyColor;
        } else if (this.isWarning()) {
            color = RJcConst.warningColor;
        }
        return color;
    }

    public Integer getFontStyle() {
        Integer n = null;
        if (this.isModify()) {
            n = new Integer(3);
        } else if (this.isWarning()) {
            n = new Integer(2);
        }
        return n;
    }

    protected boolean isEnabled() {
        return true;
    }

    protected boolean isModify() {
        return false;
    }

    protected boolean isWarning() {
        return false;
    }

    public String getToolTip() {
        return null;
    }

    public RJcTableModel getTableModel() {
        return this.model;
    }

    public void setTableModel(RJcTableModel rJcTableModel) {
        this.saveModel = rJcTableModel;
    }
}

