/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.com.abs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Point;
import java.awt.dnd.Autoscroll;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import sanproject.client.com.abs.RJaDefaultTreeCellRenderer;
import sanproject.client.com.abs.RJaTreeNode;

public class RJaTreeManager
extends JPanel
implements TreeSelectionListener,
MouseListener {
    protected RJaTreeNode rootNode;
    protected DefaultTreeModel treeModel;
    protected InnerTree tree;
    protected JScrollPane scrollPane;
    private BorderLayout thisLayout = new BorderLayout();
    private Vector refreshTarget = null;
    public static final Insets autoscrollInsets = new Insets(0, 0, 0, 0);

    public RJaTreeManager() {
        this.rootNode = new RJaTreeNode(this);
        this.treeModel = new DefaultTreeModel(this.rootNode, true);
        this.treeModel.addTreeModelListener(new InnerTreeModelListener());
        this.tree = new InnerTree(this, this.treeModel);
        this.tree.getSelectionModel().addTreeSelectionListener(this);
        this.tree.putClientProperty("JTree.lineStyle", "Angled");
        this.scrollPane = new JScrollPane(this.tree);
        this.scrollPane.setBorder(BorderFactory.createLoweredBevelBorder());
        this.setLayout(this.thisLayout);
        this.add((Component)this.scrollPane, "Center");
        this.initTree();
    }

    protected void initTree() {
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setCellRenderer(new RJaDefaultTreeCellRenderer());
        this.tree.setEditable(false);
        this.tree.setRootVisible(true);
        this.tree.setShowsRootHandles(true);
    }

    protected void enableToolTip() {
        ToolTipManager.sharedInstance().registerComponent(this.tree);
    }

    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public JTree getTree() {
        return this.tree;
    }

    public TreeModel getTreeModel() {
        return this.treeModel;
    }

    public RJaTreeNode getRootNode() {
        return this.rootNode;
    }

    public void setRootObject(Object object) {
        this.rootNode.setUserObject(object);
        this.treeModel.nodeChanged(this.rootNode);
    }

    public void clear() {
        this.rootNode.removeAllChildren();
        this.treeModel.reload();
    }

    public void removeCurrentNode() {
        RJaTreeNode rJaTreeNode;
        MutableTreeNode mutableTreeNode;
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath != null && (mutableTreeNode = (MutableTreeNode)(rJaTreeNode = (RJaTreeNode)treePath.getLastPathComponent()).getParent()) != null) {
            this.treeModel.removeNodeFromParent(rJaTreeNode);
        }
    }

    public void removeNode(RJaTreeNode rJaTreeNode) {
        MutableTreeNode mutableTreeNode;
        if (rJaTreeNode != null && (mutableTreeNode = (MutableTreeNode)rJaTreeNode.getParent()) != null) {
            this.treeModel.removeNodeFromParent(rJaTreeNode);
        }
    }

    public RJaTreeNode addObject(Object object) {
        RJaTreeNode rJaTreeNode = null;
        TreePath treePath = this.tree.getSelectionPath();
        rJaTreeNode = treePath == null ? this.rootNode : (RJaTreeNode)treePath.getLastPathComponent();
        return this.addObject(rJaTreeNode, object, true);
    }

    public RJaTreeNode addObject(RJaTreeNode rJaTreeNode, Object object) {
        return this.addObject(rJaTreeNode, object, false);
    }

    public RJaTreeNode addObject(RJaTreeNode rJaTreeNode, Object object, boolean bl) {
        RJaTreeNode rJaTreeNode2 = new RJaTreeNode(this, object);
        if (rJaTreeNode == null) {
            rJaTreeNode = this.rootNode;
        }
        this.treeModel.insertNodeInto(rJaTreeNode2, rJaTreeNode, rJaTreeNode.getChildCount());
        if (bl) {
            this.tree.scrollPathToVisible(new TreePath(rJaTreeNode2.getPath()));
        }
        return rJaTreeNode2;
    }

    public RJaTreeNode insertObject(int n, Object object) {
        RJaTreeNode rJaTreeNode = null;
        TreePath treePath = this.tree.getSelectionPath();
        rJaTreeNode = treePath == null ? this.rootNode : (RJaTreeNode)treePath.getLastPathComponent();
        return this.insertObject(rJaTreeNode, n, object, true);
    }

    public RJaTreeNode insertObject(RJaTreeNode rJaTreeNode, int n, Object object) {
        return this.insertObject(rJaTreeNode, n, object, false);
    }

    public RJaTreeNode insertObject(RJaTreeNode rJaTreeNode, int n, Object object, boolean bl) {
        RJaTreeNode rJaTreeNode2 = new RJaTreeNode(this, object);
        if (rJaTreeNode == null) {
            rJaTreeNode = this.rootNode;
        }
        this.treeModel.insertNodeInto(rJaTreeNode2, rJaTreeNode, n);
        if (bl) {
            this.tree.scrollPathToVisible(new TreePath(rJaTreeNode2.getPath()));
        }
        return rJaTreeNode2;
    }

    public int indexOf(RJaTreeNode rJaTreeNode, Object object) {
        int n = -1;
        Enumeration<TreeNode> enumeration = rJaTreeNode.children();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            RJaTreeNode rJaTreeNode2 = (RJaTreeNode)enumeration.nextElement();
            Object object2 = rJaTreeNode2.getUserObject();
            if (object2.equals(object)) {
                n = n2;
                break;
            }
            ++n2;
        }
        return n;
    }

    public int lookup(RJaTreeNode rJaTreeNode, Comparable comparable) {
        RJaTreeNode rJaTreeNode2;
        Object object;
        int n = 0;
        Enumeration<TreeNode> enumeration = rJaTreeNode.children();
        while (enumeration.hasMoreElements() && (!((object = (rJaTreeNode2 = (RJaTreeNode)enumeration.nextElement()).getUserObject()) instanceof Comparable) || ((Comparable)object).compareTo(comparable) <= 0)) {
            ++n;
        }
        return n;
    }

    public void expand(TreePath treePath) {
        RJaTreeNode rJaTreeNode = (RJaTreeNode)treePath.getLastPathComponent();
        rJaTreeNode.createChildren(true);
    }

    public void collapse(TreePath treePath) {
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        System.out.println("TreeSelectionEvent_valueChanged");
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void superRefresh() {
        this.refresh();
        if (this.refreshTarget != null) {
            Enumeration enumeration = this.refreshTarget.elements();
            while (enumeration.hasMoreElements()) {
                Component component = (Component)enumeration.nextElement();
                component.repaint();
            }
        }
    }

    public void refresh() {
        this.revalidate();
        this.repaint();
        this.tree.revalidate();
        this.tree.repaint();
    }

    public void setRefreshTarget(Component component) {
        if (this.refreshTarget == null) {
            this.refreshTarget = new Vector(4, 2);
        }
        this.refreshTarget.add(component);
    }

    private class InnerTreeModelListener
    implements TreeModelListener {
        private InnerTreeModelListener() {
        }

        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            RJaTreeNode rJaTreeNode = (RJaTreeNode)treeModelEvent.getTreePath().getLastPathComponent();
            try {
                int n = treeModelEvent.getChildIndices()[0];
                rJaTreeNode = (RJaTreeNode)rJaTreeNode.getChildAt(n);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }

        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
            RJaTreeNode rJaTreeNode = (RJaTreeNode)treeModelEvent.getTreePath().getLastPathComponent();
            TreeNode[] treeNodeArray = ((RJaTreeNode)rJaTreeNode.getLastChild()).getPath();
        }

        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            RJaTreeNode rJaTreeNode = (RJaTreeNode)treeModelEvent.getTreePath().getLastPathComponent();
        }

        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        }
    }

    public class InnerTree
    extends JTree
    implements Autoscroll {
        private RJaTreeManager manager;

        public InnerTree(RJaTreeManager rJaTreeManager2, TreeModel treeModel) {
            super(treeModel);
            this.manager = rJaTreeManager2;
        }

        public void expandPath(TreePath treePath) {
            if (treePath != null && !this.isExpanded(treePath)) {
                this.manager.expand(treePath);
            }
            super.expandPath(treePath);
        }

        public void collapsePath(TreePath treePath) {
            this.manager.collapse(treePath);
            super.collapsePath(treePath);
        }

        public void repaint(long l) {
            this.manager.superRefresh();
        }

        public Insets getAutoscrollInsets() {
            Insets insets = autoscrollInsets;
            if (this.manager instanceof Autoscroll) {
                insets = ((Autoscroll)((Object)this.manager)).getAutoscrollInsets();
            }
            return insets;
        }

        public void autoscroll(Point point) {
            if (this.manager instanceof Autoscroll) {
                ((Autoscroll)((Object)this.manager)).autoscroll(point);
            }
        }
    }
}

