/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.data;

import java.awt.Component;
import java.awt.Window;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import sanproject.client.com.RJComWaitingDialog;
import sanproject.client.data.RJDataCacheException;
import sanproject.client.data.RJDataCacheItem;
import sanproject.client.data.RJDataCacheMap;
import sanproject.client.data.RJDataControl;
import sanproject.client.data.RJDataControlDoing;
import sanproject.client.data.RJDataException;
import sanproject.client.data.RJDataMethodInfo;
import sanproject.client.data.RJDataVersionInfo;
import sanproject.serverux.dataimpl.DISKgetVersionInfoEx;

public class RJDataCache {
    private RJDataControl controller = null;
    private LinkedHashMap cache = null;
    private boolean versionCheckMode = false;
    private boolean showDialog = true;
    private Component ownerCompo = null;
    private boolean versionmode = false;
    private boolean filemode = false;
    RJDataVersionInfo objVersion = null;
    private boolean cacheExec = false;
    private int m_iMaxHashEntries = 1000;
    private float m_fLoadFactor = 1.0f;
    private int m_iTraceLevel = 1;
    private static final int I_DCERRPART = 10;
    private static final int I_DCERRCODE = 6027;
    private static final long L_SLEEPTIME = 5L;
    private static final boolean TRACE_FLAG_CACHE = true;
    private static final int TRACE_LEVEL_CACHE = 5;
    private static final byte MASK_CACHEMODE = Byte.parseByte("00000001", 2);
    private static final byte MASK_FILEMODE = Byte.parseByte("00000010", 2);
    private static final String DIR_NAME = ".webconsole";
    private static final String FILE_NAME = "webconsole.cache";
    private static final String FILE_PATH = System.getProperty("user.home") + File.separator + ".webconsole" + File.separator + "webconsole.cache";
    private static final int MAX_M_LHASH_ENTRIES = 1000;
    private static final float LOAD_FACTOR = 1.0f;
    private static final boolean ACCESS_ORDER = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RJDataCache(RJDataControl rJDataControl) {
        this.controller = rJDataControl;
        this.objVersion = new RJDataVersionInfo(this);
        String string = null;
        String string2 = null;
        String string3 = null;
        try {
            string = System.getProperty("DCLINKEDHASHENTRY", "1000");
            this.m_iMaxHashEntries = Integer.parseInt(string);
            if (this.m_iMaxHashEntries <= 0) {
                this.m_iMaxHashEntries = 1000;
            }
            string2 = System.getProperty("DCLINKEDHASHLOADFACT", "1.0f");
            this.m_fLoadFactor = Float.parseFloat(string2);
            if (this.m_fLoadFactor <= 0.0f) {
                this.m_fLoadFactor = 1.0f;
            }
            string3 = System.getProperty("dccachedebug", "3");
            this.m_iTraceLevel = Integer.parseInt(string3);
            if (this.m_iTraceLevel <= 0) {
                this.m_iTraceLevel = 5;
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.m_iMaxHashEntries = 1000;
            this.m_fLoadFactor = 1.0f;
            this.m_iTraceLevel = 5;
        }
        finally {
            this.cache = new RJDataCacheMap(this.m_iMaxHashEntries, this.m_fLoadFactor, true);
        }
    }

    public RJDataControl getDataControl() {
        return this.controller;
    }

    public void setShowWaitingDialog(boolean bl) {
        this.showDialog = bl;
    }

    public boolean isShowWaitingDialog() {
        return this.showDialog;
    }

    public void setWaitingDialogComponent(Component component) {
        this.ownerCompo = component;
    }

    public Component getWaitingDialogComponent() {
        return this.ownerCompo;
    }

    public boolean isVersionmode() {
        return this.versionmode;
    }

    public boolean isFilemode() {
        return this.filemode;
    }

    public void Init() {
        this.TraceDCCache(1, "[DataCache] Init Start");
        byte by = this.controller.m_RJDataStartParam.getRSDJAVADG();
        if ((by & MASK_CACHEMODE) == MASK_CACHEMODE) {
            this.versionmode = true;
            this.TraceDCCache(1, "[DataCache] Init >>>versionmode");
        } else {
            this.versionmode = false;
        }
        if ((by & MASK_FILEMODE) == MASK_FILEMODE && this.versionmode) {
            this.filemode = true;
            this.TraceDCCache(1, "[DataCache] Init >>>filemode");
        } else {
            this.filemode = false;
        }
        if (this.filemode) {
            this.cacheFileRead();
        }
        this.TraceDCCache(1, "[DataCache] Init End");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getCacheInfo(RJDataMethodInfo rJDataMethodInfo) throws RJDataException {
        Object object;
        block13: {
            object = null;
            try {
                if (rJDataMethodInfo != null) {
                    String string = rJDataMethodInfo.getName();
                    this.TraceDCCache(3, "[DataCache] getCacheInfo [" + string + "] Start");
                    DISKgetVersionInfoEx dISKgetVersionInfoEx = null;
                    RJDataCacheItem rJDataCacheItem = null;
                    try {
                        int n = rJDataMethodInfo.getVerChkKindBit();
                        if (!this.isVersionmode() || n == 0) {
                            this.TraceDCCache(5, "[DataCache] getCacheInfo [VMode=OFF or VMethod=NO");
                            object = this.getServerInfo(rJDataMethodInfo);
                        } else {
                            this.TraceDCCache(5, "[DataCache] getCacheInfo [VMode=ON and VMethod=YES");
                            this.cacheExec = true;
                            rJDataCacheItem = this.getCacheItem(rJDataMethodInfo);
                            int[] nArray = rJDataCacheItem == null ? this.objVersion.creatVersionInfo(n) : rJDataCacheItem.getVersionInfo();
                            dISKgetVersionInfoEx = this.getServerVersion();
                            if (rJDataCacheItem == null || this.objVersion.versionCheck(dISKgetVersionInfoEx, n, nArray)) {
                                Object object2 = this.getServerInfo(rJDataMethodInfo);
                                int[] nArray2 = this.objVersion.versionUpDate(dISKgetVersionInfoEx, n, nArray);
                                rJDataCacheItem = this.registCacheItem(rJDataMethodInfo, object2, nArray2);
                            }
                            object = rJDataCacheItem.getItem();
                        }
                    }
                    catch (RJDataCacheException rJDataCacheException) {
                        object = this.getServerInfo(rJDataMethodInfo);
                        this.removeCacheItem(rJDataMethodInfo);
                    }
                    finally {
                        this.cacheExec = false;
                    }
                    this.TraceDCCache(1, "[DataCache] getCacheInfo [" + string + "] End");
                    break block13;
                }
                this.TraceDCCache(1, "[DataCache] getCacheInfo Error [RJDataMethodInfo >>> None]");
            }
            catch (RJDataException rJDataException) {
                throw rJDataException;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return object;
    }

    private RJDataCacheItem getCacheItem(RJDataMethodInfo rJDataMethodInfo) {
        String string = rJDataMethodInfo.getName();
        this.TraceDCCache(1, "[DataCache] getCacheItem [" + string + "] Start");
        RJDataCacheItem rJDataCacheItem = (RJDataCacheItem)this.cache.get(rJDataMethodInfo);
        this.TraceDCCache(1, "[DataCache] getCacheItem [" + string + "] End");
        return rJDataCacheItem;
    }

    private RJDataCacheItem registCacheItem(RJDataMethodInfo rJDataMethodInfo, Object object, int[] nArray) {
        String string = rJDataMethodInfo.getName();
        this.TraceDCCache(1, "[DataCache] registCacheItem [" + string + "] Start");
        RJDataCacheItem rJDataCacheItem = new RJDataCacheItem(object, nArray);
        this.cache.put(rJDataMethodInfo, rJDataCacheItem);
        this.TraceDCCache(1, "[DataCache] registCacheItem [" + string + "] End");
        return rJDataCacheItem;
    }

    private void removeCacheItem(RJDataMethodInfo rJDataMethodInfo) {
        String string = rJDataMethodInfo.getName();
        this.TraceDCCache(1, "[DataCache] removeCacheItem [" + string + "] Start");
        this.cache.remove(rJDataMethodInfo);
        this.TraceDCCache(1, "[DataCache] removeCacheItem [" + string + "] End");
    }

    private Object getServerInfo(RJDataMethodInfo rJDataMethodInfo) throws RJDataException {
        String string = rJDataMethodInfo.getName();
        this.TraceDCCache(1, "[DataCache] getServerInfo [" + string + "] Start");
        this.waitControl();
        this.controller.getServerInfo(rJDataMethodInfo);
        this.confirm(string);
        Object object = this.controller.getServerInfoData();
        this.TraceDCCache(1, "[DataCache] getServerInfo [" + string + "] End");
        return object;
    }

    protected void waitControl() throws RJDataException {
        this.TraceDCCache(5, "[DataCache] waitControl Start");
        RJDataControlDoing rJDataControlDoing = this.controller.getControlDoing();
        while (rJDataControlDoing.getDoing()) {
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException interruptedException) {
                int n = 10;
                int n2 = 6027;
                RJDataException rJDataException = new RJDataException(n, n2);
                this.TraceDCCache(1, "[DataCache] waitControl ERR[" + n + "," + n2 + "]");
                throw rJDataException;
            }
        }
        this.TraceDCCache(5, "[DataCache] waitControl End");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void confirm(String string) throws RJDataException {
        this.TraceDCCache(3, "[DataCache] confirm[" + string + "] Start");
        Component component = this.ownerCompo;
        boolean bl = this.showDialog;
        RJComWaitingDialog rJComWaitingDialog = null;
        if (component != null) {
            this.TraceDCCache(3, "[DataCache] confirm COMPON >>> " + component.getName());
        }
        try {
            Object object;
            if (bl) {
                object = new Runnable_WaitDC(this.controller);
                if (object != null) {
                    rJComWaitingDialog = this.createWaitingDialog(component);
                }
                if (rJComWaitingDialog != null) {
                    this.TraceDCCache(3, "[DataCache] confirm Runnable Start");
                    rJComWaitingDialog.show((Runnable)object);
                } else {
                    this.TraceDCCache(3, "[DataCache] confirm Runnable No");
                }
            }
            if (!bl || rJComWaitingDialog == null) {
                this.TraceDCCache(3, "[DataCache] confirm WDFlag >>> false");
                this.controller.waitDC(null);
            }
            object = this.controller.getEndStatus();
            int n = (Integer)((ArrayList)object).get(0);
            int n2 = (Integer)((ArrayList)object).get(1);
            this.TraceDCCache(3, "[DataCache] confirm[" + string + "] EndStatus[" + n + "," + n2 + "]");
            if (n != 0) {
                RJDataException rJDataException = new RJDataException(n, n2);
                throw rJDataException;
            }
            this.TraceDCCache(3, "[DataCache] confirm[" + string + "] End");
        }
        finally {
            if (bl && rJComWaitingDialog != null) {
                this.TraceDCCache(3, "[DataCache] confirm WD dispose");
                rJComWaitingDialog.dispose();
            }
        }
    }

    protected void putLog(String string, String string2, String string3) {
        if (this.controller != null) {
            // empty if block
        }
        System.out.println(string + " " + string2 + " " + string3);
    }

    protected void TraceDCCache(int n, String string) {
        if (string != null && n <= this.m_iTraceLevel) {
            System.out.println(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cacheFileWrite() {
        this.TraceDCCache(1, "[DataCache] cacheFileWrite Start");
        try {
            String string = System.getProperty("WebConsole.cache", FILE_PATH);
            this.TraceDCCache(1, "[DataCache] [cacheFileWrite] save cache... [" + string + "]");
            while (this.cacheExec) {
                this.TraceDCCache(3, "[DataCache] cacheFileWrite >>>WritingWait");
                Thread.sleep(5L);
            }
            this.cacheExec = true;
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(this.cache);
            objectOutputStream.close();
            fileOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.TraceDCCache(1, "[DataCache] cacheFileWrite >>>FileNotFoundException");
        }
        catch (IOException iOException) {
            this.TraceDCCache(1, "[DataCache] cacheFileWrite >>>IOException");
        }
        catch (InterruptedException interruptedException) {
            this.TraceDCCache(1, "[DataCache] cacheFileWrite >>>InterruptedException");
        }
        finally {
            this.cacheExec = false;
        }
        this.TraceDCCache(1, "[DataCache] cacheFileWrite End");
    }

    protected void cacheFileRead() {
        this.TraceDCCache(1, "[DataCache] cacheFileRead Start");
        String string = System.getProperty("WebConsole.cache", FILE_PATH);
        try {
            this.TraceDCCache(1, "[DataCache] cacheFileRead load cache... [" + string + "]");
            FileInputStream fileInputStream = new FileInputStream(string);
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            this.cache = (RJDataCacheMap)objectInputStream.readObject();
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.TraceDCCache(1, "[DataCache] cacheFileRead >>>FileNotFoundException");
        }
        catch (IOException iOException) {
            this.TraceDCCache(1, "[DataCache] cacheFileRead >>>IOException");
            File file = new File(string);
            file.delete();
            this.cacheClear();
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.TraceDCCache(1, "[DataCache] cacheFileRead >>>ClassNotFoundException");
            classNotFoundException.printStackTrace();
        }
        this.TraceDCCache(1, "[DataCache] cacheFileRead End");
    }

    private DISKgetVersionInfoEx getServerVersion() throws RJDataException, RJDataCacheException {
        this.TraceDCCache(1, "[DataCache] getServerVersion Start");
        DISKgetVersionInfoEx dISKgetVersionInfoEx = null;
        RJDataMethodInfo rJDataMethodInfo = new RJDataMethodInfo("getVersionInfoEx");
        rJDataMethodInfo.setInfo(new Class[0], new Object[0]);
        dISKgetVersionInfoEx = (DISKgetVersionInfoEx)this.getServerInfo(rJDataMethodInfo);
        if (dISKgetVersionInfoEx == null) {
            this.TraceDCCache(1, "[DataCache] getServerVersion Error [result=null]");
            throw new RJDataCacheException();
        }
        this.TraceDCCache(1, "[DataCache] getServerVersion End");
        return dISKgetVersionInfoEx;
    }

    protected void cacheClear() {
        this.TraceDCCache(1, "[DataCache] cacheClear Start");
        this.cache.clear();
        this.TraceDCCache(1, "[DataCache] cacheClear End");
    }

    protected void cacheDeletion() {
        this.TraceDCCache(1, "[DataCache] cacheDeletion Start");
        this.cache.clear();
        this.cache = null;
        this.TraceDCCache(1, "[DataCache] cacheDeletion End");
    }

    private RJComWaitingDialog createWaitingDialog(Component component) {
        Window window = null;
        if (component != null) {
            window = this.searchWindow(component);
        }
        if (window == null) {
            window = this.searchWindow(this.getApplet());
        }
        RJComWaitingDialog rJComWaitingDialog = this.controller.getStartParamClass().createWaitingDialog2(window);
        return rJComWaitingDialog;
    }

    private Window searchWindow(Component component) {
        Window window = null;
        for (Component component2 = component; component2 != null; component2 = component2.getParent()) {
            if (!(component2 instanceof Window)) continue;
            window = (Window)component2;
            break;
        }
        return window;
    }

    private Component getApplet() {
        return this.controller.m_RJDataStartParam.getJApplet();
    }

    private class Runnable_WaitDC
    implements Runnable {
        private RJDataControl DC = null;

        Runnable_WaitDC(RJDataControl rJDataControl) {
            this.DC = rJDataControl;
        }

        public void run() {
            this.DC.waitDC(null);
        }
    }
}

