/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.exdevice.luoperation;

import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Arrays;
import java.util.EventListener;
import java.util.EventObject;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import sanproject.client.com.RJCom;
import sanproject.client.com.RJComFont;
import sanproject.client.data.RJDataControl;

public class LDEVMapPanel
extends JPanel {
    private static final int ROWHEADER_WIDTH = 28;
    private static final int TILE_WIDTH = 18;
    private static final int TILE_HEIGHT = 18;
    private LayoutManager defaultLayout = new BorderLayout();
    private Border tileBorder;
    private Cursor invalidCursor = Cursor.getPredefinedCursor(0);
    private Cursor validCursor = Cursor.getPredefinedCursor(12);
    private Color unusableColor = new Color(160, 160, 160);
    private Color usableColor = UIManager.getColor("Table.background");
    private Color selectedColor = UIManager.getColor("Table.selectionBackground");
    private boolean[] usableMap;
    private int[] selectedIndexes;
    private boolean operationEnabled = true;
    static /* synthetic */ Class class$sanproject$client$exdevice$luoperation$LDEVMapPanel$TileSelectedListener;

    public LDEVMapPanel() {
        this.tileBorder = BorderFactory.createLineBorder(this.selectedColor, 2);
        this.usableMap = new boolean[256];
        this.selectedIndexes = new int[0];
        try {
            this.invalidCursor = Cursor.getSystemCustomCursor("Invalid.32x32");
        }
        catch (AWTException aWTException) {
            aWTException.printStackTrace(System.err);
        }
        this.buildPanelLayout();
    }

    public void setLayout(LayoutManager layoutManager) {
        if (this.defaultLayout != null && !this.defaultLayout.equals(layoutManager)) {
            throw new UnsupportedOperationException();
        }
        super.setLayout(layoutManager);
    }

    public void setUsableMap(boolean[] blArray) {
        int n;
        if (blArray != null) {
            n = blArray.length;
            if (n > 256) {
                n = 256;
            }
            System.arraycopy(blArray, 0, this.usableMap, 0, n);
        } else {
            n = 0;
        }
        Arrays.fill(this.usableMap, n, 256, false);
        this.setSelectedIndexes(null);
    }

    public void setSelectedIndexes(int[] nArray) {
        if (nArray == null) {
            this.selectedIndexes = new int[0];
        } else {
            int n = nArray.length;
            this.selectedIndexes = new int[n];
            System.arraycopy(nArray, 0, this.selectedIndexes, 0, n);
            Arrays.sort(this.selectedIndexes);
        }
        this.repaint();
    }

    public void setOperationEnabled(boolean bl) {
        this.operationEnabled = bl;
    }

    public boolean isOperationEnabled() {
        boolean bl = this.isEnabled() && this.operationEnabled;
        return bl;
    }

    public Cursor getValidCursor() {
        Cursor cursor = this.validCursor;
        return cursor;
    }

    public Cursor getInvalidCursor() {
        Cursor cursor = this.invalidCursor;
        return cursor;
    }

    public void addTileSelectedListener(TileSelectedListener tileSelectedListener) {
        this.listenerList.add(class$sanproject$client$exdevice$luoperation$LDEVMapPanel$TileSelectedListener == null ? (class$sanproject$client$exdevice$luoperation$LDEVMapPanel$TileSelectedListener = LDEVMapPanel.class$("sanproject.client.exdevice.luoperation.LDEVMapPanel$TileSelectedListener")) : class$sanproject$client$exdevice$luoperation$LDEVMapPanel$TileSelectedListener, tileSelectedListener);
    }

    public void removeTileSelectedListener(TileSelectedListener tileSelectedListener) {
        this.listenerList.remove(class$sanproject$client$exdevice$luoperation$LDEVMapPanel$TileSelectedListener == null ? (class$sanproject$client$exdevice$luoperation$LDEVMapPanel$TileSelectedListener = LDEVMapPanel.class$("sanproject.client.exdevice.luoperation.LDEVMapPanel$TileSelectedListener")) : class$sanproject$client$exdevice$luoperation$LDEVMapPanel$TileSelectedListener, tileSelectedListener);
    }

    protected void fireTileSelected(LDEVTile lDEVTile) {
        EventListener[] eventListenerArray;
        if (lDEVTile != null && (eventListenerArray = this.getListeners(class$sanproject$client$exdevice$luoperation$LDEVMapPanel$TileSelectedListener == null ? (class$sanproject$client$exdevice$luoperation$LDEVMapPanel$TileSelectedListener = LDEVMapPanel.class$("sanproject.client.exdevice.luoperation.LDEVMapPanel$TileSelectedListener")) : class$sanproject$client$exdevice$luoperation$LDEVMapPanel$TileSelectedListener)) != null) {
            TileSelectedEvent tileSelectedEvent = new TileSelectedEvent(lDEVTile);
            for (int i = 0; i < eventListenerArray.length; ++i) {
                TileSelectedListener tileSelectedListener = (TileSelectedListener)eventListenerArray[i];
                tileSelectedListener.tileSelected(tileSelectedEvent);
            }
        }
    }

    private void buildPanelLayout() {
        JComponent jComponent;
        Object object;
        String string;
        int n;
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                LDEVTile lDEVTile = (LDEVTile)mouseEvent.getSource();
                if (LDEVMapPanel.this.isOperationEnabled() && lDEVTile.isUsable() && !lDEVTile.isSelected()) {
                    RJCom.putLog(RJDataControl.getDataControl(), "[ExDevice_LU]", "LDEVMapPanel", "[LDEVMapPanel] LDEVTile Select.", 0);
                    LDEVMapPanel.this.fireTileSelected(lDEVTile);
                }
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                LDEVTile lDEVTile = (LDEVTile)mouseEvent.getSource();
                if (LDEVMapPanel.this.isOperationEnabled() && lDEVTile.isUsable()) {
                    lDEVTile.setBorder(LDEVMapPanel.this.tileBorder);
                }
            }

            public void mouseExited(MouseEvent mouseEvent) {
                LDEVTile lDEVTile = (LDEVTile)mouseEvent.getSource();
                lDEVTile.setBorder(null);
            }
        };
        Dimension dimension = new Dimension(28, 18);
        Dimension dimension2 = new Dimension(18, 18);
        Border border = BorderFactory.createEmptyBorder(4, 4, 4, 4);
        Component component = Box.createRigidArea(dimension);
        LayoutManager layoutManager = new GridLayout(1, 0, 1, 0);
        Serializable serializable = new JPanel();
        ((Container)serializable).setLayout(layoutManager);
        ((JComponent)serializable).setOpaque(false);
        for (n = 0; n < 16; ++n) {
            string = Integer.toHexString(n);
            object = string.toUpperCase();
            jComponent = new JLabel();
            ((JLabel)jComponent).setText((String)object);
            jComponent.setFont(RJComFont.buttonFont);
            ((JLabel)jComponent).setHorizontalAlignment(0);
            jComponent.setBorder(border);
            jComponent.setPreferredSize(dimension2);
            ((Container)serializable).add(jComponent);
        }
        layoutManager = new BorderLayout(0, 0);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(layoutManager);
        jPanel.setOpaque(false);
        jPanel.add(component, "West");
        jPanel.add((Component)serializable, "Center");
        serializable = new GridLayout(0, 1, 0, 1);
        component = new JPanel();
        ((Container)component).setLayout((LayoutManager)((Object)serializable));
        ((JComponent)component).setOpaque(false);
        for (int i = 0; i < 16; ++i) {
            String string2 = Integer.toHexString(i) + "0";
            string = string2.toUpperCase();
            object = new JLabel();
            ((JLabel)object).setText(string);
            ((JComponent)object).setFont(RJComFont.buttonFont);
            ((JLabel)object).setHorizontalAlignment(4);
            ((JComponent)object).setBorder(border);
            ((JComponent)object).setPreferredSize(dimension);
            ((Container)component).add((Component)object);
        }
        Serializable serializable2 = new GridLayout(0, 16, 1, 1);
        serializable = new JPanel();
        ((Container)serializable).setLayout((LayoutManager)((Object)serializable2));
        ((JComponent)serializable).setOpaque(false);
        for (n = 0; n < 16; ++n) {
            for (int i = 0; i < 16; ++i) {
                int n2 = n * 16 + i;
                jComponent = new LDEVTile(n2);
                jComponent.setPreferredSize(dimension2);
                jComponent.addMouseListener(mouseAdapter);
                ((Container)serializable).add(jComponent);
            }
        }
        serializable2 = Color.LIGHT_GRAY;
        this.setLayout(this.defaultLayout);
        this.setBackground((Color)serializable2);
        this.add((Component)jPanel, "North");
        this.add(component, "West");
        this.add((Component)serializable, "Center");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static interface TileSelectedListener
    extends EventListener {
        public void tileSelected(TileSelectedEvent var1);
    }

    public static final class TileSelectedEvent
    extends EventObject {
        private TileSelectedEvent(LDEVTile lDEVTile) {
            super(lDEVTile);
        }

        public int getLDEVIndex() {
            LDEVTile lDEVTile = (LDEVTile)this.getSource();
            int n = lDEVTile.getIndex();
            return n;
        }
    }

    public final class LDEVTile
    extends JComponent {
        private int index;

        private LDEVTile(int n) {
            this.index = n;
        }

        public Cursor getCursor() {
            Cursor cursor = LDEVMapPanel.this.invalidCursor;
            if (LDEVMapPanel.this.isOperationEnabled() && !this.isSelected() && this.isUsable()) {
                cursor = LDEVMapPanel.this.validCursor;
            }
            return cursor;
        }

        public int getIndex() {
            int n = this.index;
            return n;
        }

        public boolean isSelected() {
            int n = Arrays.binarySearch(LDEVMapPanel.this.selectedIndexes, this.index);
            boolean bl = n >= 0;
            return bl;
        }

        public boolean isUsable() {
            boolean bl;
            try {
                bl = LDEVMapPanel.this.usableMap[this.index];
            }
            catch (Exception exception) {
                bl = false;
            }
            return bl;
        }

        protected void paintComponent(Graphics graphics) {
            Color color = LDEVMapPanel.this.unusableColor;
            if (this.isSelected()) {
                color = LDEVMapPanel.this.selectedColor;
            } else if (this.isUsable()) {
                color = LDEVMapPanel.this.usableColor;
            }
            int n = this.getWidth();
            int n2 = this.getHeight();
            graphics.setColor(color);
            graphics.fillRect(0, 0, n, n2);
            Border border = this.getBorder();
            if (border != null) {
                border.paintBorder(this, graphics, 0, 0, n, n2);
            }
        }
    }
}

