/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.monitor.com;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;
import sanproject.client.com.RJcButton;
import sanproject.client.com.RJcConst;
import sanproject.client.com.RJcMainTitlePanel;
import sanproject.client.com.RJcTabPanel;
import sanproject.client.monitor.com.RJHihDataSupplier;
import sanproject.client.monitor.com.RJHihDef;
import sanproject.client.monitor.com.RJHihSuperException;

public abstract class RJHihBasePanel
extends RJcTabPanel
implements RJHihDef {
    private RJcMainTitlePanel titlePanel;
    protected RJHihDataSupplier supplier;
    protected ActionListener listener;
    public static final int RIGHT = 0;
    public static final int LEFT = 1;
    private Vector buttonVector = null;
    private JLabel dummyLabel;
    private int dummyPosition = 0;
    private JPanel bottomPanel = null;
    private Border bottomBorder = BorderFactory.createEmptyBorder(2, 0, 2, 0);
    private GridBagLayout bottomPanelLayout;
    private String title = "???";
    private Color border = null;

    public RJHihBasePanel(RJHihDataSupplier rJHihDataSupplier) {
        this(rJHihDataSupplier, null);
    }

    public RJHihBasePanel(RJHihDataSupplier rJHihDataSupplier, ActionListener actionListener) {
        this.supplier = rJHihDataSupplier;
        this.listener = actionListener;
    }

    protected void initialize() {
        BorderLayout borderLayout = new BorderLayout();
        borderLayout.setHgap(8);
        borderLayout.setVgap(4);
        this.setLayout(borderLayout);
        String string = this.getWindowName();
        if (string != null) {
            this.setBackground(this.getBgColor(this.getWindowKey()));
        }
        this.titlePanel = new RJcMainTitlePanel(this.getWindowKey());
        this.add((Component)this.titlePanel, "North");
    }

    public abstract String getWindowName();

    public String getMainTitle() {
        return this.titlePanel.getMainTitle();
    }

    public void setMainTitle(String string) {
        this.titlePanel.setMainTitle(string);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public void addExtra(JPanel jPanel) {
        this.titlePanel.addExtra(jPanel);
    }

    public void addExtra2(JPanel jPanel) {
        this.titlePanel.addExtra2(jPanel);
    }

    public Insets getInsets() {
        return new Insets(4, 4, 4, 4);
    }

    public void setEnabled(JTabbedPane jTabbedPane) {
    }

    public void setPartner(Component component) {
    }

    public void setEnabledTopFrame(boolean bl) {
        this.supplier.putLog("[Monitor]", "[BasePanel]", "setEnabledTopFrame(" + bl + ")");
        if (!bl) {
            this.supplier.waitCursor(this);
            this.supplier.disableWindow();
        } else {
            this.supplier.defaultCursor(this);
        }
    }

    protected void managementEndEvent() {
        try {
            super.managementEndEvent();
        }
        catch (RJHihSuperException rJHihSuperException) {
            System.out.println("RJHihBasePanel(managementEndEvent):catch RJHihSuperException ");
        }
    }

    public JButton newButton(String string) {
        RJcButton rJcButton = new RJcButton(string);
        rJcButton.setFont(RJcConst.boldFont);
        rJcButton.setActionCommand(string);
        rJcButton.setName(string);
        Dimension dimension = rJcButton.getPreferredSize();
        dimension.height = 24;
        if (dimension.width < 80) {
            dimension.width = 80;
        }
        rJcButton.setPreferredSize(new Dimension(dimension.width, dimension.height));
        rJcButton.setMinimumSize(new Dimension(dimension.width, dimension.height));
        return rJcButton;
    }

    public void addButton(JButton jButton, int n) {
        if (this.buttonVector == null) {
            this.buttonVector = new Vector();
            this.dummyLabel = new JLabel();
            this.buttonVector.add(this.dummyLabel);
        }
        if (n == 0) {
            this.buttonVector.add(jButton);
        } else if (n == 1) {
            this.buttonVector.add(this.dummyPosition, jButton);
            ++this.dummyPosition;
        }
    }

    public void buttonCreate() {
        if (this.bottomPanel == null) {
            this.bottomPanel = new JPanel();
            this.bottomPanelLayout = new GridBagLayout();
            this.bottomPanel.setLayout(this.bottomPanelLayout);
            this.bottomPanel.setBorder(this.bottomBorder);
            this.bottomPanel.setOpaque(false);
            Enumeration enumeration = this.buttonVector.elements();
            int n = 0;
            while (enumeration.hasMoreElements()) {
                Component component = (Component)enumeration.nextElement();
                this.bottomPanel.add(component, this.getConstraints(component, n));
                ++n;
            }
            this.add((Component)this.bottomPanel, "South");
        }
    }

    private GridBagConstraints getConstraints(Component component, int n) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = component instanceof JButton ? 0.0 : 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, n == 0 ? 0 : 8, 0, 0);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        return gridBagConstraints;
    }

    public void showApplyEndMsg() {
        this.setEnabledTopFrame(true);
        this.supplier.showMessage();
        this.supplier.paraShowApplyEndMsg();
        if (this.m_DataControl != null) {
            super.showApplyEndMsg();
        }
        this.supplier.hideMessage();
    }
}

