/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.openldevguard.gui.main;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import sanproject.client.com.RJComDialog;
import sanproject.client.data.RJDataMsg;
import sanproject.client.openldevguard.color.ColorManager;
import sanproject.client.openldevguard.com.KeyEventReceiver;
import sanproject.client.openldevguard.com.KeyEventTransferable;
import sanproject.client.openldevguard.com.StandardButton;
import sanproject.client.openldevguard.com.TableSortedListener;
import sanproject.client.openldevguard.font.FontManager;
import sanproject.client.openldevguard.gui.ComponentFactory;
import sanproject.client.openldevguard.gui.ComponentUtilities;
import sanproject.client.openldevguard.gui.OpenLDEVGuardException;
import sanproject.client.openldevguard.gui.OpenLDEVGuardProperties;
import sanproject.client.openldevguard.gui.SortKindTableHeader;
import sanproject.client.openldevguard.gui.logging.Logger;
import sanproject.client.openldevguard.gui.main.ErrorInformationTableModel;
import sanproject.client.openldevguard.gui.main.ErrorInformationWrapper;
import sanproject.client.openldevguard.gui.main.OpenLDEVGuardDataControlWrapper;
import sanproject.client.openldevguard.gui.main.RequestFocusAtNextPageButtonShortcutKey;
import sanproject.client.openldevguard.gui.main.RequestFocusAtPreviousPageButtonShortcutKey;
import sanproject.client.openldevguard.gui.main.ShortcutKey;
import sanproject.client.openldevguard.gui.main.ShortcutKeySupport;
import sanproject.client.openldevguard.gui.main.StandardComponentFactory;
import sanproject.client.openldevguard.gui.main.TableDataItem;
import sanproject.client.openldevguard.gui.main.TableDataItemTableCellRenderer;
import sanproject.client.openldevguard.gui.main.ViewDefine;
import sanproject.client.openldevguard.icon.IconManager;

class ErrorInformationDialogPanel
extends JPanel
implements KeyEventReceiver,
ShortcutKeySupport {
    private static final String MODULE_NAME = "ErrorInformation";
    private Set msetShortcutKeys;
    private OpenLDEVGuardDataControlWrapper mdcwWrapper;
    private JTable mtblErrorTable;
    private ErrorInformationTableModel mtamTableModel;
    private JButton mbtnDialogClose;
    private JButton mbtnPreviousPage;
    private JButton mbtnNextPage;
    static /* synthetic */ Class class$sanproject$client$openldevguard$gui$main$TableDataItem;
    static /* synthetic */ Class class$java$awt$Dialog;

    ErrorInformationDialogPanel(OpenLDEVGuardDataControlWrapper openLDEVGuardDataControlWrapper) {
        this.mdcwWrapper = openLDEVGuardDataControlWrapper;
        this.msetShortcutKeys = new HashSet();
        ContainerListener containerListener = new ContainerListener(){

            public void componentAdded(ContainerEvent containerEvent) {
                ErrorInformationDialogPanel.this.addComponent(containerEvent);
            }

            public void componentRemoved(ContainerEvent containerEvent) {
                ErrorInformationDialogPanel.this.removeComponent(containerEvent);
            }
        };
        this.addContainerListener(containerListener);
        ComponentFactory componentFactory = StandardComponentFactory.getComponentFactory();
        Object object = new TableDataItemTableCellRenderer();
        Object object2 = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                Point point;
                int n;
                JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
                Rectangle rectangle = jTableHeader.getHeaderRect(n = jTableHeader.columnAtPoint(point = mouseEvent.getPoint()));
                Rectangle rectangle2 = ComponentUtilities.getClickableRectangle(rectangle);
                if (rectangle2.contains(point)) {
                    ErrorInformationDialogPanel.this.requestTableSort(n);
                }
            }
        };
        Object object3 = ViewDefine.isSupportSortKindHeader() ? new SortKindTableHeader() : new JTableHeader();
        ((Component)object3).addMouseListener((MouseListener)object2);
        ((JTableHeader)object3).setReorderingAllowed(false);
        ComponentUtilities.supportMouseClick((JTableHeader)object3);
        this.mtamTableModel = new ErrorInformationTableModel(openLDEVGuardDataControlWrapper);
        if (object3 instanceof TableSortedListener) {
            object2 = (TableSortedListener)object3;
            this.mtamTableModel.addTableSortedListener((TableSortedListener)object2);
        }
        this.mtblErrorTable = componentFactory.createTable();
        this.mtblErrorTable.setDefaultRenderer(class$sanproject$client$openldevguard$gui$main$TableDataItem == null ? (class$sanproject$client$openldevguard$gui$main$TableDataItem = ErrorInformationDialogPanel.class$("sanproject.client.openldevguard.gui.main.TableDataItem")) : class$sanproject$client$openldevguard$gui$main$TableDataItem, (TableCellRenderer)object);
        this.mtblErrorTable.setTableHeader((JTableHeader)object3);
        this.mtblErrorTable.setModel(this.mtamTableModel);
        object2 = this.mtblErrorTable.getColumnModel();
        ((JTableHeader)object3).setColumnModel((TableColumnModel)object2);
        int n = 2;
        Object object4 = this.mtblErrorTable.getSelectionModel();
        object4.setSelectionMode(n);
        ComponentUtilities.supportRightClickSelection(this.mtblErrorTable);
        ComponentUtilities.supportRepaintWhenFocusMoved(this.mtblErrorTable);
        object = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ErrorInformationDialogPanel.this.doButtonAction(actionEvent);
            }
        };
        object3 = "COMMON/Close";
        object2 = openLDEVGuardDataControlWrapper.getGuidanceString((String)object3);
        object4 = openLDEVGuardDataControlWrapper.getGuidanceColor((String)object3);
        this.mbtnDialogClose = componentFactory.createButton((String)object2);
        this.mbtnDialogClose.addActionListener((ActionListener)object);
        this.mbtnDialogClose.setForeground((Color)object4);
        object = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ErrorInformationDialogPanel.this.doButtonAction(actionEvent);
            }
        };
        object3 = IconManager.getInstance();
        object2 = ((IconManager)object3).getIcon("pup.gif");
        object4 = new Dimension(10, 10);
        this.mbtnPreviousPage = new StandardButton();
        this.mbtnPreviousPage.addActionListener((ActionListener)object);
        this.mbtnPreviousPage.setPreferredSize((Dimension)object4);
        this.mbtnPreviousPage.setFocusPainted(false);
        this.mbtnPreviousPage.setMargin(new Insets(1, 1, 1, 1));
        this.mbtnPreviousPage.setVerticalAlignment(3);
        this.mbtnPreviousPage.setVisible(false);
        this.mbtnPreviousPage.setIcon((Icon)object2);
        object = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ErrorInformationDialogPanel.this.doButtonAction(actionEvent);
            }
        };
        object3 = IconManager.getInstance();
        object2 = ((IconManager)object3).getIcon("pdown.gif");
        object4 = new Dimension(10, 10);
        this.mbtnNextPage = new StandardButton();
        this.mbtnNextPage.addActionListener((ActionListener)object);
        this.mbtnNextPage.setPreferredSize((Dimension)object4);
        this.mbtnNextPage.setFocusPainted(false);
        this.mbtnNextPage.setMargin(new Insets(1, 1, 1, 1));
        this.mbtnNextPage.setVerticalAlignment(3);
        this.mbtnNextPage.setVisible(false);
        this.mbtnNextPage.setIcon((Icon)object2);
        object = new RequestFocusAtPreviousPageButtonShortcutKey();
        this.addShortcutKey((ShortcutKey)object);
        object = new RequestFocusAtNextPageButtonShortcutKey();
        this.addShortcutKey((ShortcutKey)object);
        this.buildPanelLayout();
        object = new Runnable(){

            public void run() {
                try {
                    ErrorInformationDialogPanel.this.mtamTableModel.initializeData();
                    ErrorInformationDialogPanel.this.loadColumnWidths();
                    ErrorInformationDialogPanel.this.adjustmentColumnWidth();
                    ErrorInformationDialogPanel.this.setPageButtonVisible();
                }
                catch (OpenLDEVGuardException openLDEVGuardException) {
                    ErrorInformationDialogPanel.this.processException(openLDEVGuardException);
                }
            }
        };
        SwingUtilities.invokeLater((Runnable)object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void keyEventReceived(KeyEventTransferable keyEventTransferable, KeyEvent keyEvent) {
        Set set;
        int n = keyEvent.getKeyCode();
        int n2 = keyEvent.getModifiers();
        String string = KeyEvent.getKeyText(n);
        String string2 = KeyEvent.getKeyModifiersText(n2);
        Logger.put(Level.FINEST, MODULE_NAME, "    keyEventReceived()    [" + string2 + " + " + string + "]");
        Object object = this.msetShortcutKeys;
        synchronized (object) {
            set = Collections.synchronizedSet(this.msetShortcutKeys);
        }
        object = set.iterator();
        while (object.hasNext() && !keyEvent.isConsumed()) {
            ShortcutKey shortcutKey = (ShortcutKey)object.next();
            shortcutKey.keyEventHappened(this, keyEvent);
        }
    }

    public final Set getShortcutKeys() {
        HashSet hashSet = new HashSet(this.msetShortcutKeys);
        return hashSet;
    }

    public final void addShortcutKey(ShortcutKey shortcutKey) {
        Logger.put(Level.FINEST, MODULE_NAME, "add shortcut key. [" + shortcutKey + "]");
        this.msetShortcutKeys.add(shortcutKey);
    }

    public final void removeShortcutKey(ShortcutKey shortcutKey) {
        Logger.put(Level.FINEST, MODULE_NAME, "remove shortcut key. [" + shortcutKey + "]");
        this.msetShortcutKeys.remove(shortcutKey);
    }

    private void addComponent(ContainerEvent containerEvent) {
        Component component = containerEvent.getChild();
        if (component instanceof KeyEventTransferable) {
            KeyEventTransferable keyEventTransferable = (KeyEventTransferable)((Object)component);
            keyEventTransferable.addKeyEventReceiver(this);
        }
    }

    private void removeComponent(ContainerEvent containerEvent) {
        Object object;
        Component component = containerEvent.getChild();
        if (component instanceof KeyEventTransferable) {
            object = (KeyEventTransferable)((Object)component);
            object.removeKeyEventReceiver(this);
        }
        if (component instanceof Container) {
            object = (Container)component;
            ((Container)object).removeAll();
        }
    }

    private void buildPanelLayout() {
        ComponentFactory componentFactory = StandardComponentFactory.getComponentFactory();
        Object object = this.mdcwWrapper.getGuidanceString("COMMON/ErrorDetail");
        JPanel jPanel = ComponentUtilities.buildTitlePanel(componentFactory, (String)object);
        object = new BorderLayout(4, 4);
        JPanel jPanel2 = componentFactory.createPanel();
        jPanel2.setLayout((LayoutManager)object);
        jPanel2.setOpaque(false);
        jPanel2.add((Component)jPanel, "West");
        Object object2 = new Dimension(600, 260);
        object = componentFactory.createScrollPane(this.mtblErrorTable);
        ((JComponent)object).setPreferredSize((Dimension)object2);
        ((JScrollPane)object).setHorizontalScrollBarPolicy(30);
        ((JScrollPane)object).setVerticalScrollBarPolicy(22);
        ((JScrollPane)object).setCorner("UPPER_RIGHT_CORNER", this.mbtnPreviousPage);
        ((JScrollPane)object).setCorner("LOWER_RIGHT_CORNER", this.mbtnNextPage);
        ComponentUtilities.decorateTransparentViewport((JScrollPane)object);
        ComponentUtilities.decorateInputAreaBorder((JComponent)object);
        object2 = new BorderLayout(4, 4);
        jPanel = componentFactory.createPanel();
        jPanel.setLayout((LayoutManager)object2);
        jPanel.setOpaque(false);
        jPanel.add((Component)object, "Center");
        Serializable serializable = new GridLayout(1, 0, 4, 4);
        object2 = componentFactory.createPanel();
        ((Container)object2).setLayout((LayoutManager)((Object)serializable));
        ((JComponent)object2).setOpaque(false);
        ((Container)object2).add(this.mbtnDialogClose);
        ComponentUtilities.decorateInputAreaMarginBorder((JComponent)object2);
        serializable = new BorderLayout(4, 4);
        object = componentFactory.createPanel();
        ((Container)object).setLayout((LayoutManager)((Object)serializable));
        ((JComponent)object).setOpaque(false);
        ((Container)object).add((Component)object2, "East");
        object2 = ColorManager.getInstance();
        serializable = ((ColorManager)object2).getPanelBackground();
        BorderLayout borderLayout = new BorderLayout(4, 4);
        this.setLayout(borderLayout);
        this.setOpaque(true);
        this.setBackground((Color)serializable);
        this.add((Component)jPanel2, "North");
        this.add((Component)jPanel, "Center");
        this.add((Component)object, "South");
        ComponentUtilities.decoratePanelAreaMarginBorder(this);
    }

    private void loadColumnWidths() {
        TableColumnModel tableColumnModel = this.mtblErrorTable.getColumnModel();
        int n = tableColumnModel.getColumnCount();
        Logger.put(Level.FINER, MODULE_NAME, "load column widths.");
        for (int i = 0; i < n; ++i) {
            String string = this.mtamTableModel.getColumnID(i);
            if (string == null) continue;
            String string2 = "columnwidth_" + string;
            String string3 = OpenLDEVGuardProperties.getProperty(string2);
            int n2 = 75;
            try {
                n2 = Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                String string4 = String.valueOf(n2);
                OpenLDEVGuardProperties.setProperty(string2, string4);
            }
            Logger.put(Level.FINEST, MODULE_NAME, "    " + string2 + " => " + n2);
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            tableColumn.setPreferredWidth(n2);
        }
    }

    private void saveColumnWidths() {
        TableColumnModel tableColumnModel = this.mtblErrorTable.getColumnModel();
        int n = tableColumnModel.getColumnCount();
        Logger.put(Level.FINER, MODULE_NAME, "save column widths.");
        for (int i = 0; i < n; ++i) {
            String string = this.mtamTableModel.getColumnID(i);
            if (string == null) continue;
            String string2 = "columnwidth_" + string;
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            int n2 = tableColumn.getPreferredWidth();
            String string3 = String.valueOf(n2);
            OpenLDEVGuardProperties.setProperty(string2, string3);
            Logger.put(Level.FINEST, MODULE_NAME, "    " + string2 + " <= " + n2);
        }
    }

    protected void adjustmentColumnWidth() {
        Object object;
        Object object2;
        Object object3;
        int n;
        int n2;
        FontManager fontManager = FontManager.getInstance();
        Font font = fontManager.getNormalFont();
        FontMetrics fontMetrics = this.getFontMetrics(font);
        int n3 = 1;
        String string = this.mtamTableModel.getColumnID(n3);
        String string2 = "columnwidth_" + string;
        String string3 = OpenLDEVGuardProperties.getProperty(string2);
        try {
            n2 = Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            n2 = 75;
        }
        int n4 = this.mtamTableModel.getRowCount();
        for (n = 0; n < n4; ++n) {
            String string4;
            int n5;
            object3 = (TableDataItem)this.mtamTableModel.getValueAt(n, 0);
            object2 = (ErrorInformationWrapper)object3.getReferencedObject();
            if (object2 == null || n2 >= (n5 = fontMetrics.stringWidth(string4 = ((RJDataMsg)(object = object2.getErrorMessage())).getMessage()))) continue;
            n2 = n5;
        }
        n = n2 + 20;
        object3 = this.mtblErrorTable.getColumnModel();
        object2 = object3.getColumn(n3);
        ((TableColumn)object2).setPreferredWidth(n);
        object = String.valueOf(n);
        OpenLDEVGuardProperties.setProperty(string2, (String)object);
    }

    private void setPageButtonVisible() {
        boolean bl = this.mtamTableModel.hasPreviousPage();
        this.mbtnPreviousPage.setVisible(bl);
        bl = this.mtamTableModel.hasNextPage();
        this.mbtnNextPage.setVisible(bl);
    }

    private void doButtonAction(ActionEvent actionEvent) {
        Dialog dialog;
        Object object = actionEvent.getSource();
        if (object.equals(this.mbtnPreviousPage)) {
            Logger.put(Level.FINE, MODULE_NAME, "request show previous page.");
            if (this.mtamTableModel.hasPreviousPage()) {
                this.mtamTableModel.changePreviousPage();
                this.setPageButtonVisible();
                int n = this.mtamTableModel.getRowCount();
                Rectangle rectangle = this.mtblErrorTable.getCellRect(n, 0, true);
                this.mtblErrorTable.scrollRectToVisible(rectangle);
            } else {
                Logger.put(Level.FINE, MODULE_NAME, "has not previous page.");
            }
        } else if (object.equals(this.mbtnNextPage)) {
            Logger.put(Level.FINE, MODULE_NAME, "request show next page.");
            if (this.mtamTableModel.hasNextPage()) {
                this.mtamTableModel.changeNextPage();
                this.setPageButtonVisible();
                Rectangle rectangle = this.mtblErrorTable.getCellRect(0, 0, true);
                this.mtblErrorTable.scrollRectToVisible(rectangle);
            } else {
                Logger.put(Level.FINE, MODULE_NAME, "has not next page.");
            }
        } else if (object.equals(this.mbtnDialogClose) && (dialog = (Dialog)SwingUtilities.getAncestorOfClass(class$java$awt$Dialog == null ? (class$java$awt$Dialog = ErrorInformationDialogPanel.class$("java.awt.Dialog")) : class$java$awt$Dialog, this)) != null) {
            this.saveColumnWidths();
            this.removeAll();
            dialog.dispose();
        }
    }

    private void requestTableSort(int n) {
        Cursor cursor = new Cursor(3);
        Cursor cursor2 = new Cursor(0);
        this.setCursor(cursor);
        this.mtamTableModel.requestSort(n);
        this.setCursor(cursor2);
    }

    final void requestFocusAtPreviousPageButton() {
        if (this.mbtnPreviousPage.isVisible()) {
            this.mbtnPreviousPage.requestFocus();
        }
    }

    final void requestFocusAtNextPageButton() {
        if (this.mbtnNextPage.isVisible()) {
            this.mbtnNextPage.requestFocus();
        }
    }

    private void processException(OpenLDEVGuardException openLDEVGuardException) {
        RJDataMsg rJDataMsg = openLDEVGuardException.getMessageObject();
        String string = rJDataMsg.getMessage();
        Throwable throwable = openLDEVGuardException.getCause();
        if (throwable != null) {
            string = string + "[" + throwable.getMessage() + "]";
        }
        Logger.put(Level.SEVERE, MODULE_NAME, string);
        Object[] objectArray = new Object[]{this.mdcwWrapper.getGuidanceString("COMMON/OK")};
        RJComDialog.show(this, rJDataMsg, 0, objectArray, objectArray[0]);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

