/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.ppkey;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import sanproject.client.com.RJCom;
import sanproject.client.com.RJComDialog;
import sanproject.client.com.RJComFont;
import sanproject.client.com.RJComUty;
import sanproject.client.com.RJIconTBL;
import sanproject.client.data.RJDataControl;
import sanproject.client.data.RJDataMsg;
import sanproject.client.openldevguard.com.StandardPanel;
import sanproject.client.openldevguard.gui.ComponentFactory;
import sanproject.client.openldevguard.gui.ComponentUtilities;
import sanproject.client.ppkey.DefaultComponentFactory;
import sanproject.client.ppkey.LicenseCounterWrapperList;
import sanproject.client.ppkey.LicenseListTableCellRenderer;
import sanproject.client.ppkey.LicenseListTableModel;
import sanproject.client.ppkey.RJPPKeyGuidance;
import sanproject.client.ppkey.RJPPKeyInfoClass;
import sanproject.serverux.dataimpl.PPKgetKeyBasic;

public class LicenseListPanel
extends StandardPanel {
    public static final OperationState NONE_EDIT = new OperationState("none edit");
    public static final OperationState EDITED = new OperationState("edited");
    private boolean editable;
    private OperationState operationState;
    private RJDataControl controller;
    private RJPPKeyGuidance guidance;
    private RJPPKeyInfoClass ppInfo;
    private JLabel productNameLabel;
    private JLabel totalCapacityLabel;
    private JTable licenseListTable;
    private JSpinner capacitySpinner;
    private JButton setButton;
    private JButton resetButton;
    private JButton applyButton;
    private JButton cancelButton;
    private LicenseListTableModel licenseTableModel;
    private SpinnerNumberModel capacitySpinnerModel;
    private LicenseCounterWrapperList wrapperList;
    private final boolean beforeModify;

    public LicenseListPanel(RJDataControl rJDataControl, RJPPKeyGuidance rJPPKeyGuidance, RJPPKeyInfoClass rJPPKeyInfoClass, boolean bl) {
        this.controller = rJDataControl;
        this.guidance = rJPPKeyGuidance;
        this.ppInfo = rJPPKeyInfoClass;
        this.editable = bl;
        this.operationState = NONE_EDIT;
        this.productNameLabel = null;
        this.totalCapacityLabel = null;
        this.licenseListTable = null;
        this.capacitySpinner = null;
        this.setButton = null;
        this.resetButton = null;
        this.applyButton = null;
        this.cancelButton = null;
        this.licenseTableModel = null;
        this.capacitySpinnerModel = null;
        ArrayList arrayList = null;
        if (rJPPKeyInfoClass != null) {
            arrayList = rJPPKeyInfoClass.counterList;
        }
        this.wrapperList = new LicenseCounterWrapperList(arrayList);
        this.beforeModify = this.wrapperList.isModified();
        this.putLog("initialize panel. (editable=" + this.editable + ")");
        this.initialzePanel();
        this.buildPanelLayout();
        this.loadColumnWidthds();
        this.updateTotalCapacity();
        this.updateOperationState();
    }

    public void addNotify() {
        super.addNotify();
        final JDialog jDialog = (JDialog)SwingUtilities.getAncestorOfClass(Window.class, this);
        if (jDialog != null) {
            AbstractAction abstractAction = new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    WindowEvent windowEvent = new WindowEvent(jDialog, 201);
                    jDialog.dispatchEvent(windowEvent);
                }
            };
            KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
            JRootPane jRootPane = jDialog.getRootPane();
            InputMap inputMap = jRootPane.getInputMap();
            inputMap.put(keyStroke, "window_escape");
            ActionMap actionMap = jRootPane.getActionMap();
            actionMap.put("window_escape", abstractAction);
        }
    }

    public final boolean isCapacityEditable() {
        boolean bl = this.editable;
        return bl;
    }

    public final OperationState getOperationState() {
        OperationState operationState = this.operationState;
        return operationState;
    }

    public final LicenseCounterWrapperList getChangedWrapperList() {
        LicenseCounterWrapperList licenseCounterWrapperList = null;
        OperationState operationState = this.getOperationState();
        if (operationState.equals(EDITED)) {
            licenseCounterWrapperList = this.wrapperList;
        }
        return licenseCounterWrapperList;
    }

    private void initialzePanel() {
        DefaultComponentFactory defaultComponentFactory = new DefaultComponentFactory(this.guidance);
        Object object = this.isInstalledProduct() ? RJIconTBL.getIcon(102) : RJIconTBL.getIcon(103);
        Object object2 = this.ppInfo.m_strPPName;
        this.productNameLabel = defaultComponentFactory.createLabel();
        this.productNameLabel.setIcon((Icon)object);
        this.productNameLabel.setText((String)object2);
        this.totalCapacityLabel = defaultComponentFactory.createLabel();
        this.totalCapacityLabel.setHorizontalAlignment(4);
        object = new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                LicenseListPanel.this.licenseSelectionChanged();
            }
        };
        this.licenseTableModel = new LicenseListTableModel(this.guidance, this.wrapperList);
        object2 = new LicenseListTableCellRenderer();
        this.licenseListTable = defaultComponentFactory.createTable();
        this.licenseListTable.setAutoResizeMode(0);
        this.licenseListTable.setCellSelectionEnabled(false);
        this.licenseListTable.setColumnSelectionAllowed(false);
        this.licenseListTable.setDefaultRenderer(Integer.class, (TableCellRenderer)object2);
        this.licenseListTable.setDragEnabled(false);
        this.licenseListTable.setForeground(Color.BLACK);
        this.licenseListTable.setRowSelectionAllowed(true);
        this.licenseListTable.setSelectionMode(0);
        this.licenseListTable.setModel(this.licenseTableModel);
        Object object3 = this.licenseListTable.getSelectionModel();
        object3.addListSelectionListener((ListSelectionListener)object);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                Point point;
                int n;
                JTableHeader jTableHeader;
                Rectangle rectangle;
                Rectangle rectangle2;
                if (!mouseEvent.isPopupTrigger() && (rectangle2 = ComponentUtilities.getClickableRectangle(rectangle = (jTableHeader = (JTableHeader)mouseEvent.getSource()).getHeaderRect(n = jTableHeader.columnAtPoint(point = mouseEvent.getPoint())))).contains(point)) {
                    LicenseListPanel.this.licenseTableModel.setSortAt(n);
                }
            }
        };
        JTableHeader jTableHeader = this.licenseListTable.getTableHeader();
        jTableHeader.addMouseListener(mouseAdapter);
        jTableHeader.setReorderingAllowed(false);
        object = RJComFont.itemFont;
        object2 = new Integer(0);
        this.capacitySpinnerModel = new SpinnerNumberModel();
        this.capacitySpinnerModel.setMinimum((Comparable<?>)object2);
        this.capacitySpinner = new JSpinner();
        this.capacitySpinner.setModel(this.capacitySpinnerModel);
        this.capacitySpinner.setEnabled(false);
        this.capacitySpinner.setFont((Font)object);
        object = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LicenseListPanel.this.clickSetButton();
            }
        };
        object2 = this.guidance.setButton.getGuidance();
        object3 = this.guidance.setButton.getColor();
        this.setButton = defaultComponentFactory.createButton();
        this.setButton.setText((String)object2);
        this.setButton.setEnabled(false);
        this.setButton.setForeground((Color)object3);
        this.setButton.addActionListener((ActionListener)object);
        object = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LicenseListPanel.this.clickResetButton();
            }
        };
        object2 = this.guidance.resetButton.getGuidance();
        object3 = this.guidance.resetButton.getColor();
        this.resetButton = defaultComponentFactory.createButton();
        this.resetButton.setText((String)object2);
        this.resetButton.setEnabled(false);
        this.resetButton.setForeground((Color)object3);
        this.resetButton.addActionListener((ActionListener)object);
        object = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LicenseListPanel.this.clickApplyButton();
            }
        };
        object2 = this.guidance.okButton.getGuidance();
        object3 = this.guidance.okButton.getColor();
        this.applyButton = defaultComponentFactory.createButton();
        this.applyButton.setText((String)object2);
        this.applyButton.setForeground((Color)object3);
        this.applyButton.addActionListener((ActionListener)object);
        object = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LicenseListPanel.this.clickCancelButton();
            }
        };
        object2 = this.guidance.CANCELBTN.getGuidance();
        object3 = this.guidance.CANCELBTN.getColor();
        this.cancelButton = defaultComponentFactory.createButton();
        this.cancelButton.setText((String)object2);
        this.cancelButton.setForeground((Color)object3);
        this.cancelButton.addActionListener((ActionListener)object);
    }

    private void buildPanelLayout() {
        DefaultComponentFactory defaultComponentFactory = new DefaultComponentFactory(this.guidance);
        Object object = this.isCapacityEditable() ? this.guidance.portableListTitle.getGuidance() : this.guidance.licenseListTitle.getGuidance();
        Serializable serializable = new Dimension(12, 24);
        Serializable serializable2 = new Color(0, 0, 153);
        JPanel jPanel = defaultComponentFactory.createPanel();
        jPanel.setOpaque(true);
        jPanel.setBackground((Color)serializable2);
        jPanel.setPreferredSize((Dimension)serializable);
        serializable2 = RJComFont.ppTitleFont;
        Object object2 = Color.BLACK;
        serializable = defaultComponentFactory.createLabel((String)object);
        ((JComponent)serializable).setFont((Font)serializable2);
        ((JComponent)serializable).setForeground((Color)object2);
        serializable2 = new BorderLayout(8, 0);
        JPanel jPanel2 = defaultComponentFactory.createPanel();
        jPanel2.setLayout((LayoutManager)((Object)serializable2));
        jPanel2.setOpaque(false);
        jPanel2.add((Component)jPanel, "West");
        jPanel2.add((Component)serializable, "Center");
        serializable2 = new Dimension(503, 104);
        serializable = defaultComponentFactory.createScrollPane(this.licenseListTable);
        ((JScrollPane)serializable).setVerticalScrollBarPolicy(22);
        ((JComponent)serializable).setPreferredSize((Dimension)serializable2);
        object2 = new BorderLayout(5, 3);
        serializable2 = defaultComponentFactory.createPanel();
        ((Container)serializable2).setLayout((LayoutManager)object2);
        ((JComponent)serializable2).setOpaque(true);
        ((JComponent)serializable2).setBackground(Color.WHITE);
        ((Container)serializable2).add(this.productNameLabel, "West");
        ((Container)serializable2).add(this.totalCapacityLabel, "East");
        ComponentUtilities.decorateInformationAreaBorder((JComponent)serializable2);
        object2 = new BorderLayout();
        jPanel = defaultComponentFactory.createPanel();
        jPanel.setLayout((LayoutManager)object2);
        jPanel.setOpaque(false);
        jPanel.add((Component)serializable, "Center");
        jPanel.add((Component)serializable2, "South");
        ComponentUtilities.decorateInputAreaBorder(jPanel);
        object2 = this.guidance.changeNumberLabel.getGuidance();
        serializable2 = ComponentUtilities.buildListTitleComponent(defaultComponentFactory, (String)object2);
        LayoutManager layoutManager = new GridLayout(1, 0, 5, 3);
        JPanel jPanel3 = defaultComponentFactory.createPanel();
        jPanel3.setLayout(layoutManager);
        jPanel3.setOpaque(false);
        jPanel3.add(this.capacitySpinner);
        jPanel3.add(this.setButton);
        layoutManager = new BorderLayout();
        Serializable serializable3 = defaultComponentFactory.createPanel();
        serializable3.setLayout(layoutManager);
        serializable3.setOpaque(false);
        serializable3.add(jPanel3, "West");
        object2 = ComponentUtilities.buildListValueComponent((ComponentFactory)defaultComponentFactory, serializable3);
        serializable3 = new BorderLayout(5, 3);
        serializable = defaultComponentFactory.createPanel();
        ((Container)serializable).setLayout((LayoutManager)((Object)serializable3));
        ((JComponent)serializable).setOpaque(false);
        ((Container)serializable).add((Component)serializable2, "West");
        ((Container)serializable).add((Component)object2, "Center");
        serializable2 = new BorderLayout(5, 8);
        object = defaultComponentFactory.createPanel();
        ((Container)object).setLayout((LayoutManager)((Object)serializable2));
        ((JComponent)object).setOpaque(false);
        ((Container)object).add((Component)jPanel, "Center");
        if (this.isCapacityEditable()) {
            ((Container)object).add((Component)serializable, "South");
        }
        serializable2 = new GridLayout(1, 0, 5, 3);
        serializable = defaultComponentFactory.createPanel();
        ((Container)serializable).setLayout((LayoutManager)((Object)serializable2));
        ((JComponent)serializable).setOpaque(false);
        ((Container)serializable).add(this.applyButton);
        if (this.isCapacityEditable()) {
            ((Container)serializable).add(this.resetButton);
        }
        object2 = new GridLayout(1, 0, 5, 3);
        serializable2 = defaultComponentFactory.createPanel();
        ((Container)serializable2).setLayout((LayoutManager)object2);
        ((JComponent)serializable2).setOpaque(false);
        ((Container)serializable2).add(this.applyButton);
        if (this.isCapacityEditable()) {
            ((Container)serializable2).add(this.cancelButton);
        }
        object2 = new BorderLayout(5, 3);
        jPanel = defaultComponentFactory.createPanel();
        jPanel.setLayout((LayoutManager)object2);
        jPanel.setOpaque(false);
        jPanel.add((Component)serializable, "West");
        jPanel.add((Component)serializable2, "East");
        ComponentUtilities.decorateInputAreaMarginBorder(jPanel);
        serializable = new BorderLayout(5, 3);
        serializable2 = this.guidance.BASEPANEL.getColor();
        this.setLayout((LayoutManager)((Object)serializable));
        this.setOpaque(true);
        this.setBackground((Color)serializable2);
        this.add((Component)jPanel2, "North");
        this.add((Component)object, "Center");
        this.add((Component)jPanel, "South");
        ComponentUtilities.decoratePanelAreaMarginBorder(this);
    }

    private void loadColumnWidthds() {
        TableColumnModel tableColumnModel = this.licenseListTable.getColumnModel();
        int n = tableColumnModel.getColumnCount();
        for (int i = 0; i < n; ++i) {
            int n2 = this.licenseTableModel.getPreferredColumnWidth(i);
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            tableColumn.setPreferredWidth(n2);
        }
    }

    private void updateTotalCapacity() {
        int n = this.wrapperList.getTotalCurrentCapacity();
        int n2 = this.wrapperList.getTotalModifiedCapacity();
        String string = this.guidance.totalCapacityLabel.getGuidance();
        String string2 = this.guidance.licenseUnit.getGuidance();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append(" ");
        stringBuffer.append(n);
        if (n != n2) {
            stringBuffer.append(" -> ");
            stringBuffer.append(n2);
        }
        stringBuffer.append(" ");
        stringBuffer.append("(");
        stringBuffer.append(string2);
        stringBuffer.append(")");
        String string3 = stringBuffer.toString();
        this.totalCapacityLabel.setText(string3);
    }

    private void updateOperationState() {
        if (this.isCapacityEditable()) {
            boolean bl = this.wrapperList.isModified();
            this.resetButton.setEnabled(bl);
        }
    }

    private void closeOwnerWindow() {
        Window window = (Window)SwingUtilities.getAncestorOfClass(Window.class, this);
        if (window != null) {
            window.dispose();
            this.putLog("disposed owner window.");
        }
    }

    private void licenseSelectionChanged() {
        if (this.isCapacityEditable()) {
            int n;
            int n2;
            Integer n3;
            int n4 = this.licenseListTable.getRowCount();
            int[] nArray = this.licenseListTable.getSelectedRows();
            boolean bl = false;
            Integer n5 = n3 = new Integer(0);
            if (n4 > 0 && nArray.length == 1 && (n2 = this.licenseTableModel.getCurrentLicenseCountAt(n = nArray[0])) > 0) {
                n3 = (Integer)this.licenseTableModel.getValueAt(n, 2);
                n5 = (Integer)this.licenseTableModel.getValueAt(n, 3);
                bl = true;
            }
            this.capacitySpinnerModel.setMaximum(n3);
            this.capacitySpinnerModel.setValue(n5);
            this.capacitySpinner.setEnabled(bl);
            this.setButton.setEnabled(bl);
            this.revalidate();
        }
    }

    private void clickSetButton() {
        if (this.isCapacityEditable()) {
            int n = this.licenseListTable.getRowCount();
            int[] nArray = this.licenseListTable.getSelectedRows();
            if (n > 0 && nArray.length == 1) {
                int n2 = nArray[0];
                Integer n3 = (Integer)this.capacitySpinner.getValue();
                int n4 = n3;
                this.licenseTableModel.updateLicenseCount(n2, n4);
                this.updateTotalCapacity();
                this.updateOperationState();
            }
        }
    }

    private void clickResetButton() {
        boolean bl = false;
        int n = 410;
        int n2 = 59307;
        RJDataMsg rJDataMsg = RJCom.getMsg(this.controller, n, n2);
        Object[] objectArray = rJDataMsg.getMessage();
        this.putLog((String)objectArray);
        objectArray = new Object[]{RJComUty.CAPTION_MSG_OK, RJComUty.CAPTION_MSG_CANCEL};
        n2 = RJComDialog.show(this, rJDataMsg, 0, objectArray, objectArray[0]);
        if (n2 == 0) {
            this.putLog("'OK' was specified by user.");
            bl = true;
        } else {
            this.putLog("'Cancel' was specified by user.");
        }
        if (bl) {
            this.wrapperList.clearChangedCount();
            this.licenseTableModel.updateLicenseCount();
            this.updateTotalCapacity();
            this.updateOperationState();
        }
    }

    private void clickApplyButton() {
        boolean bl = true;
        if (this.isCapacityEditable()) {
            bl = false;
            if (this.isTotalCapacityError()) {
                this.showTotalCapacityError();
            } else if (this.isRAWCapacityError()) {
                this.showRAWCapacityError();
            } else {
                if (this.wrapperList.isModified()) {
                    this.operationState = EDITED;
                } else if (this.beforeModify) {
                    this.operationState = EDITED;
                }
                bl = true;
            }
        }
        if (bl) {
            this.closeOwnerWindow();
        }
    }

    private void clickCancelButton() {
        this.closeOwnerWindow();
    }

    private boolean isInstalledProduct() {
        boolean bl = false;
        if (!(this.ppInfo.m_strStatus.equals("Not Installed") || this.ppInfo.m_strStatus.equals("Not Enough License") || this.ppInfo.m_strStatus.equals("Expired"))) {
            bl = true;
        }
        return bl;
    }

    private boolean isTotalCapacityError() {
        int n = this.wrapperList.getTotalModifiedCapacity();
        boolean bl = n <= 0;
        return bl;
    }

    private void showTotalCapacityError() {
        int n = 410;
        int n2 = 59305;
        RJDataMsg rJDataMsg = RJCom.getMsg(this.controller, n, n2);
        Object[] objectArray = rJDataMsg.getMessage();
        this.putLog((String)objectArray);
        objectArray = new Object[]{RJComUty.CAPTION_MSG_OK};
        RJComDialog.show(this, rJDataMsg, 0, objectArray, objectArray[0]);
    }

    private boolean isRAWCapacityError() {
        int n;
        long l;
        PPKgetKeyBasic pPKgetKeyBasic = this.guidance.m_PPKgetKeyBasic;
        switch (this.ppInfo.m_nAccountType) {
            case 1: {
                l = pPKgetKeyBasic.lLDEVSize;
                break;
            }
            case 2: {
                l = pPKgetKeyBasic.lMFSize;
                break;
            }
            case 3: {
                l = pPKgetKeyBasic.lOpenSize;
                break;
            }
            case 4: {
                l = this.ppInfo.m_nUsedCapa;
                break;
            }
            default: {
                l = -1L;
            }
        }
        boolean bl = false;
        if (l != -1L && l > (long)(n = this.wrapperList.getTotalModifiedCapacity() * 1024)) {
            bl = true;
        }
        return bl;
    }

    private void showRAWCapacityError() {
        int n = 410;
        int n2 = 59306;
        RJDataMsg rJDataMsg = RJCom.getMsg(this.controller, n, n2);
        Object[] objectArray = rJDataMsg.getMessage();
        this.putLog((String)objectArray);
        objectArray = new Object[]{RJComUty.CAPTION_MSG_OK};
        RJComDialog.show(this, rJDataMsg, 0, objectArray, objectArray[0]);
    }

    private void putLog(String string) {
        String string2 = "[LicenseList]";
        String string3 = "[PPKey]";
        System.out.println(string3 + " " + string2 + " " + string);
        RJCom.putLog(this.controller, string3, string2, string, 0);
    }

    public static final class OperationState {
        private String status;

        private OperationState(String string) {
            this.status = string;
        }
    }
}

