/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.account;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.border.Border;
import sanproject.client.account.RJAccDataSupplier;
import sanproject.client.account.RJAccDef;
import sanproject.client.account.RJAccGuideDef;
import sanproject.client.account.RJAccTablePanel;
import sanproject.client.account.RJAccTreePanel;
import sanproject.client.account.RJAccUserElement;
import sanproject.client.com.RJComUty;
import sanproject.client.com.RJcGuide;
import sanproject.client.com.RJcHeaderPanel;
import sanproject.client.com.RJcListPanel;
import sanproject.client.com.RJcPanel;
import sanproject.client.data.RJDataMsg;

public class RJAccUserInfoPanel
extends RJcPanel
implements RJAccGuideDef,
RJAccDef {
    protected RJAccDataSupplier supplier;
    private JLabel userID = new JLabel();
    private JLabel slprID = new JLabel();
    private RJAccTablePanel permissionPanel;
    private RJAccTreePanel treePanel = null;
    private boolean runMediator = false;
    private JComboBox jcAuth;
    private JComboBox jcAudLog;
    private JComboBox jcEnc;
    private JComboBox jcPer;
    String[] szCombo = new String[]{RJcGuide.text("Account/ItemDisable"), RJcGuide.text("Account/ItemReadOnly"), RJcGuide.text("Account/ItemReadWrite")};
    String[] szPerCombo = new String[]{RJcGuide.text("Account/ItemDisable"), RJcGuide.text("Account/ItemEnable")};
    int iAuthCombo_Before = 0;
    int iAudCombo_Before = 0;
    int iEncCombo_Before = 0;
    int iPerCombo_Before = 0;
    int iAuthCombo_After = 0;
    int iAudCombo_After = 0;
    int iEncCombo_After = 0;
    int iPerCombo_After = 0;
    RJAccUserElement UserElement = null;

    public RJAccUserInfoPanel(RJAccDataSupplier rJAccDataSupplier) {
        this.jcAuth = new JComboBox<String>(this.szCombo);
        this.jcAudLog = new JComboBox<String>(this.szCombo);
        this.jcEnc = new JComboBox<String>(this.szPerCombo);
        this.jcPer = new JComboBox<String>(this.szPerCombo);
        this.supplier = rJAccDataSupplier;
        this.setLayout(new BorderLayout(8, 4));
        Border border = BorderFactory.createEmptyBorder(0, 4, 0, 0);
        this.setBorder(border);
        RJcHeaderPanel rJcHeaderPanel = new RJcHeaderPanel("Account/User_Information");
        JSplitPane jSplitPane = new JSplitPane();
        jSplitPane.setOrientation(0);
        jSplitPane.setContinuousLayout(true);
        jSplitPane.setDividerSize(4);
        jSplitPane.setDividerLocation(200);
        jSplitPane.setOpaque(false);
        jSplitPane.add((Component)this.createTopPanel(), "top");
        jSplitPane.add((Component)this.createButtomPanel(), "bottom");
        this.setOpaque(false);
        this.add((Component)rJcHeaderPanel, "North");
        this.add((Component)jSplitPane, "Center");
    }

    public void setElement(RJAccUserElement rJAccUserElement) {
        this.reset();
        this.UserElement = rJAccUserElement;
        this.userID.setText(rJAccUserElement.getName());
        this.slprID.setText(rJAccUserElement.getSlprName());
        this.jcAuth.setSelectedIndex(rJAccUserElement.GetAuthCombo());
        this.jcAudLog.setSelectedIndex(rJAccUserElement.GetAudCombo());
        this.jcEnc.setSelectedIndex(rJAccUserElement.GetEncCombo());
        this.jcPer.setSelectedIndex(rJAccUserElement.GetPerCombo());
        this.permissionPanel.setElement(rJAccUserElement);
        if (this.supplier.isModify() && !rJAccUserElement.getdeleteUserFlag() && !rJAccUserElement.getDisacleUserFlag()) {
            this.iAuthCombo_Before = rJAccUserElement.GetAuthCombo();
            this.iAudCombo_Before = rJAccUserElement.GetAudCombo();
            this.iEncCombo_Before = rJAccUserElement.GetEncCombo();
            this.iPerCombo_Before = rJAccUserElement.GetPerCombo();
            this.setEditable();
            this.setAllActionLisnaer();
        }
        this.permissionPanel.refresh();
    }

    private void clearAllActionLisnaer() {
        this.clearActionLisnaer(this.jcAuth);
        this.clearActionLisnaer(this.jcAudLog);
        this.clearActionLisnaer(this.jcEnc);
        this.clearActionLisnaer(this.jcPer);
    }

    private void setAllActionLisnaer() {
        this.setActionLisnaer(this.jcAuth);
        this.setActionLisnaer(this.jcAudLog);
        this.setActionLisnaer(this.jcEnc);
        this.setActionLisnaer(this.jcPer);
    }

    public void reset() {
        this.clearAllActionLisnaer();
        this.userID.setText("");
        this.slprID.setText("");
        this.jcAuth.setSelectedIndex(0);
        this.jcAudLog.setSelectedIndex(0);
        this.jcEnc.setSelectedIndex(0);
        this.jcPer.setSelectedIndex(0);
        this.jcAuth.setEnabled(false);
        this.jcAudLog.setEnabled(false);
        this.jcEnc.setEnabled(false);
        this.jcPer.setEnabled(false);
        this.treePanel.requestFocus();
        this.permissionPanel.reset();
    }

    public void setTreePanel(RJAccTreePanel rJAccTreePanel) {
        this.treePanel = rJAccTreePanel;
        this.permissionPanel.setTreePanel(rJAccTreePanel);
    }

    private JScrollPane createTopPanel() {
        JScrollPane jScrollPane = new JScrollPane();
        Border border = BorderFactory.createEmptyBorder(0, 0, 4, 0);
        jScrollPane.setBorder(border);
        jScrollPane.setOpaque(false);
        jScrollPane.getViewport().setOpaque(false);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(10);
        RJcListPanel rJcListPanel = new RJcListPanel();
        rJcListPanel.setMinLabelWidth(0);
        rJcListPanel.addEntry("Account/AddUsrNameLabel", this.userID);
        rJcListPanel.addEntry("Account/SLPRID", this.slprID);
        rJcListPanel.addEntry("Account/AccountAuthorityLbl", this.jcAuth);
        rJcListPanel.addEntry("Account/AuditAuthorityLbl", this.jcAudLog);
        rJcListPanel.addEntry("Account/EncryptAuthorityLbl", this.jcEnc);
        rJcListPanel.addEntry("Account/StrorageAuthorityLbl", this.jcPer);
        rJcListPanel.completed();
        jScrollPane.getViewport().add(rJcListPanel);
        return jScrollPane;
    }

    private JPanel createButtomPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(8, 4));
        Border border = BorderFactory.createEmptyBorder(4, 0, 0, 0);
        jPanel.setBorder(border);
        RJcHeaderPanel rJcHeaderPanel = new RJcHeaderPanel("Account/TableTitle");
        Border border2 = BorderFactory.createEmptyBorder(4, 8, 4, 8);
        this.permissionPanel = new RJAccTablePanel(this.supplier);
        this.permissionPanel.setBorder(border2);
        this.permissionPanel.setBackground(RJcGuide.color("Account/TablePanelBgClr"));
        jPanel.setOpaque(false);
        jPanel.add((Component)rJcHeaderPanel, "North");
        jPanel.add((Component)this.permissionPanel, "Center");
        return jPanel;
    }

    private void setActionLisnaer(JComboBox jComboBox) {
        jComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RJAccUserInfoPanel.this.comboMediator();
            }
        });
    }

    private void clearActionLisnaer(JComboBox jComboBox) {
        ActionListener[] actionListenerArray = jComboBox.getActionListeners();
        for (int i = 0; actionListenerArray.length > i; ++i) {
            jComboBox.removeActionListener(actionListenerArray[i]);
        }
    }

    private void comboMediator() {
        if (this.supplier.isModify() && !this.runMediator) {
            this.runMediator = true;
            this.mediator_core();
            this.runMediator = false;
        }
    }

    private void mediator_core() {
        this.supplier.putLog("[Account]", "[Combo]", "Change");
        if (this.UserElement != null) {
            if (this.checkDisable()) {
                this.message(21055618);
                this.backStateCombo();
            } else {
                String string = this.supplier.strLoginUserName;
                if (string.equals(this.UserElement.getName()) && this.jcAuth.getSelectedIndex() != 2) {
                    if (this.iAuthCombo_Before != this.jcAuth.getSelectedIndex() && this.iAuthCombo_Before == 2) {
                        int n = this.massage2(21055619);
                        if (n != 0) {
                            this.backStateCombo();
                        } else {
                            this.recordCombo();
                        }
                    } else {
                        this.recordCombo();
                    }
                } else {
                    this.recordCombo();
                }
            }
            this.permissionPanel.refresh();
        }
    }

    private void backStateCombo() {
        this.jcAuth.setSelectedIndex(this.iAuthCombo_Before);
        this.jcAudLog.setSelectedIndex(this.iAudCombo_Before);
        this.jcEnc.setSelectedIndex(this.iEncCombo_Before);
        this.jcPer.setSelectedIndex(this.iPerCombo_Before);
    }

    private void recordCombo() {
        this.iAuthCombo_Before = this.jcAuth.getSelectedIndex();
        this.iAudCombo_Before = this.jcAudLog.getSelectedIndex();
        this.iEncCombo_Before = this.jcEnc.getSelectedIndex();
        this.iPerCombo_Before = this.jcPer.getSelectedIndex();
        this.UserElement.SetAuthCombo(this.jcAuth.getSelectedIndex());
        this.UserElement.SetAudCombo(this.jcAudLog.getSelectedIndex());
        this.UserElement.SetEncCombo(this.jcEnc.getSelectedIndex());
        this.UserElement.SetPerCombo(this.jcPer.getSelectedIndex());
    }

    private void message(int n) {
        Object[] objectArray = new Object[]{RJComUty.CAPTION_MSG_OK};
        RJDataMsg rJDataMsg = this.supplier.getMessage(n);
        int n2 = this.supplier.showMessage(this.supplier.getParentPanel(), rJDataMsg, 0, objectArray, objectArray[0]);
    }

    private int massage2(int n) {
        Object[] objectArray = new Object[]{RJComUty.CAPTION_MSG_OK, RJComUty.CAPTION_MSG_CANCEL};
        RJDataMsg rJDataMsg = this.supplier.getMessage(n);
        int n2 = this.supplier.showMessage(this.supplier.getParentPanel(), rJDataMsg, 0, objectArray, objectArray[0]);
        return n2;
    }

    private boolean checkDisable() {
        boolean bl = false;
        if (this.jcAuth.getSelectedIndex() == 0 && this.jcAudLog.getSelectedIndex() == 0 && this.jcEnc.getSelectedIndex() == 0 && this.jcPer.getSelectedIndex() == 0) {
            bl = true;
            this.supplier.putLog("[Account]", "[Combo]", "ALL ComboBox are Disable");
        }
        return bl;
    }

    private void setEditable() {
        if (this.supplier.isModify() && this.supplier.getAccountPermissionFromRMI() == 2) {
            if (!this.supplier.IsBuiltInACC(this.UserElement.getName())) {
                this.jcAuth.setEnabled(true);
            }
            if (this.UserElement.getSlprID() == Short.MAX_VALUE) {
                this.jcAudLog.setEnabled(true);
                this.jcEnc.setEnabled(true);
            }
            this.jcPer.setEnabled(true);
        }
    }
}

