/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.com.abs;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.event.ChangeEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import sanproject.client.com.abs.RJaTableColumnGroup;
import sanproject.client.com.abs.RJaTableHeaderRenderer;
import sanproject.client.com.abs.RJaTableHeaderUI;

public class RJaTableHeader
extends JTableHeader {
    private static final String uiClassID = "RJaTableHeaderUI";
    protected ArrayList columnGroups = null;

    public RJaTableHeader() {
        this(null);
    }

    public RJaTableHeader(TableColumnModel tableColumnModel) {
        super(tableColumnModel);
        this.setUI(new RJaTableHeaderUI());
        this.setReorderingAllowed(false);
        HMouseAdapter hMouseAdapter = new HMouseAdapter();
        this.addMouseListener(hMouseAdapter);
        this.addMouseMotionListener(hMouseAdapter);
    }

    public void setReorderingAllowed(boolean bl) {
        this.reorderingAllowed = bl;
        if (this.columnGroups != null) {
            this.reorderingAllowed = false;
        }
    }

    public void setColumnGroup(ArrayList arrayList) {
        this.columnGroups = arrayList;
        if (arrayList != null) {
            this.reorderingAllowed = false;
        }
    }

    public void addColumnGroup(RJaTableColumnGroup rJaTableColumnGroup) {
        if (this.columnGroups == null) {
            this.columnGroups = new ArrayList();
            this.reorderingAllowed = false;
        }
        this.columnGroups.add(rJaTableColumnGroup);
    }

    public Iterator getColumnGroups(TableColumn tableColumn) {
        Iterator iterator = null;
        if (this.columnGroups != null) {
            Iterator iterator2 = this.columnGroups.iterator();
            while (iterator2.hasNext()) {
                RJaTableColumnGroup rJaTableColumnGroup = (RJaTableColumnGroup)iterator2.next();
                ArrayList arrayList = rJaTableColumnGroup.getColumnGroups(tableColumn, new ArrayList());
                if (arrayList == null) continue;
                iterator = arrayList.iterator();
                break;
            }
        }
        return iterator;
    }

    public void setColumnMargin() {
        if (this.columnGroups != null) {
            int n = this.getColumnModel().getColumnMargin();
            Iterator iterator = this.columnGroups.iterator();
            while (iterator.hasNext()) {
                RJaTableColumnGroup rJaTableColumnGroup = (RJaTableColumnGroup)iterator.next();
                rJaTableColumnGroup.setColumnMargin(n);
            }
        }
    }

    public void columnMarginChanged(ChangeEvent changeEvent) {
        TableColumn tableColumn = this.getResizingColumn();
        if (tableColumn != null && this.table.getAutoResizeMode() != 0 && this.table.getAutoResizeMode() != 4) {
            TableColumnModel tableColumnModel = this.getColumnModel();
            int n = tableColumnModel.getColumnCount() - 1;
            int n2 = tableColumn.getModelIndex() + 1;
            if (this.table.getAutoResizeMode() == 3) {
                n2 = n;
            }
            if (tableColumn.getModelIndex() == n || tableColumnModel.getColumn(n2).getWidth() <= tableColumnModel.getColumn(n2).getMinWidth()) {
                int n3 = this.table.getAutoResizeMode();
                this.table.setAutoResizeMode(3);
                this.table.sizeColumnsToFit(-1);
                this.table.setAutoResizeMode(n3);
            } else {
                super.columnMarginChanged(changeEvent);
            }
        } else {
            super.columnMarginChanged(changeEvent);
        }
    }

    class HMouseAdapter
    extends MouseAdapter
    implements MouseMotionListener {
        private RJaTableHeaderRenderer pressedRenderer = null;
        private Object identifier = null;

        HMouseAdapter() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
            TableColumnModel tableColumnModel = jTableHeader.getColumnModel();
            int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getPoint().x);
            if (n >= 0 && n < tableColumnModel.getColumnCount()) {
                TableCellRenderer tableCellRenderer;
                TableColumn tableColumn = tableColumnModel.getColumn(n);
                TableColumn tableColumn2 = jTableHeader.getResizingColumn();
                if (tableColumn2 == null && (tableCellRenderer = tableColumn.getHeaderRenderer()) instanceof RJaTableHeaderRenderer) {
                    this.identifier = tableColumn.getIdentifier();
                    this.pressedRenderer = (RJaTableHeaderRenderer)tableCellRenderer;
                    this.pressedRenderer.setPressed(true);
                    jTableHeader.repaint();
                }
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.pressedRenderer != null) {
                JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
                this.pressedRenderer.setPressed(false);
                this.pressedRenderer = null;
                jTableHeader.repaint();
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (this.pressedRenderer != null) {
                JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
                this.pressedRenderer.setPressed(false);
                this.pressedRenderer = null;
                jTableHeader.repaint();
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            TableColumnModel tableColumnModel = ((JTableHeader)mouseEvent.getSource()).getColumnModel();
            int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getPoint().x);
            if (n >= 0 && n < tableColumnModel.getColumnCount()) {
                Object object = tableColumnModel.getColumn(n).getIdentifier();
                if (this.pressedRenderer != null && object != null && !object.equals(this.identifier)) {
                    JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
                    this.pressedRenderer.setPressed(false);
                    this.pressedRenderer = null;
                    jTableHeader.repaint();
                }
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }
}

