/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.exdevice.data;

import java.math.BigInteger;
import sanproject.client.com.RJCom;
import sanproject.client.data.RJDataControl;

public class Utility {
    public static byte[] bigIntToByteArray(BigInteger bigInteger, int n) {
        byte[] byArray = new byte[n];
        byte[] byArray2 = bigInteger.toByteArray();
        if (byArray2.length < byArray.length) {
            System.arraycopy(byArray2, 0, byArray, byArray.length - byArray2.length, byArray2.length);
        } else {
            System.arraycopy(byArray2, byArray2.length - byArray.length, byArray, 0, byArray.length);
        }
        return byArray;
    }

    public static String bigIntToHexString(BigInteger bigInteger, int n) {
        String string = bigInteger.toString(16);
        StringBuffer stringBuffer = new StringBuffer(string);
        while (stringBuffer.length() < n) {
            stringBuffer.insert(0, '0');
        }
        return stringBuffer.toString();
    }

    public static String intToHexString(int n, int n2) {
        String string = Integer.toHexString(n);
        StringBuffer stringBuffer = new StringBuffer(string);
        while (stringBuffer.length() < n2) {
            stringBuffer.insert(0, '0');
        }
        return stringBuffer.toString();
    }

    public static BigInteger kibToLba(long l) {
        BigInteger bigInteger = BigInteger.valueOf(l);
        bigInteger = bigInteger.shiftLeft(1);
        return bigInteger;
    }

    public static String byteArrayToHexString(byte[] byArray) {
        BigInteger bigInteger = new BigInteger(byArray);
        String string = bigInteger.toString(16);
        if ((string.length() & 1) == 1) {
            string = '0' + string;
        }
        return string;
    }

    public static String byteToHexString(byte by) {
        String string = Integer.toHexString(by & 0xFF);
        if (string.length() < 2) {
            string = '0' + string;
        }
        return string;
    }

    public static void putExceptionLog(String string, Exception exception) {
        if (exception != null) {
            String string2 = string != null ? string : "";
            Utility.putLog(string2, exception.toString());
            StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
            for (int i = 0; i < stackTraceElementArray.length && i < 5; ++i) {
                StringBuffer stringBuffer = new StringBuffer(" at ");
                stringBuffer.append(stackTraceElementArray[i].getMethodName());
                stringBuffer.append("(");
                stringBuffer.append(stackTraceElementArray[i].getFileName());
                stringBuffer.append(":");
                stringBuffer.append(stackTraceElementArray[i].getLineNumber());
                stringBuffer.append(")");
                Utility.putLog(string2, stringBuffer.toString());
            }
        }
    }

    public static void putLog(String string, String string2) {
        Utility.putLog(string, string2, 0);
    }

    public static void putLog(String string, String string2, int n) {
        RJDataControl rJDataControl = RJDataControl.getDataControl();
        RJCom.putLog(rJDataControl, "ExDevice", string, string2, n);
    }
}

