/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.ftp;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import sanproject.client.com.RJComUty;
import sanproject.client.com.RJcButton;
import sanproject.client.com.RJcCushionPanel;
import sanproject.client.com.RJcGuide;
import sanproject.client.data.RJDataMsg;
import sanproject.client.ftp.RJftpASCIIPassField;
import sanproject.client.ftp.RJftpASCIITextField;
import sanproject.client.ftp.RJftpDataSupplier;
import sanproject.client.ftp.RJftpGuide;
import sanproject.client.ftp.RJftpIPField;
import sanproject.client.ftp.RJftpIPField_IPv6;
import sanproject.client.ftp.RJftpTabPanel;
import sanproject.client.syslog.RJMediator;
import sanproject.client.syslog.RJRadioButton;
import sanproject.client.syslog.RJslDef;
import sanproject.serverux.data.AuditFTPServ;

public class RJftpMediator
implements RJftpGuide,
RJMediator {
    RJftpDataSupplier dataSupplier;
    private RJftpTabPanel parentPanel;
    private RJRadioButton enable;
    private RJRadioButton disable;
    private RJRadioButton ipv6;
    private RJRadioButton ipv4;
    private RJftpIPField ipField;
    private RJftpIPField_IPv6 ipField_IPv6;
    private RJftpASCIITextField usrField;
    private RJftpASCIIPassField passField;
    private RJftpASCIITextField folderField;
    private JButton transferBtn;
    private JPanel dmy_NetworkPanel;
    CardLayout ipField_chg;
    private int srvNum = 0;

    public RJftpMediator() {
        this(0, null);
    }

    public RJftpMediator(int n, RJftpDataSupplier rJftpDataSupplier) {
        this.srvNum = n;
        this.dataSupplier = rJftpDataSupplier;
        this.init();
    }

    public void init() {
        this.enable = new RJRadioButton(RJcGuide.text("syslog/Enable"), false);
        this.disable = new RJRadioButton(RJcGuide.text("syslog/Disable"), false);
        this.ipv4 = new RJRadioButton(RJcGuide.text("syslog/IPv4"), false);
        this.ipv6 = new RJRadioButton(RJcGuide.text("syslog/IPv6"), false);
        this.enable.setOpaque(false);
        this.disable.setOpaque(false);
        this.ipv4.setOpaque(false);
        this.ipv6.setOpaque(false);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.enable);
        buttonGroup.add(this.disable);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.ipv4);
        buttonGroup2.add(this.ipv6);
        this.ipField = new RJftpIPField();
        this.ipField.setPreferredSize(new Dimension(180, 20));
        this.ipField_IPv6 = new RJftpIPField_IPv6();
        this.ipField_IPv6.setPreferredSize(new Dimension(390, 20));
        this.usrField = new RJftpASCIITextField(256);
        this.passField = new RJftpASCIIPassField(256);
        this.folderField = new RJftpASCIITextField(256);
        this.transferBtn = new RJcButton("FTP/SrvTransferBtn");
        this.transferBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RJftpMediator.this.transferBtn_actionPerformed(actionEvent);
            }
        });
        this.ipField_chg = new CardLayout();
        this.dmy_NetworkPanel = new JPanel(this.ipField_chg);
        this.dmy_NetworkPanel.setOpaque(false);
    }

    public void setTabPanel(RJftpTabPanel rJftpTabPanel) {
        this.parentPanel = rJftpTabPanel;
    }

    public void setvalue() {
        int[] nArray;
        int[] nArray2;
        this.releaseMediator();
        this.setEnable(false);
        this.enable.setEnabled(false);
        this.disable.setEnabled(false);
        this.ipv4.setEnabled(false);
        this.ipv6.setEnabled(false);
        this.enable.setSelected(false);
        this.disable.setSelected(false);
        this.ipv4.setSelected(false);
        this.ipv6.setSelected(false);
        AuditFTPServ auditFTPServ = this.dataSupplier.getFTPData(this.srvNum);
        auditFTPServ = this.convInitPrm(auditFTPServ);
        if (this.srvNum == 0) {
            nArray2 = RJslDef.def_IPv4;
            nArray = RJslDef.def_IPv6;
        } else {
            nArray2 = RJslDef.def_IPv4_2;
            nArray = RJslDef.def_IPv6_2;
        }
        if (auditFTPServ.bIPv6) {
            this.ipField_chg.show(this.dmy_NetworkPanel, "IPv6");
            nArray = auditFTPServ.iIPAddr;
        } else {
            this.ipField_chg.show(this.dmy_NetworkPanel, "IPv4");
            nArray2 = this.getIPv4Address(auditFTPServ.iIPAddr);
        }
        this.ipField.setValue(nArray2);
        this.ipField_IPv6.setValue(nArray);
        this.usrField.setText(auditFTPServ.strUsername);
        this.passField.setText(auditFTPServ.strPassword);
        this.folderField.setText(auditFTPServ.strOutputDir);
        this.enable.setSelected(auditFTPServ.bLogOutput);
        this.disable.setSelected(!auditFTPServ.bLogOutput);
        this.ipv6.setSelected(auditFTPServ.bIPv6);
        this.ipv4.setSelected(!auditFTPServ.bIPv6);
        if (this.dataSupplier.isModify()) {
            this.enable.setEnabled(true);
            this.disable.setEnabled(true);
            this.colleagueChanged();
            this.setMediator();
        }
    }

    public AuditFTPServ convInitPrm(AuditFTPServ auditFTPServ) {
        AuditFTPServ auditFTPServ2 = new AuditFTPServ();
        auditFTPServ2.iIPAddr = auditFTPServ.iIPAddr;
        auditFTPServ2.strUsername = auditFTPServ.strUsername;
        auditFTPServ2.strPassword = auditFTPServ.strPassword;
        auditFTPServ2.strOutputDir = auditFTPServ.strOutputDir;
        auditFTPServ2.bLogOutput = auditFTPServ.bLogOutput;
        auditFTPServ2.bIPv6 = auditFTPServ.bIPv6;
        this.ipField.setForceEdit(false);
        this.ipField_IPv6.setForceEdit(false);
        this.usrField.setForceEdit(false);
        this.folderField.setForceEdit(false);
        if (!this.dataSupplier.check_IP(auditFTPServ2)) {
            auditFTPServ2.iIPAddr = auditFTPServ2.bIPv6 ? RJslDef.def_IPv6 : this.cnvIP(RJslDef.def_IPv4);
            if (this.srvNum == 1) {
                auditFTPServ2.iIPAddr = auditFTPServ2.bIPv6 ? RJslDef.def_IPv6_2 : this.cnvIP(RJslDef.def_IPv4_2);
            }
            this.ipField.setForceEdit(this.dataSupplier.isModify());
            this.ipField_IPv6.setForceEdit(this.dataSupplier.isModify());
            this.dataSupplier.compel_set();
            this.dataSupplier.putLog("[FTP]", "[chkPrm]", "[IP" + this.srvNum + ":Failure]");
        }
        if (auditFTPServ2.strOutputDir == null || auditFTPServ2.strOutputDir.equals("")) {
            auditFTPServ2.strOutputDir = "/";
            this.dataSupplier.putLog("[FTP]", "[chkPrm]", "[Folder" + this.srvNum + ":Failure]");
        }
        if (auditFTPServ2.strOutputDir.indexOf("/") != 0) {
            auditFTPServ2.strOutputDir = "/" + auditFTPServ2.strOutputDir;
            this.folderField.setForceEdit(this.dataSupplier.isModify());
        }
        if (auditFTPServ2.strUsername == null) {
            auditFTPServ2.strUsername = "";
        }
        if (auditFTPServ2.strPassword == null || auditFTPServ2.strUsername.equals("")) {
            this.dataSupplier.putLog("[FTP]", "[chkPrm]", "[USER" + this.srvNum + ":Failure]");
            auditFTPServ2.strPassword = "";
        }
        return auditFTPServ2;
    }

    public int[] cnvIP(int[] nArray) {
        int n;
        int[] nArray2 = new int[8];
        for (n = 0; n < 4; ++n) {
            nArray2[n] = 0;
        }
        for (n = 0; n < 4; ++n) {
            nArray2[n + 4] = this.ipField.getAddress_int()[n];
        }
        return nArray2;
    }

    public AuditFTPServ getValue() {
        AuditFTPServ auditFTPServ = new AuditFTPServ();
        auditFTPServ.bIPv6 = this.ipv6.isSelected();
        auditFTPServ.bLogOutput = this.enable.isSelected();
        auditFTPServ.iIPAddr = this.getIPAddress();
        auditFTPServ.strUsername = this.usrField.getText();
        auditFTPServ.strPassword = new String(this.passField.getPassword());
        auditFTPServ.strOutputDir = this.folderField.getText();
        return auditFTPServ;
    }

    public boolean chksts() {
        boolean bl;
        boolean bl2 = bl = this.enable.getstate() || this.ipv6.getstate() || this.usrField.chgSts() || this.passField.chgSts() || this.folderField.chgSts();
        bl = this.ipv6.isSelected() ? bl || this.ipField_IPv6.getstate() : bl || this.ipField.getstate();
        return bl;
    }

    private void transferBtn_actionPerformed(ActionEvent actionEvent) {
        int n;
        RJDataMsg rJDataMsg;
        Object[] objectArray;
        this.dataSupplier.putLog("[FTP]", "[Transfer]", "Button ActionPerformed");
        boolean bl = true;
        AuditFTPServ auditFTPServ = new AuditFTPServ();
        auditFTPServ.iIPAddr = this.getIPAddress();
        if (this.usrField.getText().equals("") || this.folderField.getText().equals("")) {
            objectArray = new Object[]{RJComUty.CAPTION_MSG_OK};
            rJDataMsg = this.dataSupplier.getMessage(1001055640);
            n = this.dataSupplier.showMessage(this.parentPanel, rJDataMsg, 0, objectArray, objectArray[0]);
            bl = false;
        }
        if (bl && this.chksts()) {
            objectArray = new Object[]{RJComUty.CAPTION_MSG_OK};
            rJDataMsg = this.dataSupplier.getMessage(1001055641);
            n = this.dataSupplier.showMessage(this.parentPanel, rJDataMsg, 0, objectArray, objectArray[0]);
            bl = false;
        }
        if (bl) {
            this.parentPanel.transfer2FTP(this.srvNum);
        }
    }

    private void setMediator() {
        this.enable.setMediator(this);
        this.disable.setMediator(this);
        this.ipv6.setMediator(this);
        this.ipv4.setMediator(this);
    }

    private void releaseMediator() {
        this.enable.setMediator(null);
        this.disable.setMediator(null);
        this.ipv6.setMediator(null);
        this.ipv4.setMediator(null);
    }

    public void colleagueChanged() {
        this.releaseMediator();
        boolean bl = this.dataSupplier.isModify() && this.enable.isSelected();
        this.setEnable(bl);
        if (this.ipv6.isSelected()) {
            this.ipField_chg.show(this.dmy_NetworkPanel, "IPv6");
        } else {
            this.ipField_chg.show(this.dmy_NetworkPanel, "IPv4");
        }
        if (this.disable.isSelected()) {
            AuditFTPServ auditFTPServ = new AuditFTPServ();
            auditFTPServ.bIPv6 = this.ipv6.isSelected();
            auditFTPServ.iIPAddr = this.getIPAddress();
            if (!this.dataSupplier.check_IP(auditFTPServ)) {
                this.enable.setSelected(true);
                this.setEnable(true);
                Object[] objectArray = new Object[]{RJComUty.CAPTION_MSG_OK};
                RJDataMsg rJDataMsg = this.dataSupplier.getMessage(1001055011);
                if (this.ipv6.isSelected()) {
                    rJDataMsg = this.dataSupplier.getMessage(1001065683);
                }
                int n = this.dataSupplier.showMessage(this.parentPanel, rJDataMsg, 0, objectArray, objectArray[0]);
                if (this.ipv6.isSelected()) {
                    this.ipField_IPv6.requestFocus();
                } else {
                    this.ipField.requestFocus();
                }
            }
        }
        boolean bl2 = this.dataSupplier.getFTPData((int)this.srvNum).bLogOutput != this.enable.isSelected();
        this.enable.setstate(bl2);
        this.disable.setstate(bl2);
        boolean bl3 = this.dataSupplier.getFTPData((int)this.srvNum).bIPv6 != this.ipv6.isSelected();
        this.ipv6.setstate(bl3);
        this.ipv4.setstate(bl3);
        this.ipField.setForceEdit_Disp(bl3);
        this.ipField_IPv6.setForceEdit_Disp(bl3);
        this.ipField.colleagueChanged();
        this.ipField_IPv6.colleagueChanged();
        this.setMediator();
    }

    private void setEnable(boolean bl) {
        this.ipv4.setEnabled(bl);
        this.ipv6.setEnabled(bl);
        this.ipField.setEnabled(bl);
        this.ipField.setEditable(bl);
        this.ipField_IPv6.setEnabled(bl);
        this.ipField_IPv6.setEditable(bl);
        this.usrField.setEnabled(bl);
        this.usrField.setEditable(bl);
        this.passField.setEnabled(bl);
        this.passField.setEditable(bl);
        this.folderField.setEnabled(bl);
        this.folderField.setEditable(bl);
        this.transferBtn.setEnabled(bl);
    }

    public RJcCushionPanel getNetWorkPanel() {
        RJcCushionPanel rJcCushionPanel = new RJcCushionPanel(this.createDMYNetworkPanel());
        return rJcCushionPanel;
    }

    public RJcCushionPanel getUsrSetingPanel() {
        RJcCushionPanel rJcCushionPanel = new RJcCushionPanel(this.createUsrSettingPanel());
        return rJcCushionPanel;
    }

    public RJcCushionPanel getOutPutPanel() {
        RJcCushionPanel rJcCushionPanel = new RJcCushionPanel(this.creatOutPutPanel());
        return rJcCushionPanel;
    }

    public RJcCushionPanel getFolderPanel() {
        RJcCushionPanel rJcCushionPanel = new RJcCushionPanel(this.createFolderPanel());
        return rJcCushionPanel;
    }

    public RJcCushionPanel getTranceferPanel() {
        RJcCushionPanel rJcCushionPanel = new RJcCushionPanel(this.createTranceferPanel());
        return rJcCushionPanel;
    }

    private JPanel createUsrSettingPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setOpaque(false);
        JLabel jLabel = new JLabel(RJcGuide.text("FTP/UserID"));
        jLabel.setOpaque(false);
        JLabel jLabel2 = new JLabel(RJcGuide.text("FTP/PassWord"));
        jLabel2.setOpaque(false);
        JPanel jPanel2 = this.createFastenPanel(this.usrField, 100, 20);
        JPanel jPanel3 = this.createFastenPanel(this.passField, 100, 20);
        JPanel jPanel4 = new JPanel();
        jPanel4.setOpaque(false);
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)jPanel2, new GridBagConstraints(1, 0, 1, 1, 0.1, 0.0, 17, 2, new Insets(0, 4, 0, 0), 0, 0));
        jPanel.add((Component)jLabel2, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 4, 0, 0), 0, 0));
        jPanel.add((Component)jPanel3, new GridBagConstraints(3, 0, 1, 1, 0.1, 0.0, 17, 2, new Insets(0, 4, 0, 0), 0, 0));
        jPanel.add((Component)jPanel4, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    private JPanel createDMYNetworkPanel() {
        this.dmy_NetworkPanel.removeAll();
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setOpaque(false);
        JPanel jPanel2 = new JPanel();
        jPanel2.setOpaque(false);
        this.dmy_NetworkPanel.add((Component)this.getIPTextPanel_IPv4(), "IPv4");
        this.dmy_NetworkPanel.add((Component)this.getIPTextPanel_IPv6(), "IPv6");
        jPanel.add((Component)this.getIPChgPanel(), new GridBagConstraints(0, 0, 2, 1, 0.1, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.dmy_NetworkPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)jPanel2, new GridBagConstraints(1, 1, 1, 1, 0.1, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    public JPanel getIPChgPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setOpaque(false);
        JLabel jLabel = new JLabel(" ");
        jLabel.setOpaque(false);
        jPanel.add((Component)this.ipv4, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.ipv6, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 0, 0), 0, 0));
        jPanel.add((Component)jLabel, new GridBagConstraints(2, 0, 1, 1, 0.1, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    public JPanel getIPTextPanel_IPv4() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setOpaque(false);
        JLabel jLabel = new JLabel(RJcGuide.text("syslog/IPAdd"));
        JLabel jLabel2 = new JLabel(" ");
        jLabel2.setOpaque(false);
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.ipField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 0, 0), 0, 0));
        jPanel.add((Component)jLabel2, new GridBagConstraints(2, 0, 1, 1, 0.1, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    public JPanel getIPTextPanel_IPv6() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setOpaque(false);
        JLabel jLabel = new JLabel(RJcGuide.text("syslog/IPAdd"));
        JLabel jLabel2 = new JLabel(" ");
        jLabel2.setOpaque(false);
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.ipField_IPv6, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 0, 0), 0, 0));
        jPanel.add((Component)jLabel2, new GridBagConstraints(2, 0, 1, 1, 0.1, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    public JPanel creatOutPutPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setOpaque(false);
        jPanel.add((Component)this.enable, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.disable, new GridBagConstraints(1, 0, 1, 1, 0.1, 0.0, 17, 2, new Insets(0, 4, 0, 0), 0, 0));
        return jPanel;
    }

    private JPanel createFolderPanel() {
        JPanel jPanel = this.createFastenPanel(this.folderField, 400, 20);
        JPanel jPanel2 = new JPanel();
        jPanel2.setOpaque(false);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.setOpaque(false);
        jPanel3.add((Component)jPanel, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel3.add((Component)jPanel2, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel3;
    }

    private JPanel createTranceferPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setOpaque(false);
        jPanel.add((Component)this.transferBtn, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.0, 13, 0, new Insets(0, 4, 0, 0), 0, 0));
        return jPanel;
    }

    private JPanel createFastenPanel(JTextField jTextField, int n, int n2) {
        JPanel jPanel = new JPanel();
        jTextField.setBorder(BorderFactory.createEmptyBorder());
        jTextField.setOpaque(false);
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBackground(Color.white);
        jPanel.setBorder(UIManager.getBorder("TextField.border"));
        jPanel.setMinimumSize(new Dimension(n, n2));
        jPanel.add((Component)jTextField, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.1, 13, 1, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    public void setIPFocus() {
        if (this.ipv6.isSelected()) {
            this.ipField_IPv6.requestFocus();
        } else {
            this.ipField.requestFocus();
        }
    }

    public void setUsrFocus() {
        this.usrField.requestFocus();
    }

    public void setFolderFocus() {
        this.folderField.requestFocus();
    }

    public int[] getIPv4Address(int[] nArray) {
        int[] nArray2 = new int[4];
        for (int i = 0; i < 4; ++i) {
            nArray2[i] = nArray[i + 4];
        }
        return nArray2;
    }

    public int[] getIPAddress() {
        int[] nArray = new int[8];
        if (this.ipv4.isSelected()) {
            if (this.ipField.getAddress_int().length == 4) {
                int n;
                for (n = 0; n < 4; ++n) {
                    nArray[n] = 0;
                }
                for (n = 0; n < 4; ++n) {
                    nArray[n + 4] = this.ipField.getAddress_int()[n];
                }
            } else {
                for (int i = 0; i < 8; ++i) {
                    nArray[i] = this.ipField.getAddress_int()[i];
                }
            }
        } else {
            nArray = this.ipField_IPv6.getAddress_int();
        }
        return nArray;
    }
}

