/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.hur.dialog.com;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import sanproject.client.com.RJCom;
import sanproject.client.com.RJComModalDialog;
import sanproject.client.data.RJDataMsg;
import sanproject.client.hur.RJHurAbsChildPanel;
import sanproject.client.hur.RJHurDataControl;
import sanproject.client.hur.RJHurGuide;
import sanproject.client.hur.RJHurMacro;
import sanproject.client.hur.dialog.com.RJHurBaseDialogPanel;

public abstract class RJHurBaseDialog
extends RJComModalDialog
implements RJHurMacro {
    private static final String CLASSNAME = "RJHurBaseDialog";
    protected RJHurDataControl m_hurDC = null;
    protected RJHurAbsChildPanel m_pnlChild = null;
    protected RJHurBaseDialogPanel m_pnlBase = null;
    private JPanel m_pnlGround = null;
    private boolean m_bClosedBtn = false;
    protected boolean m_bPreset = false;
    protected ArrayList m_lstData = null;
    public boolean closeBtnEnable = true;
    static /* synthetic */ Class class$java$awt$Frame;

    public RJHurBaseDialog(RJHurAbsChildPanel rJHurAbsChildPanel, RJHurDataControl rJHurDataControl) {
        super((Frame)SwingUtilities.getAncestorOfClass(class$java$awt$Frame == null ? (class$java$awt$Frame = RJHurBaseDialog.class$("java.awt.Frame")) : class$java$awt$Frame, rJHurAbsChildPanel), true);
        try {
            this.m_pnlChild = rJHurAbsChildPanel;
            this.m_hurDC = rJHurDataControl;
            this.initInstance();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void initInstance() throws Exception {
        this.setTitle(this.getDialogTitle());
        this.enableEvents(64L);
        this.m_pnlBase = this.getBasePanel();
        this.m_pnlGround = new JPanel(new BorderLayout());
        this.m_pnlGround.setBackground(this.getBorderColor());
        this.m_pnlGround.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.m_pnlGround.add(this.m_pnlBase);
        this.getContentPane().add(this.m_pnlGround);
    }

    protected Color getBorderColor() {
        return RJHurGuide.color("Dialog_BDRClr");
    }

    protected abstract String getDialogTitle();

    protected abstract RJHurBaseDialogPanel getBasePanel();

    public void show() {
        Point point = this.getDialogLocation();
        this.setLocation(point);
        super.show();
    }

    public void windowClose() {
        this.setVisible(false);
        this.closeDialog();
    }

    protected void closeDialog() {
        this.m_pnlChild.dialogClose(this.m_bPreset, this.m_lstData, this.m_bClosedBtn);
    }

    public void dispose() {
        if (this.closeBtnEnable) {
            this.getContentPane().removeAll();
            super.dispose();
        }
    }

    protected void dialogInit() {
        super.dialogInit();
        this.setResizable(false);
    }

    private Point getDialogLocation() {
        Point point = null;
        Window window = this.getOwner();
        if (window != null) {
            Point point2 = window.getLocationOnScreen();
            Dimension dimension = window.getSize();
            Dimension dimension2 = this.getSize();
            point2.x += (dimension.width - dimension2.width) / 2;
            point2.y += (dimension.height - dimension2.height) / 2;
            point = new Point(point2);
        } else {
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension dimension3 = this.getSize();
            if (dimension3.height > dimension.height) {
                dimension3.height = dimension.height;
            }
            if (dimension3.width > dimension.width) {
                dimension3.width = dimension.width;
            }
            point = new Point((dimension.width - dimension3.width) / 2, (dimension.height - dimension3.height) / 2);
        }
        return point;
    }

    public void setPresetFlg(boolean bl) {
        this.m_bPreset = bl;
    }

    public void setClosedBtn(boolean bl) {
        this.m_bClosedBtn = bl;
    }

    public void setData(ArrayList arrayList) {
        this.m_lstData = arrayList;
    }

    public RJDataMsg getMessageInf(int n) {
        return RJCom.getMsg(this.m_hurDC.getCommonDC(), this.m_hurDC.getClientPart(), n);
    }

    public Object[] getMessageOptOK() {
        Object[] objectArray = new Object[]{RJHurGuide.text("OK")};
        return objectArray;
    }

    public Icon getIcon(String string) {
        return RJCom.createImgIcon(this.m_hurDC.getCommonDC(), string);
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            if (this.closeBtnEnable) {
                this.m_bClosedBtn = false;
                this.windowClose();
            }
        } else {
            super.processWindowEvent(windowEvent);
        }
    }

    public boolean isInstalled() {
        return this.m_hurDC.isInstalled();
    }

    public int whichPP() {
        return this.m_hurDC.getPPKind();
    }

    public RJHurAbsChildPanel getOriginChildPanel() {
        return this.m_pnlChild;
    }

    public void HURComputlog(String string, String string2) {
        this.m_pnlChild.HURputlog(true, string, string2);
        System.out.println("[HUR] " + string + " " + string2);
    }

    public RJHurDataControl getHurDC() {
        return this.m_hurDC;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

