/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.monitor.com;

import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import sanproject.client.com.abs.RJaTreeNode;
import sanproject.client.com.restoreview.DefaultScrollPaneViewRestorer;
import sanproject.client.com.restoreview.DefaultTreeComponentParser;
import sanproject.client.com.restoreview.DefaultTreeViewRestorer;
import sanproject.client.com.restoreview.TreeComponentParser;
import sanproject.client.com.restoreview.UnsupportedComponentException;
import sanproject.client.com.restoreview.UnsupportedRestoreModeException;
import sanproject.client.monitor.com.RJHihElement;
import sanproject.client.monitor.com.RJHihTreePanel;

public class RJHihTreeViewRestorer {
    private InnerTreeViewRestorer restorerTree = new InnerTreeViewRestorer();
    private DefaultScrollPaneViewRestorer restorerScrollPane = new DefaultScrollPaneViewRestorer();
    private HashMap saveElements = new HashMap();

    public RJHihTreeViewRestorer() {
        this(false);
    }

    public RJHihTreeViewRestorer(boolean bl) {
        this.restorerTree.setRestorAll(bl);
    }

    public void saveView(RJHihTreePanel rJHihTreePanel) {
        if (rJHihTreePanel.getRootNode().getUserObject() != null) {
            JTree jTree = rJHihTreePanel.getTree();
            try {
                this.restorerTree.saveViewComponent(jTree);
                this.restorerScrollPane.saveViewComponent(rJHihTreePanel.getScrollPane());
            }
            catch (UnsupportedComponentException unsupportedComponentException) {
                // empty catch block
            }
            this.saveElements.clear();
            TreePath[] treePathArray = jTree.getSelectionPaths();
            if (treePathArray != null) {
                for (int i = 0; i < treePathArray.length; ++i) {
                    RJaTreeNode rJaTreeNode = (RJaTreeNode)treePathArray[i].getLastPathComponent();
                    this.saveElements.put(this.pathString(treePathArray[i]), rJaTreeNode.getUserObject());
                }
            }
        }
    }

    public void restoreView(RJHihTreePanel rJHihTreePanel) {
        if (rJHihTreePanel.getRootNode().getUserObject() != null) {
            JTree jTree = rJHihTreePanel.getTree();
            try {
                this.restorerTree.restoreViewComponent(jTree);
                jTree.clearSelection();
                ArrayList arrayList = this.restorerTree.getSelectionPaths();
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    RJHihElement rJHihElement;
                    TreePath treePath = (TreePath)iterator.next();
                    RJaTreeNode rJaTreeNode = (RJaTreeNode)treePath.getLastPathComponent();
                    RJHihElement rJHihElement2 = (RJHihElement)rJaTreeNode.getUserObject();
                    if (rJHihElement2.equals(rJHihElement = (RJHihElement)this.saveElements.get(this.pathString(treePath)))) {
                        rJHihElement2.setTableModel(rJHihElement.getTableModel());
                    }
                    jTree.addSelectionPath(treePath);
                    rJHihElement2.setTableModel(null);
                }
                int n = 768;
                this.restorerScrollPane.setRestoreMode(n);
                this.restorerScrollPane.restoreViewComponent(rJHihTreePanel.getScrollPane());
            }
            catch (UnsupportedComponentException unsupportedComponentException) {
            }
            catch (UnsupportedRestoreModeException unsupportedRestoreModeException) {
                // empty catch block
            }
        }
    }

    private String pathString(TreePath treePath) {
        String string = ":";
        int n = treePath.getPathCount();
        for (int i = 0; i < n; ++i) {
            RJaTreeNode rJaTreeNode = (RJaTreeNode)treePath.getPathComponent(i);
            Object object = rJaTreeNode.getUserObject();
            String string2 = object.toString();
            if (object instanceof RJHihElement) {
                string2 = ((RJHihElement)object).getName();
            }
            string = string + string2 + ":";
        }
        return string;
    }

    class InnerTreeComponentParser
    extends DefaultTreeComponentParser {
        InnerTreeComponentParser() {
        }

        protected boolean isSameTreeNode(Object object, Object object2) {
            boolean bl = false;
            if (object != null && object2 != null) {
                Object object3;
                String string = object.toString().trim();
                String string2 = object2.toString().trim();
                if (object instanceof DefaultMutableTreeNode && (object3 = ((DefaultMutableTreeNode)object).getUserObject()) instanceof RJHihElement) {
                    string = ((RJHihElement)object3).getName();
                }
                if (object2 instanceof DefaultMutableTreeNode && (object3 = ((DefaultMutableTreeNode)object2).getUserObject()) instanceof RJHihElement) {
                    string2 = ((RJHihElement)object3).getName();
                }
                bl = string.equals(string2);
            }
            return bl;
        }
    }

    class InnerTreeViewRestorer
    extends DefaultTreeViewRestorer {
        private ArrayList selectionPaths = new ArrayList();
        private boolean restorAll = false;

        InnerTreeViewRestorer() {
            super.setComponentParser(new InnerTreeComponentParser());
        }

        public ArrayList getSelectionPaths() {
            return this.selectionPaths;
        }

        public void restoreViewComponent(Component component) throws UnsupportedComponentException {
            this.selectionPaths.clear();
            if (!(component instanceof JTree)) {
                super.restoreViewComponent(component);
                return;
            }
            if (this.hasSavedViewComponent()) {
                JTree jTree = (JTree)component;
                JTree jTree2 = this.getSavedViewComponent();
                TreeSelectionModel treeSelectionModel = jTree2.getSelectionModel();
                TreeComponentParser treeComponentParser = (TreeComponentParser)this.getComponentParser();
                treeComponentParser.setAnalysisComponent(jTree);
                int n = jTree2.getRowCount();
                for (int i = 0; i < n; ++i) {
                    TreePath treePath = jTree2.getPathForRow(i);
                    if (treeSelectionModel.isPathSelected(treePath)) {
                        this.expandPath(jTree, treeComponentParser, treePath);
                        TreePath treePath2 = treeComponentParser.searchTreeNode(treePath);
                        if (treePath2 == null) continue;
                        this.selectionPaths.add(treePath2);
                        continue;
                    }
                    if (!this.restorAll || !jTree2.isExpanded(treePath)) continue;
                    this.expandPath(jTree, treeComponentParser, treePath);
                }
            }
        }

        private void expandPath(JTree jTree, TreeComponentParser treeComponentParser, TreePath treePath) {
            int n;
            JTree jTree2 = this.getSavedViewComponent();
            TreePath[] treePathArray = new TreePath[treePath.getPathCount()];
            TreePath treePath2 = treePath;
            for (n = treePathArray.length - 1; n >= 0; --n) {
                treePathArray[n] = treePath2;
                treePath2 = treePathArray[n].getParentPath();
            }
            for (n = 0; n < treePathArray.length && (treePath2 = treeComponentParser.searchTreeNode(treePathArray[n])) != null; ++n) {
                if (!jTree2.isExpanded(treePathArray[n])) continue;
                jTree.expandPath(treePath2);
            }
        }

        public void setRestorAll(boolean bl) {
            this.restorAll = bl;
        }
    }
}

