/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.monitor.hihsm.attribute;

import java.awt.event.ActionEvent;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.JComponent;
import sanproject.client.com.RJcGuide;
import sanproject.client.com.RJcTreePanel;
import sanproject.client.monitor.com.RJHihDataSupplier;
import sanproject.client.monitor.com.RJHihHiLdevElement;
import sanproject.client.monitor.com.RJHihIconTable;
import sanproject.client.monitor.hihsm.attribute.RJHihAttributeData;
import sanproject.common.Robj_interface_RJiLDEVIndex;
import sanproject.serverux.arg.monitor.HIHsmSetAttributeInfo;
import sanproject.serverux.data.HIHsmLDEVUseRate;
import sanproject.serverux.data.MonitorInfoCollection;
import sanproject.serverux.dataimpl.RJiLDEVInfoDetail3;

public class RJHihAtLdevElement
extends RJHihHiLdevElement
implements Serializable {
    public static final int ATTR_Normal = 0;
    public static final int ATTR_Reserved = 1;
    protected int attribute = -1;
    protected int attributeInit = -1;
    private String[] menuItems = new String[]{RJcGuide.text("Attribute/PopupNormalLdev"), RJcGuide.text("Attribute/PopupReservedLdev")};
    protected JComponent invoker;
    protected Integer useRateAverage = null;
    private Integer useRateMaximum = null;
    private int moveHistory;
    protected int ownerIDInit = 0;

    public RJHihAtLdevElement(RJiLDEVInfoDetail3 rJiLDEVInfoDetail3, RJHihDataSupplier rJHihDataSupplier, RJcTreePanel rJcTreePanel) {
        super((Robj_interface_RJiLDEVIndex)rJiLDEVInfoDetail3, rJHihDataSupplier, rJcTreePanel);
        this.initDetail(rJiLDEVInfoDetail3);
    }

    public RJHihAtLdevElement(int n, int n2, int n3, RJHihDataSupplier rJHihDataSupplier, RJcTreePanel rJcTreePanel) {
        super(n, n2, n3, rJHihDataSupplier, rJcTreePanel);
    }

    public void initDetail(RJiLDEVInfoDetail3 rJiLDEVInfoDetail3) {
        super.initDetail(rJiLDEVInfoDetail3);
        this.attribute = this.isReserve() ? 1 : 0;
        this.attributeInit = this.attribute;
        if (this.attribute == 1) {
            this.ownerIDInit = this.supplier.getOwnerID(this.ldkc, this.cu, this.ldev);
            this.setOwnerID(this.ownerIDInit);
        }
    }

    public void collectUseRate(MonitorInfoCollection monitorInfoCollection, int n) {
        this.useRateAverage = null;
        this.useRateMaximum = null;
        this.moveHistory = 0;
        if (monitorInfoCollection != null) {
            HIHsmLDEVUseRate hIHsmLDEVUseRate = (HIHsmLDEVUseRate)monitorInfoCollection.get(n);
            this.useRateAverage = RJHihAtLdevElement.newInteger(hIHsmLDEVUseRate.getTotalAverage());
            this.useRateMaximum = RJHihAtLdevElement.newInteger(hIHsmLDEVUseRate.getTotalMax());
            this.moveHistory = hIHsmLDEVUseRate.getTotalMoveHistory();
        }
    }

    public Icon getIcon() {
        Icon icon = null;
        if (this.attribute < 0) {
            this.attribute = this.isReserve() ? 1 : 0;
            this.attributeInit = this.attribute;
        }
        if (this.attribute == 0) {
            icon = this.isAllowReserved() ? RJHihIconTable.getIcon(45) : RJHihIconTable.getIcon(41);
        } else {
            icon = RJHihIconTable.getIcon(42);
            if (this.getOwnerID() != 0) {
                icon = RJHihIconTable.getIcon(46);
            }
        }
        if (icon == null) {
            icon = super.getIcon(false);
        }
        return icon;
    }

    public boolean isAllowReserved() {
        boolean bl = true;
        int n = this.getLUPath();
        if (n != 0 || this.isLuse() || this.isPoolVol() || this.isJnlVol() || !this.isPoolRelation() || this.isSysDisk() || this.isLockVol() || this.isOdmVol()) {
            bl = false;
        }
        return bl;
    }

    public Icon getIcon(boolean bl) {
        return null;
    }

    public void menuItemActionPerformed(ActionEvent actionEvent, int n) {
        if ((this.getLUPath() == 0 || n != 1) && this.attribute != n) {
            this.setAttribute(n);
            this.invoker.repaint(1L);
            HIHsmSetAttributeInfo hIHsmSetAttributeInfo = new HIHsmSetAttributeInfo(1);
            hIHsmSetAttributeInfo.setLdkc(0, this.getLDKC());
            hIHsmSetAttributeInfo.setCu(0, this.getCU());
            hIHsmSetAttributeInfo.setLdev(0, this.getLDEV());
            hIHsmSetAttributeInfo.setReserveFlag(this.attribute);
            RJHihAttributeData rJHihAttributeData = (RJHihAttributeData)this.supplier.getAttributedata();
            rJHihAttributeData.setLdevData(hIHsmSetAttributeInfo);
        }
    }

    public Integer getRateAverage() {
        return this.useRateAverage;
    }

    public Integer getRateMaximum() {
        return this.useRateMaximum;
    }

    public int getMoveHistory() {
        return this.moveHistory;
    }

    public boolean isModify() {
        return this.attributeInit != this.attribute;
    }

    public Comparable getIconValue() {
        int n = this.attribute * 2;
        if (n == 0 && this.getLUPath() != 0) {
            n = 1;
        }
        if (this.attribute == 1) {
            n += this.getOwnerID();
        }
        return new Integer(n);
    }

    public String[] getMenuItems() {
        return this.menuItems;
    }

    public void setInvoker(JComponent jComponent) {
        this.invoker = jComponent;
    }

    public int getAttribute() {
        return this.attribute;
    }

    public void setAttribute(int n) {
        this.attribute = n;
        int n2 = this.attribute == 1 ? this.ownerIDInit : -1;
        this.setOwnerID(n2);
    }
}

