/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.monitor.hihsm.manualplan;

import sanproject.client.com.RJcElement;
import sanproject.client.com.RJcGuide;
import sanproject.client.com.abs.RJaDataModelEntry;
import sanproject.client.monitor.com.RJHihDataSupplier;
import sanproject.client.monitor.com.RJHihElement;
import sanproject.client.monitor.hihsm.manualplan.RJHihMpLdevElement;
import sanproject.client.monitor.hihsm.manualplan.RJHihMpLdevTableModel;

public class RJHihMpSLdevTableModel
extends RJHihMpLdevTableModel {
    static final int NORMALVOL_MODE = 0;
    static final int AOUVOL_MODE = 1;
    private int volMode = 0;
    private static final int RAID700_SOURCE_TBL_AVAILABILITY_COLUMN_SIZE = 96;
    private static final int HM700_SOURCE_TBL_AVAILABILITY_COLUMN_SIZE = 160;

    public RJHihMpSLdevTableModel(RJHihDataSupplier rJHihDataSupplier) {
        super(rJHihDataSupplier);
    }

    protected void defineTable() {
        this.setAutoResizeMode(0);
        this.addRHColumnInfo("LDEV", RJcGuide.text("ManualPlan/ListSrcLdevLbl"), 102, new RJHihElement(), false, 2);
        this.columnNames.setSearchKey("LDEV");
    }

    public void defineTable(int n) {
        this.volMode = n;
        if (this.volMode == 0) {
            this.setAutoResizeMode(2);
            this.columnNames.setSearchKey("LDEV");
            if (!this.supplier.isHM()) {
                this.addColumnInfo("ETYPE", RJcGuide.text("ManualPlan/ListSrcEmulationLbl"), 96, new String(""), false, 0);
            }
            this.addColumnInfo("CAPA", RJcGuide.text("ManualPlan/ListSrcCapaLbl"), 102, new String(""), false, 4);
            this.addColumnInfo("AVERAGE", RJcGuide.text("Attribute/LdevListAverageLbl"), this.getAvailabilityColumnSize(), new String(""), false, 4);
            this.addColumnInfo("MAX", RJcGuide.text("Attribute/LdevListMaxLbl"), this.getAvailabilityColumnSize(), new String(""), false, 4);
        } else if (this.volMode == 1) {
            this.columnNames.setSearchKey("LDEV");
            if (!this.supplier.isHM()) {
                this.addColumnInfo("ETYPE", RJcGuide.text("ManualPlan/ListSrcEmulationLbl"), 72, new String(""), false, 0);
            }
            this.addColumnInfo("CAPA", RJcGuide.text("ManualPlan/ListSrcCapaLbl"), 96, new String(""), false, 4);
            this.addColumnInfo("VVOLUSED", RJcGuide.text("ManualPlan/ListAouVolUsedLbl"), 96, new String(""), false, 4);
            this.addColumnInfo("POOLID", RJcGuide.text("COMMON/PoolID"), 96, new String(""), false, 4);
            this.addColumnInfo("REMAINPOOL", RJcGuide.text("ManualPlan/ListPoolRemainderLbl"), 96, new String(""), false, 4);
            this.addColumnInfo("POOLCAPA", RJcGuide.text("ManualPlan/ListPoolCapacityLbl"), 96, new String(""), false, 4);
        }
        this.columnNames.addKey("HISTORY");
    }

    private int getAvailabilityColumnSize() {
        return this.supplier.isHM() ? 160 : 96;
    }

    public void addRow(RJcElement rJcElement) {
        RJaDataModelEntry rJaDataModelEntry = this.newEntry();
        rJaDataModelEntry.put("LDEV", rJcElement);
        rJaDataModelEntry = this.availEntry(rJaDataModelEntry);
        if (!this.supplier.isHM()) {
            rJaDataModelEntry.put("ETYPE", ((RJHihMpLdevElement)rJcElement).getEmulationType());
        }
        rJaDataModelEntry.put("CAPA", ((RJHihMpLdevElement)rJcElement).getCapacity());
        if (this.volMode == 0) {
            rJaDataModelEntry.put("AVERAGE", ((RJHihMpLdevElement)rJcElement).getRateAverage());
            rJaDataModelEntry.put("MAX", ((RJHihMpLdevElement)rJcElement).getRateMaximum());
        } else if (this.volMode == 1) {
            rJaDataModelEntry.put("VVOLUSED", ((RJHihMpLdevElement)rJcElement).getVVolUsedGB());
            rJaDataModelEntry.put("REMAINPOOL", ((RJHihMpLdevElement)rJcElement).getPoolRemainderCapacity());
            rJaDataModelEntry.put("POOLCAPA", ((RJHihMpLdevElement)rJcElement).getPoolCapacity());
            rJaDataModelEntry.put("POOLID", ((RJHihMpLdevElement)rJcElement).getPoolId());
        }
        rJaDataModelEntry.put("HISTORY", ((RJHihMpLdevElement)rJcElement).getMoveHistory());
    }

    public boolean isSourceLDEV() {
        boolean bl = false;
        RJHihMpLdevElement rJHihMpLdevElement = this.getSelectedLDEV();
        if (rJHihMpLdevElement != null) {
            bl = !rJHihMpLdevElement.isReserve() && !rJHihMpLdevElement.isMoving() && rJHihMpLdevElement.isPoolRelation();
        }
        return bl;
    }

    public Object getValueAt(int n, Object object) {
        Object object2 = super.getValueAt(n, object);
        if (object2 != null && object.equals("REMAINPOOL")) {
            object2 = ((RJaDataModelEntry)this.rows.get(n)).get("REMAINPOOL") + " " + RJcGuide.text("COMMON/UNIT_GB");
        }
        if (object2 != null && object.equals("POOLCAPA")) {
            object2 = ((RJaDataModelEntry)this.rows.get(n)).get("POOLCAPA") + " " + RJcGuide.text("COMMON/UNIT_GB");
        }
        if (object2 != null && object.equals("VVOLUSED")) {
            object2 = ((RJaDataModelEntry)this.rows.get(n)).get("VVOLUSED") + " " + RJcGuide.text("COMMON/UNIT_GB");
        }
        return object2;
    }
}

