/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.monitor.performance.physical;

import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.Icon;
import sanproject.client.com.RJcGuide;
import sanproject.client.com.RJcTreePanel;
import sanproject.client.com.abs.RJaTreeNode;
import sanproject.client.monitor.com.RJHihDataSupplier;
import sanproject.client.monitor.com.RJHihElement;
import sanproject.client.monitor.com.RJHihIconTable;
import sanproject.client.monitor.com.RJHihTimePair;
import sanproject.client.monitor.performance.physical.RJHihPhDrrElement;
import sanproject.client.monitor.performance.physical.RJHihPhDrrTableModel;
import sanproject.serverux.arg.monitor.HIHsmDKADRRCompositionInfoArgInfo;
import sanproject.serverux.arg.monitor.HIHsmDRRUseRateArgInfo;
import sanproject.serverux.arg.monitor.HIHsmPhysicalDRRUseRateArgInfo;
import sanproject.serverux.arg.monitor.MonArg;
import sanproject.serverux.data.HIHsmDKACompositionInfo;
import sanproject.serverux.data.HIHsmDKADRRCompositionInfo;
import sanproject.serverux.data.HIHsmDRRCompositionInfo;
import sanproject.serverux.data.MonitorInfoCollection;

public class RJHihPhDrrFolderElement
extends RJHihElement {
    private int clusterNo;
    private int dkaNo;
    private HIHsmDRRCompositionInfo drrs = null;
    private HIHsmDKADRRCompositionInfo dkadrrs = null;
    private HIHsmDKACompositionInfo dkas = null;

    public RJHihPhDrrFolderElement(int n, int n2, RJHihDataSupplier rJHihDataSupplier, RJcTreePanel rJcTreePanel) {
        super(RJcGuide.text("PerformanceManagement/PhysicalDrr"), rJHihDataSupplier, rJcTreePanel);
        this.clusterNo = n;
        this.dkaNo = n2;
    }

    public RJHihPhDrrFolderElement(RJHihDataSupplier rJHihDataSupplier, RJcTreePanel rJcTreePanel) {
        this(-1, -1, rJHihDataSupplier, rJcTreePanel);
    }

    public void selectNode(RJaTreeNode rJaTreeNode) {
        this.supplier.putLog("[Monitor]", "[Physical]", "RJHihPhDrrFolderElement.selectNode start");
        this.createChildren();
        this.model = this.saveModel;
        if (this.model == null) {
            this.model = new RJHihPhDrrTableModel(this.supplier);
        }
        this.model.beginSetting();
        MonitorInfoCollection monitorInfoCollection = this.getDRRUseRate();
        this.table.createTable(this.model);
        Iterator iterator = this.children.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            RJHihPhDrrElement rJHihPhDrrElement = (RJHihPhDrrElement)iterator.next();
            rJHihPhDrrElement.collectUseRate(monitorInfoCollection, n);
            this.model.addRow(rJHihPhDrrElement);
            ++n;
        }
        this.model.completeSetting();
        this.table.completedTable();
        this.supplier.putLog("[Monitor]", "[Physical]", "RJHihPhDrrFolderElement.selectNode end");
    }

    private void createChildren() {
        if (this.children == null) {
            this.getDkaDrrs();
            this.children = new ArrayList();
            for (int i = 0; i < this.dkadrrs.getSize(); ++i) {
                this.clusterNo = this.dkadrrs.getCluster(i);
                this.dkas = (HIHsmDKACompositionInfo)this.dkadrrs.getDka(i);
                for (int j = 0; j < this.dkas.getSize(); ++j) {
                    this.drrs = (HIHsmDRRCompositionInfo)this.dkas.getDrr(j);
                    this.dkaNo = this.dkas.getNumber(j);
                    for (int k = 0; k < this.drrs.getSize(); ++k) {
                        int n = this.drrs.getNumber(k);
                        String string = this.drrs.getName(k);
                        RJHihPhDrrElement rJHihPhDrrElement = new RJHihPhDrrElement(this.clusterNo, this.dkaNo, n, string, this.supplier, this.treePanel);
                        this.children.add(rJHihPhDrrElement);
                    }
                }
            }
        }
    }

    private HIHsmDKADRRCompositionInfo getDkaDrrs() {
        if (this.dkadrrs == null) {
            HIHsmDKADRRCompositionInfoArgInfo hIHsmDKADRRCompositionInfoArgInfo = new HIHsmDKADRRCompositionInfoArgInfo();
            this.dkadrrs = (HIHsmDKADRRCompositionInfo)this.supplier.getMonitorInfo((MonArg)hIHsmDKADRRCompositionInfoArgInfo);
        }
        return this.dkadrrs;
    }

    private MonitorInfoCollection getDRRUseRate() {
        MonitorInfoCollection monitorInfoCollection = null;
        RJHihTimePair rJHihTimePair = this.supplier.getMonitoringInfo().getMonitoringTime();
        int n = this.children.size();
        if (rJHihTimePair != null && n > 0) {
            Object object = null;
            object = this.getRangeKind() == 0 ? new HIHsmPhysicalDRRUseRateArgInfo(2, rJHihTimePair.getFromTime(), rJHihTimePair.getToTime(), n) : new HIHsmDRRUseRateArgInfo(2, rJHihTimePair.getFromTime(), rJHihTimePair.getToTime(), n);
            Iterator iterator = this.children.iterator();
            int n2 = 0;
            while (iterator.hasNext()) {
                RJHihPhDrrElement rJHihPhDrrElement = (RJHihPhDrrElement)iterator.next();
                object.setAllParam(n2, rJHihPhDrrElement.getClusterNo(), rJHihPhDrrElement.getDkaNo(), rJHihPhDrrElement.getDrrNo());
                ++n2;
            }
            monitorInfoCollection = (MonitorInfoCollection)this.supplier.getMonitorInfo((MonArg)object);
        }
        return monitorInfoCollection;
    }

    public Icon getIcon(boolean bl) {
        Icon icon = RJHihIconTable.getIcon(18);
        return icon;
    }
}

