/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.openldevguard.gui.main;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import sanproject.client.openldevguard.com.TableSortedEvent;
import sanproject.client.openldevguard.com.TableSortedListener;
import sanproject.client.openldevguard.gui.OpenLDEVGuardException;
import sanproject.client.openldevguard.gui.logging.Logger;
import sanproject.client.openldevguard.gui.main.TableDataItem;
import sanproject.client.openldevguard.gui.main.ViewDefine;
import sanproject.client.openldevguard.utility.ObjectUtilities;
import sanproject.client.openldevguard.utility.sort.DataSorter;
import sanproject.client.openldevguard.utility.sort.DataSorterFactory;

public abstract class AbstractPagingTableModel
implements TableModel {
    protected static final int SORTTYPE_STRING = 1;
    protected static final int SORTTYPE_MIXTURE = 2;
    private String mstrModuleName;
    private Set msetModelListeners;
    private Set msetSortedListeners;
    private List mlstDataList;
    private boolean mbSupportThreeWaySort = ViewDefine.isSupportThreeWaySort();
    private int miShowPage = 0;
    private TableDataItem[][] marrCellItems;
    private String[] marrColumnNames;
    private String[] marrColumnID;
    static /* synthetic */ Class class$sanproject$client$openldevguard$gui$main$TableDataItem;

    public AbstractPagingTableModel() {
        this.msetModelListeners = new HashSet();
        this.msetSortedListeners = new HashSet();
        this.mlstDataList = new ArrayList();
        this.marrCellItems = new TableDataItem[0][0];
        this.marrColumnNames = new String[0];
        this.marrColumnID = new String[0];
        String string = ObjectUtilities.getClassName(this);
        this.mstrModuleName = string = string.substring(string.lastIndexOf(46) + 1);
    }

    public final int getRowCount() {
        return this.marrCellItems.length;
    }

    public final int getColumnCount() {
        int n = this.marrColumnNames.length;
        return n;
    }

    public final String getColumnName(int n) {
        String string = this.marrColumnNames[n];
        return string;
    }

    public final Class getColumnClass(int n) {
        return class$sanproject$client$openldevguard$gui$main$TableDataItem == null ? (class$sanproject$client$openldevguard$gui$main$TableDataItem = AbstractPagingTableModel.class$("sanproject.client.openldevguard.gui.main.TableDataItem")) : class$sanproject$client$openldevguard$gui$main$TableDataItem;
    }

    public final boolean isCellEditable(int n, int n2) {
        boolean bl = false;
        return bl;
    }

    public final Object getValueAt(int n, int n2) {
        TableDataItem tableDataItem = this.marrCellItems[n][n2];
        return tableDataItem;
    }

    public final void setValueAt(Object object, int n, int n2) {
        throw new UnsupportedOperationException("setValueAt() is unsupported.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addTableModelListener(TableModelListener tableModelListener) {
        Set set = this.msetModelListeners;
        synchronized (set) {
            this.msetModelListeners.add(tableModelListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeTableModelListener(TableModelListener tableModelListener) {
        Set set = this.msetModelListeners;
        synchronized (set) {
            this.msetModelListeners.remove(tableModelListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addTableSortedListener(TableSortedListener tableSortedListener) {
        Set set = this.msetSortedListeners;
        synchronized (set) {
            this.msetSortedListeners.add(tableSortedListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeTableSortedListener(TableSortedListener tableSortedListener) {
        Set set = this.msetSortedListeners;
        synchronized (set) {
            this.msetSortedListeners.remove(tableSortedListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireTableChanged(TableModelEvent tableModelEvent) {
        Set set;
        Object object = this.msetModelListeners;
        synchronized (object) {
            set = Collections.synchronizedSet(this.msetModelListeners);
        }
        object = set.iterator();
        while (object.hasNext()) {
            TableModelListener tableModelListener = (TableModelListener)object.next();
            tableModelListener.tableChanged(tableModelEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireTableSorted(TableSortedEvent tableSortedEvent) {
        Set set;
        Object object = this.msetSortedListeners;
        synchronized (object) {
            set = Collections.synchronizedSet(this.msetSortedListeners);
        }
        object = set.iterator();
        while (object.hasNext()) {
            TableSortedListener tableSortedListener = (TableSortedListener)object.next();
            tableSortedListener.tableSorted(tableSortedEvent);
        }
    }

    public final boolean hasPreviousPage() {
        int n = this.getShowPage();
        boolean bl = n > 0;
        return bl;
    }

    public final boolean hasNextPage() {
        int n;
        int n2 = this.getShowPage();
        boolean bl = n2 < (n = this.getMaxPageCount()) - 1;
        return bl;
    }

    public final String getColumnID(int n) {
        String string = this.marrColumnID[n];
        return string;
    }

    public final int getShowPage() {
        return this.miShowPage;
    }

    public final int getMaxPageCount() {
        int n = this.getAllRowDataCount();
        int n2 = this.getMaxRowCountInPage();
        int n3 = n2 < 1 ? 1 : (n - 1) / n2 + 1;
        return n3;
    }

    public final int getAllRowDataCount() {
        int n = this.mlstDataList.size();
        return n;
    }

    public abstract int getMaxRowCountInPage();

    protected abstract List getAllRowDataList();

    protected abstract TableDataItem createCellObject(Object var1, int var2);

    protected abstract TableDataItem[] getRowCellItems(Object var1);

    protected abstract int getSorterType(int var1);

    public abstract int getSortingIndex();

    public abstract int getSortKind(int var1);

    protected abstract String[] getColumnNames();

    protected abstract String[] getColumnIDs();

    protected final void updateCellData() throws OpenLDEVGuardException {
        Logger.put(Level.FINEST, this.mstrModuleName, "updateCellData()");
        Logger.put(Level.FINEST, this.mstrModuleName, "    -> get all data...");
        List list = this.getAllRowDataList();
        int n = list.size();
        Logger.put(Level.FINEST, this.mstrModuleName, "        list count = " + n);
        this.mlstDataList = list;
        this.marrColumnNames = this.getColumnNames();
        this.marrColumnID = this.getColumnIDs();
        this.updateChangePageAt(0);
    }

    protected final void updateRows(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            TableDataItem tableDataItem = this.marrCellItems[n][0];
            Object object = tableDataItem.getReferencedObject();
            TableDataItem[] tableDataItemArray = this.getRowCellItems(object);
            this.marrCellItems[n] = tableDataItemArray;
        }
    }

    protected final void updateSortCellData(int n, int n2) {
        Object object;
        List list;
        int n3 = this.getSortingIndex();
        List list2 = this.getSortedRowDataList(this.mlstDataList);
        int n4 = this.getMaxRowCountInPage();
        if (n4 < 1) {
            list = list2;
        } else {
            int n5 = this.miShowPage * n4;
            int n6 = this.getAllRowDataCount();
            int n7 = n6 < n5 + n4 ? n6 : n5 + n4;
            list = list2.subList(n5, n7);
        }
        long l = System.currentTimeMillis();
        Logger.put(Level.FINER, this.mstrModuleName, "create all cell items.");
        ArrayList<TableDataItem[]> arrayList = new ArrayList<TableDataItem[]>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            TableDataItem[] tableDataItemArray = this.getRowCellItems(object);
            arrayList.add(tableDataItemArray);
        }
        object = new TableDataItem[0][0];
        object = (TableDataItem[][])arrayList.toArray((T[])object);
        this.marrCellItems = object;
        long l2 = System.currentTimeMillis();
        Logger.put(Level.FINER, this.mstrModuleName, " * " + (l2 - l) + " milli seconds.");
    }

    protected final void updateChangePageAt(int n) {
        int n2 = this.getMaxPageCount();
        if (n < 0 || n >= n2) {
            throw new ArrayIndexOutOfBoundsException("cannot view page at " + n);
        }
        Logger.put(Level.FINER, this.mstrModuleName, "update cell data. page at " + n);
        this.miShowPage = n;
        int n3 = this.getSortingIndex();
        int n4 = this.getSortKind(n3);
        this.updateSortCellData(n3, n4);
    }

    private List getSortedRowDataList(List list) {
        long l = System.currentTimeMillis();
        Logger.put(Level.FINER, this.mstrModuleName, "sorting process start...");
        List<Object> list2 = new ArrayList();
        int n = this.getSortingIndex();
        int n2 = this.getSortKind(n);
        if (n != -1 && n2 != 0) {
            Object object;
            Object object2;
            Object object3;
            Logger.put(Level.FINER, this.mstrModuleName, "    index -> " + n);
            Logger.put(Level.FINER, this.mstrModuleName, "    kind -> " + n2);
            int n3 = this.getSorterType(n);
            DataSorter dataSorter = n3 == 1 ? DataSorterFactory.createStringDataSorter() : DataSorterFactory.createMixtureDataSorter();
            Logger.put(Level.FINER, this.mstrModuleName, "    sorter = " + dataSorter);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                object3 = iterator.next();
                object2 = this.createCellObject(object3, n);
                object = object2.createSortKey();
                dataSorter.put(object, object3);
            }
            Logger.put(Level.FINER, this.mstrModuleName, "    execute sort...");
            object3 = dataSorter.getSortedDataList();
            Logger.put(Level.FINER, this.mstrModuleName, "    sort finished.");
            if (n2 == 2) {
                int n4 = object3.size();
                object = object3.listIterator(n4);
                while (object.hasPrevious()) {
                    Object e = object.previous();
                    list2.add(e);
                }
            } else {
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    object = object2.next();
                    list2.add(object);
                }
            }
        } else {
            list2 = list;
        }
        long l2 = System.currentTimeMillis();
        Logger.put(Level.FINER, this.mstrModuleName, " * " + (l2 - l) + " milli seconds.");
        return list2;
    }

    protected final int getNextSortKind(int n, int n2) {
        int n3 = this.getSortingIndex() == n ? (this.mbSupportThreeWaySort ? (n2 == 1 ? 2 : (n2 == 2 ? 0 : 1)) : (n2 == 1 ? 2 : (n2 == 2 ? 1 : 1))) : 1;
        return n3;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

