/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem.server.adapters.ih.smtp;

import com.ws.wbem.server.adapters.ih.common.IndicationHandler;
import java.util.Properties;
import java.util.logging.Level;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.wbem.CloseableIterator;
import javax.wbem.WBEMException;
import javax.wbem.provider.ProviderHandle;

public class EMailIndicationHandler
extends IndicationHandler {
    private static final String CPN_MANAGEDELEMENT = "ManagedElement";
    private static final String CPN_SETTINGDATA = "SettingData";
    private static final String CN_ELEMENTSETTINGDATA = "WS_EMailIndicationHandlerSettingDataSetting";
    private static final String CN_SETTINGDATA = "WS_EMailIndicationHandlerSettingData";
    private static final String CPN_SMTPUSERNAME = "smtpUsername";
    private static final String CPN_SMTPPASSWORD = "smtpPassword";
    private static final String CPN_PROTOCOL = "protocol";
    private static final String CPN_SMTPHOST = "smtpHost";
    private static final String CPN_SMTPPORT = "smtpPort";
    private static final String CPN_FROM = "emailFrom";
    private static final String CPN_SUBJECT = "emailSubject";
    private static final String DEFAULT_PORT_SMTP_SECURE = "465";
    private static final String PROTOCOL_SMTPS = "smtps";
    private static final String PROTOCOL_TLS = "tls";
    private static final String SMTP = "SMTP";
    private String mMsgFrom;
    private String mMsgSubject;
    private Session mSession;

    public String getClassName() {
        return "CIM_ListenerDestination";
    }

    @Override
    public void start(CIMInstance cIMInstance) {
        super.start(cIMInstance);
        if (!this.initSession()) {
            this.stop();
        }
    }

    @Override
    protected IndicationHandler.DeliveryStatus deliverIndication(Object object, CIMInstance cIMInstance) {
        IndicationHandler.DeliveryStatus deliveryStatus = IndicationHandler.DeliveryStatus.SUCCESSFUL;
        try {
            MimeMessage mimeMessage = new MimeMessage(this.mSession);
            if (null != this.mMsgFrom) {
                mimeMessage.setFrom((Address)new InternetAddress(this.mMsgFrom));
            }
            mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)((String)object)));
            if (null != this.mMsgSubject) {
                mimeMessage.setSubject(this.mMsgSubject);
            }
            mimeMessage.setText(cIMInstance.toString());
            Transport.send((Message)mimeMessage);
        }
        catch (MessagingException messagingException) {
            this.mLogger.log(Level.SEVERE, "Caught exception when trying to deliver indication to SMTP:" + object, messagingException);
            deliveryStatus = IndicationHandler.DeliveryStatus.UNSUCCESSFUL;
        }
        return deliveryStatus;
    }

    @Override
    protected Object getDestinationObject(String string) {
        return string;
    }

    @Override
    public void initialize(ProviderHandle providerHandle) {
        super.initialize(providerHandle);
    }

    private boolean initSession() {
        Properties properties = new Properties();
        boolean bl = true;
        try {
            CloseableIterator closeableIterator = this.mWBEMClient.associatorInstances(this.mInstIndicationHandler.getObjectPath(), CN_ELEMENTSETTINGDATA, CN_SETTINGDATA, CPN_MANAGEDELEMENT, CPN_SETTINGDATA, null);
            if (closeableIterator.hasNext()) {
                CIMInstance cIMInstance = (CIMInstance)closeableIterator.next();
                CIMObjectPath cIMObjectPath = cIMInstance.getObjectPath();
                CIMInstance cIMInstance2 = mInternalProvider.getInstance(cIMObjectPath, null);
                String string = (String)cIMInstance2.getPropertyValue(CPN_SMTPHOST);
                if (null != string) {
                    properties.put("mail.smtp.host", string);
                    String string2 = (String)cIMInstance2.getPropertyValue(CPN_PROTOCOL);
                    if (PROTOCOL_SMTPS.equalsIgnoreCase(string2)) {
                        properties.put("mail.smtp.ssl.enable", "true");
                    } else if (PROTOCOL_TLS.equalsIgnoreCase(string2)) {
                        properties.put("mail.smtp.starttls.enable", "true");
                    }
                    String string3 = (String)cIMInstance2.getPropertyValue(CPN_SMTPPORT);
                    if (null == string3) {
                        properties.put("mail.smtp.port", DEFAULT_PORT_SMTP_SECURE);
                    }
                    final String string4 = (String)cIMInstance2.getPropertyValue(CPN_SMTPPASSWORD);
                    final String string5 = (String)cIMInstance2.getPropertyValue(CPN_SMTPUSERNAME);
                    this.mMsgFrom = (String)cIMInstance2.getPropertyValue(CPN_FROM);
                    this.mMsgSubject = (String)cIMInstance2.getPropertyValue(CPN_SUBJECT);
                    Authenticator authenticator = null;
                    if (null != string5) {
                        properties.put("mail.smtp.auth", "true");
                        authenticator = new Authenticator(){

                            protected PasswordAuthentication getPasswordAuthentication() {
                                return new PasswordAuthentication(string5, string4);
                            }
                        };
                    }
                    this.mSession = Session.getDefaultInstance((Properties)properties, authenticator);
                } else {
                    this.mLogger.severe("Could not get smtp Hostname from EmailIndicationHandler instance.  Cannot start EmailIndicationHandler");
                    bl = false;
                }
            } else {
                this.mLogger.severe("Could not start EMail Indication handler because this handler could not find it's associated SettingData information");
                bl = false;
            }
        }
        catch (WBEMException wBEMException) {
            this.mLogger.log(Level.SEVERE, "Could not start EMail Indication handler because an exception was thrown when this adapter was trying to find it's associated SettingData", wBEMException);
            bl = false;
        }
        return bl;
    }
}

